/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.chart.box;

import com.scudata.app.common.Section;
import com.scudata.common.MessageManager;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.MonthlyCalendar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DialogDateChooser
extends JDialog {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeCommonMessage.get();
    private Calendar calendar;
    private Calendar retCal;
    private String STR_TITLE;
    private String STR_DATE;
    private String[] STR_ARRAY_MONTH_LIST;
    private String STR_ERR1;
    private String STR_ERR2;
    private JPanel basePanel;
    private JPanel containerPanel;
    private JPanel controlPanel;
    private JComboBox jComboBox1;
    private JSpinner jSpinner1;
    private MonthlyCalendar monthCalendar;
    private JPanel viewPanel;
    private SpinnerDateModel timeModel = new SpinnerDateModel();

    private void loadLanguageString() {
        this.STR_TITLE = this.mm.getMessage("datechooser.selectdate");
        this.STR_DATE = this.mm.getMessage("datechooser.date");
        this.STR_ARRAY_MONTH_LIST = new Section(this.mm.getMessage("datechooser.month")).toStringArray();
        this.STR_ERR1 = this.mm.getMessage("datechooser.err1");
        this.STR_ERR2 = this.mm.getMessage("datechooser.err2");
    }

    public DialogDateChooser() {
        this.init();
    }

    public DialogDateChooser(Dialog owner) {
        super(owner);
        this.init();
    }

    public DialogDateChooser(Dialog owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public DialogDateChooser(Dialog owner, String title) {
        super(owner, title);
        this.init();
    }

    public DialogDateChooser(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init();
    }

    public DialogDateChooser(Dialog owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.init();
    }

    public DialogDateChooser(Frame owner) {
        super(owner);
        this.init();
    }

    public DialogDateChooser(Frame owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public DialogDateChooser(Frame owner, String title) {
        super(owner, title);
        this.init();
    }

    public DialogDateChooser(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init();
    }

    public DialogDateChooser(Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.init();
    }

    public void initDate(Calendar calendar) {
        int m = calendar.get(2);
        this.jComboBox1.setSelectedIndex(m);
        this.jSpinner1.setValue(calendar.getTime());
        this.monthCalendar.setYearMonth(calendar);
        this.timeModel.setValue(calendar.getTime());
    }

    private void init() {
        this.loadLanguageString();
        this.initComponents();
        this.calendar = Calendar.getInstance();
        this.initDate(this.calendar);
    }

    private void initComponents() {
        this.basePanel = new JPanel();
        this.containerPanel = new JPanel();
        this.controlPanel = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.jSpinner1 = new JSpinner();
        this.viewPanel = new JPanel();
        this.monthCalendar = new MonthlyCalendar(){

            @Override
            protected void dateSelected() {
                DialogDateChooser.this.doSelection();
            }
        };
        this.setDefaultCloseOperation(2);
        this.setTitle(this.STR_TITLE);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DialogDateChooser.this.formWindowClosing(evt);
            }
        });
        this.basePanel.setLayout(new FlowLayout(1, 10, 10));
        this.basePanel.setBackground(new Color(252, 250, 252));
        this.containerPanel.setLayout(new BorderLayout());
        this.containerPanel.setBorder(new TitledBorder(this.STR_DATE));
        this.containerPanel.setOpaque(false);
        this.controlPanel.setLayout(new FlowLayout(1, 12, 0));
        this.controlPanel.setBorder(new EmptyBorder(new Insets(5, 0, 10, 0)));
        this.controlPanel.setOpaque(false);
        this.jComboBox1.setMaximumRowCount(7);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(this.STR_ARRAY_MONTH_LIST));
        this.jComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DialogDateChooser.this.jComboBox1ItemStateChanged(evt);
            }
        });
        this.controlPanel.add(this.jComboBox1);
        this.jSpinner1.setModel(new SpinnerDateModel());
        this.jSpinner1.setEditor(new JSpinner.DateEditor(this.jSpinner1, "yyyy"));
        this.jSpinner1.setPreferredSize(this.jComboBox1.getPreferredSize());
        this.jSpinner1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DialogDateChooser.this.jSpinner1StateChanged(evt);
            }
        });
        this.controlPanel.add(this.jSpinner1);
        this.containerPanel.add((Component)this.controlPanel, "North");
        this.viewPanel.setLayout(new FlowLayout(1, 0, 0));
        this.viewPanel.setBorder(new EmptyBorder(new Insets(0, 0, 10, 0)));
        this.viewPanel.setOpaque(false);
        this.monthCalendar.setBorder(new BevelBorder(1));
        this.viewPanel.add(this.monthCalendar);
        this.containerPanel.add((Component)this.viewPanel, "Center");
        this.basePanel.add(this.containerPanel);
        this.getContentPane().add((Component)this.basePanel, "Center");
        JSpinner spinner = new JSpinner(this.timeModel);
        JSpinner.DateEditor editor = new JSpinner.DateEditor(spinner, "HH:mm:ss");
        spinner.setEditor(editor);
        this.getContentPane().add((Component)spinner, "South");
        this.pack();
    }

    private void jSpinner1StateChanged(ChangeEvent evt) {
        Date date = (Date)this.jSpinner1.getValue();
        this.calendar.setTime(date);
        this.monthCalendar.setYear(this.calendar.get(1));
        this.monthCalendar.repaint();
    }

    private void jComboBox1ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        this.monthCalendar.setMonth(this.jComboBox1.getSelectedIndex() + 1);
        this.monthCalendar.repaint();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.retCal = null;
    }

    @Override
    public void setVisible(boolean b) {
        this.monthCalendar.resetHighlight();
        super.setVisible(b);
    }

    private void doSelection() {
        this.retCal = this.monthCalendar.getSelectedDate();
        super.setVisible(false);
        this.dispose();
    }

    public Calendar getSelectedDate() {
        Date d = (Date)this.timeModel.getValue();
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        if (this.retCal != null) {
            this.retCal.set(11, c.get(11));
            this.retCal.set(12, c.get(12));
            this.retCal.set(13, c.get(13));
        }
        return this.retCal;
    }

    public void setYearMonth(int y, int m) {
        if (y < 1970) {
            throw new IllegalArgumentException(this.STR_ERR1);
        }
        if (m < 1 || m > 12) {
            throw new IllegalArgumentException(this.STR_ERR2);
        }
        this.jComboBox1.setSelectedIndex(m - 1);
        this.calendar.set(1, y);
        this.jSpinner1.setValue(this.calendar.getTime());
        this.monthCalendar.setYearMonth(y, m);
    }

    public void setWeekStartOnSunday(boolean b) {
        this.monthCalendar.setWeekStartOnSunday(b);
    }

    public boolean getWeekStartOnSunday() {
        return this.monthCalendar.getWeekStartOnSunday();
    }
}

