/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.control;

import com.scudata.cellset.INormalCell;
import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.Area;
import com.scudata.common.CellLocation;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.IAtomicCmd;
import com.scudata.ide.common.control.CellRect;
import com.scudata.ide.spl.AtomicCell;
import com.scudata.ide.spl.AtomicSpl;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.SheetSpl;
import com.scudata.ide.spl.control.CellSetParser;
import com.scudata.ide.spl.control.ContentPanel;
import com.scudata.ide.spl.control.ControlUtils;
import com.scudata.ide.spl.control.SplControl;
import com.scudata.ide.spl.control.SplEditor;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.JTextComponent;

public class CellSelectListener
implements MouseMotionListener,
MouseListener,
KeyListener {
    protected SplControl control;
    protected ContentPanel cp;
    protected boolean editable = true;
    protected final byte NEXT_TOP = 1;
    protected final byte NEXT_BOTTOM = (byte)2;
    protected final byte NEXT_LEFT = (byte)3;
    protected final byte NEXT_RIGHT = (byte)4;
    protected final byte FORWARD_UP = 1;
    protected final byte FORWARD_DOWN = (byte)2;
    protected final byte FORWARD_LEFT = (byte)4;
    protected final byte FORWARD_RIGHT = (byte)8;
    protected Timer dragTimer = null;
    protected int row = 0;
    protected int col = 0;
    protected byte forward = 0;
    protected boolean supportMultiSelect = true;
    protected boolean isCtrlDown = false;

    public CellSelectListener(SplControl control, ContentPanel panel) {
        this(control, panel, true);
    }

    public CellSelectListener(SplControl control, ContentPanel panel, boolean editable) {
        this.control = control;
        this.cp = panel;
        this.editable = editable;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.dragTimer != null) {
            this.dragTimer.stop();
            this.dragTimer = null;
        }
        if (!this.editable) {
            this.showPopup(e);
            return;
        }
        CellLocation pos = ControlUtils.lookupCellPosition(e.getX(), e.getY(), this.cp);
        if (pos == null) {
            return;
        }
        if (this.control.isSelectingCell()) {
            this.control.setActiveCell(pos);
            return;
        }
        int row = pos.getRow();
        int col = pos.getCol();
        boolean isActiveCell = false;
        if (this.control.getActiveCell() != null && this.control.getActiveCell().getRow() == row && this.control.getActiveCell().getCol() == col) {
            isActiveCell = true;
        }
        boolean isCellSelected = false;
        int i = 0;
        while (i < this.control.getSelectedAreas().size()) {
            Area a = this.control.getSelectedArea(i);
            if (a != null && a.contains(pos.getRow(), pos.getCol())) {
                isCellSelected = true;
                break;
            }
            ++i;
        }
        if (e.getButton() == 1 || !isCellSelected) {
            Area a = null;
            if (!this.control.getSelectedAreas().isEmpty()) {
                a = this.control.getSelectedArea(-1);
            }
            if (!e.isControlDown() || !this.supportMultiSelect) {
                this.control.clearSelectedArea();
            }
            if (e.isShiftDown() && a != null) {
                int startRow = a.getBeginRow();
                int endRow = a.getEndRow();
                int startCol = a.getBeginCol();
                int endCol = a.getEndCol();
                if (pos.getRow() <= startRow) {
                    startRow = pos.getRow();
                } else {
                    endRow = pos.getRow();
                }
                if (pos.getCol() <= startCol) {
                    startCol = pos.getCol();
                } else {
                    endCol = pos.getCol();
                }
                a = new Area(startRow, startCol, endRow, endCol);
                this.control.addSelectedArea(a, true);
                ControlUtils.scrollToVisible(this.control.getViewport(), this.control, pos.getRow(), pos.getCol());
                this.control.repaint();
            } else {
                this.cp.rememberedRow = pos.getRow();
                this.cp.rememberedCol = pos.getCol();
                a = new Area(pos.getRow(), pos.getCol(), pos.getRow(), pos.getCol());
                a = this.control.setActiveCell(pos);
                this.control.addSelectedArea(a, false);
                this.control.repaint();
                this.cp.requestFocus();
            }
        }
        if (isActiveCell && e.getButton() == 1 && e.getClickCount() != 2) {
            this.cp.initEditor((byte)1);
            this.cp.editorMousePressed(e, row, col);
        }
        final MouseEvent me = e;
        Thread t = new Thread(){

            @Override
            public void run() {
                CellSelectListener.this.showPopup(me);
            }
        };
        SwingUtilities.invokeLater(t);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.dragTimer != null) {
            this.dragTimer.stop();
            this.dragTimer = null;
        }
        if (!this.editable) {
            this.showPopup(e);
            return;
        }
        if (this.control.isSelectingCell()) {
            return;
        }
        CellLocation pos = ControlUtils.lookupCellPosition(e.getX(), e.getY(), this.cp);
        if (pos == null) {
            return;
        }
        int row = pos.getRow();
        int col = pos.getCol();
        this.setCursor(this.control.cellSet.getCell(row, col));
        this.control.fireRegionSelect(false);
        this.control.status = 0;
        final MouseEvent me = e;
        Thread t = new Thread(){

            @Override
            public void run() {
                CellSelectListener.this.showPopup(me);
            }
        };
        SwingUtilities.invokeLater(t);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            this.control.fireDoubleClicked(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.dragTimer != null) {
            this.dragTimer.stop();
            this.dragTimer = null;
        }
        if (!this.editable) {
            return;
        }
        this.whenCursorMoving(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        CellLocation pos = ControlUtils.lookupCellPosition(e.getX(), e.getY(), this.cp);
        if (pos == null) {
            this.cp.setToolTipText(null);
            return;
        }
        int row = pos.getRow();
        int col = pos.getCol();
        if (row <= this.control.cellSet.getRowCount() && col <= this.control.cellSet.getColCount()) {
            String tips = ((PgmNormalCell)this.control.cellSet.getCell(row, col)).getTip();
            if (StringUtils.isValidString(tips = GM.transTips(tips))) {
                this.cp.setToolTipText(tips);
            } else {
                this.cp.setToolTipText(null);
            }
            this.control.fireMouseMove(row, col);
            this.setCursor(this.control.cellSet.getCell(row, col));
        }
    }

    protected void whenCursorMoving(MouseEvent e) {
        int y;
        if (this.control.getActiveCell() == null) {
            return;
        }
        int x = e.getX();
        CellLocation pos = ControlUtils.lookupCellPosition(x, y = e.getY(), this.cp);
        if (pos == null) {
            if (e.isControlDown() || e.isShiftDown()) {
                return;
            }
            this.holdDrag(x, y);
        } else {
            int row = pos.getRow();
            int col = pos.getCol();
            if (row == 0 || col == 0) {
                return;
            }
            this.scrollToArea(row, col);
        }
    }

    protected void holdDrag(int x, int y) {
        int j;
        int i;
        int count;
        this.row = 0;
        this.col = 0;
        this.forward = 0;
        CellSetParser parser = new CellSetParser(this.control.cellSet);
        if (y < this.cp.cellY[this.cp.drawStartRow][this.cp.drawStartCol]) {
            this.row = this.cp.drawStartRow;
            int r = this.cp.drawStartRow - 1;
            while (r >= 1) {
                if (parser.isRowVisible(r)) {
                    this.row = r;
                    break;
                }
                --r;
            }
            this.forward = (byte)(this.forward + 1);
        }
        if (y > this.cp.cellY[this.cp.drawEndRow][this.cp.drawStartCol] + this.cp.cellH[this.cp.drawEndRow][this.cp.drawStartCol]) {
            count = this.control.cellSet.getRowCount();
            this.row = this.cp.drawEndRow;
            int r = this.cp.drawEndRow + 1;
            while (r <= count) {
                if (parser.isRowVisible(r)) {
                    this.row = r;
                    break;
                }
                ++r;
            }
            this.forward = (byte)(this.forward + 2);
        }
        if (x < this.cp.cellX[this.cp.drawStartRow][this.cp.drawStartCol]) {
            this.col = this.cp.drawStartCol;
            int c = this.cp.drawStartCol - 1;
            while (c >= 1) {
                if (parser.isColVisible(c)) {
                    this.col = c;
                    break;
                }
                --c;
            }
            this.forward = (byte)(this.forward + 4);
        }
        if (x > this.cp.cellX[this.cp.drawStartRow][this.cp.drawEndCol] + this.cp.cellW[this.cp.drawStartRow][this.cp.drawEndCol]) {
            count = this.control.cellSet.getColCount();
            this.col = this.cp.drawEndCol;
            int c = this.cp.drawEndCol + 1;
            while (c <= count) {
                if (parser.isColVisible(c)) {
                    this.col = c;
                    break;
                }
                ++c;
            }
            this.forward = (byte)(this.forward + 8);
        }
        if (this.row == 0 || this.row > this.control.cellSet.getRowCount()) {
            i = 1;
            while (i < this.cp.cellX.length) {
                j = 1;
                while (j < this.cp.cellX[i].length) {
                    if (y > this.cp.cellY[i][j] && y <= this.cp.cellY[i][j] + this.cp.cellH[i][j]) {
                        this.row = i;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.col == 0 || this.col > this.control.cellSet.getColCount()) {
            i = 1;
            while (i < this.cp.cellX.length) {
                j = 1;
                while (j < this.cp.cellX[i].length) {
                    if (x > this.cp.cellX[i][j] && x <= this.cp.cellX[i][j] + this.cp.cellW[i][j]) {
                        this.col = j;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.row == 0 || this.col == 0) {
            return;
        }
        this.dragTimer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int delay;
                if (CellSelectListener.this.row <= 0 || CellSelectListener.this.col <= 0 || CellSelectListener.this.row > CellSelectListener.this.control.cellSet.getRowCount() || CellSelectListener.this.col > CellSelectListener.this.control.cellSet.getColCount()) {
                    return;
                }
                CellSelectListener.this.scrollToArea(CellSelectListener.this.row, CellSelectListener.this.col);
                if ((CellSelectListener.this.forward & 1) == 1) {
                    --CellSelectListener.this.row;
                }
                if ((CellSelectListener.this.forward & 2) == 2) {
                    ++CellSelectListener.this.row;
                }
                if ((CellSelectListener.this.forward & 4) == 4) {
                    --CellSelectListener.this.col;
                }
                if ((CellSelectListener.this.forward & 8) == 8) {
                    ++CellSelectListener.this.col;
                }
                if ((delay = CellSelectListener.this.dragTimer.getDelay()) > 10) {
                    if ((delay -= 30) < 5) {
                        delay = 5;
                    }
                    CellSelectListener.this.dragTimer.setDelay(delay);
                    CellSelectListener.this.dragTimer.restart();
                }
            }
        });
        this.dragTimer.setInitialDelay(5);
        this.dragTimer.start();
    }

    protected void scrollToArea(int row, int col) {
        this.control.status = 1;
        Area area = new Area(this.control.getActiveCell().getRow(), this.control.getActiveCell().getCol(), row, col);
        area = ControlUtils.adjustArea(area);
        ControlUtils.scrollToVisible(this.control.getViewport(), this.control, row, col);
        this.control.addSelectedArea(area, true);
        this.control.repaint();
        SplEditor editor = ControlUtils.extractSplEditor(this.control);
        if (editor != null) {
            editor.setSelectedAreas(this.control.getSelectedAreas());
            editor.resetSelectedAreas();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 17) {
            this.isCtrlDown = false;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        CellLocation activeCell = this.control.getActiveCell();
        if (activeCell == null) {
            return;
        }
        int curCol = activeCell.getCol();
        int curRow = activeCell.getRow();
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        PgmCellSet ics = this.control.getCellSet();
        SplEditor editor = ControlUtils.extractSplEditor(this.control);
        int key = e.getKeyCode();
        switch (key) {
            case 10: {
                if (e.isAltDown()) {
                    return;
                }
                if (e.isShiftDown()) {
                    return;
                }
                if (e.isControlDown()) {
                    if (editor == null) break;
                    editor.hotKeyInsert((byte)0);
                    break;
                }
                if (GM.isMacOS() && e.isMetaDown()) {
                    if (editor == null) break;
                    editor.hotKeyInsert((byte)0);
                    break;
                }
                if (GVSpl.panelValue != null) {
                    GVSpl.panelValue.tableValue.setLocked(false);
                }
                CellSetParser parser = new CellSetParser(this.control.cellSet);
                int nextCol = -1;
                int c = curCol + 1;
                while (c <= this.control.cellSet.getColCount()) {
                    PgmNormalCell cell;
                    if (parser.isColVisible(c) && !this.isSkipCell(cell = this.control.cellSet.getPgmNormalCell(curRow, c), parser, curRow, c)) {
                        nextCol = c;
                        break;
                    }
                    ++c;
                }
                if (nextCol > 0) {
                    this.control.scrollToArea(this.control.setActiveCell(new CellLocation(curRow, nextCol)));
                    break;
                }
                if (curRow == ics.getRowCount()) {
                    this.appendOneRow();
                } else {
                    boolean allHide = true;
                    int r = curRow + 1;
                    while (r <= ics.getRowCount()) {
                        if (parser.isRowVisible(r)) {
                            allHide = false;
                            break;
                        }
                        ++r;
                    }
                    if (allHide && editor != null) {
                        AtomicSpl cmd = editor.getInsertRow(false, new CellRect(curRow, 1, 1, 1));
                        editor.executeCmd(cmd);
                    }
                }
                this.control.scrollToArea(this.control.toDownCell());
                break;
            }
            case 8: {
                if (GM.isMacOS()) {
                    if (!(e.isAltDown() || e.isMetaDown() || e.isShiftDown())) {
                        if (editor == null) break;
                        editor.clear((byte)1);
                        break;
                    }
                    return;
                }
                if (e.isControlDown()) {
                    if (curCol > 1) {
                        int moveCols = ics.getColCount() - curCol + 1;
                        CellRect srcRect = new CellRect(curRow, curCol, 1, moveCols);
                        CellRect tarRect = new CellRect(curRow, curCol - 1, 1, moveCols);
                        this.moveRect(srcRect, tarRect);
                        break;
                    }
                    if (curRow <= 1) break;
                    int colCount = ics.getColCount();
                    if (this.getEmptyColumns(curRow - 1) == colCount) {
                        AtomicSpl cmd = new AtomicSpl(this.control);
                        cmd.setType((byte)3);
                        CellRect rect = new CellRect(curRow - 1, 1, 1, colCount);
                        cmd.setRect(rect);
                        cmds.add(cmd);
                        ControlUtils.extractSplEditor(this.control).executeCmd(cmds);
                        this.control.scrollToArea(this.control.setActiveCell(new CellLocation(rect.getBeginRow(), rect.getBeginCol())));
                        break;
                    }
                    int topUsedCols = this.getUsedCols(curRow - 1);
                    this.connectRowUpTo(curRow, topUsedCols + 1);
                    break;
                }
                AtomicCell ac = new AtomicCell(this.control, ics.getCell(activeCell.getRow(), activeCell.getCol()));
                ac.setProperty((byte)1);
                ac.setValue(null);
                cmds.add(ac);
                ControlUtils.extractSplEditor(this.control).executeCmd(cmds);
                break;
            }
            case 113: {
                int ca = 0;
                try {
                    CellLocation cl = this.control.getActiveCell();
                    String text = ControlUtils.getCellText(this.control.cellSet, cl.getRow(), cl.getCol(), true);
                    ca = text.length();
                }
                catch (Throwable cl) {
                    // empty catch block
                }
                this.cp.initEditor(ca, (byte)1);
                break;
            }
            case 36: {
                if (e.isControlDown()) {
                    int firstVisibleRow = 1;
                    int rowCount = this.control.cellSet.getRowCount();
                    CellSetParser parser = new CellSetParser(ics);
                    while (!parser.isRowVisible(firstVisibleRow)) {
                        if (++firstVisibleRow <= rowCount) continue;
                        return;
                    }
                    if (e.isShiftDown()) {
                        Area area = this.control.getSelectedArea(0);
                        Area newArea = new Area(firstVisibleRow, area.getBeginCol(), activeCell.getRow(), area.getEndCol());
                        this.control.selectToArea(newArea);
                        break;
                    }
                    this.control.scrollToArea(this.control.setActiveCell(new CellLocation(firstVisibleRow, curCol)));
                    break;
                }
                int firstCol = this.getFirstNonEmptyColumn(curRow);
                if (curCol == firstCol) {
                    firstCol = 1;
                }
                this.control.scrollToArea(this.control.setActiveCell(new CellLocation(curRow, firstCol)));
                break;
            }
            case 35: {
                if (e.isControlDown()) {
                    int lastVisibleRow = this.control.cellSet.getRowCount();
                    CellSetParser parser = new CellSetParser(ics);
                    while (!parser.isRowVisible(lastVisibleRow)) {
                        if (--lastVisibleRow >= 1) continue;
                        return;
                    }
                    if (e.isShiftDown()) {
                        Area area = this.control.getSelectedArea(0);
                        Area newArea = new Area(activeCell.getRow(), area.getBeginCol(), lastVisibleRow, area.getEndCol());
                        this.control.selectToArea(newArea);
                        break;
                    }
                    this.control.scrollToArea(this.control.setActiveCell(new CellLocation(lastVisibleRow, curCol)));
                    break;
                }
                this.control.scrollToArea(this.control.setActiveCell(new CellLocation(curRow, ics.getColCount())));
                break;
            }
            case 33: {
                int PAGE_WIDTH = GM.getPageWidth(this.control.scale);
                int PAGE_HEIGHT = GM.getPageHeight(this.control.scale);
                CellSetParser parser = new CellSetParser(this.control.cellSet);
                if (e.isControlDown()) {
                    int preVisibleCol = curCol;
                    int tmpWidth = parser.getColWidth(curCol, this.control.scale);
                    int c = curCol - 1;
                    while (c >= 1) {
                        if (parser.isColVisible(c)) {
                            preVisibleCol = c;
                            if ((tmpWidth += parser.getColWidth(c, this.control.scale)) > PAGE_WIDTH) break;
                        }
                        --c;
                    }
                    if (e.isShiftDown()) {
                        Area area = this.control.getSelectedArea(0);
                        Area newArea = new Area(area.getBeginRow(), preVisibleCol, area.getEndRow(), activeCell.getCol());
                        this.control.selectToArea(newArea);
                        break;
                    }
                    this.control.scrollToArea(this.control.setActiveCell(new CellLocation(curRow, preVisibleCol)));
                    break;
                }
                int tmpHeight = parser.getRowHeight(curRow, this.control.scale);
                int preVisibleRow = curRow;
                int r = curRow - 1;
                while (r >= 1) {
                    if (parser.isRowVisible(r)) {
                        preVisibleRow = r;
                        if ((tmpHeight += parser.getRowHeight(r, this.control.scale)) > PAGE_HEIGHT) break;
                    }
                    --r;
                }
                this.control.scrollToArea(this.control.setActiveCell(new CellLocation(preVisibleRow, curCol)));
                if (preVisibleRow != 1) break;
                this.control.getVerticalScrollBar().setValue(0);
                break;
            }
            case 34: {
                CellSetParser parser = new CellSetParser(this.control.cellSet);
                int PAGE_WIDTH = GM.getPageWidth(this.control.scale);
                int PAGE_HEIGHT = GM.getPageHeight(this.control.scale);
                if (e.isControlDown()) {
                    int deltaW = this.cp.getColOffset(curCol, this.control.scale) - this.control.getHorizontalScrollBar().getValue();
                    int subVisibleCol = curCol;
                    int colCount = this.control.cellSet.getColCount();
                    int tmpWidth = parser.getColWidth(curCol, this.control.scale);
                    int c = curCol + 1;
                    while (c <= colCount) {
                        if (parser.isColVisible(c)) {
                            subVisibleCol = c;
                            if ((tmpWidth += parser.getColWidth(c, this.control.scale)) > PAGE_WIDTH) break;
                        }
                        ++c;
                    }
                    if (e.isShiftDown()) {
                        Area area = this.control.getSelectedArea(0);
                        Area newArea = new Area(area.getBeginRow(), activeCell.getCol(), area.getEndRow(), subVisibleCol);
                        this.control.selectToArea(newArea);
                    } else {
                        this.control.scrollToArea(this.control.setActiveCell(new CellLocation(curRow, subVisibleCol)));
                    }
                    this.control.getHorizontalScrollBar().setValue(this.cp.getColOffset(subVisibleCol, this.control.scale) - deltaW);
                    break;
                }
                int tmpHeight = parser.getRowHeight(curRow, this.control.scale);
                int subVisibleRow = curRow;
                int rowCount = this.control.cellSet.getRowCount();
                int r = curRow + 1;
                while (r <= rowCount) {
                    if (parser.isRowVisible(r)) {
                        subVisibleRow = r;
                        if ((tmpHeight += parser.getRowHeight(curRow, this.control.scale)) > PAGE_HEIGHT) break;
                    }
                    ++r;
                }
                this.control.scrollToArea(this.control.setActiveCell(new CellLocation(subVisibleRow, curCol)));
                break;
            }
            case 38: {
                if (e.isShiftDown()) {
                    CellLocation tarPos = null;
                    if (e.isControlDown()) {
                        Area area = this.control.getSelectedArea(0);
                        CellLocation pos = new CellLocation(activeCell.getRow(), activeCell.getCol());
                        if (area.getEndRow() == activeCell.getRow()) {
                            pos.setRow(area.getBeginRow());
                        }
                        tarPos = this.getNextPos(pos, (byte)1);
                    }
                    this.control.selectToUpCell(tarPos);
                    break;
                }
                if (e.isAltDown()) {
                    return;
                }
                if (e.isMetaDown()) {
                    return;
                }
                if (e.isControlDown()) {
                    this.control.scrollToArea(this.control.setActiveCell(this.getNextPos(activeCell, (byte)1)));
                    break;
                }
                this.control.scrollToArea(this.control.toUpCell());
                break;
            }
            case 40: {
                if (e.isShiftDown()) {
                    CellLocation tarPos = null;
                    if (e.isControlDown()) {
                        Area area = this.control.getSelectedArea(0);
                        CellLocation pos = new CellLocation(activeCell.getRow(), activeCell.getCol());
                        if (area.getBeginRow() == activeCell.getRow()) {
                            pos.setRow(area.getEndRow());
                        }
                        tarPos = this.getNextPos(pos, (byte)2);
                    }
                    this.control.selectToDownCell(tarPos);
                    break;
                }
                if (e.isAltDown()) {
                    return;
                }
                if (e.isMetaDown()) {
                    return;
                }
                if (e.isControlDown()) {
                    this.control.scrollToArea(this.control.setActiveCell(this.getNextPos(activeCell, (byte)2)));
                    break;
                }
                this.control.scrollToArea(this.control.toDownCell());
                break;
            }
            case 37: {
                if (e.isShiftDown()) {
                    CellLocation tarPos = null;
                    if (e.isControlDown()) {
                        Area area = this.control.getSelectedArea(0);
                        CellLocation pos = new CellLocation(activeCell.getRow(), activeCell.getCol());
                        if (area.getEndCol() == activeCell.getCol()) {
                            pos.setRow(area.getBeginCol());
                        }
                        tarPos = this.getNextPos(pos, (byte)3);
                    }
                    this.control.selectToLeftCell(tarPos);
                    break;
                }
                if (e.isAltDown()) {
                    return;
                }
                if (e.isMetaDown()) {
                    return;
                }
                if (e.isControlDown()) {
                    this.control.scrollToArea(this.control.setActiveCell(this.getNextPos(activeCell, (byte)3)));
                    break;
                }
                this.control.scrollToArea(this.control.toLeftCell());
                break;
            }
            case 39: {
                if (e.isShiftDown()) {
                    CellLocation tarPos = null;
                    if (e.isControlDown()) {
                        Area area = this.control.getSelectedArea(0);
                        CellLocation pos = new CellLocation(activeCell.getRow(), activeCell.getCol());
                        if (area.getBeginCol() == activeCell.getCol()) {
                            pos.setCol(area.getEndCol());
                        }
                        tarPos = this.getNextPos(pos, (byte)4);
                    }
                    this.control.selectToRightCell(tarPos);
                    break;
                }
                if (e.isAltDown()) {
                    return;
                }
                if (e.isMetaDown()) {
                    return;
                }
                if (e.isControlDown()) {
                    this.control.scrollToArea(this.control.setActiveCell(this.getNextPos(activeCell, (byte)4)));
                    break;
                }
                this.control.scrollToArea(this.control.toRightCell());
                break;
            }
            case 127: {
                if (GM.isMacOS()) {
                    AtomicCell ac = new AtomicCell(this.control, ics.getCell(activeCell.getRow(), activeCell.getCol()));
                    ac.setProperty((byte)1);
                    ac.setValue(null);
                    cmds.add(ac);
                    ControlUtils.extractSplEditor(this.control).executeCmd(cmds);
                    break;
                }
                return;
            }
            case 155: {
                if (e.isControlDown()) {
                    if (editor == null) break;
                    editor.hotKeyInsert((byte)2);
                    break;
                }
                if (!e.isAltDown() || editor == null) break;
                editor.hotKeyInsert((byte)3);
                break;
            }
            case 9: {
                if (e.isShiftDown()) {
                    this.control.scrollToArea(this.control.toLeftCell());
                    break;
                }
                if (e.isControlDown()) {
                    this.showNextSheet();
                    this.isCtrlDown = true;
                    break;
                }
                if (curCol == ics.getColCount()) {
                    this.appendOneCol();
                }
                this.control.scrollToArea(this.control.toRightCell());
                break;
            }
            case 27: {
                this.control.resetCellSelection(null);
                break;
            }
            case 73: {
                if (GM.isMacOS()) {
                    if (!e.isMetaDown() || e.isControlDown() || e.isAltDown() || editor == null) break;
                    editor.hotKeyInsert((byte)2);
                    break;
                }
                if (!e.isControlDown() || e.isShiftDown() || e.isAltDown() || GV.appSheet == null) break;
                ((SheetSpl)GV.appSheet).importSameNameTxt();
                break;
            }
            default: {
                if (e.getKeyCode() == 67 && e.isAltDown() && !e.isControlDown()) {
                    if (e.isShiftDown()) {
                        if (editor != null && editor.canCopyPresent()) {
                            editor.copyPresent();
                            break;
                        }
                    } else {
                        if (editor == null) break;
                        editor.altC();
                        break;
                    }
                }
                if (e.getKeyCode() == 86 && e.isAltDown() && !e.isControlDown() && !e.isShiftDown()) {
                    if (editor == null) break;
                    editor.altV();
                    break;
                }
                if (e.getKeyCode() == 65 && e.isControlDown() && !e.isShiftDown() && !e.isAltDown()) {
                    this.control.selectAll();
                    break;
                }
                if (e.getKeyCode() == 87 && e.isControlDown() && !e.isShiftDown() && !e.isAltDown()) {
                    if (GV.appSheet == null) break;
                    GV.appFrame.closeSheet(GV.appSheet);
                    break;
                }
                if (e.isActionKey()) {
                    return;
                }
                if (e.isControlDown() || e.isAltDown() || e.getKeyCode() == 16 || e.isMetaDown()) {
                    return;
                }
                if (!this.cp.isEditing()) {
                    this.cp.initEditor((byte)1);
                }
                return;
            }
        }
        e.consume();
    }

    protected void showNextSheet() {
        GVSpl.appFrame.showNextSheet(this.isCtrlDown);
    }

    protected boolean isSkipCell(PgmNormalCell cell, CellSetParser parser, int curRow, int c) {
        return cell.isNoteBlock() || cell.isNoteCell() || !StringUtils.isValidString(parser.getDispText(curRow, c));
    }

    protected void setCursor(INormalCell cell) {
        boolean isActive = false;
        if (this.control.getActiveCell() != null && this.control.getActiveCell().getRow() == cell.getRow() && this.control.getActiveCell().getCol() == cell.getCol()) {
            isActive = true;
        }
        if (isActive) {
            this.cp.setCursor(Cursor.getPredefinedCursor(1));
        } else {
            this.cp.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected void connectRowUpTo(int connectRow, int upCol) {
        int usedCols = this.getUsedCols(connectRow);
        if (usedCols == 0) {
            usedCols = 1;
        }
        CellRect srcRect = new CellRect(connectRow, 1, 1, usedCols);
        CellRect tarRect = new CellRect(connectRow - 1, upCol, 1, usedCols);
        Vector<IAtomicCmd> cmds = GMSpl.getMoveRectCmd(ControlUtils.extractSplEditor(this.control), srcRect, tarRect);
        if (cmds != null && !cmds.isEmpty()) {
            AtomicSpl cmd = new AtomicSpl(this.control);
            cmd.setType((byte)3);
            CellRect rect = new CellRect(connectRow, 1, 1, this.control.cellSet.getColCount());
            cmd.setRect(rect);
            cmds.add(cmd);
            ControlUtils.extractSplEditor(this.control).executeCmd(cmds);
            this.control.scrollToArea(this.control.setActiveCell(new CellLocation(tarRect.getBeginRow(), tarRect.getBeginCol())));
        }
    }

    protected int getFirstNonEmptyColumn(int row) {
        PgmCellSet ics = this.control.getCellSet();
        int c = 1;
        while (c <= ics.getColCount()) {
            NormalCell nc = (NormalCell)ics.getCell(row, c);
            if (StringUtils.isValidString(nc.getExpString())) {
                return c;
            }
            ++c;
        }
        return 1;
    }

    protected CellLocation getNextPos(CellLocation pos, byte direction) {
        PgmCellSet ics = this.control.getCellSet();
        CellSetParser parser = new CellSetParser(ics);
        int row = pos.getRow();
        int col = pos.getCol();
        int newr = row;
        int newc = col;
        block0 : switch (direction) {
            case 1: {
                newr = 1;
                int r = row - 1;
                while (r >= 1) {
                    NormalCell nc;
                    if (parser.isRowVisible(r) && StringUtils.isValidString((nc = (NormalCell)ics.getCell(r, col)).getExpString())) {
                        newr = r;
                        break block0;
                    }
                    --r;
                }
                break;
            }
            case 2: {
                newr = ics.getRowCount();
                int r = row + 1;
                while (r <= ics.getRowCount()) {
                    NormalCell nc;
                    if (parser.isRowVisible(r) && StringUtils.isValidString((nc = (NormalCell)ics.getCell(r, col)).getExpString())) {
                        newr = r;
                        break block0;
                    }
                    ++r;
                }
                break;
            }
            case 3: {
                newc = 1;
                int c = col - 1;
                while (c >= 1) {
                    NormalCell nc;
                    if (parser.isColVisible(c) && StringUtils.isValidString((nc = (NormalCell)ics.getCell(row, c)).getExpString())) {
                        newc = c;
                        break block0;
                    }
                    --c;
                }
                break;
            }
            case 4: {
                newc = ics.getColCount();
                int c = col + 1;
                while (c <= ics.getColCount()) {
                    NormalCell nc;
                    if (parser.isColVisible(c) && StringUtils.isValidString((nc = (NormalCell)ics.getCell(row, c)).getExpString())) {
                        newc = c;
                        break block0;
                    }
                    ++c;
                }
                break;
            }
        }
        return new CellLocation(newr, newc);
    }

    public int getUsedCols(int row) {
        PgmCellSet ics = this.control.getCellSet();
        int colCount = ics.getColCount();
        return colCount - this.getEmptyColumns(row);
    }

    protected int getEmptyColumns(int row) {
        int colCount;
        PgmCellSet ics = this.control.getCellSet();
        int c = colCount = ics.getColCount();
        while (c >= 1) {
            NormalCell nc = (NormalCell)ics.getCell(row, c);
            if (StringUtils.isValidString(nc.getExpString())) {
                return colCount - c;
            }
            --c;
        }
        return colCount;
    }

    public int getUsedRows(int col) {
        PgmCellSet ics = this.control.getCellSet();
        int rowCount = ics.getRowCount();
        return rowCount - this.getEmptyRows(col);
    }

    protected int getEmptyRows(int col) {
        int rowCount;
        PgmCellSet ics = this.control.getCellSet();
        int r = rowCount = ics.getRowCount();
        while (r >= 1) {
            NormalCell nc = (NormalCell)ics.getCell(r, col);
            if (StringUtils.isValidString(nc.getExpString())) {
                return rowCount - r;
            }
            --r;
        }
        return rowCount;
    }

    protected boolean moveRect(CellRect srcRect, CellRect tarRect) {
        return this.moveRect(srcRect, tarRect, true);
    }

    public boolean moveRect(CellRect srcRect, CellRect tarRect, boolean scrollToTarget) {
        Vector<IAtomicCmd> cmds = GMSpl.getMoveRectCmd(ControlUtils.extractSplEditor(this.control), srcRect, tarRect);
        if (cmds == null) {
            return false;
        }
        ControlUtils.extractSplEditor(this.control).executeCmd(cmds);
        if (scrollToTarget) {
            this.control.scrollToArea(this.control.setActiveCell(new CellLocation(tarRect.getBeginRow(), tarRect.getBeginCol())));
        }
        return true;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        JComponent textEditor;
        if (!this.editable) {
            return;
        }
        char c = e.getKeyChar();
        if (!Character.isDefined(c)) {
            return;
        }
        if (e.isControlDown()) {
            return;
        }
        if (e.isAltDown()) {
            return;
        }
        if (c == '\u001b' || c == '\n' || c == '\b' || c == '\t') {
            return;
        }
        if (this.cp.isEditing() && (textEditor = this.cp.getEditor()) instanceof JTextComponent) {
            textEditor.requestFocus();
            String text = String.valueOf(e.getKeyChar());
            try {
                ((JTextComponent)textEditor).setText(text);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void showPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.control.fireRightClicked(e, 1);
        }
    }

    protected void appendOneRow() {
        SplEditor editor = ControlUtils.extractSplEditor(this.control);
        if (editor != null) {
            editor.appendRows(1);
        }
    }

    protected void appendOneCol() {
        SplEditor editor = ControlUtils.extractSplEditor(this.control);
        if (editor != null) {
            editor.appendCols(1);
        }
    }
}

