/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.control;

import com.scudata.cellset.datamodel.CellSet;
import com.scudata.cellset.datamodel.ColCell;
import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.cellset.datamodel.RowCell;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.GC;
import com.scudata.ide.common.GM;
import com.scudata.ide.spl.control.SplControl;
import java.awt.Color;
import java.awt.Font;

public class CellSetParser {
    private static NormalCell blankCell;
    private CellSet cellSet;
    public static final byte TYPE_NOTE = 1;
    public static final byte TYPE_CALC = 2;
    public static final byte TYPE_CONST = 3;
    public static final byte TYPE_CONST_NULL = 4;
    public static final byte TYPE_EXP = 5;
    public static final byte TYPE_EXP_NULL = 6;
    public static final byte TYPE_CELL_NOTE = 7;

    public CellSetParser(CellSet cellSet) {
        this.cellSet = cellSet;
        blankCell = new PgmNormalCell();
    }

    public CellSet getCellSet() {
        return this.cellSet;
    }

    public NormalCell getCell(int row, int col) {
        return this.getCell(row, col, false);
    }

    public NormalCell getCell(int row, int col, boolean create) {
        NormalCell cell = (NormalCell)this.cellSet.getCell(row, col);
        if (cell == null) {
            if (create) {
                return new PgmNormalCell();
            }
            return blankCell;
        }
        return cell;
    }

    public int getCellIndent(int row, int col) {
        return ConfigOptions.iIndent;
    }

    public byte getCellDispType(int row, int col) {
        NormalCell cell = this.getCell(row, col);
        int dispType = 6;
        if (cell == null) {
            return (byte)dispType;
        }
        String expStr = cell.getExpString();
        if (StringUtils.isValidString(expStr) && (expStr = expStr.trim()).startsWith("/*")) {
            if (expStr.endsWith("*/")) {
                return 7;
            }
            if (expStr.indexOf("*/") > 1) {
                if (cell.getValue() != null) {
                    return 5;
                }
                return 6;
            }
        }
        int type = cell.getType();
        switch (type) {
            case 64: 
            case 128: {
                return 1;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                dispType = 2;
            }
        }
        int topRow = 1;
        int c = 1;
        while (c < col) {
            int r = row;
            while (r >= topRow) {
                NormalCell temp = this.getCell(r, c);
                switch (temp.getType()) {
                    case 128: {
                        return 1;
                    }
                    case 2: 
                    case 8: {
                        dispType = 2;
                        topRow = r;
                        break;
                    }
                    default: {
                        if (!StringUtils.isValidString(temp.getExpString())) break;
                        topRow = r;
                    }
                }
                --r;
            }
            ++c;
        }
        if (cell.getType() == 32) {
            if (this.isSubCell(row, col)) {
                return 4;
            }
            if (dispType != 2) {
                return 3;
            }
        }
        if (cell.getValue() != null) {
            return 5;
        }
        return 6;
    }

    public static byte[][] getCellDispTypes(PgmCellSet cellSet) {
        CellSetParser parser = new CellSetParser(cellSet);
        int rc = cellSet.getRowCount();
        int cc = cellSet.getColCount();
        byte[][] dispTypes = new byte[rc][cc];
        int r = 1;
        while (r <= rc) {
            dispTypes[r - 1] = new byte[cc];
            int c = 1;
            while (c <= cc) {
                dispTypes[r - 1][c - 1] = parser.getCellDispType(r, c);
                ++c;
            }
            ++r;
        }
        return dispTypes;
    }

    private boolean isSubCell(int row, int col) {
        int colCount = this.cellSet.getColCount();
        int r = row;
        while (r >= 1) {
            int c = colCount;
            while (c >= 1) {
                if (r == row && c > col) {
                    c = col;
                } else {
                    NormalCell nc = this.getCell(r, c);
                    String expStr = nc.getExpString();
                    if (StringUtils.isValidString(expStr)) {
                        if (!this.isSubString(expStr)) {
                            return false;
                        }
                        switch (nc.getType()) {
                            case 1: 
                            case 2: 
                            case 4: 
                            case 8: {
                                return true;
                            }
                            case 32: {
                                break;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                }
                --c;
            }
            --r;
        }
        return false;
    }

    private boolean isSubString(String expStr) {
        char lastChar = expStr.charAt(expStr.length() - 1);
        return lastChar == ',' || lastChar == ';' || lastChar == '(';
    }

    public Color getBackColor(int row, int col) {
        return this.getCellTypeColor(row, col, false);
    }

    public Color getForeColor(int row, int col) {
        return this.getCellTypeColor(row, col, true);
    }

    protected Color getCellTypeColor(int row, int col, boolean isGetForeground) {
        byte type = this.getCellDispType(row, col);
        if (type == 7) {
            return isGetForeground ? ConfigOptions.iCellNoteFColor : ConfigOptions.iCellNoteBColor;
        }
        if (type == 1) {
            return isGetForeground ? ConfigOptions.iNoteFColor : ConfigOptions.iNoteBColor;
        }
        if (type == 4) {
            return isGetForeground ? ConfigOptions.iNValueFColor : ConfigOptions.iNValueBColor;
        }
        if (type == 3) {
            return isGetForeground ? ConfigOptions.iConstFColor : ConfigOptions.iConstBColor;
        }
        if (type == 5) {
            return isGetForeground ? ConfigOptions.iValueFColor : ConfigOptions.iValueBColor;
        }
        return isGetForeground ? ConfigOptions.iNValueFColor : ConfigOptions.iNValueBColor;
    }

    public String getDispText(int row, int col) {
        NormalCell nc = this.getCell(row, col);
        String text = nc.getExpString();
        return text;
    }

    public Font getFont(int row, int col, float scale) {
        return GM.getScaleFont(scale);
    }

    public String getFontName(int row, int col) {
        return GC.font.getFontName();
    }

    public int getFontSize(int row, int col) {
        return GC.font.getSize();
    }

    public String getFormat(int row, int col) {
        return null;
    }

    public byte getHAlign(int row, int col) {
        return ConfigOptions.iHAlign;
    }

    public byte getVAlign(int row, int col) {
        return ConfigOptions.iVAlign;
    }

    public boolean isBold(int row, int col) {
        return ConfigOptions.bBold;
    }

    public boolean isItalic(int row, int col) {
        return ConfigOptions.bItalic;
    }

    public boolean isUnderline(int row, int col) {
        return ConfigOptions.bUnderline;
    }

    public int getRowCount() {
        return this.cellSet.getRowCount();
    }

    public int getRowHeight(int row, float scale) {
        RowCell cell = (RowCell)this.cellSet.getRowCell(row);
        float height = cell.getHeight();
        int h = (int)Math.ceil(height * scale);
        if ((double)scale != 1.0) {
            ++h;
        }
        return h;
    }

    public int getColCount() {
        return this.cellSet.getColCount();
    }

    public int getColWidth(int col, float scale) {
        ColCell cell = (ColCell)this.cellSet.getColCell(col);
        float width = cell.getWidth();
        int w = (int)Math.ceil(width * scale);
        if ((double)scale != 1.0) {
            ++w;
        }
        return w;
    }

    public boolean isRowVisible(int row) {
        RowCell rc = (RowCell)this.cellSet.getRowCell(row);
        return rc.getVisible() != 1;
    }

    public boolean isColVisible(int col) {
        ColCell cc = (ColCell)this.cellSet.getColCell(col);
        return cc.getVisible() != 1;
    }

    public int getColsWidth(SplControl control, int startCol, int count, float scale) {
        int width = 0;
        int i = 0;
        int col = startCol;
        while (i < count) {
            if (this.isColVisible(col)) {
                width += this.getColWidth(col, scale);
            }
            ++i;
            ++col;
        }
        return width;
    }

    public int getRowsHeight(SplControl control, int startRow, int count, float scale) {
        int height = 0;
        int i = 0;
        int row = startRow;
        while (i < count) {
            if (this.isRowVisible(row)) {
                height += this.getRowHeight(row, scale);
            }
            ++i;
            ++row;
        }
        return height;
    }

    public int getSubEnd(int row) {
        int subEnd = -1;
        int c = 1;
        int cc = this.cellSet.getColCount();
        while (c <= cc) {
            PgmNormalCell cell = (PgmNormalCell)this.cellSet.getCell(row, c);
            switch (cell.getType()) {
                case 2: 
                case 8: 
                case 16: 
                case 128: {
                    subEnd = ((PgmCellSet)this.cellSet).getCodeBlockEndRow(row, c);
                    if (subEnd <= row) break;
                    return subEnd;
                }
            }
            ++c;
        }
        return subEnd;
    }

    public boolean isSubExpand(int row, int subEnd) {
        if (subEnd <= row) {
            return false;
        }
        RowCell rc = (RowCell)this.cellSet.getRowCell(row + 1);
        return rc.getVisible() != 1;
    }
}

