/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.control;

import com.scudata.cellset.INormalCell;
import com.scudata.cellset.datamodel.CellSet;
import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.Area;
import com.scudata.common.CellLocation;
import com.scudata.common.IntArrayList;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.control.BorderStyle;
import com.scudata.ide.common.control.CellBorder;
import com.scudata.ide.common.control.CellRect;
import com.scudata.ide.common.swing.RSyntaxTextAreaEx;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.SheetSpl;
import com.scudata.ide.spl.ToolBarProperty;
import com.scudata.ide.spl.control.CellEditingListener;
import com.scudata.ide.spl.control.CellSetParser;
import com.scudata.ide.spl.control.ControlUtils;
import com.scudata.ide.spl.control.EditorRightClicked;
import com.scudata.ide.spl.control.ShowEditorListener;
import com.scudata.ide.spl.control.SplControl;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextHitInfo;
import java.awt.geom.Rectangle2D;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class ContentPanel
extends JPanel
implements InputMethodListener,
InputMethodRequests {
    private static final long serialVersionUID = 1L;
    public static Color XOR_COLOR = new Color(51, 0, 51);
    CellSet cellSet;
    protected CellSetParser parser;
    protected int startRow;
    protected int endRow;
    protected int startCol;
    protected int endCol;
    protected boolean isEditing;
    protected boolean onlyDrawCellInWin;
    protected boolean editable;
    JScrollPane jsp;
    protected SplControl control;
    int[][] cellX;
    int[][] cellY;
    int[][] cellW;
    int[][] cellH;
    public int drawStartRow;
    public int drawStartCol;
    public int drawEndRow;
    public int drawEndCol;
    protected RTextScrollPane spEditor;
    protected RSyntaxTextAreaEx editor;
    public int rememberedRow = 0;
    public int rememberedCol = 0;
    public static final int MULTI_EDITOR = 2;
    protected boolean preventChange = false;
    protected BorderStyle borderStyle = new BorderStyle();
    public static BasicStroke bs1 = new BasicStroke(2.0f, 0, 0, 1.0f, new float[]{4.0f}, 0.0f);
    public static BasicStroke bs2 = new BasicStroke(2.0f, 0, 0, 1.0f, new float[]{5.0f}, 0.0f);
    protected BasicStroke bs = null;
    protected CellLocation editPos = null;
    protected String undoExp = null;
    protected SheetSpl sheet;
    private Rectangle dropRect = null;
    public static final byte MODE_PAINT = 0;
    public static final byte MODE_SHOW = 1;
    public static final byte MODE_HIDE = 2;

    public ContentPanel(CellSet cellSet, int startRow, int endRow, int startCol, int endCol, boolean isEditing, boolean onlyDrawCellInWin, JScrollPane jsp) {
        this(cellSet, startRow, endRow, startCol, endCol, isEditing, onlyDrawCellInWin, jsp, null);
    }

    public ContentPanel(CellSet cellSet, int startRow, int endRow, int startCol, int endCol, boolean isEditing, boolean onlyDrawCellInWin, JScrollPane jsp, SheetSpl sheet) {
        this.sheet = sheet;
        this.cellSet = cellSet;
        this.parser = this.newCellSetParser(cellSet);
        this.startRow = startRow;
        this.endRow = endRow;
        this.startCol = startCol;
        this.endCol = endCol;
        this.isEditing = isEditing;
        this.onlyDrawCellInWin = onlyDrawCellInWin;
        this.jsp = jsp;
        if (jsp instanceof SplControl) {
            this.control = (SplControl)jsp;
        }
        this.setDoubleBuffered(true);
        this.initCellLocations();
        this.setLayout(null);
        this.newEditor();
        this.spEditor = new RTextScrollPane((RTextArea)this.editor);
        this.spEditor.setLineNumbersEnabled(false);
        this.spEditor.setHorizontalScrollBarPolicy(31);
        this.spEditor.setVerticalScrollBarPolicy(21);
        this.editor.setVisible(false);
        this.spEditor.setVisible(false);
        this.add((Component)this.spEditor);
        if (!isEditing) {
            this.addMouseListener(new ShowEditorListener(this));
        } else {
            this.enableInputMethods(true);
            this.addInputMethodListener(this);
            this.addEditorFocusListener((JTextComponent)((Object)this.editor));
            this.addCellEditingListener(this.control, (JTextComponent)((Object)this.editor));
            EditorRightClicked erc = new EditorRightClicked(this.control);
            this.editor.addMouseListener(erc);
            MouseAdapter ma = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    MouseListener[] ml;
                    if (e.getClickCount() == 2 && (ml = ContentPanel.this.getMouseListeners()) != null) {
                        int i = 0;
                        while (i < ml.length) {
                            ml[i].mouseClicked(e);
                            ++i;
                        }
                    }
                }
            };
            this.editor.addMouseListener(ma);
        }
    }

    protected void newEditor() {
        this.editor = new RSyntaxTextAreaEx(){
            private static final long serialVersionUID = 1L;

            public Point getToolTipLocation(MouseEvent e) {
                if (ContentPanel.this.control.getActiveCell() == null) {
                    return new Point(-9999, -9999);
                }
                int r = ContentPanel.this.control.getActiveCell().getRow();
                int c = ContentPanel.this.control.getActiveCell().getCol();
                Point p = ContentPanel.this.getTipPos(1 + ContentPanel.this.cellX[r][c], 1 + ContentPanel.this.cellY[r][c]);
                return new Point(p.x - ContentPanel.this.cellX[r][c], p.y - ContentPanel.this.cellY[r][c]);
            }

            @Override
            protected void docUpdate() {
                if (ContentPanel.this.preventChange || this.preventChanged) {
                    return;
                }
                super.docUpdate();
                try {
                    GV.toolBarProperty.setTextEditorText(ContentPanel.this.editor.getText());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    ContentPanel.this.resetEditorBounds();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
    }

    protected CellSetParser newCellSetParser(CellSet cellSet) {
        return new CellSetParser(cellSet);
    }

    protected void addCellEditingListener(SplControl control, JTextComponent jtext) {
        CellEditingListener listener = new CellEditingListener(control, this);
        jtext.addKeyListener(listener);
    }

    protected void addEditorFocusListener(JTextComponent jtext) {
        jtext.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GVSpl.isCellEditing = true;
            }
        });
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.repaint();
    }

    public boolean isEditable() {
        return this.editable;
    }

    protected boolean isCellEditable(int row, int col) {
        return this.editable;
    }

    public void setCellSet(CellSet newCellSet) {
        this.cellSet = newCellSet;
        this.parser = new CellSetParser(newCellSet);
        this.repaint();
    }

    public SplControl getControl() {
        return this.control;
    }

    @Override
    public Dimension getPreferredSize() {
        float scale = 1.0f;
        if (this.control != null) {
            scale = this.control.scale;
        }
        if (this.endCol > this.cellSet.getColCount()) {
            this.endCol = this.cellSet.getColCount();
        }
        if (this.endRow > this.cellSet.getRowCount()) {
            this.endRow = this.cellSet.getRowCount();
        }
        int width = 0;
        int col = this.startCol;
        while (col <= this.cellSet.getColCount()) {
            if (this.parser.isColVisible(col)) {
                width += this.parser.getColWidth(col, scale);
            }
            ++col;
        }
        int height = 0;
        int lastRowHeight = 0;
        int row = this.startRow;
        while (row <= this.cellSet.getRowCount()) {
            if (this.parser.isRowVisible(row)) {
                lastRowHeight = this.parser.getRowHeight(row, scale);
                height += lastRowHeight;
            }
            ++row;
        }
        Rectangle displayWin = this.jsp.getViewport().getViewRect();
        if (displayWin != null && displayWin.height > lastRowHeight) {
            height += displayWin.height - lastRowHeight - 1;
        }
        return new Dimension(width + 2, height + 2);
    }

    public int getRowOffset(int row, float scale) {
        int h = 0;
        int r = 1;
        while (r < row) {
            if (this.parser.isRowVisible(r)) {
                h += this.parser.getRowHeight(r, scale);
            }
            ++r;
        }
        return h;
    }

    public int getColOffset(int col, float scale) {
        int w = 0;
        int c = 1;
        while (c < col) {
            if (this.parser.isColVisible(c)) {
                w += this.parser.getColWidth(c, scale);
            }
            ++c;
        }
        return w;
    }

    @Override
    public void paintComponent(Graphics g) {
        int col;
        int i;
        super.paintComponent(g);
        ControlUtils.setGraphicsRenderingHints(g);
        float scale = 1.0f;
        if (this.control != null) {
            scale = this.control.scale;
        }
        int rows = this.cellSet.getRowCount() + 1;
        int cols = this.cellSet.getColCount() + 1;
        if (cols != this.cellX[0].length || rows != this.cellX.length) {
            this.initCellLocations(rows, cols);
        }
        this.clearCoordinate();
        boolean isSub = false;
        if (this.isEditing) {
            if (!isSub) {
                g.clearRect(0, 0, 999999, 999999);
            }
            this.startCol = 1;
            this.startRow = 1;
            this.endRow = rows - 1;
            this.endCol = cols - 1;
        }
        Rectangle displayWin = null;
        if (this.onlyDrawCellInWin) {
            displayWin = this.jsp.getViewport().getViewRect();
        }
        if (!this.isEditing && !isSub) {
            g.setColor(Color.white);
            if (this.onlyDrawCellInWin) {
                g.fillRect(displayWin.x, displayWin.y, displayWin.width + 5, displayWin.height + 5);
            } else {
                Dimension d = this.getPreferredSize();
                g.fillRect(0, 0, d.width + 5, d.height + 5);
            }
        }
        int x = 1;
        int y = 1;
        this.drawStartRow = this.startRow;
        if (displayWin != null && displayWin.y >= 0) {
            i = this.startRow;
            while (i < this.endRow) {
                if (this.parser.isRowVisible(i)) {
                    int rh = this.parser.getRowHeight(i, scale);
                    if (y + rh > displayWin.y) break;
                    y += rh;
                }
                ++i;
            }
            this.drawStartRow = i;
        }
        this.drawStartCol = this.startCol;
        if (displayWin != null && displayWin.y >= 0) {
            i = this.startCol;
            while (i < this.endCol) {
                if (this.parser.isColVisible(i)) {
                    int rw = this.parser.getColWidth(i, scale);
                    if (x + rw > displayWin.x) break;
                    x += rw;
                }
                ++i;
            }
            this.drawStartCol = i;
        }
        float underLineSize = 0.75f;
        ((Graphics2D)g).setStroke(new BasicStroke(underLineSize *= this.control.scale));
        this.drawEndRow = this.endRow;
        this.drawEndCol = this.endCol;
        int tmpX = x;
        int row = this.drawStartRow;
        while (row <= this.endRow) {
            if (displayWin != null && y >= displayWin.y + displayWin.height) {
                this.drawEndRow = row - 1;
                break;
            }
            if (this.parser.isRowVisible(row)) {
                x = tmpX;
                col = this.drawStartCol;
                while (col <= this.endCol) {
                    if (displayWin != null && x >= displayWin.x + displayWin.width) {
                        this.drawEndCol = col - 1;
                        break;
                    }
                    if (this.parser.isColVisible(col)) {
                        int colWidth;
                        int width = colWidth = this.parser.getColWidth(col, scale);
                        int height = this.parser.getRowHeight(row, scale);
                        if (displayWin != null && x + width <= displayWin.x) {
                            x += colWidth;
                        } else if (displayWin != null && y + height <= displayWin.y) {
                            x += colWidth;
                        } else {
                            Color refCellColor;
                            List<INormalCell> refCells;
                            this.cellX[row][col] = x;
                            this.cellW[row][col] = width;
                            this.cellY[row][col] = y;
                            this.cellH[row][col] = height;
                            Shape oldClip = g.getClip();
                            try {
                                Rectangle2D oldRect;
                                double dispWidth = width;
                                double dispHeight = height;
                                if (displayWin != null) {
                                    if (x + width > displayWin.x + displayWin.width) {
                                        dispWidth = Math.min(width, displayWin.x + displayWin.width - x);
                                    }
                                    if (y + height > displayWin.y + displayWin.height) {
                                        dispHeight = Math.min(height, displayWin.y + displayWin.height - y);
                                    }
                                }
                                double clipx = x;
                                double clipy = y;
                                if (displayWin != null) {
                                    clipx = Math.max(x, displayWin.x);
                                    clipy = Math.max(y, displayWin.y);
                                }
                                if (clipx + dispWidth > (oldRect = oldClip.getBounds2D()).getX() + oldRect.getWidth()) {
                                    dispWidth = oldRect.getX() + oldRect.getWidth() - clipx;
                                }
                                if (clipy + dispHeight > oldRect.getY() + oldRect.getHeight()) {
                                    dispHeight = oldRect.getY() + oldRect.getHeight() - clipy;
                                }
                                g.setClip(new Rectangle2D.Double(clipx, clipy, dispWidth, dispHeight));
                                Color bkcolor = this.parser.getBackColor(row, col);
                                if (bkcolor != null) {
                                    g.setColor(bkcolor);
                                    g.fillRect(x, y, width, height);
                                }
                                if (!ConfigOptions.bDispOutCell.booleanValue()) {
                                    this.drawText(g, row, col, x, y, width, height, scale);
                                }
                                ContentPanel.drawFlag(g, x, y, this.parser, row, col, scale);
                                if (this.isCellSelected(row, col)) {
                                    Color selectCellBkcolor;
                                    if (ConfigOptions.getCellColor() != null) {
                                        selectCellBkcolor = ConfigOptions.getCellColor();
                                    } else {
                                        selectCellBkcolor = Color.black;
                                        g.setXORMode(XOR_COLOR);
                                    }
                                    g.setColor(selectCellBkcolor);
                                    g.fillRect(this.cellX[row][col], this.cellY[row][col], this.cellW[row][col], this.cellH[row][col]);
                                    g.setPaintMode();
                                }
                                if (this.control.isBreakPointCell(row, col)) {
                                    g.setColor(ConfigOptions.iBreakPointBColor);
                                    int r = row;
                                    int c = col;
                                    g.fillRect(this.cellX[r][c], this.cellY[r][c], this.cellW[r][c], this.cellH[r][c]);
                                    g.setPaintMode();
                                }
                                if (this.control.getStepPosition() != null) {
                                    CellLocation cp = this.control.getStepPosition();
                                    int r = cp.getRow();
                                    int c = cp.getCol();
                                    if (r == row && c == col) {
                                        g.setColor(new Color(0, 255, 255));
                                        g.fillRect(this.cellX[r][c], this.cellY[r][c], this.cellW[r][c], this.cellH[r][c]);
                                        g.setPaintMode();
                                        if (!ConfigOptions.bDispOutCell.booleanValue()) {
                                            this.drawText(g, row, col, x, y, width, height, scale);
                                        }
                                    }
                                }
                            }
                            finally {
                                g.setClip(oldClip);
                            }
                            if (ConfigOptions.bGridline.booleanValue()) {
                                CellBorder.setEnv(g, this.borderStyle, row, col, this.parser.getRowCount(), this.parser.getColCount(), this.isEditing);
                                CellBorder.drawBorder(x, y, width, height);
                            }
                            if (this.editor != null && this.editor.isVisible() && (refCells = this.editor.getRefCells()) != null && !refCells.isEmpty() && (refCellColor = this.editor.getRefCellColor(row, col)) != null) {
                                g.setColor(refCellColor);
                                Stroke oldStroke = ((Graphics2D)g).getStroke();
                                float lineSize = 2.0f;
                                ((Graphics2D)g).setStroke(new BasicStroke(lineSize *= this.control.scale));
                                g.drawRect(this.cellX[row][col], this.cellY[row][col], this.cellW[row][col], this.cellH[row][col]);
                                ((Graphics2D)g).setStroke(oldStroke);
                                g.setPaintMode();
                            }
                            x += colWidth;
                        }
                    }
                    ++col;
                }
                y += this.parser.getRowHeight(row, scale);
            }
            ++row;
        }
        if (this.control != null && ConfigOptions.bDispOutCell.booleanValue()) {
            row = this.drawStartRow;
            while (row <= this.drawEndRow) {
                col = this.drawStartCol;
                while (col <= this.drawEndCol) {
                    if (this.cellX[row][col] != 0) {
                        int height = this.parser.getRowHeight(row, scale);
                        int w = this.parser.getColWidth(col, scale);
                        int pw = this.getPaintableWidth(row, col, scale);
                        int px = this.cellX[row][col];
                        int py = this.cellY[row][col];
                        byte halign = this.parser.getHAlign(row, col);
                        if (halign == 4) {
                            px = px + w - pw;
                        }
                        Shape oldClip = g.getClip();
                        try {
                            Rectangle2D oldRect;
                            double dispWidth = pw;
                            double dispHeight = height;
                            if (displayWin != null) {
                                if (px + pw > displayWin.x + displayWin.width) {
                                    dispWidth = Math.min(pw, displayWin.x + displayWin.width - px);
                                }
                                if (py + height > displayWin.y + displayWin.height) {
                                    dispHeight = Math.min(height, displayWin.y + displayWin.height - py);
                                }
                            }
                            double clipx = px;
                            double clipy = py;
                            if (displayWin != null) {
                                clipx = Math.max(px, displayWin.x);
                                clipy = Math.max(py, displayWin.y);
                            }
                            if (clipx + dispWidth > (oldRect = oldClip.getBounds2D()).getX() + oldRect.getWidth()) {
                                dispWidth = oldRect.getX() + oldRect.getWidth() - clipx;
                            }
                            if (clipy + dispHeight > oldRect.getY() + oldRect.getHeight()) {
                                dispHeight = oldRect.getY() + oldRect.getHeight() - clipy;
                            }
                            g.setClip(new Rectangle2D.Double(clipx, clipy, dispWidth, dispHeight));
                            this.drawText(g, row, col, px, py, pw, height, scale);
                        }
                        finally {
                            g.setClip(oldClip);
                        }
                    }
                    ++col;
                }
                ++row;
            }
        }
        if (this.control != null && this.control.getCopySourceArea() != null) {
            this.bs = this.bs == bs1 ? bs2 : bs1;
            Area a = this.control.getCopySourceArea();
            int copyBeginRow = a.getBeginRow();
            int copyEndRow = a.getEndRow();
            int copyBeginCol = a.getBeginCol();
            int copyEndCol = a.getEndCol();
            x = -1;
            y = -1;
            if (copyBeginRow < this.drawStartRow) {
                copyBeginRow = this.drawStartRow;
                y = new Double(Math.abs(this.getY())).intValue();
            }
            if (copyBeginCol < this.drawStartCol) {
                copyBeginCol = this.drawStartCol;
                x = new Double(Math.abs(this.getX())).intValue();
            }
            if (y == -1) {
                y = this.cellY[copyBeginRow][copyBeginCol];
            }
            if (x == -1) {
                x = this.cellX[copyBeginRow][copyBeginCol];
            }
            int w = -1;
            int h = -1;
            if (copyEndRow > this.drawEndRow) {
                h = new Double(this.getBounds().getMaxY() - this.getBounds().getMinY()).intValue();
            }
            if (copyEndCol > this.drawEndCol) {
                w = new Double(this.getBounds().getMaxX() - this.getBounds().getMinX()).intValue();
            }
            if (w == -1) {
                w = this.cellX[copyBeginRow][copyEndCol] - x + this.cellW[copyBeginRow][copyEndCol];
            }
            if (h == -1) {
                h = this.cellY[copyEndRow][copyBeginCol] - y + this.cellH[copyEndRow][copyBeginCol];
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.blue);
            BasicStroke stroke = (BasicStroke)g2.getStroke();
            g2.setStroke(this.bs);
            g2.drawRect(x, y, w, h);
            g2.setStroke(stroke);
        }
        this.initEditor(this.submitEditor(true));
        this.drawSelectedRectBorder(g);
        this.drawDropRect(g, scale);
        if (!isSub) {
            g.dispose();
        }
    }

    protected boolean isCellSelected(int row, int col) {
        if (this.control == null) {
            return false;
        }
        Vector<Object> areas = this.control.getSelectedAreas();
        int i = 0;
        while (i < areas.size()) {
            Area a;
            Object one = areas.get(i);
            if (one != null && (a = one instanceof CellRect ? ((CellRect)one).getArea() : (Area)one).contains(row, col)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setEditorText(String text) {
        this.preventChange = true;
        if (this.editor instanceof RSyntaxTextAreaEx) {
            this.editor.setText(text);
        }
        this.preventChange = false;
    }

    public void setPreventChange(boolean preventChange) {
        this.preventChange = preventChange;
    }

    protected void resetEditorBounds() {
        int ew;
        if (this.editor == null || this.control == null || this.control.getActiveCell() == null) {
            return;
        }
        Rectangle srcRect = this.spEditor.getBounds();
        String editingText = ((JTextComponent)((Object)this.editor)).getText();
        int r = this.control.getActiveCell().getRow();
        int c = this.control.getActiveCell().getCol();
        if (ConfigOptions.bDispOutCell.booleanValue() && srcRect.width < (ew = this.getEditableWidth(editingText, r, c, this.control.scale))) {
            editingText = String.valueOf(editingText) + "a";
        }
        CellRect rect = this.getEditorBounds(editingText, r, c, this.control.scale);
        int w = rect.getRowCount();
        int h = rect.getColCount();
        if (h < srcRect.height) {
            h = srcRect.height;
        }
        if (h < srcRect.height) {
            h = srcRect.height;
        }
        if (this.editPos == null) {
            if (w != srcRect.width || h != srcRect.height) {
                this.spEditor.setSize(w, h);
            }
        } else if (w > srcRect.width || h > srcRect.height) {
            if (w < srcRect.width) {
                w = srcRect.width;
            }
            if (h < srcRect.height) {
                h = srcRect.height;
            }
            this.spEditor.setSize(w, h);
        }
    }

    protected void setCaret(int caretPosition, String newText) {
        int len = newText.length();
        if (caretPosition > 0 && caretPosition <= len && this.editor instanceof JTextComponent && caretPosition <= ((JTextComponent)((Object)this.editor)).getText().length()) {
            ((JTextComponent)((Object)this.editor)).setCaretPosition(caretPosition);
        }
    }

    public void reloadEditorText() {
        CellLocation m_activeCell = this.control.getActiveCell();
        if (m_activeCell == null) {
            return;
        }
        String text = ControlUtils.getCellText(this.cellSet, m_activeCell.getRow(), m_activeCell.getCol(), this.isEditing);
        if (this.editor instanceof JTextComponent) {
            int i = ((JTextComponent)((Object)this.editor)).getCaretPosition();
            try {
                this.preventChange = true;
                ((JTextComponent)((Object)this.editor)).setText(text);
                this.setCaret(i, text);
            }
            finally {
                this.preventChange = false;
            }
        }
    }

    public int getPaintableWidth(int cr, int cc, float scale) {
        int w;
        block7: {
            byte halign;
            block8: {
                float textH;
                w = this.parser.getColWidth(cc, scale);
                String drawText = ControlUtils.getCellText(this.cellSet, cr, cc, true);
                int indent = ConfigOptions.iIndent;
                float cw = this.parser.getColWidth(cc, scale) - indent;
                float ch = this.parser.getRowHeight(cr, scale);
                if (ch > (textH = ControlUtils.getStringHeight(drawText, cw, GM.getScaleFont(scale)))) {
                    return w;
                }
                halign = this.parser.getHAlign(cr, cc);
                if (halign != 0) break block8;
                int c = cc + 1;
                while (c <= this.cellSet.getColCount()) {
                    if (this.parser.isColVisible(c)) {
                        NormalCell nc = (NormalCell)this.cellSet.getCell(cr, c);
                        if (StringUtils.isValidString(nc.getExpString())) break block7;
                        w += this.parser.getColWidth(c, scale);
                    }
                    ++c;
                }
                break block7;
            }
            if (halign != 4) break block7;
            int c = cc - 1;
            while (c >= 1) {
                if (this.parser.isColVisible(c)) {
                    NormalCell nc = (NormalCell)this.cellSet.getCell(cr, c);
                    if (StringUtils.isValidString(nc.getExpString())) break;
                    w += this.parser.getColWidth(c, scale);
                }
                --c;
            }
        }
        return w;
    }

    public int getEditableWidth(String editingText, int row, int col, float scale) {
        int w = this.parser.getColWidth(col, scale);
        if (ConfigOptions.bDispOutCell.booleanValue()) {
            int textWidth = ControlUtils.getStringMaxWidth(editingText, GM.getScaleFont(scale));
            int c = col + 1;
            while (c <= this.cellSet.getColCount()) {
                if (this.parser.isColVisible(c)) {
                    NormalCell nc = (NormalCell)this.cellSet.getCell(row, c);
                    if (StringUtils.isValidString(nc.getExpString()) || w > textWidth + 5) break;
                    w += this.parser.getColWidth(c, scale);
                }
                ++c;
            }
        }
        return w;
    }

    protected int getEditableHeight(String text, int row, int col, int maxW, float scale) {
        int h = this.parser.getRowHeight(row, scale);
        float textH = ControlUtils.getStringHeight(text, maxW - 5, GM.getScaleFont(scale));
        int r = row + 1;
        while (r <= this.cellSet.getRowCount()) {
            if (this.parser.isRowVisible(r)) {
                if ((float)h > textH + 3.0f) break;
                h += this.parser.getRowHeight(r, scale);
            }
            ++r;
        }
        return h;
    }

    protected void drawSelectedRectBorder(Graphics g) {
        int y2;
        int x2;
        int y1;
        int x1;
        boolean drawRight;
        boolean drawBottom;
        Area area = this.control.getSelectedArea(0);
        if (area == null) {
            return;
        }
        int row = area.getBeginRow();
        int col = area.getBeginCol();
        int endRow = area.getEndRow();
        int endCol = area.getEndCol();
        boolean drawTop = true;
        if (row < this.drawStartRow && endRow >= this.drawStartRow) {
            row = this.drawStartRow;
            drawTop = false;
        }
        boolean drawLeft = true;
        if (col < this.drawStartCol && endCol >= this.drawStartCol) {
            col = this.drawStartCol;
            drawLeft = false;
        }
        if (endRow > this.drawEndRow) {
            endRow = this.drawEndRow;
            drawBottom = false;
        } else {
            drawBottom = true;
        }
        if (endCol > this.drawEndCol) {
            endCol = this.drawEndCol;
            drawRight = false;
        } else {
            drawRight = true;
        }
        int width = 0;
        int c = col;
        while (c <= endCol) {
            if (this.parser.isColVisible(c) && c >= this.drawStartCol) {
                width += this.parser.getColWidth(c, this.control.scale);
            }
            ++c;
        }
        int height = 0;
        int r = row;
        while (r <= endRow) {
            if (this.parser.isRowVisible(r) && r >= this.drawStartRow) {
                height += this.parser.getRowHeight(r, this.control.scale);
            }
            ++r;
        }
        if (width == 0 || height == 0) {
            return;
        }
        row = Math.max(this.drawStartRow, row);
        float lineSize = 3.0f;
        ((Graphics2D)g).setStroke(new BasicStroke(lineSize *= this.control.scale));
        g.setColor(Color.BLACK);
        g.setXORMode(Color.lightGray);
        int LINE_WIDTH = 3;
        if (drawTop) {
            x1 = this.cellX[row][col];
            y1 = this.cellY[row][col];
            x2 = this.cellX[row][col] + width;
            y2 = y1;
            g.drawLine(x1, y1, x2, y2);
        }
        if (drawLeft) {
            x1 = this.cellX[row][col];
            y1 = this.cellY[row][col];
            x2 = x1;
            y2 = y1 + height;
            if (drawTop) {
                y1 += 3;
            }
            if (drawBottom) {
                y2 -= 3;
            }
            g.drawLine(x1, y1, x2, y2);
        }
        if (drawBottom) {
            x1 = this.cellX[row][col];
            y1 = this.cellY[row][col] + height;
            x2 = this.cellX[row][col] + width;
            y2 = y1;
            g.drawLine(x1, y1, x2, y2);
        }
        if (drawRight) {
            x1 = this.cellX[row][col] + width;
            y1 = this.cellY[row][col];
            x2 = x1;
            y2 = this.cellY[row][col] + height;
            if (drawTop) {
                y1 += 3;
            }
            if (drawBottom) {
                y2 -= 3;
            }
            g.drawLine(x1, y1, x2, y2);
        }
    }

    public void setDropRect(Rectangle rect) {
        this.dropRect = rect;
    }

    protected void drawDropRect(Graphics g, float scale) {
        if (this.dropRect == null) {
            return;
        }
        Rectangle displayWin = this.jsp.getViewport().getViewRect();
        if (displayWin == null) {
            return;
        }
        g.setColor(Color.DARK_GRAY);
        ((Graphics2D)g).setStroke(new BasicStroke(this.control.scale, 0, 0, 10.0f, new float[]{10.0f, 5.0f}, 0.0f));
        int x = this.dropRect.x;
        int y = this.dropRect.y;
        int w = Math.min(x + this.dropRect.width, displayWin.x + displayWin.width) - x;
        int h = Math.min(y + this.dropRect.height, displayWin.y + displayWin.height) - y;
        g.drawRect(x, y, w - 2, h - 2);
        Shape oldClip = g.getClip();
        g.setClip(x, y, w - 2, h - 2);
        g.setPaintMode();
        String dragMessage = IdeSplMessage.get().getMessage("contentpanel.dragmessage");
        Font oldFont = this.getFont();
        Font font = new Font("Dialog", 1, (int)(14.0f * scale));
        g.setFont(font);
        int stringWidth = this.getFontMetrics(font).stringWidth(dragMessage);
        if (w > stringWidth) {
            x += (w - stringWidth) / 2;
        }
        g.drawString(dragMessage, x, y + 20);
        ((Graphics2D)g).setStroke(new BasicStroke(this.control.scale));
        g.setFont(oldFont);
        g.setClip(oldClip);
    }

    public static void drawFlag(Graphics g, int x, int y, CellSetParser parser, int row, int col, float scale) {
        PgmNormalCell cell = (PgmNormalCell)parser.getCell(row, col);
        int maxFlagSize = Math.min(parser.getRowHeight(row, scale), parser.getColWidth(col, scale));
        int flagSize = Math.min(maxFlagSize, 8);
        Color oldColor = g.getColor();
        if (StringUtils.isValidString(cell.getTip())) {
            g.setColor(Color.white);
            g.setXORMode(new Color(51, 153, 0));
            int w = parser.getColWidth(col, scale);
            int[] x1 = new int[]{x + w - flagSize, x + w, x + w};
            int[] y1 = new int[]{y, y, y + flagSize};
            g.fillPolygon(x1, y1, 3);
        }
        if (cell.isResultCell()) {
            g.setColor(Color.white);
            g.setXORMode(Color.BLUE);
            int h = parser.getRowHeight(row, scale);
            int w = parser.getColWidth(col, scale);
            int[] x1 = new int[]{x + w - flagSize, x + w, x + w};
            int[] y1 = new int[]{y + h, y + h, y + h - flagSize};
            g.fillPolygon(x1, y1, 3);
        }
        g.setPaintMode();
        g.setColor(oldColor);
    }

    public void initCellLocations() {
        int rows = this.parser.getRowCount() + 1;
        int cols = this.parser.getColCount() + 1;
        this.initCellLocations(rows, cols);
    }

    public void initCellLocations(int rows, int cols) {
        this.cellX = new int[rows][cols];
        this.cellW = new int[rows][cols];
        this.cellY = new int[rows][cols];
        this.cellH = new int[rows][cols];
    }

    protected void drawText(Graphics g, int row, int col, int x, int y, int w, int h, float scale) {
        String text = this.parser.getDispText(row, col);
        this.drawText(text, g, row, col, x, y, w, h, scale);
    }

    protected Color getCellColor(int row, int col) {
        return null;
    }

    protected String getCellDispText(int row, int col) {
        return null;
    }

    protected byte getHAlign(int row, int col) {
        return this.parser.getHAlign(row, col);
    }

    protected void drawText(String text, Graphics g, int row, int col, int x, int y, int w, int h, float scale) {
        Font font = this.parser.getFont(row, col, scale);
        byte halign = this.getHAlign(row, col);
        byte valign = this.parser.getVAlign(row, col);
        Color c = this.parser.getForeColor(row, col);
        if (this.control.isBreakPointCell(row, col)) {
            c = Color.white;
        } else if (!this.isCellEditable(row, col)) {
            c = Color.darkGray;
        }
        try {
            String dispText;
            boolean underLine = this.parser.isUnderline(row, col);
            int indent = ConfigOptions.iIndent;
            indent = (int)Math.floor((float)indent * scale);
            Color cellColor = this.getCellColor(row, col);
            if (cellColor != null) {
                c = cellColor;
            }
            if ((dispText = this.getCellDispText(row, col)) != null) {
                text = dispText;
            }
            this.drawText(g, text, x, y, w, h, underLine, halign, valign, font, c, indent);
        }
        finally {
            g.setPaintMode();
        }
    }

    protected int drawText(Graphics g, String text, int x, int y, int w, int h, boolean underLine, byte halign, byte valign, Font font, Color c, int indent) {
        return ControlUtils.drawText(g, text, x, y, w, h, underLine, halign, valign, font, c, indent);
    }

    protected void clearCoordinate() {
        int i = 0;
        while (i < this.cellX.length) {
            int j = 0;
            while (j < this.cellX[i].length) {
                this.cellX[i][j] = 0;
                this.cellY[i][j] = 0;
                this.cellW[i][j] = 0;
                this.cellH[i][j] = 0;
                ++j;
            }
            ++i;
        }
    }

    public JComponent getEditor() {
        return this.editor;
    }

    public boolean isEditing() {
        return this.editor != null && this.editor.isVisible();
    }

    public void addText(String text) {
        if (this.editor == null) {
            return;
        }
        if (!this.editor.isVisible()) {
            return;
        }
        String newText = "";
        if (this.editor instanceof JTextComponent) {
            GM.addText((JTextComponent)((Object)this.editor), text);
            newText = ((JTextComponent)((Object)this.editor)).getText();
        }
        this.resetEditorBounds();
        this.control.fireEditorInputing(newText);
    }

    public void editorMousePressed(MouseEvent e, int row, int col) {
        if (this.editor == null) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        x -= this.cellX[row][col];
        y -= this.cellY[row][col];
        try {
            MouseListener[] ml;
            DefaultCaret dc;
            MouseEvent e1 = new MouseEvent((Component)((Object)this.editor), e.getID(), e.getWhen(), e.getModifiers(), x, y, 1, e.isPopupTrigger(), e.getButton());
            Caret caret = this.editor.getCaret();
            if (caret != null && caret instanceof DefaultCaret && (dc = (DefaultCaret)caret) != null) {
                dc.mousePressed(e1);
                this.editor.caretChanged(dc.getDot());
            }
            if ((ml = this.editor.getMouseListeners()) != null) {
                int i = 0;
                while (i < ml.length) {
                    ml[i].mousePressed(e1);
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void initEditor(int caretPosition) {
        this.initEditor(caretPosition, (byte)0);
    }

    public void initEditor(byte mode) {
        int ca = 0;
        try {
            CellLocation cl = this.control.getActiveCell();
            String text = ControlUtils.getCellText(this.control.cellSet, cl.getRow(), cl.getCol(), true);
            ca = text.length();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.initEditor(ca, mode);
    }

    protected void hideEditor() {
        if (this.editor != null && this.editor.isVisible()) {
            this.setEditorVisible(false);
        }
    }

    public void initEditor(int caretPosition, byte mode) {
        int col;
        if (mode != 0) {
            this.editPos = null;
        }
        if (!this.editable || this.control == null || this.control.getActiveCell() == null) {
            this.hideEditor();
            return;
        }
        int row = this.control.getActiveCell().getRow();
        if (!this.isCellEditable(row, col = this.control.getActiveCell().getCol())) {
            this.hideEditor();
            return;
        }
        if (GV.appSheet != null && GV.appSheet instanceof SheetSpl && !((SheetSpl)GV.appSheet).isCellSetEditable()) {
            this.hideEditor();
            return;
        }
        if (row > this.cellSet.getRowCount() || col > this.cellSet.getColCount()) {
            return;
        }
        if (!this.parser.isRowVisible(row) || !this.parser.isColVisible(col)) {
            return;
        }
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof JInternalFrame) {
                if (((JInternalFrame)container).isSelected()) break;
                this.submitEditor();
                return;
            }
            container = container.getParent();
        }
        String text = null;
        switch (mode) {
            case 1: {
                this.stopMatch();
                this.editPos = new CellLocation(row, col);
                if (!this.editor.isVisible()) {
                    this.setEditorVisible(true);
                }
                this.editor.requestFocus();
                text = ControlUtils.getCellText(this.cellSet, row, col, this.isEditing);
                CellRect rect = this.getEditorBounds(text, row, col, this.control.scale);
                this.spEditor.setBounds(rect.getBeginRow(), rect.getBeginCol(), rect.getRowCount(), rect.getColCount());
                this.preventChange = true;
                try {
                    this.undoExp = text;
                    this.editor.setText(text, false);
                    ((JTextComponent)((Object)this.editor)).setEditable(true);
                }
                finally {
                    this.preventChange = false;
                }
                GV.isCellEditing = true;
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                this.stopMatch();
                if (this.editor.isVisible()) {
                    this.setEditorVisible(false);
                }
                if (this.cellX.length > row && this.cellX[row].length > col) {
                    this.spEditor.setBounds(this.cellX[row][col], this.cellY[row][col], 1, 1);
                    break;
                }
                Rectangle rec = this.spEditor.getBounds();
                this.spEditor.setBounds(rec.x, rec.y, 1, 1);
            }
        }
        byte valign = this.parser.getVAlign(row, col);
        if (valign == 8) {
            this.editor.setAlignmentY(0.0f);
        } else if (valign == 16) {
            this.editor.setAlignmentY(0.5f);
        } else if (valign == 32) {
            this.editor.setAlignmentY(1.0f);
        }
        Color bkcolor = this.parser.getBackColor(row, col);
        this.editor.setBackground(bkcolor == null ? new JTextPane().getBackground() : bkcolor);
        this.editor.setForeground(this.parser.getForeColor(row, col));
        this.editor.setFont(this.parser.getFont(row, col, this.control.scale));
        this.spEditor.setBounds(this.spEditor.getBounds());
        this.spEditor.setBorder(BorderFactory.createLineBorder(Color.darkGray, 1));
    }

    protected void stopMatch() {
    }

    public synchronized void setEditorVisible(boolean isVisible) {
        if (this.spEditor != null) {
            this.spEditor.setVisible(isVisible);
        }
        if (this.editor != null) {
            this.editor.setVisible(isVisible);
        }
    }

    public CellRect getEditorBounds(String text, int row, int col, float scale) {
        int x = this.cellX[row][col];
        int y = this.cellY[row][col];
        int w = this.getEditableWidth(text, row, col, scale);
        if (this.onlyDrawCellInWin) {
            boolean BORDER_SIZE = false;
            Rectangle displayWin = this.jsp.getViewport().getViewRect();
            if (x + w > displayWin.x + displayWin.width) {
                w = displayWin.x + displayWin.width - x - 0;
            }
            if (x + w > this.cellX[row][this.drawEndCol] + this.cellW[row][this.drawEndCol]) {
                w = this.cellX[row][this.drawEndCol] + this.cellW[row][this.drawEndCol] - x - 0;
            }
        }
        int h = this.getEditableHeight(text, row, col, w, scale);
        if (this.onlyDrawCellInWin) {
            boolean BORDER_SIZE = false;
            Rectangle displayWin = this.jsp.getViewport().getViewRect();
            if (y + h > displayWin.y + displayWin.height) {
                h = displayWin.y + displayWin.height - y - 0;
            }
            if (this.parser.isRowVisible(this.drawEndRow) && y + h > this.cellY[this.drawEndRow][col] + this.cellH[this.drawEndRow][col]) {
                h = this.cellY[this.drawEndRow][col] + this.cellH[this.drawEndRow][col] - y - 0;
            }
        }
        return new CellRect(x, y, w, h);
    }

    public int submitEditor() {
        return this.submitEditor(false);
    }

    protected int submitEditor(boolean isPaint) {
        if (this.control == null || this.editor == null || !this.editor.isVisible() || this.control.getActiveCell() == null) {
            return -1;
        }
        String text = ((JTextComponent)((Object)this.editor)).getText();
        if (!isPaint && this.isCellEditing()) {
            int col;
            int p = ((JTextComponent)((Object)this.editor)).getCaretPosition();
            int row = this.control.getActiveCell().getRow();
            if (!text.equals(ControlUtils.getCellText(this.cellSet, row, col = this.control.getActiveCell().getCol(), this.isEditing))) {
                this.control.fireCellTextInput(this.control.getActiveCell(), text);
            }
            return p;
        }
        return text == null ? 0 : text.length();
    }

    protected boolean isCellEditing() {
        try {
            return this.isEditing && GV.isCellEditing || GV.toolBarProperty.getWindowEditor().isFocusOwner();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void undoEditor() {
        String text = ((JTextComponent)((Object)this.editor)).getText();
        try {
            this.preventChange = true;
            if (StringUtils.isValidString(text)) {
                String newText = this.undoExp;
                if (text.equals(this.undoExp)) {
                    newText = null;
                }
                ((JTextComponent)((Object)this.editor)).setText(newText);
                ((ToolBarProperty)GV.toolBarProperty).setTextEditorText(newText, true);
                this.undoExp = text;
            } else if (StringUtils.isValidString(this.undoExp)) {
                ((JTextComponent)((Object)this.editor)).setText(this.undoExp);
                ((ToolBarProperty)GV.toolBarProperty).setTextEditorText(this.undoExp, true);
                this.undoExp = null;
            }
        }
        finally {
            this.preventChange = false;
        }
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this;
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        return this.getTipPos(e.getX(), e.getY());
    }

    protected Point getTipPos(int x1, int y1) {
        int tipHeight;
        int y;
        int col;
        CellLocation cl = ControlUtils.lookupCellPosition(x1, y1, this);
        if (cl == null) {
            return null;
        }
        int row = cl.getRow();
        String tips = ((PgmNormalCell)this.cellSet.getCell(row, col = cl.getCol())).getTip();
        if (!StringUtils.isValidString(tips)) {
            return null;
        }
        IntArrayList list = new IntArrayList();
        tips = GM.transTips(tips, list);
        int tipWidth = list.getInt(0) + 10;
        Rectangle displayWin = this.jsp.getViewport().getViewRect();
        int x = this.cellX[row][col] + this.cellW[row][col] + tipWidth < displayWin.x + displayWin.width ? this.cellX[row][col] + this.cellW[row][col] + 15 : this.cellX[row][col] - tipWidth - 15;
        if (x < 0 || x > displayWin.x + displayWin.width) {
            x = 0;
        }
        if ((y = this.cellY[row][col] + 15 + (tipHeight = list.getInt(1)) < displayWin.y + displayWin.height ? this.cellY[row][col] + 15 : displayWin.y + displayWin.height - 15 - tipHeight) < 0 || y > displayWin.y + displayWin.height) {
            y = 0;
        }
        return new Point(x, y);
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent event) {
        try {
            int count = event.getCommittedCharacterCount();
            AttributedCharacterIterator text = event.getText();
            String composedText = "";
            if (text != null) {
                char c = text.first();
                while (count-- > 0) {
                    composedText = String.valueOf(composedText) + String.valueOf(c);
                    c = text.next();
                }
                if (this.editor != null && this.editor instanceof JTextComponent && StringUtils.isValidString(composedText)) {
                    if (this.editor == null || !this.editor.isVisible()) {
                        this.initEditor((byte)1);
                    }
                    ((JTextComponent)((Object)this.editor)).setText(composedText);
                    this.editor.requestFocus();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void caretPositionChanged(InputMethodEvent event) {
    }

    @Override
    public Rectangle getTextLocation(TextHitInfo offset) {
        return new Rectangle(0, 0);
    }

    @Override
    public TextHitInfo getLocationOffset(int x, int y) {
        return null;
    }

    @Override
    public int getInsertPositionOffset() {
        return 0;
    }

    @Override
    public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    @Override
    public int getCommittedTextLength() {
        return 0;
    }

    @Override
    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    @Override
    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    public void dispose() {
        this.cellSet = null;
        this.jsp = null;
        this.cellX = null;
        this.cellY = null;
        this.cellW = null;
        this.cellH = null;
        this.editor = null;
    }
}

