/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.control;

import com.scudata.common.CellLocation;
import com.scudata.ide.common.control.ControlUtilsBase;
import com.scudata.ide.spl.control.CellSetParser;
import com.scudata.ide.spl.control.ContentPanel;
import com.scudata.ide.spl.control.SplControl;
import com.scudata.ide.spl.control.SplControlListener;
import com.scudata.ide.spl.control.SplEditor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.Map;
import javax.swing.JViewport;

public class ControlUtils
extends ControlUtilsBase {
    public static SplEditor extractSplEditor(SplControl control) {
        if (control.m_editorListener == null || control.m_editorListener.isEmpty()) {
            return null;
        }
        if (control.m_editorListener.get(0) instanceof SplControlListener) {
            return ((SplControlListener)control.m_editorListener.get(0)).getEditor();
        }
        return null;
    }

    public static boolean scrollToVisible(JViewport viewport, SplControl control, int row, int col) {
        Rectangle fieldArea = new Rectangle();
        CellSetParser parser = new CellSetParser(control.cellSet);
        fieldArea.x = parser.getColsWidth(control, 1, col - 1, control.scale) + 1;
        fieldArea.y = parser.getRowsHeight(control, 1, row - 1, control.scale) + 1;
        if (row == 0) {
            fieldArea.width = control.cellW[col];
            fieldArea.height = 20;
        } else if (col == 0) {
            fieldArea.width = 40;
            fieldArea.height = control.cellH[row];
        } else {
            fieldArea.width = (int)control.cellSet.getColCell(col).getWidth();
            fieldArea.height = (int)control.cellSet.getRowCell(row).getHeight();
        }
        return ControlUtils.scrollToVisible(viewport, fieldArea);
    }

    public static CellLocation lookupCellPosition(int x, int y, ContentPanel panel) {
        int i = 1;
        while (i < panel.cellX.length) {
            int j = 1;
            while (j < panel.cellX[i].length) {
                if (y > panel.cellY[i][j] && y <= panel.cellY[i][j] + panel.cellH[i][j] && x > panel.cellX[i][j] && x <= panel.cellX[i][j] + panel.cellW[i][j]) {
                    return new CellLocation(i, j);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static void setGraphicsRenderingHints(Graphics g) {
        if (g instanceof Graphics2D) {
            Graphics2D g2D = (Graphics2D)g;
            Toolkit tk = Toolkit.getDefaultToolkit();
            Object hints = tk.getDesktopProperty("awt.font.desktophints");
            if (hints != null && hints instanceof Map) {
                g2D.addRenderingHints((Map)hints);
            } else {
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
        }
    }
}

