/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.control;

import com.scudata.cellset.datamodel.Command;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.CellLocation;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.KeyWord;
import com.scudata.dm.Param;
import com.scudata.dm.Sequence;
import com.scudata.expression.CSVariable;
import com.scudata.expression.ElementRef;
import com.scudata.expression.Expression;
import com.scudata.expression.FieldId;
import com.scudata.expression.FieldRef;
import com.scudata.expression.FunctionLib;
import com.scudata.expression.Node;
import com.scudata.expression.VarParam;
import com.scudata.expression.operator.DotOperator;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.ToolBarPropertyBase;
import com.scudata.ide.common.control.FuncWindow;
import com.scudata.ide.common.function.FuncInfo;
import com.scudata.ide.common.function.FuncManager;
import com.scudata.ide.spl.GVSplSE;
import com.scudata.ide.spl.control.JWindowNames;
import com.scudata.util.EnvUtil;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public abstract class FuncListener
implements KeyListener {
    protected boolean isHotKeyEnabled = true;

    public FuncListener(JTextComponent jtext) {
        jtext.setRequestFocusEnabled(true);
        jtext.setFocusable(true);
        if (GVSplSE.matchWindow == null) {
            GVSplSE.matchWindow = new JWindowNames(){
                private static final long serialVersionUID = 1L;

                @Override
                public void selectName(String name) {
                    try {
                        JTextComponent jtext = FuncListener.this.getJText();
                        if (jtext != null) {
                            FuncListener.this.replaceName(jtext, name);
                            FuncListener.this.updateToolBarText();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
            GVSplSE.matchWindow.setVisible(true);
            GVSplSE.matchWindow.hideWindow();
        }
        jtext.addFocusListener(new FocusAdapter(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void focusLost(FocusEvent e) {
                if (!JWindowNames.isMatching()) return;
                try {
                    Component src = e.getOppositeComponent();
                    if (src == null) {
                        JWindowNames.stopMatch();
                        return;
                    }
                    while (!(src instanceof JWindowNames) && (src = src.getParent()) != null) {
                    }
                    if (src instanceof JWindowNames) return;
                    JWindowNames.stopMatch();
                    return;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public abstract JTextComponent getJText();

    protected void updateToolBarText() {
    }

    public void setHotKeyEnabled(boolean isEnabled) {
        this.isHotKeyEnabled = isEnabled;
    }

    protected boolean isFuncEnabled() {
        return true;
    }

    public abstract int[] getPosition(JTextComponent var1, int var2, int var3);

    public abstract String getCellText(JTextComponent var1);

    public abstract int getCaretPosition(JTextComponent var1);

    public abstract PgmCellSet getCellSet();

    public abstract Context getContext();

    @Override
    public void keyReleased(KeyEvent e) {
        if (!this.isFuncEnabled()) {
            this.stopMatch();
            return;
        }
        JTextComponent jtext = this.getSource(e);
        if (jtext == null) {
            return;
        }
        if (!Character.isDefined(e.getKeyChar())) {
            return;
        }
        if (e.isControlDown() || e.isAltDown()) {
            return;
        }
        int key = e.getKeyCode();
        if (!(this.isHotKeyEnabled || key != 27 && key != 10)) {
            return;
        }
        if (key == 46 || key == 37 || key == 39 || key == 127 || key == 8) {
            this.startMatch(jtext);
            return;
        }
        if (Character.isLetterOrDigit(key) || key == 45 || key == 523) {
            this.startMatch(jtext);
            return;
        }
        if (key != 38 && key != 40) {
            this.stopMatch();
            return;
        }
        this.matchKeyWord(jtext);
    }

    protected boolean startMatch(JTextComponent jtext) {
        try {
            this.stopMatch();
            if (jtext == null) {
            }
            String text = this.getCellText(jtext);
            if (!StringUtils.isValidString(text)) {
            }
            int expType = this.getExpType(text);
            switch (expType) {
                case 32: 
                case 64: 
                case 128: 
                case 256: 
            }
            int p = this.getCaretPosition(jtext);
            if (p <= 0) {
            }
            if (this.isCaretInQuotes(text, p)) {
            }
            String[] fieldNames = null;
            List<FuncInfo> funcs = null;
            Object mainObject = this.getMainObject(jtext, text);
            String funcName = this.getCurrentFuncName(jtext, text);
            if (mainObject != null && (fieldNames = this.getFieldNames(mainObject)) != null && funcName != null) {
                ArrayList<String> matchFieldNames = new ArrayList<String>();
                String[] stringArray = fieldNames;
                int n = fieldNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    if (name != null && name.startsWith(funcName)) {
                        matchFieldNames.add(name);
                    }
                    ++n2;
                }
                fieldNames = matchFieldNames.toArray(new String[matchFieldNames.size()]);
            }
            funcs = this.matchFuncList(FuncManager.getManager().getFuncList(), funcName);
            return this.showMatchWindow(jtext, fieldNames, funcs);
        }
        finally {
            return false;
        }
    }

    private boolean isCaretInQuotes(String expStr, int p) {
        int len = Math.min(p, expStr.length());
        int i = 0;
        while (i < len) {
            char c = expStr.charAt(i);
            if (c == '\"' || c == '\'') {
                int match = Sentence.scanQuotation(expStr, i);
                if (match == -1) {
                    return true;
                }
                i = match + 1;
                if (i > p) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public void stopMatch() {
        JWindowNames.stopMatch();
    }

    protected void matchKeyWord(JTextComponent jtext) {
        if (!this.isFuncEnabled()) {
            this.stopMatch();
            return;
        }
        if (JWindowNames.isMatching()) {
            String str = this.getCellText(jtext);
            String name = this.getCurrentFuncName(jtext, str);
            if (name == null) {
                this.stopMatch();
                return;
            }
            boolean isSearched = GVSplSE.matchWindow.searchName(name);
            if (!isSearched) {
                this.stopMatch();
            } else {
                jtext.requestFocus();
            }
        }
    }

    private int getExpType(String exp) {
        int sign = exp != null && exp.length() > 0 ? (exp.startsWith("==") ? 2 : (exp.startsWith("=") ? 1 : (exp.startsWith(">>") ? 8 : (exp.startsWith(">") ? 4 : (exp.startsWith("//") ? 128 : (exp.startsWith("/") ? 64 : (Command.isCommand(exp) ? 16 : 32))))))) : 256;
        return sign;
    }

    private Object getMainObject(JTextComponent jtext, String text) {
        try {
            char preChar;
            int p = this.getCaretPosition(jtext);
            String preStr = text.substring(0, p);
            while (preStr != null && (preStr.startsWith("=") || preStr.startsWith(">"))) {
                preStr = preStr.substring(1);
            }
            boolean isPeriod = false;
            if (StringUtils.isValidString(preStr) && (preChar = text.charAt(p - 1)) == '.') {
                isPeriod = true;
                preStr = preStr.substring(0, preStr.length() - 1);
            }
            Object val = null;
            String mainObjExpStr = null;
            if (isPeriod) {
                mainObjExpStr = this.parseMainObj(preStr);
            } else if (StringUtils.isValidString(preStr)) {
                int funcEnd = -1;
                boolean isFunc = false;
                boolean hasPeriod = false;
                int i = preStr.length() - 1;
                while (i >= 0) {
                    char c = preStr.charAt(i);
                    if (c == '(') {
                        funcEnd = i;
                    } else if (c == '.') {
                        if (funcEnd < 0) {
                            hasPeriod = true;
                        } else {
                            String func = preStr.substring(i + 1, funcEnd);
                            int optIndex = func.indexOf("@");
                            if (optIndex > 0) {
                                func = func.substring(0, optIndex);
                            }
                            if (FunctionLib.isMemberFnName(func)) {
                                int scount = 1;
                                int k = funcEnd + 2;
                                while (k < text.length()) {
                                    c = text.charAt(k);
                                    if (c == ')') {
                                        --scount;
                                    } else if (c == '(') {
                                        ++scount;
                                    }
                                    if (scount == 0 && p > k) {
                                        return false;
                                    }
                                    ++k;
                                }
                                mainObjExpStr = this.parseMainObj(preStr.substring(0, i));
                                isFunc = true;
                                break;
                            }
                        }
                    }
                    --i;
                }
                if (!isFunc && funcEnd > -1) {
                    int scount = 1;
                    int i2 = funcEnd + 1;
                    while (i2 < text.length()) {
                        char c = text.charAt(i2);
                        if (c == ')') {
                            --scount;
                        } else if (c == '(') {
                            ++scount;
                        }
                        if (scount == 0 && p > i2) {
                            return false;
                        }
                        ++i2;
                    }
                    mainObjExpStr = this.parseMainObj(preStr.substring(0, funcEnd));
                } else if (hasPeriod) {
                    mainObjExpStr = this.parseMainObj(preStr);
                }
            }
            if (mainObjExpStr != null) {
                Context ctx;
                preStr = mainObjExpStr;
                PgmCellSet cellSet = this.getCellSet();
                CellLocation cl = CellLocation.parse(preStr);
                if (cl != null && cellSet != null) {
                    PgmNormalCell cell = cellSet.getPgmNormalCell(cl.getRow(), cl.getCol());
                    val = cell.getValue(false);
                } else {
                    Param param;
                    ctx = this.getContext();
                    if (ctx == null && cellSet != null) {
                        ctx = cellSet.getContext();
                    }
                    if ((param = EnvUtil.getParam(preStr, ctx)) != null) {
                        val = param.getValue();
                    }
                }
                if (val == null && (preStr.indexOf(".") > 0 || preStr.indexOf("(") > 0)) {
                    ElementRef homeNode;
                    Expression exp;
                    Node home;
                    ctx = this.getContext();
                    if (ctx == null && cellSet != null) {
                        ctx = cellSet.getContext();
                    }
                    if ((home = (exp = new Expression(cellSet, ctx, preStr)).getHome()) instanceof DotOperator) {
                        DotOperator homeNode2 = (DotOperator)home;
                        Node right = homeNode2.getRight();
                        if ((right instanceof FieldRef || right instanceof FieldId) && this.isValidNode(homeNode2)) {
                            val = exp.calculate(ctx);
                        }
                    } else if (home instanceof ElementRef && this.isValidNode(homeNode = (ElementRef)home)) {
                        val = exp.calculate(ctx);
                    }
                }
                return val;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getCurrentFuncName(JTextComponent jtext, String str) {
        int p = this.getCaretPosition(jtext);
        int[] pos = GM.getCurrentWordPosition(str, p);
        if (pos == null) {
            return null;
        }
        int start = pos[0];
        int end = pos[1];
        return str.substring(start, end);
    }

    private List<FuncInfo> matchFuncList(List<FuncInfo> funcs, String funcName) {
        if (!StringUtils.isValidString(funcName)) {
            return null;
        }
        ArrayList<FuncInfo> matchFuncs = new ArrayList<FuncInfo>();
        for (FuncInfo fi : funcs) {
            if (fi.getName() == null) continue;
            if (StringUtils.isValidString(funcName)) {
                if (!fi.getName().startsWith(funcName)) continue;
                matchFuncs.add(fi);
                continue;
            }
            matchFuncs.add(fi);
        }
        return matchFuncs;
    }

    private String parseMainObj(String preStr) {
        int start = -1;
        int brackets = 0;
        int memberEnd = -1;
        int mainObjEnd = -1;
        int i = preStr.length() - 1;
        while (i >= 0) {
            char c = preStr.charAt(i);
            if (c == ')') {
                char c1;
                if (i < preStr.length() - 1 && (c1 = preStr.charAt(i + 1)) != '.') {
                    return null;
                }
                ++brackets;
            } else if (c == '(') {
                if (--brackets < 0) {
                    start = i + 1;
                    break;
                }
                if (brackets == 0) {
                    memberEnd = i;
                }
            } else if (c == '.') {
                String member;
                if (memberEnd > -1 && FunctionLib.isMemberFnName(member = preStr.substring(i + 1, memberEnd))) {
                    return null;
                }
                memberEnd = -1;
                mainObjEnd = i;
            } else if (KeyWord.isSymbol(c)) {
                if (brackets <= 0) {
                    start = i + 1;
                    break;
                }
            } else if ('@' == c && brackets >= 0) {
                return null;
            }
            --i;
        }
        if (start == -1) {
            start = 0;
        }
        if (mainObjEnd == -1) {
            return preStr.substring(start);
        }
        if (mainObjEnd <= start) {
            return null;
        }
        return preStr.substring(start, mainObjEnd);
    }

    private String[] getFieldNames(Object val) {
        if (val == null) {
            return null;
        }
        DataStruct ds = null;
        if (val instanceof Sequence) {
            ds = ((Sequence)val).dataStruct();
        } else if (val instanceof BaseRecord) {
            ds = ((BaseRecord)val).dataStruct();
        }
        if (ds != null) {
            String[] fieldNames = ds.getFieldNames();
            if (fieldNames == null || fieldNames.length == 0) {
                return null;
            }
            return fieldNames;
        }
        return null;
    }

    private boolean showMatchWindow(JTextComponent jtext, String[] fieldNames, List<FuncInfo> funcs) throws BadLocationException {
        int fieldSize = fieldNames == null ? 0 : fieldNames.length;
        int funcSize = funcs == null ? 0 : funcs.size();
        String[] allNames = new String[fieldSize + funcSize];
        if (fieldNames != null) {
            System.arraycopy(fieldNames, 0, allNames, 0, fieldSize);
        }
        if (funcs != null) {
            int i = 0;
            while (i < funcSize) {
                FuncInfo fi = funcs.get(i);
                allNames[fieldSize + i] = FuncWindow.getFuncString(fi, null, null, -1);
                ++i;
            }
        }
        if (allNames != null && allNames.length > 0) {
            GVSplSE.matchWindow.setNames(fieldNames, funcs);
            int MAX_WIDTH = 500;
            int MAX_HEIGHT = 300;
            int w = 200;
            FontMetrics fmWindow = GVSplSE.matchWindow.getFontMetrics(GVSplSE.matchWindow.getFont());
            int IMAGE_WIDTH = 40;
            String[] stringArray = allNames;
            int n = allNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (StringUtils.isValidString(name) && (w = Math.max(w, fmWindow.stringWidth(name) + 40)) >= 500) {
                    w = 500;
                    break;
                }
                ++n2;
            }
            int ROW_HEIGHT = 22;
            int h = Math.min(22 * allNames.length + 2, 300);
            int[] xy = this.getPosition(jtext, w, h);
            if (xy == null) {
                return false;
            }
            GVSplSE.matchWindow.setBounds(xy[0], xy[1], w, h);
            jtext.requestFocus();
            return true;
        }
        return false;
    }

    private void replaceName(JTextComponent jtext, String name) {
        char c;
        int end;
        int start;
        int p = this.getCaretPosition(jtext);
        String str = this.getCellText(jtext);
        int[] pos = GM.getCurrentWordPosition(str, p);
        if (pos == null) {
            start = p;
            end = p;
        } else {
            start = pos[0];
            end = pos[1];
        }
        if (end > -1 && end < str.length() && ((c = str.charAt(end)) == '@' || c == '(')) {
            String[] strs = this.splitFuncStr(name);
            name = strs[0];
        }
        jtext.setSelectionStart(start);
        jtext.setSelectionEnd(end);
        GM.addText(jtext, name);
        JWindowNames.stopMatch();
        jtext.requestFocus();
    }

    private String[] splitFuncStr(String name) {
        String[] strs = new String[3];
        if (!StringUtils.isValidString(name)) {
            return strs;
        }
        int index = name.indexOf("(");
        if (index > -1) {
            String params;
            strs[2] = params = name.substring(index);
            name = name.substring(0, index);
        }
        if ((index = name.indexOf("@")) > -1) {
            String opt;
            strs[1] = opt = name.substring(index);
            name = name.substring(0, index);
        }
        strs[0] = name;
        return strs;
    }

    private boolean isValidNode(Node node) {
        if (node == null) {
            return false;
        }
        Node left = node.getLeft();
        while (left != null) {
            if (!(left instanceof VarParam || left instanceof CSVariable || left instanceof DotOperator || left instanceof ElementRef)) {
                return false;
            }
            left = left.getLeft();
        }
        return true;
    }

    protected JTextComponent getSource(KeyEvent e) {
        Object src = e.getSource();
        if (src instanceof JTextComponent) {
            return (JTextComponent)src;
        }
        if (src instanceof ToolBarPropertyBase) {
            return ((ToolBarPropertyBase)src).getWindowEditor();
        }
        return null;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.isFuncEnabled()) {
            return;
        }
        int key = e.getKeyCode();
        boolean isMatching = JWindowNames.isMatching();
        switch (key) {
            case 10: {
                if (e.isAltDown() || e.isShiftDown()) {
                    this.stopMatch();
                    break;
                }
                if (!isMatching) break;
                GVSplSE.matchWindow.hideWindow();
                e.consume();
                return;
            }
            case 27: {
                if (!isMatching) break;
                this.stopMatch();
                break;
            }
            case 9: {
                if (!isMatching) break;
                GVSplSE.matchWindow.selectName();
                e.consume();
                return;
            }
            case 38: {
                if (!isMatching) break;
                GVSplSE.matchWindow.selectBefore();
                e.consume();
                return;
            }
            case 40: {
                if (!isMatching) break;
                GVSplSE.matchWindow.selectNext();
                e.consume();
                return;
            }
            case 33: {
                if (!isMatching) break;
                GVSplSE.matchWindow.selectPageUp();
                e.consume();
                return;
            }
            case 34: {
                if (!isMatching) break;
                GVSplSE.matchWindow.selectPageDown();
                e.consume();
                return;
            }
            case 36: {
                if (!isMatching) break;
                GVSplSE.matchWindow.selectFirst();
                e.consume();
                return;
            }
            case 35: {
                if (!isMatching) break;
                GVSplSE.matchWindow.selectEnd();
                e.consume();
                return;
            }
            case 113: {
                if (!isMatching) break;
                this.stopMatch();
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

