/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.control;

import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.control.FuncWindow;
import com.scudata.ide.common.function.FuncInfo;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.JListEx;
import com.scudata.ide.spl.GVSplSE;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public abstract class JWindowNames
extends JWindow {
    private static final long serialVersionUID = 1L;
    private JListEx listWindow;
    private JScrollPane jSPWin;
    private final Color BACK_COLOR = new Color(255, 255, 214);
    private final Color SELECTED_COLOR = this.BACK_COLOR.darker();
    private Vector<String> nameList;
    private List<FuncInfo> funcs;
    private int fieldSize = 0;
    private final int PAGE_COUNT = 10;
    private static final ImageIcon IMAGE_FIELD = GM.getImageIcon("/com/scudata/ide/common/resources/treecolumn.gif");
    private static final ImageIcon IMAGE_FUNC = GM.getImageIcon("/com/scudata/ide/common/resources/func.gif");

    public JWindowNames() {
        super(GV.appFrame);
        try {
            this.initUI();
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    public abstract void selectName(String var1);

    public synchronized void setNames(String[] fieldNames, List<FuncInfo> funcs) {
        this.funcs = funcs;
        this.getContentPane().remove(this.jSPWin);
        this.listWindow = new JListEx();
        this.jSPWin = new JScrollPane(this.listWindow);
        this.getContentPane().add((Component)this.jSPWin, "Center");
        fieldNames = this.sortNames(fieldNames);
        if (funcs != null) {
            Collections.sort(funcs, new Comparator<FuncInfo>(){

                @Override
                public int compare(FuncInfo o1, FuncInfo o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
        this.nameList = new Vector();
        Vector<String> dispList = new Vector<String>();
        if (fieldNames != null) {
            String[] stringArray = fieldNames;
            int n = fieldNames.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.nameList.add(s);
                dispList.add(IdeCommonMessage.get().getMessage("jwindownames.fieldname", s));
                ++n2;
            }
        }
        if (funcs != null) {
            for (FuncInfo fi : funcs) {
                this.nameList.add(fi.getName());
            }
        }
        this.listWindow.x_setData(this.nameList, this.nameList);
        int n = this.fieldSize = fieldNames == null ? 0 : fieldNames.length;
        if (!this.nameList.isEmpty()) {
            this.listWindow.setSelectedIndex(0);
        }
        this.initList();
    }

    private String[] sortNames(String[] names) {
        if (names == null) {
            return null;
        }
        Object[] cloneNames = new String[names.length];
        System.arraycopy(names, 0, cloneNames, 0, names.length);
        Arrays.sort(cloneNames);
        return cloneNames;
    }

    public String getSelectedName() {
        return (String)this.listWindow.getSelectedValue();
    }

    public void selectName() {
        String name;
        int index = this.listWindow.getSelectedIndex();
        if (index < 0) {
            return;
        }
        if (index < this.fieldSize) {
            name = (String)this.listWindow.getSelectedValue();
        } else {
            int funcIndex = index - this.fieldSize;
            FuncInfo fi = this.funcs.get(funcIndex);
            name = FuncWindow.getFuncString(fi, null, null, -1, false);
        }
        this.selectName(name);
    }

    public void selectBefore() {
        int index = this.listWindow.getSelectedIndex();
        this.selectIndex(--index);
    }

    public void selectPageUp() {
        int index = this.listWindow.getSelectedIndex();
        this.selectIndex(index -= 10);
    }

    private void selectIndex(int index) {
        int maxIndex;
        if (index < 0) {
            index = 0;
        }
        if (index >= (maxIndex = this.nameList.size())) {
            index = maxIndex - 1;
        }
        this.listWindow.setSelectedIndex(index);
        this.scrollToIndex(this.listWindow.getSelectedIndex());
    }

    public void selectPageDown() {
        int index = this.listWindow.getSelectedIndex();
        this.selectIndex(index += 10);
    }

    public void selectFirst() {
        this.selectIndex(0);
    }

    public void selectEnd() {
        this.selectIndex(this.nameList.size() - 1);
    }

    public void selectNext() {
        int index = this.listWindow.getSelectedIndex();
        this.selectIndex(++index);
    }

    public boolean searchName(String pre) {
        String val;
        if (pre == null) {
            return false;
        }
        pre = pre.toLowerCase();
        int index = this.listWindow.getSelectedIndex();
        if (index > -1 && (val = this.nameList.get(index)).toLowerCase().startsWith(pre)) {
            return true;
        }
        int i = 0;
        while (i < this.nameList.size()) {
            String val2 = this.nameList.get(i);
            if (val2 != null && val2.toLowerCase().startsWith(pre)) {
                this.listWindow.setSelectedIndex(i);
                this.scrollToIndex(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    private void scrollToIndex(int i) {
        int max = this.jSPWin.getVerticalScrollBar().getMaximum();
        int value = max * i / this.nameList.size();
        this.jSPWin.getVerticalScrollBar().setValue(value);
    }

    public void hideWindow() {
        this.invalidate();
        this.setBounds(-100, -100, 5, 5);
        Thread t = new Thread(){

            @Override
            public void run() {
                JWindowNames.this.validate();
                JWindowNames.this.repaint();
            }
        };
        SwingUtilities.invokeLater(t);
    }

    public boolean isDisplay() {
        Rectangle rect = this.getBounds();
        if (rect == null) {
            return false;
        }
        return rect.x >= 0 || rect.y >= 0;
    }

    private void initList() {
        ListCellRenderer cellRenderer = new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String tooltip;
                ImageIcon ii;
                String funcName;
                JPanel panel = new JPanel(new BorderLayout());
                if (index < JWindowNames.this.fieldSize) {
                    funcName = (String)JWindowNames.this.nameList.get(index);
                    ii = IMAGE_FIELD;
                    tooltip = IdeCommonMessage.get().getMessage("jwindownames.fieldname");
                } else {
                    ii = IMAGE_FUNC;
                    int funcIndex = index - JWindowNames.this.fieldSize;
                    FuncInfo fi = (FuncInfo)JWindowNames.this.funcs.get(funcIndex);
                    funcName = FuncWindow.getFuncString(fi, null, null, -1);
                    tooltip = fi.getDesc();
                }
                JLabel label = new JLabel(ii);
                panel.add((Component)label, "West");
                JTextField text = new JTextField(funcName);
                if (isSelected) {
                    text.setBackground(JWindowNames.this.SELECTED_COLOR);
                } else {
                    text.setBackground(JWindowNames.this.BACK_COLOR);
                }
                text.setBorder(null);
                panel.add((Component)text, "Center");
                panel.setToolTipText(tooltip);
                panel.setMinimumSize(new Dimension(0, 22));
                panel.setPreferredSize(new Dimension(0, 22));
                return panel;
            }
        };
        this.listWindow.setCellRenderer(cellRenderer);
        this.listWindow.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    if (JWindowNames.this.listWindow.isSelectionEmpty()) {
                        return;
                    }
                    try {
                        JWindowNames.this.selectName();
                        e.consume();
                    }
                    catch (Exception e1) {
                        GM.showException(JWindowNames.this, e1);
                    }
                }
            }
        });
        this.listWindow.setBackground(this.BACK_COLOR);
        this.jSPWin.setBackground(this.BACK_COLOR);
        KeyListener kl = this.getKeyListener();
        this.listWindow.addKeyListener(kl);
        this.jSPWin.addKeyListener(kl);
    }

    private KeyListener getKeyListener() {
        KeyAdapter kl = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    e.consume();
                    JWindowNames.this.dispose();
                } else if (e.getKeyCode() == 10) {
                    if (JWindowNames.this.listWindow.isSelectionEmpty()) {
                        return;
                    }
                    JWindowNames.this.selectName();
                    e.consume();
                }
            }
        };
        return kl;
    }

    private void initUI() {
        this.listWindow = new JListEx();
        this.jSPWin = new JScrollPane(this.listWindow);
        this.getContentPane().add((Component)this.jSPWin, "Center");
        this.setBackground(this.BACK_COLOR);
        this.addKeyListener(this.getKeyListener());
    }

    public static boolean isMatching() {
        return GVSplSE.matchWindow != null && GVSplSE.matchWindow.isDisplay();
    }

    public static void stopMatch() {
        if (JWindowNames.isMatching()) {
            GVSplSE.matchWindow.hideWindow();
        }
    }
}

