/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.control;

import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.Area;
import com.scudata.common.CellLocation;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.GC;
import com.scudata.ide.common.IAtomicCmd;
import com.scudata.ide.common.control.CellRect;
import com.scudata.ide.spl.AtomicCell;
import com.scudata.ide.spl.control.ControlUtils;
import com.scudata.ide.spl.control.EditorListener;
import com.scudata.ide.spl.control.SplControl;
import com.scudata.ide.spl.control.SplEditor;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.text.JTextComponent;

public class SplControlListener
implements EditorListener {
    SplEditor editor;

    public SplControlListener(SplEditor editor) {
        this.editor = editor;
    }

    public SplEditor getEditor() {
        return this.editor;
    }

    @Override
    public void rightClicked(MouseEvent e, int clickPlace) {
        this.editor.getSplListener().rightClicked(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void regionsSelect(Vector<Object> vectRegion, Vector<Integer> selectedRows, Vector<Integer> selectedColumns, boolean selectedAll, boolean keyEvent) {
        this.editor.selectedRects.clear();
        int i = 0;
        while (i < vectRegion.size()) {
            Area a = (Area)vectRegion.get(i);
            if (a != null) {
                this.editor.selectedRects.add(new CellRect(a));
            }
            ++i;
        }
        this.editor.selectedCols = selectedColumns;
        this.editor.selectedRows = selectedRows;
        this.editor.selectState = vectRegion.isEmpty() ? (byte)0 : (selectedAll ? (byte)2 : (selectedColumns.size() > 0 ? (byte)4 : (selectedRows.size() > 0 ? (byte)3 : (byte)1)));
        this.editor.getSplListener().selectStateChanged(this.editor.selectState, keyEvent);
    }

    @Override
    public boolean columnWidthChange(Vector<Integer> vectColumn, float nWidth) {
        ControlUtils.clearWrapBuffer();
        this.editor.selectedCols = vectColumn;
        this.editor.setColumnWidth(nWidth);
        return true;
    }

    @Override
    public boolean rowHeightChange(Vector<Integer> vectRow, float nHeight) {
        ControlUtils.clearWrapBuffer();
        this.editor.selectedRows = vectRow;
        this.editor.setRowHeight(nHeight);
        return true;
    }

    public boolean cellRegionMove(Area area, int nRowPos, int nColumnPos) {
        return true;
    }

    @Override
    public boolean cellRegionPaste(Area area, int nRowPos, int nColumnPos) {
        return true;
    }

    @Override
    public boolean cellRegionExpand(Area area, int nColumnExpand, int nRowExpand) {
        return true;
    }

    @Override
    public boolean cellRegionShrink(Area area, int nColumnShrink, int nRowShrink) {
        return true;
    }

    public static AtomicCell getCellHeightCmd(SplControl control, int row, int col, String newText) {
        float textH;
        if (!ConfigOptions.bAutoSizeRowHeight.booleanValue()) {
            return null;
        }
        PgmCellSet ics = control.cellSet;
        float w = control.getContentPanel().getEditableWidth(newText, row, col, control.scale);
        float h = ics.getRowCell(row).getHeight();
        if (h < (textH = ControlUtils.getStringHeight(newText, w, GC.font) + 7.0f)) {
            AtomicCell rac = new AtomicCell(control, ics.getRowCell(row));
            rac.setProperty((byte)101);
            rac.setValue(new Float(textH));
            return rac;
        }
        return null;
    }

    @Override
    public boolean cellTextInput(int row, int col, String strText) {
        PgmCellSet ics = this.editor.getComponent().cellSet;
        strText = strText != null ? strText : "";
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        NormalCell nc = (NormalCell)ics.getCell(row, col);
        AtomicCell ac = new AtomicCell(this.editor.getComponent(), nc);
        ac.setProperty((byte)1);
        if (StringUtils.isValidString(strText)) {
            ac.setValue(strText);
        } else {
            ac.setValue(null);
        }
        cmds.add(ac);
        ac = SplControlListener.getCellHeightCmd(this.editor.getComponent(), row, col, strText);
        if (ac != null) {
            cmds.add(ac);
        }
        this.editor.executeCmd(cmds);
        return true;
    }

    @Override
    public void editorInputing(String text) {
    }

    @Override
    public void doubleClicked(MouseEvent e) {
        if (this.editor.getComponent() == null) {
            return;
        }
        CellLocation pos = this.editor.getComponent().getActiveCell();
        if (pos != null) {
            JTextComponent textEditor = this.editor.getComponent().getEditor();
            if (textEditor == null || !textEditor.isEditable()) {
                return;
            }
            this.editor.textEditor();
        }
    }

    @Override
    public void mouseMove(int row, int col) {
    }

    @Override
    public void scrollBarMoved() {
    }
}

