/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dialog;

import com.scudata.app.common.AppUtil;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.FreeConstraints;
import com.scudata.ide.spl.GMSplSE;
import com.scudata.ide.spl.control.SplEditorSE;
import com.scudata.ide.spl.dialog.DialogAbout;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.ide.spl.resources.IdeSplSEMessage;
import com.scudata.ide.spl.update.UpdateManager;
import com.scudata.util.Variant;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class DialogAboutSE
extends DialogAbout {
    private static final long serialVersionUID = 1L;
    private JLabel labelExpDate1 = new JLabel(IdeCommonMessage.get().getMessage("dialogabout.expdate"));
    private JLabel labelExpDate2 = new JLabel();
    private JLabel labelServiceDate1 = new JLabel(IdeSplSEMessage.get().getMessage("dialogaboutse.serviceexp"));
    private JLabel labelServiceDate2 = new JLabel();
    private JLabel labelDownload1 = new JLabel(IdeCommonMessage.get().getMessage("dialogabout.download"));
    private JLabel labelDownload2 = new JLabel();
    private JLabel labelUser2 = new JLabel(IdeCommonMessage.get().getMessage("dialogabout.defisv"));
    private JButton jBCheckUpdate = new JButton(IdeCommonMessage.get().getMessage("menu.help.update"));
    public boolean dispSN = false;
    private Thread cuThread = null;
    protected boolean isChecking = false;

    public DialogAboutSE(boolean dispSN) {
        this(GV.appFrame, GV.appFrame.getProductName(), dispSN);
    }

    public DialogAboutSE(JFrame frame, String productName, boolean dispSN) {
        super(frame, productName);
        this.dispSN = dispSN;
        this.init();
        this.initSE();
    }

    public void setCheckUpdateVisible(boolean isVisible) {
        this.jBCheckUpdate.setVisible(isVisible);
        this.jBCheckUpdate.setEnabled(isVisible);
    }

    protected void checkUpdate() {
        try {
            String serviceProductId = GMSplSE.getServiceProductId();
            UpdateManager.checkUpdate(this, false, serviceProductId, this.productName);
        }
        catch (Exception e) {
            GM.showException(this, e, true, GM.getLogoImage(this, true), IdeSplMessage.get().getMessage("spl.updateerrorpre"));
        }
    }

    @Override
    protected void closeDialog() {
        if (this.cuThread != null) {
            AppUtil.destroyThread(this.cuThread);
        }
        super.closeDialog();
    }

    private void initSE() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                GM.setDialogDefaultButton(DialogAboutSE.this, DialogAboutSE.this.jBClose, DialogAboutSE.this.jBClose);
            }
        });
        this.jBCheckUpdate.setMnemonic('U');
        this.jPButton.add((Component)this.jBCheckUpdate, 0);
        boolean canUpdate = UpdateManager.canUpdate();
        this.jPButton.setEnabled(canUpdate);
        this.jBCheckUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (DialogAboutSE.this.isChecking) {
                    return;
                }
                DialogAboutSE.this.isChecking = true;
                DialogAboutSE.this.cuThread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            DialogAboutSE.this.checkUpdate();
                        }
                        finally {
                            (this).DialogAboutSE.this.isChecking = false;
                            DialogAboutSE.this.cuThread = null;
                        }
                    }
                };
                SwingUtilities.invokeLater(DialogAboutSE.this.cuThread);
            }
        });
        if (!this.dispSN) {
            return;
        }
        this.labelDownload2.setCursor(Cursor.getPredefinedCursor(12));
        this.labelDownload2.setForeground(Color.blue);
        this.labelDownload2.setBorder(null);
        this.labelDownload2.setFont(this.URL_FONT);
        this.labelDownload1.setForeground(SystemColor.textHighlight);
        this.labelDownload2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                try {
                    GM.browse(DialogAboutSE.this.labelDownload2.getText());
                }
                catch (Exception e1) {
                    GM.showException(DialogAboutSE.this, e1);
                }
            }
        });
        int dialogHeight = SplEditorSE.isFree() || SplEditorSE.isTrial() ? 25 + DIALOG_HEIGHT + 55 : DIALOG_HEIGHT;
        this.setSize(DIALOG_WIDTH, dialogHeight);
        GM.centerWindow(this);
    }

    @Override
    protected int getBottomLabel1Width() {
        if (!this.dispSN) {
            return super.getBottomLabel1Width();
        }
        return GM.isChineseLanguage() ? 80 : 140;
    }

    @Override
    protected int placeCenter() {
        int y = super.placeCenter();
        if (!this.dispSN) {
            return y;
        }
        if (SplEditorSE.isFree() || SplEditorSE.isTrial() || SplEditorSE.isSubs() && SplEditorSE.getNo() == 0) {
            this.labelUser2.setFont(new Font("Dialog", 0, 14));
            this.labelUser2.setForeground(Color.black);
            this.labelUser2.setHorizontalAlignment(0);
            this.labelUser2.setBorder(BorderFactory.createEtchedBorder());
            this.panelTop.add((Component)this.labelUser2, new FreeConstraints(10, y, DIALOG_WIDTH - 30, 30));
            y += 36;
        }
        return y;
    }

    @Override
    protected void placeLogo() {
        super.placeLogo();
        if (!this.dispSN) {
            return;
        }
        int LABEL1_WIDTH = this.getTopLabel1Width();
        int LABEL2_WIDTH = 200;
        if (!SplEditorSE.isFree()) {
            this.y1 += 25;
            this.panelTop.add((Component)this.labelExpDate1, new FreeConstraints(this.x1, this.y1, LABEL1_WIDTH, -1));
            this.panelTop.add((Component)this.labelExpDate2, new FreeConstraints(this.x1 + LABEL1_WIDTH, this.y1, 200, -1));
        }
        if (SplEditorSE.isSale() || SplEditorSE.isSubs()) {
            this.y1 += 25;
            this.panelTop.add((Component)this.labelServiceDate1, new FreeConstraints(this.x1, this.y1, LABEL1_WIDTH, -1));
            this.panelTop.add((Component)this.labelServiceDate2, new FreeConstraints(this.x1 + LABEL1_WIDTH, this.y1, 200, -1));
        }
    }

    @Override
    protected void placeBottom(int x1, int x2, int y1) {
        if (!this.dispSN) {
            return;
        }
        this.panelTop.add((Component)this.labelDownload1, new FreeConstraints(x1, y1, -1, -1));
        this.panelTop.add((Component)this.labelDownload2, new FreeConstraints(x2, y1, -1, -1));
    }

    @Override
    protected void placeLongLogo() {
        super.placeLongLogo();
        if (!this.dispSN) {
            return;
        }
        int LABEL1_WIDTH = this.getTopLabel1Width();
        int LABEL2_WIDTH = 200;
        if (!SplEditorSE.isFree()) {
            this.y1 += 25;
            this.panelTop.add((Component)this.labelExpDate1, new FreeConstraints(this.x1, this.y1, LABEL1_WIDTH, -1));
            this.panelTop.add((Component)this.labelExpDate2, new FreeConstraints(this.x1 + LABEL1_WIDTH, this.y1, 200, -1));
        }
        if (SplEditorSE.isSale() || SplEditorSE.isSubs()) {
            this.y1 += 25;
            this.panelTop.add((Component)this.labelServiceDate1, new FreeConstraints(this.x1, this.y1, LABEL1_WIDTH, -1));
            this.panelTop.add((Component)this.labelServiceDate2, new FreeConstraints(this.x1 + LABEL1_WIDTH, this.y1, 200, -1));
        }
    }

    @Override
    protected void loadMessage() {
        super.loadMessage();
        if (!this.dispSN) {
            return;
        }
        long expTime = SplEditorSE.getExpiration();
        String expDate = expTime > 0L ? (expTime == 0L ? "" : Variant.format(new Date(expTime), "yyyy-MM-dd")) : IdeCommonMessage.get().getMessage("dialogabout.expforever");
        if (SplEditorSE.isSale()) {
            this.labelExpDate2.setText(IdeCommonMessage.get().getMessage("dialogabout.expforever"));
            this.labelServiceDate2.setText(expDate);
        } else {
            this.labelExpDate2.setText(expDate);
            this.labelServiceDate2.setText(expDate);
        }
        this.labelDownload2.setText(GMSplSE.getDownloadUrl());
        if (SplEditorSE.isFree()) {
            this.labelUser2.setText("<html>" + IdeSplSEMessage.get().getMessage("dialogaboutse.nosn") + "</html>");
        } else if (SplEditorSE.isTrial() || SplEditorSE.isSubs() && SplEditorSE.getNo() == 0) {
            this.labelUser2.setText("<html>" + IdeSplSEMessage.get().getMessage("sn.trialsn") + "</html>");
        }
        String labelProduct = this.LABEL_EXT;
        int product = SplEditorSE.getProduct();
        switch (product) {
            case 4: {
                labelProduct = this.LABEL_DESK;
                break;
            }
            case 7: {
                if (SplEditorSE.isNoIDE()) {
                    labelProduct = this.LABEL_PRO_LITE;
                }
                labelProduct = this.LABEL_PRO;
                break;
            }
            case 6: {
                if (SplEditorSE.isNoIDE()) {
                    labelProduct = this.LABEL_ENT_LITE;
                }
                labelProduct = this.LABEL_ENT;
            }
        }
        this.labelProductEdition2.setText(labelProduct);
    }

    @Override
    protected boolean isEditionVisible() {
        return !SplEditorSE.isFree();
    }
}

