/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dialog;

import com.scudata.common.MessageManager;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.GC;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.dialog.RQDialog;
import com.scudata.ide.common.swing.JComboBoxEx;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class DialogCopyPresent
extends RQDialog {
    private static final long serialVersionUID = 1L;
    private Vector<Object> codes = new Vector();
    private Vector<String> disps = new Vector();
    private MessageManager mm = IdeSplMessage.get();
    private JLabel jLType = new JLabel(this.mm.getMessage("dialogcopypresent.type"));
    private final String LABEL_HTML = "HTML";
    private final String LABEL_TEXT = this.mm.getMessage("dialogcopypresent.text");
    private JComboBoxEx jCBType = new JComboBoxEx();
    private JCheckBox jCBHeader = new JCheckBox(this.mm.getMessage("dialogcopypresent.copyheader"));
    private JLabel jLSep = new JLabel(this.mm.getMessage("dialogcopypresent.colsep"));
    private final String TAB = "\t";
    private final String SPACE = "    ";
    private final String CSV = ",";
    private final String LABEL_TAB = "TAB";
    private final String LABEL_SPACE = this.mm.getMessage("dialogcopypresent.space");
    private final String LABEL_CSV = ",";
    private JComboBoxEx jCBSep = new JComboBoxEx();
    private JLabel jLPreview = new JLabel(this.mm.getMessage("dialogcopypresent.preview"));
    protected RSyntaxTextArea jTAPreview = new RSyntaxTextArea(){
        private static final long serialVersionUID = 1L;

        public Rectangle modelToView(int pos) throws BadLocationException {
            try {
                return super.modelToView(pos);
            }
            catch (Exception exception) {
                return null;
            }
        }
    };
    protected RTextScrollPane jSPPreview = new RTextScrollPane((RTextArea)this.jTAPreview);
    private JCheckBox jCBLineWrap = new JCheckBox(this.mm.getMessage("dialogtexteditor.linewrap"));

    public DialogCopyPresent() {
        super("Copy code for presentation", 600, 500);
        try {
            this.init();
            GM.centerWindow(this);
        }
        catch (Exception e) {
            GM.showException(this, e);
        }
    }

    private boolean saveOption(boolean showException) {
        byte type = ((Number)this.jCBType.x_getSelectedItem()).byteValue();
        if (type == 1) {
            String sep = this.getSep();
            if (sep == null || "".equals(sep)) {
                if (showException) {
                    GM.messageDialog(this, this.mm.getMessage("dialogcopypresent.emptycolsep"));
                }
                return false;
            }
            ConfigOptions.sCopyPresentSep = sep;
        }
        ConfigOptions.iCopyPresentType = type;
        ConfigOptions.bCopyPresentHeader = this.jCBHeader.isSelected();
        return true;
    }

    @Override
    protected boolean okAction(ActionEvent e) {
        return this.saveOption(true);
    }

    @Override
    protected void closeDialog(int option) {
        super.closeDialog(option);
        GM.setWindowDimension(this);
        ConfigOptions.bTextEditorLineWrap = this.jCBLineWrap.isSelected();
    }

    private String getSep() {
        Object disp = this.jCBSep.getEditor().getItem();
        if (disp != null) {
            int index = this.disps.indexOf(disp);
            if (index > -1) {
                return (String)this.codes.get(index);
            }
            return disp.toString();
        }
        return "";
    }

    private void init() {
        this.panelCenter.setLayout(new GridBagLayout());
        this.panelCenter.add((Component)this.jLType, GM.getGBC(0, 0));
        this.panelCenter.add((Component)this.jCBType, GM.getGBC(0, 1));
        GridBagConstraints gbc = GM.getGBC(1, 0);
        gbc.gridwidth = 2;
        this.panelCenter.add((Component)this.jCBHeader, gbc);
        this.panelCenter.add((Component)this.jLSep, GM.getGBC(2, 0));
        this.panelCenter.add((Component)this.jCBSep, GM.getGBC(2, 1));
        this.panelCenter.add((Component)this.jLPreview, GM.getGBC(3, 0));
        gbc = GM.getGBC(4, 0, true, true);
        gbc.gridwidth = 2;
        this.panelCenter.add((Component)this.jSPPreview, gbc);
        gbc = GM.getGBC(5, 0);
        gbc.gridwidth = 2;
        this.panelCenter.add((Component)this.jCBLineWrap, gbc);
        Vector<Integer> codeData = new Vector<Integer>();
        codeData.add(0);
        codeData.add(1);
        Vector<String> dispData = new Vector<String>();
        dispData.add("HTML");
        dispData.add(this.LABEL_TEXT);
        this.jCBType.x_setData(codeData, dispData);
        this.codes.add("\t");
        this.codes.add("    ");
        this.codes.add(",");
        this.disps.add("TAB");
        this.disps.add(this.LABEL_SPACE);
        this.disps.add(",");
        this.jCBSep.x_setData(this.codes, this.disps);
        this.jCBSep.setEditable(true);
        this.jTAPreview.setEditable(false);
        this.jTAPreview.setCodeFoldingEnabled(true);
        this.jTAPreview.setFont(GC.font);
        this.jTAPreview.setToolTipText(this.mm.getMessage("toolbarproperty.cellexp"));
        this.jTAPreview.setSyntaxEditingStyle("text/html");
        this.jCBLineWrap.setSelected(ConfigOptions.bTextEditorLineWrap);
        this.jTAPreview.setLineWrap(this.jCBLineWrap.isSelected());
        this.jCBType.x_setSelectedCodeItem(ConfigOptions.iCopyPresentType);
        this.jCBHeader.setSelected(ConfigOptions.bCopyPresentHeader);
        this.jCBSep.setSelectedItem(ConfigOptions.sCopyPresentSep);
        this.setTitle(this.mm.getMessage("dialogcopypresent.title"));
        this.setResizable(true);
        this.jCBType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogCopyPresent.this.typeChanged();
                DialogCopyPresent.this.preview();
            }
        });
        this.jCBHeader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogCopyPresent.this.preview();
            }
        });
        Component editor = this.jCBSep.getEditor().getEditorComponent();
        if (editor instanceof JTextComponent) {
            final JTextComponent textSplitChar = (JTextComponent)editor;
            textSplitChar.setFocusTraversalKeys(0, Collections.EMPTY_SET);
            textSplitChar.setFocusTraversalKeys(1, Collections.EMPTY_SET);
            textSplitChar.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 9) {
                        textSplitChar.setText("TAB");
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            });
        }
        this.jCBSep.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    DialogCopyPresent.this.preview();
                }
            }
        });
        this.jCBSep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogCopyPresent.this.preview();
            }
        });
        this.jCBLineWrap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogCopyPresent.this.jTAPreview.setLineWrap(DialogCopyPresent.this.jCBLineWrap.isSelected());
            }
        });
        this.typeChanged();
        this.preview();
    }

    private void preview() {
        if (!this.saveOption(false)) {
            return;
        }
        String str = GVSpl.splEditor.getCopyPresentString();
        this.jTAPreview.setText(str);
    }

    private void typeChanged() {
        boolean sepEnabled = ((Number)this.jCBType.x_getSelectedItem()).byteValue() == 1;
        this.jLSep.setEnabled(sepEnabled);
        this.jCBSep.setEnabled(sepEnabled);
    }
}

