/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dialog;

import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.dialog.RQDialog;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.common.swing.RQTextArea;
import com.scudata.ide.spl.dialog.DialogInputPassword;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.util.CellSetUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.table.DefaultTableCellRenderer;

public class DialogEncrypt
extends RQDialog {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeSplMessage.get();
    private final String FUNC_TIP = this.mm.getMessage("dialogencrypt.functip");
    private static String encryptFunc = null;
    private static String decryptFunc = null;
    private static String suffixName = ".enc";
    private HashSet<String> selectedFiles = new HashSet();
    private LinkedHashMap<String, File> splFiles = new LinkedHashMap();
    private static final int SELECT_WIDTH = 120;
    private boolean actionAll = false;
    private JTextField jTFDir = new JTextField();
    private JButton jBDir = new JButton(this.mm.getMessage("dialogencrypt.selectfile"));
    private JCheckBox jCBSub = new JCheckBox(this.mm.getMessage("dialogencrypt.containschild"));
    private JTextField jTFName = new JTextField();
    private static final int COL_INDEX = 0;
    private static final int COL_FILE = 1;
    private static final int COL_SELECT = 2;
    private final String LABEL_INDEX = this.mm.getMessage("dialogencrypt.index");
    private final String LABEL_FILE = this.mm.getMessage("dialogencrypt.filename");
    private final String LABEL_SELECT = this.mm.getMessage("dialogencrypt.selected");
    private JTableEx jTFile = new JTableEx(new String[]{this.LABEL_INDEX, this.LABEL_FILE, this.LABEL_SELECT});
    private JButton jBEncrypt = new JButton(this.mm.getMessage("dialogencrypt.execencrypt"));
    private RQTextArea jTAMessage = new RQTextArea();
    private JLabel jLTarget = new JLabel(this.mm.getMessage("dialogencrypt.targetdir"));
    private JTextField jTFTarget = new JTextField();
    private JButton jBTarget = new JButton(this.mm.getMessage("dialogencrypt.selectfile"));
    private final String TARGET_TIP = this.mm.getMessage("dialogencrypt.targettip");
    private final String SUFFIX_TIP = this.mm.getMessage("dialogencrypt.suffixtip");
    private JLabel jLSuffix = new JLabel(this.mm.getMessage("dialogencrypt.suffix"));
    private JTextField jTFSuffix = new JTextField();
    private JLabel jLEncryptFunc = new JLabel(this.mm.getMessage("dialogencrypt.encryptfunc"));
    private JTextField jTFEncryptFunc = new JTextField();
    private JLabel jLDecryptFunc = new JLabel(this.mm.getMessage("dialogencrypt.decryptfunc"));
    private JTextField jTFDecryptFunc = new JTextField();

    public DialogEncrypt() {
        super((Frame)GV.appFrame, IdeSplMessage.get().getMessage("dialogencrypt.title"), 600, 600);
        try {
            this.initUI();
            this.init();
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    @Override
    protected void whenWindowClosed() {
        encryptFunc = this.jTFEncryptFunc.getText();
        decryptFunc = this.jTFDecryptFunc.getText();
        suffixName = this.jTFSuffix.getText();
    }

    private void init() {
        this.jTFEncryptFunc.setText(encryptFunc);
        this.jTFDecryptFunc.setText(decryptFunc);
        this.jTFSuffix.setText(suffixName);
    }

    private void initUI() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelTop = new JPanel(new GridBagLayout());
        int row = 0;
        panelTop.add((Component)new JLabel(this.mm.getMessage("dialogencrypt.filedir")), GM.getGBC(row, 0));
        panelTop.add((Component)this.jTFDir, GM.getGBC(row, 1, true));
        panelTop.add((Component)this.jBDir, GM.getGBC(row, 2));
        panelTop.add((Component)this.jLTarget, GM.getGBC(++row, 0));
        panelTop.add((Component)this.jTFTarget, GM.getGBC(row, 1, true));
        panelTop.add((Component)this.jBTarget, GM.getGBC(row, 2));
        panelTop.add((Component)this.jLSuffix, GM.getGBC(++row, 0));
        GridBagConstraints gbc = GM.getGBC(row, 1, true);
        gbc.gridwidth = 2;
        panelTop.add((Component)this.jTFSuffix, gbc);
        panelTop.add((Component)this.jLEncryptFunc, GM.getGBC(++row, 0));
        gbc = GM.getGBC(row, 1, true);
        gbc.gridwidth = 2;
        panelTop.add((Component)this.jTFEncryptFunc, gbc);
        panelTop.add((Component)this.jLDecryptFunc, GM.getGBC(++row, 0));
        gbc = GM.getGBC(row, 1, true);
        gbc.gridwidth = 2;
        panelTop.add((Component)this.jTFDecryptFunc, gbc);
        panelTop.add((Component)new JLabel(this.mm.getMessage("dialogencrypt.filelist")), GM.getGBC(++row, 0));
        panelTop.add((Component)this.jBEncrypt, GM.getGBC(row, 2));
        gbc = GM.getGBC(++row, 0, true, true);
        gbc.gridwidth = 3;
        panelTop.add((Component)new JScrollPane(this.jTFile), gbc);
        panelTop.add((Component)new JLabel(this.mm.getMessage("dialogencrypt.filefilter")), GM.getGBC(++row, 0));
        panelTop.add((Component)this.jTFName, GM.getGBC(row, 1, true));
        panelTop.add((Component)this.jCBSub, GM.getGBC(row, 2));
        JSplitPane jSPCenter = new JSplitPane(0);
        jSPCenter.setOneTouchExpandable(true);
        jSPCenter.setDividerLocation(420);
        jSPCenter.setDividerSize(7);
        jSPCenter.setTopComponent(panelTop);
        JPanel panelBottom = new JPanel(new GridBagLayout());
        panelBottom.add((Component)new JLabel(this.mm.getMessage("dialogencrypt.message")), GM.getGBC(0, 0));
        panelBottom.add((Component)new JScrollPane(this.jTAMessage), GM.getGBC(1, 0, true, true));
        jSPCenter.setBottomComponent(panelBottom);
        this.getContentPane().add((Component)jSPCenter, "Center");
        this.jTFDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEncrypt.this.showListFiles(true);
            }
        });
        this.jTFile.setColumnFixedWidth(2, 120);
        this.jTFile.setColumnCheckBox(2, true);
        this.jTFile.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int col = DialogEncrypt.this.jTFile.columnAtPoint(e.getPoint());
                DialogEncrypt.this.selectAll(col);
            }
        });
        this.jTFile.getColumn(2).setHeaderRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return DialogEncrypt.this.getHeaderPanel(DialogEncrypt.this.LABEL_SELECT, DialogEncrypt.this.actionAll);
            }
        });
        this.jTFile.setIndexCol(0);
        this.jTFile.setColumnEditable(1, false);
        this.jTFile.setColumnFixedWidth(0, 80);
        this.jTFile.getColumn(0).setPreferredWidth(80);
        this.jTFName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DialogEncrypt.this.showListFiles(false);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DialogEncrypt.this.showListFiles(false);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DialogEncrypt.this.showListFiles(false);
            }
        });
        this.jCBSub.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEncrypt.this.showListFiles(true);
            }
        });
        this.jBDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String dir = GM.dialogSelectDirectory(DialogEncrypt.this, DialogEncrypt.this.jTFDir.getText());
                if (StringUtils.isValidString(dir)) {
                    DialogEncrypt.this.jTFDir.setText(dir);
                    DialogEncrypt.this.showListFiles(true);
                }
            }
        });
        this.jBTarget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String dir = GM.dialogSelectDirectory(DialogEncrypt.this, DialogEncrypt.this.jTFTarget.getText());
                if (StringUtils.isValidString(dir)) {
                    DialogEncrypt.this.jTFTarget.setText(dir);
                }
            }
        });
        this.jTFile.setRowHeight(25);
        this.jBEncrypt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEncrypt.this.encrypt();
            }
        });
        this.jTAMessage.setLineWrap(true);
        this.jTAMessage.setEditable(false);
        this.jTFile.setSelectionMode(0);
        this.jLEncryptFunc.setToolTipText(this.FUNC_TIP);
        this.jTFEncryptFunc.setToolTipText(this.FUNC_TIP);
        this.jLDecryptFunc.setToolTipText(this.FUNC_TIP);
        this.jTFDecryptFunc.setToolTipText(this.FUNC_TIP);
        this.jLSuffix.setToolTipText(this.SUFFIX_TIP);
        this.jTFSuffix.setToolTipText(this.SUFFIX_TIP);
        this.jLTarget.setToolTipText(this.TARGET_TIP);
        this.jTFTarget.setToolTipText(this.TARGET_TIP);
    }

    private void encrypt() {
        String enFunc;
        this.jTAMessage.setText(null);
        this.jTFile.acceptText();
        String srcDir = this.jTFDir.getText();
        if (!StringUtils.isValidString(srcDir)) {
            JOptionPane.showMessageDialog(this, this.mm.getMessage("dialogencrypt.emptysrcdir"));
            return;
        }
        String tarDir = this.jTFTarget.getText();
        if (!StringUtils.isValidString(tarDir)) {
            tarDir = srcDir;
        }
        if (!StringUtils.isValidString(enFunc = this.jTFEncryptFunc.getText())) {
            JOptionPane.showMessageDialog(this, this.mm.getMessage("dialogencrypt.emptyencryptfunc"));
            return;
        }
        String deFunc = this.jTFDecryptFunc.getText();
        if (!StringUtils.isValidString(deFunc)) {
            JOptionPane.showMessageDialog(this, this.mm.getMessage("dialogencrypt.emptydecryptfunc"));
            return;
        }
        try {
            int rc = this.jTFile.getRowCount();
            int actionCount = 0;
            int i = 0;
            while (i < rc) {
                Object tmp = this.jTFile.data.getValueAt(i, 2);
                if (tmp != null && tmp instanceof Boolean && ((Boolean)tmp).booleanValue()) {
                    ++actionCount;
                    String name = (String)this.jTFile.data.getValueAt(i, 1);
                    File f = this.splFiles.get(name);
                    if (!f.canWrite()) {
                        this.appendMessage(this.mm.getMessage("dialogencrypt.cannotwrite", name));
                    } else {
                        File targetFile;
                        File targetDir;
                        PgmCellSet cellSet;
                        String fileName = f.getAbsolutePath();
                        String psw = null;
                        if (CellSetUtil.isEncrypted(fileName)) {
                            DialogInputPassword dip = new DialogInputPassword(true);
                            dip.setTitle(this.mm.getMessage("dialogencrypt.inputpwd", name));
                            dip.setPassword(null);
                            dip.setSize(400, 100);
                            GM.centerWindow(dip);
                            dip.setVisible(true);
                            if (dip.getOption() != 0) break;
                            psw = dip.getPassword();
                        }
                        if ((cellSet = CellSetUtil.readPgmCellSet(fileName, psw)) != null && fileName != null) {
                            cellSet.setName(fileName);
                        }
                        if ((targetDir = (targetFile = new File(tarDir, name)).getParentFile()) != null && !targetDir.exists()) {
                            targetDir.mkdirs();
                        }
                        targetFile = new File(targetDir, this.getBakName(targetFile.getName()));
                        CellSetUtil.writePgmCellSet(targetFile.getAbsolutePath(), cellSet, enFunc, deFunc);
                        this.appendMessage(this.mm.getMessage("dialogencrypt.signsuccess", name));
                    }
                }
                ++i;
            }
            if (actionCount == 0) {
                JOptionPane.showMessageDialog(this, this.mm.getMessage("dialogencrypt.needselect"));
            }
        }
        catch (Exception e) {
            GM.showException(this, e);
        }
    }

    private String getBakName(String fileName) {
        String suffixName = this.jTFSuffix.getText();
        if (!StringUtils.isValidString(suffixName)) {
            return fileName;
        }
        suffixName = suffixName.trim();
        if (fileName.toLowerCase().endsWith(".splx")) {
            if (!(fileName = fileName.substring(0, fileName.length() - 5)).endsWith(suffixName)) {
                fileName = String.valueOf(fileName) + suffixName;
            }
        } else {
            fileName = String.valueOf(fileName) + suffixName;
        }
        fileName = String.valueOf(fileName) + ".splx";
        return fileName;
    }

    private void appendMessage(String message) {
        if (this.jTAMessage.getText() != null && this.jTAMessage.getText().length() > 0) {
            this.jTAMessage.append("\n");
        }
        this.jTAMessage.append(message);
    }

    private JPanel getHeaderPanel(String label, boolean selectAll) {
        JCheckBox cb = new JCheckBox(label);
        cb.setSelected(selectAll);
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)cb, "Center");
        p.setFont(this.jTFile.getFont());
        p.setBorder(new MetalBorders.TableHeaderBorder());
        p.setPreferredSize(new Dimension(120, 20));
        cb.setEnabled(this.jTFile.isEnabled());
        return p;
    }

    public void selectAll(int col) {
        if (col != 2) {
            return;
        }
        boolean selected = this.actionAll = !this.actionAll;
        int count = this.jTFile.getRowCount();
        int r = 0;
        while (r < count) {
            this.jTFile.data.setValueAt(new Boolean(selected), r, col);
            ++r;
        }
        this.jTFile.getTableHeader().repaint();
        this.repaint();
    }

    private void showListFiles(boolean selectAll) {
        try {
            this.splFiles.clear();
            this.saveSelectState();
            String sdir = this.jTFDir.getText();
            if (!StringUtils.isValidString(sdir)) {
                return;
            }
            File dir = new File(sdir);
            if (!dir.exists() || !dir.isDirectory()) {
                JOptionPane.showMessageDialog(this, this.mm.getMessage("dialogencrypt.dirnotexists", sdir));
                return;
            }
            boolean searchSub = this.jCBSub.isSelected();
            String spattern = this.jTFName.getText();
            Pattern pattern = null;
            if (spattern != null && !spattern.equals("")) {
                pattern = Pattern.compile(spattern);
            }
            this.searchSubFiles(dir, searchSub, pattern);
        }
        finally {
            try {
                this.setListFiles2Table(selectAll);
            }
            catch (Exception ex) {
                GM.showException(this, ex);
            }
        }
    }

    private void saveSelectState() {
        this.selectedFiles.clear();
        this.jTFile.acceptText();
        int r = 0;
        int count = this.jTFile.getRowCount();
        while (r < count) {
            Object tmp = this.jTFile.data.getValueAt(r, 2);
            if (tmp != null && tmp instanceof Boolean && ((Boolean)tmp).booleanValue()) {
                String fileName = (String)this.jTFile.data.getValueAt(r, 1);
                this.selectedFiles.add(fileName);
            }
            ++r;
        }
    }

    private void searchSubFiles(File pfile, boolean searchSub, Pattern pattern) {
        File[] files;
        File[] fileArray = files = pfile.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile()) {
                Matcher m;
                if (f.getName().toLowerCase().endsWith("splx") && (pattern == null || (m = pattern.matcher(f.getName())).find())) {
                    this.splFiles.put(this.getPath(f), f);
                }
            } else if (f.isDirectory() && searchSub) {
                this.searchSubFiles(f, searchSub, pattern);
            }
            ++n2;
        }
    }

    private void setListFiles2Table(boolean selectAll) throws Exception {
        this.jTFile.removeAllRows();
        this.jTFile.clearSelection();
        Iterator<String> names = this.splFiles.keySet().iterator();
        int i = 0;
        Boolean isAllSelected = null;
        while (names.hasNext()) {
            boolean isSelect;
            String name = names.next();
            boolean bl = isSelect = selectAll ? Boolean.TRUE.booleanValue() : this.selectedFiles.contains(name);
            if (!isSelect) {
                isAllSelected = Boolean.FALSE;
            } else if (isAllSelected == null) {
                isAllSelected = Boolean.TRUE;
            }
            this.jTFile.addRow(new Object[]{new Integer(i + 1), name, isSelect}, false);
        }
        this.actionAll = isAllSelected != null && isAllSelected != false;
        this.jTFile.resetIndex();
    }

    private String getPath(File f) {
        String p = new File(this.jTFDir.getText()).getAbsolutePath();
        String path = f.getAbsolutePath().substring(p.length());
        while (path.startsWith("\\") || path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }
}

