/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dialog;

import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.FTPInfo;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.swing.ESPasswordBoxEditor;
import com.scudata.ide.common.swing.ESPasswordBoxRenderer;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.ide.spl.dialog.DialogHostManager_this_windowAdapter;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;

public class DialogHostManager
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeSplMessage.get();
    private JButton jBOK = new JButton();
    private JButton jBCancel = new JButton();
    private JButton jBAdd = new JButton();
    private JButton jBDelete = new JButton();
    private JButton jBUp = new JButton();
    private JButton jBDown = new JButton();
    private final int COL_INDEX = 0;
    private final int COL_HOST = 1;
    private final int COL_PORT = 2;
    private final int COL_USER = 3;
    private final int COL_PASSWORD = 4;
    private final int COL_DIRECTORY = 5;
    private final int COL_SELECTED = 6;
    private final String TITLE_INDEX = this.mm.getMessage("dialoguploadresult.index");
    private final String TITLE_HOST = this.mm.getMessage("dialoguploadresult.hostname");
    private final String TITLE_PORT = this.mm.getMessage("dialoghostmanager.port");
    private final String TITLE_USER = this.mm.getMessage("dialoguploadresult.user");
    private final String TITLE_PASSWORD = this.mm.getMessage("dialoghostmanager.password");
    private final String TITLE_DIRECTORY = this.mm.getMessage("dialoghostmanager.dir");
    private final String TITLE_SELECTED = "TITLE_SELECTED";
    private JTableEx tableHost = new JTableEx(String.valueOf(this.TITLE_INDEX) + "," + this.TITLE_HOST + "," + this.TITLE_PORT + "," + this.TITLE_USER + "," + this.TITLE_PASSWORD + "," + this.TITLE_DIRECTORY + "," + "TITLE_SELECTED"){
        private static final long serialVersionUID = 1L;

        @Override
        public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
            switch (col) {
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    GM.dialogEditTableText(DialogHostManager.this, DialogHostManager.this.tableHost, row, col);
                }
            }
        }
    };
    private int m_option = -1;

    public DialogHostManager(JDialog parent) {
        super(parent, "FTP\u4e3b\u673a\u7ba1\u7406", true);
        try {
            this.init();
            this.setSize(600, 300);
            this.resetText();
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    public FTPInfo[] getFTPInfo() {
        this.tableHost.acceptText();
        int count = this.tableHost.getRowCount();
        if (count == 0) {
            return null;
        }
        FTPInfo[] fis = new FTPInfo[count];
        int i = 0;
        while (i < count) {
            fis[i] = new FTPInfo();
            Object tmp = this.tableHost.data.getValueAt(i, 1);
            fis[i].setHost(tmp == null ? null : (String)tmp);
            tmp = this.tableHost.data.getValueAt(i, 2);
            if (StringUtils.isValidString(tmp)) {
                fis[i].setPort(Integer.parseInt((String)tmp));
            }
            tmp = this.tableHost.data.getValueAt(i, 3);
            fis[i].setUser(tmp == null ? null : (String)tmp);
            tmp = this.tableHost.data.getValueAt(i, 4);
            fis[i].setPassword(tmp == null ? null : (String)tmp);
            tmp = this.tableHost.data.getValueAt(i, 5);
            fis[i].setDirectory(tmp == null ? null : (String)tmp);
            tmp = this.tableHost.data.getValueAt(i, 6);
            if (tmp != null) {
                fis[i].setSelected((Boolean)tmp);
            }
            ++i;
        }
        return fis;
    }

    public void setFTPInfo(FTPInfo[] ftpInfos) {
        if (ftpInfos == null || ftpInfos.length == 0) {
            return;
        }
        int i = 0;
        while (i < ftpInfos.length) {
            int row = this.tableHost.addRow();
            this.tableHost.data.setValueAt(ftpInfos[i].getHost(), row, 1);
            this.tableHost.data.setValueAt(String.valueOf(ftpInfos[i].getPort()), row, 2);
            this.tableHost.data.setValueAt(ftpInfos[i].getUser(), row, 3);
            this.tableHost.data.setValueAt(ftpInfos[i].getPassword(), row, 4);
            this.tableHost.data.setValueAt(ftpInfos[i].getDirectory(), row, 5);
            this.tableHost.data.setValueAt(new Boolean(ftpInfos[i].isSelected()), row, 6);
            ++i;
        }
    }

    private void resetText() {
        this.setTitle(this.mm.getMessage("dialoghostmanager.title"));
        this.jBOK.setText(this.mm.getMessage("button.ok"));
        this.jBCancel.setText(this.mm.getMessage("button.cancel"));
        this.jBAdd.setText(this.mm.getMessage("button.add"));
        this.jBDelete.setText(this.mm.getMessage("button.delete"));
        this.jBUp.setText(this.mm.getMessage("button.up"));
        this.jBDown.setText(this.mm.getMessage("button.down"));
    }

    public int getOption() {
        return this.m_option;
    }

    private void init() throws Exception {
        JPanel panelEast = new JPanel(new VFlowLayout());
        this.jBOK.setMnemonic('O');
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(this);
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addActionListener(this);
        this.jBAdd.setMnemonic('A');
        this.jBAdd.setText("\u589e\u52a0(A)");
        this.jBAdd.addActionListener(this);
        this.jBDelete.setMnemonic('D');
        this.jBDelete.setText("\u5220\u9664(D)");
        this.jBDelete.addActionListener(this);
        this.jBUp.setMnemonic('U');
        this.jBUp.setText("\u4e0a\u79fb(U)");
        this.jBUp.addActionListener(this);
        this.jBDown.setMnemonic('W');
        this.jBDown.setText("\u4e0b\u79fb(W)");
        this.jBDown.addActionListener(this);
        this.getContentPane().add((Component)panelEast, "East");
        panelEast.add((Component)this.jBOK, null);
        panelEast.add((Component)this.jBCancel, null);
        panelEast.add((Component)new JPanel(), null);
        panelEast.add((Component)this.jBAdd, null);
        panelEast.add((Component)this.jBDelete, null);
        panelEast.add((Component)this.jBUp, null);
        panelEast.add((Component)this.jBDown, null);
        JPanel panelCenter = new JPanel(new GridBagLayout());
        panelCenter.add((Component)new JScrollPane(this.tableHost), GM.getGBC(1, 1, true, true));
        this.getContentPane().add((Component)panelCenter, "Center");
        this.addWindowListener(new DialogHostManager_this_windowAdapter(this));
        this.tableHost.setRowHeight(22);
        this.tableHost.setIndexCol(0);
        TableColumn tc = this.tableHost.getColumn(4);
        tc.setCellEditor(new ESPasswordBoxEditor());
        tc.setCellRenderer(new ESPasswordBoxRenderer());
        this.tableHost.setColumnVisible("TITLE_SELECTED", false);
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (this.jBOK.equals(src)) {
            this.tableHost.acceptText();
            int count = this.tableHost.getRowCount();
            if (count > 0) {
                if (!this.tableHost.verifyColumnData(1, this.TITLE_HOST, false, this)) {
                    return;
                }
                if (!this.tableHost.verifyColumnData(2, this.TITLE_PORT, false, this)) {
                    return;
                }
                int i = 0;
                while (i < count) {
                    Object port = this.tableHost.data.getValueAt(i, 2);
                    if (StringUtils.isValidString(port)) {
                        try {
                            Integer.parseInt((String)port);
                        }
                        catch (Exception ex) {
                            GM.messageDialog(this, this.mm.getMessage("dialoghostmanager.invalidport", String.valueOf(i + 1)));
                            return;
                        }
                    }
                    ++i;
                }
            }
            this.m_option = 0;
            GM.setWindowDimension(this);
            this.dispose();
        } else if (this.jBCancel.equals(src)) {
            GM.setWindowDimension(this);
            this.dispose();
        } else if (this.jBAdd.equals(src)) {
            this.tableHost.addRow();
        } else if (this.jBDelete.equals(src)) {
            this.tableHost.deleteSelectedRows();
        } else if (this.jBUp.equals(src)) {
            this.tableHost.shiftUp();
        } else if (this.jBDown.equals(src)) {
            this.tableHost.shiftDown();
        }
    }
}

