/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dialog;

import com.scudata.app.common.AppUtil;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.spl.dialog.DialogInputPort_jBCancel_actionAdapter;
import com.scudata.ide.spl.dialog.DialogInputPort_jBOK_actionAdapter;
import com.scudata.ide.spl.dialog.DialogInputPort_this_windowAdapter;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.parallel.UnitContext;
import com.scudata.server.http.HttpContext;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class DialogInputPort
extends JDialog {
    private static final long serialVersionUID = 1L;
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    JButton jBOK = new JButton();
    JButton jBCancel = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabel1 = new JLabel();
    JLabel lbHost = new JLabel("Host");
    JComboBox<String> cbHosts = new JComboBox();
    JSpinner jSPort = new JSpinner();
    JLabel labelMaxLinks = new JLabel("\u6700\u5927\u8fde\u63a5\u6570");
    JSpinner jSMaxLinks = new JSpinner();
    JCheckBox cbAutoStart = new JCheckBox(IdeCommonMessage.get().getMessage("dialogodbcconfig.autostart"));
    private int m_option = -1;
    private MessageManager mm = IdeSplMessage.get();
    HttpContext hc = null;
    JFrame parent;

    public DialogInputPort(JFrame parent, String title) {
        super(parent, title, true);
        this.parent = parent;
        try {
            this.setSize(350, 150);
            this.init();
            this.resetText();
            this.setResizable(false);
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    private void resetText() {
        this.jBOK.setText(IdeCommonMessage.get().getMessage("button.ok"));
        this.jBCancel.setText(IdeCommonMessage.get().getMessage("button.cancel"));
        this.lbHost.setText(IdeCommonMessage.get().getMessage("dialogjdbcconfig.host"));
        this.labelMaxLinks.setText(IdeCommonMessage.get().getMessage("dialogoptions.maxlinks"));
        this.jLabel1.setText(this.mm.getMessage("dialoginputport.inputport"));
    }

    public int getOption() {
        return this.m_option;
    }

    private void loadHttp() {
        InputStream is = null;
        try {
            this.hc = new HttpContext(false);
            is = UnitContext.getUnitInputStream("HttpServer.xml");
            if (is == null) {
                return;
            }
            try {
                this.hc.load(is);
                is.close();
            }
            catch (Exception exception) {}
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void init() throws Exception {
        this.jSPort.setModel(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        this.jSMaxLinks.setModel(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        this.loadHttp();
        String[] allHosts = AppUtil.getLocalIps();
        int i = 0;
        while (i < allHosts.length) {
            String host = allHosts[i];
            this.cbHosts.addItem(host);
            ++i;
        }
        this.cbHosts.setSelectedItem(this.hc.getHost());
        this.jSPort.setValue(this.hc.getPort());
        this.cbAutoStart.setSelected(this.hc.isAutoStart());
        this.jSMaxLinks.setValue(this.hc.getMaxLinks());
        this.flowLayout1.setAlignment(2);
        this.jPanel1.setLayout(this.flowLayout1);
        this.jBOK.setMnemonic('O');
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new DialogInputPort_jBOK_actionAdapter(this));
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addActionListener(new DialogInputPort_jBCancel_actionAdapter(this));
        this.jPanel2.setLayout(this.gridBagLayout1);
        this.jLabel1.setText("\u7aef\u53e3");
        this.addWindowListener(new DialogInputPort_this_windowAdapter(this));
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.jBOK, null);
        this.jPanel1.add((Component)this.jBCancel, null);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.lbHost, GM.getGBC(1, 1));
        GridBagConstraints gbc = GM.getGBC(1, 2, true);
        gbc.gridwidth = 3;
        this.jPanel2.add(this.cbHosts, gbc);
        this.jPanel2.add((Component)this.jLabel1, GM.getGBC(2, 1));
        this.jPanel2.add((Component)this.jSPort, GM.getGBC(2, 2, true));
        this.jPanel2.add((Component)this.labelMaxLinks, GM.getGBC(2, 3));
        this.jPanel2.add((Component)this.jSMaxLinks, GM.getGBC(2, 4, true));
        gbc = GM.getGBC(3, 2, true);
        gbc.gridwidth = 3;
        this.jPanel2.add((Component)this.cbAutoStart, gbc);
    }

    private boolean save() {
        try {
            this.hc.setHost(this.cbHosts.getSelectedItem().toString());
            this.hc.setPort(((Number)this.jSPort.getValue()).intValue());
            this.hc.setMaxLinks(((Number)this.jSMaxLinks.getValue()).intValue());
            this.hc.setAutoStart(this.cbAutoStart.isSelected());
            String filePath = GM.getAbsolutePath("config/HttpServer.xml");
            File f = new File(filePath);
            if (f.exists() && !f.canWrite()) {
                String msg = IdeCommonMessage.get().getMessage("public.readonly", f.getName());
                throw new RQException(msg);
            }
            FileOutputStream fos = new FileOutputStream(f);
            this.hc.save(fos);
            fos.close();
            return true;
        }
        catch (Exception ex) {
            GM.showException(this, ex);
            return false;
        }
    }

    void jBOK_actionPerformed(ActionEvent e) {
        if (this.save()) {
            this.m_option = 0;
            GM.setWindowDimension(this);
            this.dispose();
        }
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }
}

