/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dialog;

import com.scudata.app.common.AppUtil;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.ide.spl.dialog.DialogOdbcConfig_jBCancel_actionAdapter;
import com.scudata.ide.spl.dialog.DialogOdbcConfig_jBOK_actionAdapter;
import com.scudata.ide.spl.dialog.DialogOdbcConfig_this_windowAdapter;
import com.scudata.parallel.UnitContext;
import com.scudata.server.odbc.OdbcContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class DialogOdbcConfig
extends JDialog {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeCommonMessage.get();
    OdbcContext oc;
    private JPanel jPanelButton = new JPanel();
    private JButton jBOK = new JButton();
    private JButton jBCancel = new JButton();
    JLabel jLabelLocalHost = new JLabel(this.mm.getMessage("dialogjdbcconfig.host"));
    JComboBox<String> cbHosts = new JComboBox();
    JLabel jLabelLocalPort = new JLabel(this.mm.getMessage("dialogjdbcconfig.port"));
    JSpinner jsPort = new JSpinner(new SpinnerNumberModel(8501, 0, Integer.MAX_VALUE, 1));
    JCheckBox cbAutoStart = new JCheckBox(this.mm.getMessage("dialogodbcconfig.autostart"));
    private JLabel labelTimeOut = new JLabel(this.mm.getMessage("dialogunitconfig.temptimeout"));
    private JSpinner jsTimeOut = new JSpinner(new SpinnerNumberModel(12, 0, Integer.MAX_VALUE, 1));
    private JLabel labelConTimeOut = new JLabel(this.mm.getMessage("dialogjdbcconfig.contimeout"));
    private JSpinner jsConTimeOut = new JSpinner(new SpinnerNumberModel(12, 0, Integer.MAX_VALUE, 1));
    private JLabel labelInterval = new JLabel(this.mm.getMessage("dialogunitconfig.checkinterval"));
    private JSpinner jSInterval = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
    private JLabel labelConMax = new JLabel(this.mm.getMessage("dialogjdbcconfig.conmax"));
    private JSpinner jsConMax = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
    private JLabel labelLog = new JLabel(this.mm.getMessage("dialogunitconfig.logprop"));
    private final int COL_INDEX = 0;
    private final int COL_PATH = 1;
    private final String TITLE_INDEX = this.mm.getMessage("dialogunitconfig.index");
    private final String TITLE_PATH = this.mm.getMessage("dialogunitconfig.path");
    private JLabel labelUser = new JLabel(this.mm.getMessage("dialogjdbcconfig.userlist"));
    private JButton bAddUser = new JButton();
    private JButton bDeleteUser = new JButton();
    private final int COL_NAME = 1;
    private final int COL_PASSWORD = 2;
    private final int COL_ADMIN = 3;
    private final String TITLE_NAME = this.mm.getMessage("dialogjdbcconfig.name");
    private final String TITLE_PASSWORD = this.mm.getMessage("dialogjdbcconfig.password");
    private final String TITLE_ADMIN = this.mm.getMessage("dialogjdbcconfig.admin");
    private JTableEx tableUser = new JTableEx(new String[]{this.TITLE_INDEX, this.TITLE_NAME, this.TITLE_PASSWORD, this.TITLE_ADMIN});
    private int m_option = -1;
    JFrame parent;

    public DialogOdbcConfig(JFrame parent, String title) {
        super(parent, title, true);
        this.parent = parent;
        try {
            this.rqInit();
            this.init();
            this.setSize(700, 600);
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
            this.resetLangText();
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    public int getOption() {
        return this.m_option;
    }

    private void init() {
        this.loadOdbc();
        String[] allHosts = AppUtil.getLocalIps();
        int i = 0;
        while (i < allHosts.length) {
            this.cbHosts.addItem(allHosts[i]);
            ++i;
        }
        this.cbHosts.setSelectedItem(this.oc.getHost());
        this.jsPort.setValue(this.oc.getPort());
        this.cbAutoStart.setSelected(this.oc.isAutoStart());
        this.jsTimeOut.setValue(this.oc.getTimeOut());
        this.jsConMax.setValue(new Integer(this.oc.getConMax()));
        this.jsConTimeOut.setValue(new Integer(this.oc.getConTimeOut()));
        this.jSInterval.setValue(new Integer(this.oc.getConPeriod()));
        List<OdbcContext.User> userList = this.oc.getUserList();
        if (userList != null) {
            int i2 = 0;
            int size = userList.size();
            while (i2 < size) {
                OdbcContext.User u = userList.get(i2);
                int row = this.tableUser.addRow();
                this.tableUser.data.setValueAt(u.getName(), row, 1);
                this.tableUser.data.setValueAt(u.getPassword(), row, 2);
                this.tableUser.data.setValueAt(u.isAdmin(), row, 3);
                ++i2;
            }
        }
    }

    private String getDefName() {
        int c = this.tableUser.getRowCount();
        int d = 0;
        boolean find = true;
        String name = "";
        while (find) {
            find = false;
            name = "user" + d;
            int i = 0;
            while (i < c) {
                String s = (String)this.tableUser.data.getValueAt(i, 1);
                if (StringUtils.isValidString(s) && name.equalsIgnoreCase(s)) {
                    ++d;
                    find = true;
                    break;
                }
                ++i;
            }
            if (!find) break;
        }
        return name;
    }

    private void loadOdbc() {
        InputStream is = null;
        try {
            this.oc = new OdbcContext();
            is = this.getUnitInputStream("OdbcServer.xml");
            if (is == null) {
                return;
            }
            try {
                this.oc.load(is);
                is.close();
            }
            catch (Exception exception) {}
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private InputStream getUnitInputStream(String relativePath) throws Exception {
        return UnitContext.getUnitInputStream(relativePath);
    }

    private boolean save() {
        try {
            this.oc.setTimeOut((Integer)this.jsTimeOut.getValue());
            this.oc.setConMax((Integer)this.jsConMax.getValue());
            this.oc.setConTimeOut((Integer)this.jsConTimeOut.getValue());
            this.oc.setConPeriod((Integer)this.jSInterval.getValue());
            this.oc.setHost((String)this.cbHosts.getSelectedItem());
            this.oc.setPort((Integer)this.jsPort.getValue());
            this.oc.setAutoStart(this.cbAutoStart.isSelected());
            ArrayList<OdbcContext.User> users = new ArrayList<OdbcContext.User>();
            this.tableUser.acceptText();
            int i = 0;
            int count = this.tableUser.getRowCount();
            while (i < count) {
                String name = (String)this.tableUser.data.getValueAt(i, 1);
                if (!StringUtils.isValidString(name)) {
                    throw new Exception("Name can not be empty!");
                }
                String password = (String)this.tableUser.data.getValueAt(i, 2);
                if (!StringUtils.isValidString(password)) {
                    throw new Exception(String.valueOf(name) + "'s password can not be empty!");
                }
                boolean admin = (Boolean)this.tableUser.data.getValueAt(i, 3);
                OdbcContext.User user = new OdbcContext.User();
                user.setName(name);
                user.setPassword(password);
                user.setAdmin(admin);
                users.add(user);
                ++i;
            }
            this.oc.setUserList(users);
            String filePath = GM.getAbsolutePath("config/OdbcServer.xml");
            File f = new File(filePath);
            if (f.exists() && !f.canWrite()) {
                String msg = IdeCommonMessage.get().getMessage("public.readonly", f.getName());
                throw new RQException(msg);
            }
            FileOutputStream fos = new FileOutputStream(f);
            this.oc.save(fos);
            fos.close();
            return true;
        }
        catch (Exception ex) {
            GM.showException(this, ex);
            return false;
        }
    }

    void resetLangText() {
        this.jBOK.setText(this.mm.getMessage("button.ok"));
        this.jBCancel.setText(this.mm.getMessage("button.cancel"));
    }

    private void rqInit() throws Exception {
        this.jPanelButton.setLayout(new VFlowLayout());
        this.jBOK.setActionCommand("");
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new DialogOdbcConfig_jBOK_actionAdapter(this));
        this.jBOK.setMnemonic('O');
        this.jBCancel.setActionCommand("");
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addActionListener(new DialogOdbcConfig_jBCancel_actionAdapter(this));
        this.jBCancel.setMnemonic('C');
        this.jPanelButton.add((Component)this.jBOK, null);
        this.jPanelButton.add((Component)this.jBCancel, null);
        this.bAddUser.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/b_add.gif"));
        this.bDeleteUser.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/b_delete.gif"));
        JPanel panelServer = new JPanel(new GridBagLayout());
        panelServer.add((Component)this.jLabelLocalHost, GM.getGBC(1, 1));
        panelServer.add(this.cbHosts, GM.getGBC(1, 2, true));
        panelServer.add((Component)this.jLabelLocalPort, GM.getGBC(1, 3));
        panelServer.add((Component)this.jsPort, GM.getGBC(1, 4, true));
        panelServer.add((Component)this.labelTimeOut, GM.getGBC(2, 1));
        panelServer.add((Component)this.jsTimeOut, GM.getGBC(2, 2, true));
        panelServer.add((Component)this.labelConMax, GM.getGBC(2, 3));
        panelServer.add((Component)this.jsConMax, GM.getGBC(2, 4, true));
        panelServer.add((Component)this.labelConTimeOut, GM.getGBC(3, 1));
        panelServer.add((Component)this.jsConTimeOut, GM.getGBC(3, 2, true));
        panelServer.add((Component)this.labelInterval, GM.getGBC(3, 3));
        panelServer.add((Component)this.jSInterval, GM.getGBC(3, 4, true));
        GridBagConstraints gbc = GM.getGBC(4, 1, true);
        gbc.gridwidth = 4;
        panelServer.add((Component)this.cbAutoStart, gbc);
        JPanel panelUserList = new JPanel(new GridBagLayout());
        panelUserList.add((Component)this.labelUser, GM.getGBC(1, 1, true));
        panelUserList.add((Component)this.bAddUser, GM.getGBC(1, 2));
        panelUserList.add((Component)this.bDeleteUser, GM.getGBC(1, 3));
        gbc = GM.getGBC(5, 1, true);
        gbc.gridwidth = 4;
        panelServer.add((Component)panelUserList, gbc);
        gbc = GM.getGBC(6, 1, true, true);
        gbc.gridwidth = 4;
        panelServer.add((Component)new JScrollPane(this.tableUser), gbc);
        JPanel panelCenter = new JPanel(new BorderLayout());
        panelCenter.add((Component)panelServer, "Center");
        JPanel panelSouth = new JPanel(new GridBagLayout());
        panelSouth.add((Component)new JLabel(), GM.getGBC(0, 1, true));
        panelCenter.add((Component)panelSouth, "South");
        this.addWindowListener(new DialogOdbcConfig_this_windowAdapter(this));
        this.getContentPane().add((Component)panelCenter, "Center");
        this.getContentPane().add((Component)this.jPanelButton, "East");
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.tableUser.setIndexCol(0);
        this.tableUser.setRowHeight(20);
        this.tableUser.setColumnCheckBox(3);
        this.bAddUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DialogOdbcConfig.this.tableUser.acceptText();
                String n = DialogOdbcConfig.this.getDefName();
                DialogOdbcConfig.this.tableUser.addRow(new Object[]{0, n, "", false});
            }
        });
        this.bDeleteUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DialogOdbcConfig.this.tableUser.acceptText();
                DialogOdbcConfig.this.tableUser.deleteSelectedRows();
            }
        });
        Dimension d = new Dimension(22, 22);
        this.bAddUser.setMaximumSize(d);
        this.bAddUser.setMinimumSize(d);
        this.bAddUser.setPreferredSize(d);
        this.bDeleteUser.setMaximumSize(d);
        this.bDeleteUser.setMinimumSize(d);
        this.bDeleteUser.setPreferredSize(d);
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jBOK_actionPerformed(ActionEvent e) {
        if (this.save()) {
            this.m_option = 0;
            GM.setWindowDimension(this);
            this.dispose();
        }
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jBSearchTarget_actionPerformed(ActionEvent e) {
        if (GM.getOperationSytem() == 0) {
            try {
                Runtime.getRuntime().exec("cmd /C start explorer.exe " + GM.getAbsolutePath("log"));
            }
            catch (Exception x) {
                GM.showException(this, x);
            }
        }
    }
}

