/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dialog;

import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.swing.JComboBoxEx;
import com.scudata.ide.spl.GMSplSE;
import com.scudata.ide.spl.GVSplSE;
import com.scudata.ide.spl.dialog.DialogOptions;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.ide.spl.resources.IdeSplSEMessage;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DialogOptionsSE
extends DialogOptions {
    private static final long serialVersionUID = 1L;
    private static final String EXTLIB_NAME = "extlib";
    private static final String ZIP_NAME = "ZipCli";
    private static final String MATH_NAME = "MathCli";
    protected JCheckBox jCBFuncNotice;
    private JCheckBox jCBNoticeNearExp;
    private JCheckBox jCBAutoExcelServer;
    private JLabel jLExcelAddinType;
    private JComboBoxEx jCBExcelAddinType;
    private JCheckBox jCBMathExtlib;

    public DialogOptionsSE() {
        this.jCBFuncNotice = new JCheckBox(this.mm.getMessage("dialogoptions.funcnotice"));
        this.jCBNoticeNearExp = new JCheckBox(this.mm.getMessage("dialogoptions.noticenearexp"));
        this.jCBAutoExcelServer = new JCheckBox(IdeSplMessage.get().getMessage("dialogoptions.autoexcelserver"));
        this.jLExcelAddinType = null;
        this.jCBExcelAddinType = null;
        this.jCBMathExtlib = new JCheckBox(IdeSplSEMessage.get().getMessage("dialogoptions.mathextlib"));
        try {
            this.initSE();
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    @Override
    protected boolean isExtEnabled() {
        return GMSplSE.getActiveProductId() != 4;
    }

    protected void initSE() {
        this.ideOptLayout.setRows(6);
        this.jPIdeOpt.add(this.jCBFuncNotice);
        this.jPIdeOpt.add(this.jCBNoticeNearExp);
        int rowCount = 6;
        if (GVSplSE.isDesktop) {
            this.ideOptLayout.setRows(7);
            rowCount = 7;
            this.jPIdeOpt.add(this.jCBMathExtlib);
            this.jPIdeOpt.add(new JPanel());
        }
        if (GMSplSE.isOfficeAddinEnabled()) {
            this.ideOptLayout.setRows(rowCount + 1);
            this.jPIdeOpt.add(this.jCBAutoExcelServer);
            if (GMSplSE.isExcelXllEnabled()) {
                this.jLExcelAddinType = new JLabel(this.mm.getMessage("dialogoptions.exceladdintype"));
                this.jCBExcelAddinType = new JComboBoxEx();
                JPanel jPExcelAddinType = new JPanel(new GridBagLayout());
                jPExcelAddinType.add((Component)this.jLExcelAddinType, GM.getGBC(0, 0, false, false, 5, 0));
                jPExcelAddinType.add((Component)this.jCBExcelAddinType, GM.getGBC(0, 1, true, false, 8, 0));
                Vector<String> excelAddinTypes = new Vector<String>();
                excelAddinTypes.add(this.mm.getMessage("dialogoptions.excelxll"));
                excelAddinTypes.add(this.mm.getMessage("dialogoptions.officeaddin"));
                this.jCBExcelAddinType.x_setData(excelAddinTypes, excelAddinTypes);
                this.jCBExcelAddinType.setSelectedIndex(ConfigOptions.bExcelXllType == null || ConfigOptions.bExcelXllType != false ? 0 : 1);
                this.jPIdeOpt.add(jPExcelAddinType);
            }
        }
        this.jCBFuncNotice.setSelected(ConfigOptions.bFuncNotice);
        this.jCBNoticeNearExp.setSelected(ConfigOptions.bNoticeExpiration);
        this.jCBAutoExcelServer.setSelected(ConfigOptions.bAutoExcelServer);
        this.jCBMathExtlib.setSelected(ConfigOptions.bLoadMathExtlib);
        this.jCBAutoExcelServer.setForeground(Color.blue);
        this.jCBMathExtlib.setForeground(Color.blue);
    }

    protected boolean isExtLibsEnabled() {
        return !GVSplSE.isDesktop;
    }

    @Override
    protected void saveCustom() {
        ConfigOptions.bFuncNotice = this.jCBFuncNotice.isSelected();
        ConfigOptions.bNoticeExpiration = this.jCBNoticeNearExp.isSelected();
        ConfigOptions.bAutoExcelServer = this.jCBAutoExcelServer.isSelected();
        ConfigOptions.bLoadMathExtlib = this.jCBMathExtlib.isSelected();
        if (this.jCBExcelAddinType != null) {
            ConfigOptions.bExcelXllType = this.jCBExcelAddinType.getSelectedIndex() == 0;
        }
        if (GVSplSE.isDesktop) {
            if (ConfigOptions.bLoadMathExtlib.booleanValue()) {
                String extlibPath = this.getExtlibPath();
                GV.config.setExtLibsPath(extlibPath);
                List<String> extLibs = GV.config.getImportLibs();
                if (extLibs == null) {
                    extLibs = new ArrayList<String>();
                }
                if (!extLibs.contains(ZIP_NAME)) {
                    extLibs.add(ZIP_NAME);
                }
                if (!extLibs.contains(MATH_NAME)) {
                    extLibs.add(MATH_NAME);
                }
            } else {
                String extlibPath = this.getExtlibPath();
                GV.config.setExtLibsPath(extlibPath);
                List<String> extLibs = GV.config.getImportLibs();
                if (extLibs == null) {
                    extLibs = new ArrayList<String>();
                }
                if (!extLibs.contains(ZIP_NAME)) {
                    extLibs.add(ZIP_NAME);
                }
                if (extLibs.contains(MATH_NAME)) {
                    extLibs.remove(MATH_NAME);
                }
            }
        }
    }

    private String getExtlibPath() {
        return GM.getAbsolutePath(EXTLIB_NAME);
    }
}

