/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dialog;

import com.scudata.app.common.Section;
import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.common.CellLocation;
import com.scudata.common.MessageManager;
import com.scudata.common.SegmentSet;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.IAtomicCmd;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.ide.spl.AtomicCell;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.control.SplControl;
import com.scudata.ide.spl.control.SplEditor;
import com.scudata.ide.spl.dialog.DialogSearch_jBCancel_actionAdapter;
import com.scudata.ide.spl.dialog.DialogSearch_jBReplaceAll_actionAdapter;
import com.scudata.ide.spl.dialog.DialogSearch_jBReplace_actionAdapter;
import com.scudata.ide.spl.dialog.DialogSearch_jBSearch_actionAdapter;
import com.scudata.ide.spl.dialog.DialogSearch_this_windowAdapter;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class DialogSearch
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static Section searchKeys = new Section();
    private static Section replaceKeys = new Section();
    private static SegmentSet status = new SegmentSet("");
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel2 = new JLabel();
    private JComboBox jCBSearch = new JComboBox();
    private JComboBox jCBReplace = new JComboBox();
    private JButton jBSearch = new JButton();
    private JButton jBReplace = new JButton();
    private JButton jBReplaceAll = new JButton();
    private JButton jBCancel = new JButton();
    private JCheckBox jCBSensitive = new JCheckBox();
    private JCheckBox jCBWordOnly = new JCheckBox();
    private JCheckBox jCBQuote = new JCheckBox();
    private JCheckBox jCBPars = new JCheckBox();
    private TitledBorder titledBorder1;
    private TitledBorder titledBorder2;
    private MessageManager splMM = IdeSplMessage.get();
    private static final String KEY_QUOTE = "quote";
    private static final String KEY_RARS = "pars";
    private static final String KEY_WORDONLY = "wordonly";
    private static final String KEY_CASE = "case";
    private boolean isReplace = false;
    private boolean isSearchClicked = false;
    private String searchString = "";
    private String replaceString = "";
    private int searchFlag;
    private int stringIndex = -1;
    private int searchedRow = -1;
    private int searchedCol = -1;
    private boolean searchSelectedCells = false;
    private int replaceAllStartRow = 1;
    private int replaceAllStartCol = 1;

    public DialogSearch() {
        super(GV.appFrame, "\u67e5\u627e", false);
        try {
            this.initUI();
            this.init();
            GM.setDialogDefaultButton(this, this.jBSearch, this.jBCancel);
            this.jCBSearch.requestFocus();
            this.resetLangText();
            this.setResizable(true);
            this.pack();
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    private void resetLangText() {
        this.setTitle(this.splMM.getMessage("dialogsearch.title"));
        this.titledBorder1.setTitle(this.splMM.getMessage("dialogsearch.titleborder1"));
        this.titledBorder2.setTitle(this.splMM.getMessage("dialogsearch.titleborder2"));
        this.jLabel1.setText(this.splMM.getMessage("dialogsearch.searchcontent"));
        this.jLabel2.setText(this.splMM.getMessage("dialogsearch.replaceas"));
        this.jBSearch.setText(this.splMM.getMessage("button.search"));
        this.jBReplace.setText(this.splMM.getMessage("button.replace"));
        this.jBReplaceAll.setText(this.splMM.getMessage("button.replaceall"));
        this.jBCancel.setText(this.splMM.getMessage("button.close"));
        this.jCBSensitive.setText(this.splMM.getMessage("dialogsearch.casesensitive"));
        this.jCBWordOnly.setText(this.splMM.getMessage("dialogsearch.wordonly"));
        this.jCBQuote.setText(this.splMM.getMessage("dialogsearch.ignorequote"));
        this.jCBPars.setText(this.splMM.getMessage("dialogsearch.ignorepars"));
    }

    private void init() {
        String sTmp = status.get(KEY_CASE);
        if (StringUtils.isValidString(sTmp)) {
            this.jCBSensitive.setSelected(new Boolean(sTmp));
        }
        if (StringUtils.isValidString(sTmp = status.get(KEY_WORDONLY))) {
            this.jCBWordOnly.setSelected(new Boolean(sTmp));
        }
        if (StringUtils.isValidString(sTmp = status.get(KEY_QUOTE))) {
            this.jCBQuote.setSelected(new Boolean(sTmp));
        }
        if (StringUtils.isValidString(sTmp = status.get(KEY_RARS))) {
            this.jCBPars.setSelected(new Boolean(sTmp));
        }
    }

    private void rememberStatus() {
        status.put(KEY_CASE, new Boolean(this.jCBSensitive.isSelected()).toString());
        status.put(KEY_WORDONLY, new Boolean(this.jCBWordOnly.isSelected()).toString());
        status.put(KEY_QUOTE, new Boolean(this.jCBQuote.isSelected()).toString());
        status.put(KEY_RARS, new Boolean(this.jCBPars.isSelected()).toString());
    }

    private void resetDropItems() {
        String sTmp = (String)this.jCBSearch.getSelectedItem();
        this.jCBSearch.removeAllItems();
        searchKeys.unionSection(sTmp);
        int i = searchKeys.size() - 1;
        while (i >= 0) {
            this.jCBSearch.addItem(searchKeys.getSection(i));
            --i;
        }
        this.jCBSearch.setSelectedItem(sTmp);
        sTmp = (String)this.jCBReplace.getSelectedItem();
        this.jCBReplace.removeAllItems();
        replaceKeys.unionSection(sTmp);
        i = replaceKeys.size() - 1;
        while (i >= 0) {
            this.jCBReplace.addItem(replaceKeys.getSection(i));
            --i;
        }
        this.jCBReplace.setSelectedItem(sTmp);
    }

    public void setConfig(boolean replace) {
        this.isReplace = replace;
        this.resetDropItems();
        if (!replace) {
            this.setTitle(this.splMM.getMessage("dialogsearch.title"));
        } else {
            this.setTitle(this.splMM.getMessage("dialogsearch.replace"));
        }
        this.jCBReplace.setEnabled(replace);
        this.jBReplace.setEnabled(replace);
        this.jBReplaceAll.setEnabled(replace);
    }

    private void initUI() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "\u641c\u7d22\u683c\u5b50\u8303\u56f4");
        this.titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "\u641c\u7d22\u5c5e\u6027\u8303\u56f4");
        JPanel panel1 = new JPanel();
        BorderLayout borderLayout1 = new BorderLayout();
        JPanel jPanel1 = new JPanel();
        VFlowLayout vFlowLayout1 = new VFlowLayout();
        GridBagLayout gridBagLayout1 = new GridBagLayout();
        panel1.setLayout(gridBagLayout1);
        this.jLabel1.setText("\u67e5\u627e\u5185\u5bb9");
        this.jLabel2.setText("\u66ff\u6362\u4e3a");
        this.jBSearch.setText("\u67e5\u627e(F)");
        this.jBSearch.setMnemonic('F');
        this.jBSearch.addActionListener(new DialogSearch_jBSearch_actionAdapter(this));
        this.jBReplace.setText("\u66ff\u6362(R)");
        this.jBReplace.setMnemonic('R');
        this.jBReplace.addActionListener(new DialogSearch_jBReplace_actionAdapter(this));
        this.jBReplaceAll.setText("\u5168\u90e8\u66ff\u6362(A)");
        this.jBReplaceAll.setMnemonic('A');
        this.jBReplaceAll.addActionListener(new DialogSearch_jBReplaceAll_actionAdapter(this));
        this.jBCancel.setText("\u5173\u95ed(C)");
        this.jBCancel.setMnemonic('C');
        this.jBCancel.addActionListener(new DialogSearch_jBCancel_actionAdapter(this));
        this.jCBSensitive.setMaximumSize(new Dimension(95, 27));
        this.jCBSensitive.setText("\u533a\u5206\u5927\u5c0f\u5199");
        this.jCBWordOnly.setText("\u4ec5\u641c\u7d22\u72ec\u7acb\u5355\u8bcd");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(this.titledBorder2);
        this.jCBSearch.setEditable(true);
        this.jCBReplace.setEditable(true);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(borderLayout1);
        this.addWindowListener(new DialogSearch_this_windowAdapter(this));
        jPanel1.setLayout(vFlowLayout1);
        this.getContentPane().add((Component)panel1, "Center");
        panel1.add((Component)this.jLabel1, GM.getGBC(1, 1));
        panel1.add((Component)this.jCBSearch, GM.getGBC(1, 2, true));
        panel1.add((Component)this.jLabel2, GM.getGBC(2, 1));
        panel1.add((Component)this.jCBReplace, GM.getGBC(2, 2, true));
        JPanel tmp = new JPanel(new GridLayout(2, 2));
        tmp.add(this.jCBSensitive);
        tmp.add(this.jCBWordOnly);
        tmp.add(this.jCBQuote);
        tmp.add(this.jCBPars);
        GridBagConstraints gbc = GM.getGBC(3, 1);
        gbc.gridwidth = 2;
        panel1.add((Component)tmp, gbc);
        gbc = GM.getGBC(4, 1, true, true);
        gbc.gridwidth = 2;
        panel1.add((Component)new JLabel(), gbc);
        this.getContentPane().add((Component)jPanel1, "East");
        jPanel1.add((Component)this.jBSearch, null);
        jPanel1.add((Component)this.jBReplace, null);
        jPanel1.add((Component)this.jBReplaceAll, null);
        jPanel1.add((Component)this.jBCancel, null);
    }

    private void setSearchConfig(String searchString, String replaceString) {
        this.searchString = searchString;
        if (replaceString == null) {
            replaceString = "";
        }
        this.replaceString = replaceString;
        this.searchFlag = 0;
        if (!this.jCBQuote.isSelected()) {
            this.searchFlag += 16;
        }
        if (!this.jCBPars.isSelected()) {
            this.searchFlag += 2;
        }
        if (!this.jCBSensitive.isSelected()) {
            ++this.searchFlag;
        }
        if (this.jCBWordOnly.isSelected()) {
            this.searchFlag += 8;
        }
    }

    private boolean search() {
        return this.search(false);
    }

    private boolean replace() {
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        this.stringIndex = -1;
        boolean lb = this.replace(false, cmds);
        if (lb && GVSpl.splEditor != null) {
            GVSpl.splEditor.executeCmd(cmds);
            this.search();
        }
        return lb;
    }

    private int replaceAll() {
        int count = 0;
        SplEditor splEditor = GVSpl.splEditor;
        if (!(splEditor.selectedRects.isEmpty() || splEditor.getSelectedRect().getColCount() <= 1 && splEditor.getSelectedRect().getRowCount() <= 1)) {
            this.replaceAllStartRow = splEditor.getSelectedRect().getBeginRow();
            this.replaceAllStartCol = splEditor.getSelectedRect().getBeginCol();
            this.searchSelectedCells = true;
        } else {
            this.replaceAllStartRow = 1;
            this.replaceAllStartCol = 1;
        }
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        while (this.replace(true, cmds)) {
            ++count;
        }
        if (count > 0 && GVSpl.splEditor != null) {
            GVSpl.splEditor.executeCmd(cmds);
        }
        this.replaceAllStartRow = 1;
        this.replaceAllStartCol = 1;
        return count;
    }

    private boolean replace(boolean replaceAll, Vector<IAtomicCmd> cmds) {
        if (this.search(replaceAll) && GVSpl.splEditor != null) {
            SplControl splControl = GVSpl.splEditor.getComponent();
            NormalCell nc = (NormalCell)splControl.cellSet.getCell(this.searchedRow, this.searchedCol);
            AtomicCell ac = new AtomicCell(splControl, nc);
            byte propId = 1;
            ac.setProperty(propId);
            String exp = nc.getExpString();
            int flag = this.searchFlag;
            if (!replaceAll) {
                flag += 4;
            }
            exp = Sentence.replace(exp, this.stringIndex, this.searchString, this.replaceString, flag);
            ac.setValue(exp);
            cmds.add(ac);
            this.stringIndex = !replaceAll ? (this.stringIndex += this.replaceString.length() - 1) : nc.getExpString().length() - 1;
            return true;
        }
        return false;
    }

    private boolean search(boolean replaceAll) {
        if (GVSpl.splEditor == null) {
            return false;
        }
        SplEditor splEditor = GVSpl.splEditor;
        SplControl splControl = splEditor.getComponent();
        int startRow = 1;
        int endRow = splControl.cellSet.getRowCount();
        int startCol = 1;
        int endCol = splControl.cellSet.getColCount();
        this.searchSelectedCells = false;
        if (!(splEditor.selectedRects.isEmpty() || splEditor.getSelectedRect().getColCount() <= 1 && splEditor.getSelectedRect().getRowCount() <= 1)) {
            startRow = splEditor.getSelectedRect().getBeginRow();
            startCol = splEditor.getSelectedRect().getBeginCol();
            endRow = splEditor.getSelectedRect().getEndRow();
            endCol = splEditor.getSelectedRect().getEndCol();
            this.searchSelectedCells = true;
        }
        int activeRow = startRow;
        int activeCol = startCol;
        CellLocation cp = splControl.getActiveCell();
        if (cp != null) {
            activeRow = cp.getRow();
            activeCol = cp.getCol();
        }
        boolean found = false;
        if (!replaceAll) {
            found = this.search(activeRow, activeCol, activeRow, endCol, replaceAll);
            if (found) {
                return true;
            }
            found = this.search(activeRow + 1, startCol, endRow, endCol, replaceAll);
            if (found) {
                return true;
            }
            found = this.search(startRow, startCol, activeRow - 1, endCol, replaceAll);
            if (found) {
                return true;
            }
            found = this.search(activeRow, startCol, activeRow, activeCol - 1, replaceAll);
            if (found) {
                return true;
            }
        } else {
            found = this.search(this.replaceAllStartRow, this.replaceAllStartCol, this.replaceAllStartRow, endCol, replaceAll);
            if (found) {
                return true;
            }
            found = this.search(this.replaceAllStartRow + 1, startCol, endRow, endCol, replaceAll);
            if (found) {
                return true;
            }
        }
        return false;
    }

    private boolean search(int startRow, int startCol, int endRow, int endCol, boolean replaceAll) {
        boolean found = false;
        SplControl splControl = GVSpl.splEditor.getComponent();
        int row = startRow;
        while (row <= endRow) {
            int col = startCol;
            while (col <= endCol) {
                NormalCell nc = (NormalCell)splControl.cellSet.getCell(row, col);
                String exp = nc.getExpString();
                if (exp == null) {
                    this.stringIndex = -1;
                } else {
                    this.stringIndex = Sentence.indexOf(exp, this.stringIndex + 1, this.searchString, this.searchFlag);
                    if (this.stringIndex >= 0) {
                        found = true;
                    }
                    if (found) {
                        this.searchedRow = row;
                        this.searchedCol = col;
                        this.replaceAllStartRow = row;
                        this.replaceAllStartCol = col;
                        if (!replaceAll) {
                            splControl.setSearchedCell(row, col, this.searchSelectedCells);
                            this.requestFocus();
                        }
                        return true;
                    }
                }
                ++col;
            }
            ++row;
        }
        return false;
    }

    void jBSearch_actionPerformed(ActionEvent e) {
        this.resetDropItems();
        this.isSearchClicked = true;
        this.setSearchConfig((String)this.jCBSearch.getSelectedItem(), "");
        if (!this.search()) {
            GM.messageDialog(this, this.splMM.getMessage("dialogsearch.cantfindword", this.jCBSearch.getSelectedItem()));
        }
    }

    void jBReplace_actionPerformed(ActionEvent e) {
        if (this.isSearchClicked) {
            this.stringIndex = -1;
        }
        this.isSearchClicked = false;
        this.resetDropItems();
        String search = (String)this.jCBSearch.getSelectedItem();
        String replace = (String)this.jCBReplace.getSelectedItem();
        this.setSearchConfig(search, replace);
        if (!this.replace()) {
            GM.messageDialog(this, this.splMM.getMessage("dialogsearch.cantfindword", this.jCBSearch.getSelectedItem()));
        }
    }

    void jBReplaceAll_actionPerformed(ActionEvent e) {
        this.resetDropItems();
        String search = (String)this.jCBSearch.getSelectedItem();
        String replace = (String)this.jCBReplace.getSelectedItem();
        this.setSearchConfig(search, replace);
        int i = this.replaceAll();
        GM.messageDialog(this, this.splMM.getMessage("dialogsearch.totalreplace", String.valueOf(i)));
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        this.rememberStatus();
        GM.setWindowDimension(this);
        this.dispose();
    }

    void this_windowClosing(WindowEvent e) {
        this.rememberStatus();
        GM.setWindowDimension(this);
        this.dispose();
    }
}

