/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dialog;

import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.dialog.RQDialog;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.spl.control.SplEditorSE;
import com.scudata.ide.spl.resources.IdeSplSEMessage;
import com.scudata.util.Variant;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.sql.Date;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public abstract class DialogSerialNo
extends RQDialog {
    private static final long serialVersionUID = 1L;
    private static final int DIALOG_WIDTH = 500;
    private static final int DIALOG_HEIGHT = 150;
    protected boolean isEdit = false;
    protected boolean showPrompt = false;
    private JLabel label = new JLabel();
    private JTextField jTFSerialNo = new JTextField();
    private JLabel labelExpDate1 = new JLabel(IdeCommonMessage.get().getMessage("dialogabout.expdate"));
    private JLabel labelExpDate2 = new JLabel();
    private JLabel labelServiceDate1 = new JLabel(IdeCommonMessage.get().getMessage("dialogabout.servicedate"));
    private JLabel labelServiceDate2 = new JLabel();
    private JCheckBox jCBPrompt = new JCheckBox(IdeSplSEMessage.get().getMessage("dialogserialno.noprompt"));

    public DialogSerialNo(Frame parent, String serialNo, String message, Image image) {
        this(parent, serialNo, message, image, false);
    }

    public DialogSerialNo(Frame parent, String serialNo, String message, Image image, boolean isEdit) {
        this(parent, serialNo, message, image, isEdit, false);
    }

    public DialogSerialNo(Frame parent, String serialNo, String message, Image image, boolean isEdit, boolean showPrompt) {
        super(parent, IdeCommonMessage.get().getMessage("dialogserialno.title"), 500, 150);
        this.dialogInit(serialNo, message, image, isEdit, showPrompt);
    }

    public DialogSerialNo(Dialog parent, String serialNo, String message, Image image) {
        this(parent, serialNo, message, image, false);
    }

    public DialogSerialNo(Dialog parent, String serialNo, String message, Image image, boolean isEdit) {
        this(parent, serialNo, message, image, isEdit, false);
    }

    public DialogSerialNo(Dialog parent, String serialNo, String message, Image image, boolean isEdit, boolean showPrompt) {
        super(parent, IdeCommonMessage.get().getMessage("dialogserialno.title"), 500, 150);
        this.dialogInit(serialNo, message, image, isEdit, showPrompt);
    }

    public void setFreeModeVisible(boolean isVisible) {
        this.jBCancel.setEnabled(isVisible);
        this.jBCancel.setVisible(isVisible);
    }

    private void dialogInit(String serialNo, String message, Image image, boolean isEdit, boolean showPrompt) {
        try {
            this.showPrompt = showPrompt;
            if (image != null) {
                this.setIconImage(image);
            }
            this.init(serialNo, message, isEdit);
            this.setSize(this.getDialogWidth(), this.getDialogHeight());
            GM.centerWindow(this);
        }
        catch (Exception e) {
            GM.showException(this, e);
        }
    }

    private int getDialogWidth() {
        if (GM.isChineseLanguage()) {
            return 480;
        }
        return 530;
    }

    private int getDialogHeight() {
        if (this.showPrompt) {
            return 155;
        }
        return 135;
    }

    public abstract void updateSerialNo(String var1) throws Exception;

    public abstract String getDownloadUrl();

    public void setSkipButton() {
    }

    public String getSerialNo() {
        return this.jTFSerialNo.getText();
    }

    public boolean isSNPrompt() {
        return !this.jCBPrompt.isSelected();
    }

    @Override
    protected boolean okAction(ActionEvent e) {
        String serialNo = this.jTFSerialNo.getText();
        try {
            this.updateSerialNo(serialNo);
            this.label.setText(" ");
            JOptionPane.showMessageDialog(this, IdeCommonMessage.get().getMessage("dialogserialno.setsn"));
            if (this.isEdit) {
                this.loadSNMessage();
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            this.setMessage(ex.getMessage());
            if (this.isEdit) {
                this.labelExpDate1.setVisible(false);
                this.labelExpDate2.setVisible(false);
                this.labelServiceDate1.setVisible(false);
                this.labelServiceDate2.setVisible(false);
            }
            return false;
        }
    }

    private void setMessage(String message) {
        if (message != null && message.indexOf("\n") > -1) {
            message = message.replaceAll("\r\n", "<br>");
            message = message.replaceAll("\n", "<br>");
            message = "<html>" + message + "</html>";
        }
        this.label.setText(message);
    }

    private void init(String serialNo, String message, boolean isEdit) {
        this.isEdit = isEdit;
        this.jTFSerialNo.setText(serialNo);
        this.jBOK.setText(IdeSplSEMessage.get().getMessage("dialogserialno.buttonset"));
        this.jBOK.setMnemonic('S');
        this.jBCancel.setText(IdeSplSEMessage.get().getMessage("button.usefree"));
        this.jBCancel.setMnemonic('F');
        if (message == null) {
            message = " ";
        }
        this.label.setHorizontalAlignment(0);
        this.label.setForeground(Color.RED);
        this.setMessage(message);
        this.getContentPane().remove(this.panelSouth);
        this.panelCenter.setLayout(new GridBagLayout());
        this.panelCenter.add((Component)new JLabel(IdeCommonMessage.get().getMessage("dialogserialno.title")), GM.getGBC(0, 0, false, false, 10, 8));
        this.panelCenter.add((Component)this.jTFSerialNo, GM.getGBC(0, 1, true, false, 0));
        this.panelCenter.add((Component)this.jBOK, GM.getGBC(0, 2, false, false, 8));
        if (this.showPrompt) {
            this.panelCenter.add((Component)this.jCBPrompt, GM.getGBC(1, 0));
            this.panelCenter.add((Component)this.jBCancel, GM.getGBC(1, 2));
        }
        if (isEdit) {
            this.panelCenter.add((Component)this.labelExpDate1, GM.getGBC(2, 0, false, false, 13));
            this.panelCenter.add((Component)this.labelExpDate2, GM.getGBC(2, 1, true));
            this.panelCenter.add((Component)this.labelServiceDate1, GM.getGBC(3, 0, false, false, 13));
            this.panelCenter.add((Component)this.labelServiceDate2, GM.getGBC(3, 1, true));
            this.loadSNMessage();
        }
        GridBagConstraints gbc = GM.getGBC(5, 0, true, true, 0, 0);
        gbc.gridwidth = 3;
        this.label.setVerticalAlignment(1);
        this.panelCenter.add((Component)this.label, gbc);
        this.jCBPrompt.setSelected(ConfigOptions.bSNPrompt);
    }

    protected long getExpiration() {
        return SplEditorSE.getExpiration();
    }

    protected boolean isSale() {
        return SplEditorSE.isSale();
    }

    protected boolean isSubs() {
        return SplEditorSE.isSubs();
    }

    protected boolean isFree() {
        return SplEditorSE.isFree();
    }

    protected void loadSNMessage() {
        long expTime = this.getExpiration();
        String expDate = expTime > 0L ? (expTime == 0L ? "" : Variant.format(new Date(expTime), "yyyy-MM-dd")) : IdeCommonMessage.get().getMessage("dialogabout.expforever");
        if (this.isSale()) {
            this.labelExpDate2.setText(IdeCommonMessage.get().getMessage("dialogabout.expforever"));
            this.labelServiceDate2.setText(expDate);
        } else {
            this.labelExpDate2.setText(expDate);
            this.labelServiceDate2.setText(expDate);
        }
        boolean expVisible = !this.isFree();
        this.labelExpDate1.setVisible(expVisible);
        this.labelExpDate2.setVisible(expVisible);
        boolean serviceVisible = this.isSale() || this.isSubs();
        this.labelServiceDate1.setVisible(serviceVisible);
        this.labelServiceDate2.setVisible(serviceVisible);
    }
}

