/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dialog;

import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.swing.FreeLayout;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class DialogSplash
extends JWindow {
    private static final long serialVersionUID = 1L;
    protected ImagePanel panelImage;
    public static final int WINDOW_WIDTH = 600;
    public static final int WINDOW_HEIGHT = 370;

    public DialogSplash(String splashImage) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.getRootPane().setWindowDecorationStyle(0);
            this.getRootPane().setBorder(null);
            this.setSize(600, 370);
            this.initUI(splashImage);
            GM.centerWindow(this);
        }
        catch (Exception e) {
            GM.writeLog(e);
        }
    }

    private void initUI(String splashImage) throws Exception {
        ImageIcon ii = this.getImageIcon(splashImage);
        Image image = null;
        if (ii != null) {
            this.setSize(ii.getIconWidth(), ii.getIconHeight());
            image = ii.getImage();
        }
        this.panelImage = new ImagePanel(image);
        this.panelImage.setOpaque(false);
        this.panelImage.setLayout(new FreeLayout());
        this.getContentPane().add(this.panelImage);
    }

    public void closeWindow() {
        this.dispose();
    }

    private ImageIcon getImageIcon(String splashImage) {
        ImageIcon ii = null;
        if (StringUtils.isValidString(splashImage)) {
            String path = GM.getAbsolutePath(splashImage);
            File f = new File(path);
            ii = f.exists() ? new ImageIcon(path) : GM.getImageIcon(this, splashImage);
        }
        if (ii == null) {
            String imgPath = "/com/scudata/ide/common/resources/" + this.getDefaultImageName() + GM.getLanguageSuffix() + ".png";
            ii = GM.getImageIcon(this, imgPath);
        }
        return ii;
    }

    protected String getDefaultImageName() {
        return "esproc";
    }

    class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private Image image = null;

        public ImagePanel(Image image) {
            this.image = image;
        }

        @Override
        public void paint(Graphics g) {
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, null);
            }
            super.paint(g);
        }
    }
}

