/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dialog;

import com.scudata.common.MessageManager;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.swing.RSyntaxTextAreaEx;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.control.SplControl;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class DialogTextEditor
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    protected RSyntaxTextArea textEditor = new RSyntaxTextAreaEx();
    protected RTextScrollPane spEditor = new RTextScrollPane((RTextArea)this.textEditor);
    private MessageManager mm = IdeSplMessage.get();
    private JCheckBox jCBLineWrap = new JCheckBox(this.mm.getMessage("dialogtexteditor.linewrap"));
    private int option = -1;

    public DialogTextEditor(JFrame parent) {
        this(parent, true);
    }

    public DialogTextEditor(JDialog parent) {
        this(parent, true);
    }

    public DialogTextEditor(JFrame parent, boolean isEditable) {
        super(parent, "", true);
        this.rqInit(isEditable);
    }

    public DialogTextEditor(JDialog parent, boolean isEditable) {
        super(parent, "", true);
        this.rqInit(isEditable);
    }

    private void rqInit(boolean isEditable) {
        this.init();
        GM.setWindowToolSize(this);
        GM.setDialogDefaultButton(this, this.okButton, this.cancelButton);
        this.setResizable(true);
        this.jCBLineWrap.setSelected(ConfigOptions.bTextEditorLineWrap);
        this.textEditor.setLineWrap(this.jCBLineWrap.isSelected());
        if (!isEditable) {
            this.textEditor.setEditable(false);
            this.okButton.setVisible(false);
            this.setTitle(this.mm.getMessage("dialogtexteditor.title1"));
        } else {
            this.setTitle(this.mm.getMessage("dialogtexteditor.title"));
        }
    }

    public int getOption() {
        return this.option;
    }

    public void setText(String text) {
        this.textEditor.setText(text);
        this.textEditor.setTabSize(3);
    }

    public String getText() {
        return this.textEditor.getText();
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        this.okButton.addActionListener(this);
        this.okButton.setMnemonic('O');
        this.cancelButton.addActionListener(this);
        this.cancelButton.setMnemonic('C');
        this.okButton.setText(this.mm.getMessage("button.ok"));
        this.cancelButton.setText(this.mm.getMessage("button.cancel"));
        JPanel panelSouth = new JPanel(new GridBagLayout());
        panelSouth.add((Component)this.jCBLineWrap, GM.getGBC(0, 0));
        panelSouth.add((Component)new JLabel(""), GM.getGBC(0, 1, true));
        panelSouth.add((Component)this.okButton, GM.getGBC(0, 2, false, false, 0));
        panelSouth.add((Component)this.cancelButton, GM.getGBC(0, 3));
        this.getContentPane().add((Component)panelSouth, "South");
        JPanel panelCenter = new JPanel(new BorderLayout());
        panelCenter.add((Component)this.spEditor, "Center");
        this.getContentPane().add((Component)panelCenter, "Center");
        this.textEditor.setEditable(true);
        try {
            SplControl control;
            if (GVSpl.splEditor != null && (control = GVSpl.splEditor.getComponent()) != null) {
                Font font = GM.getScaleFont(control.scale);
                this.textEditor.setFont(new Font("Dialog", font.getStyle(), font.getSize()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogTextEditor.this.closeWindow();
            }
        });
        this.jCBLineWrap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogTextEditor.this.textEditor.setLineWrap(DialogTextEditor.this.jCBLineWrap.isSelected());
            }
        });
    }

    private void closeWindow() {
        ConfigOptions.bTextEditorLineWrap = this.jCBLineWrap.isSelected();
        GM.setWindowDimension(this);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object c = e.getSource();
        if (c == this.okButton) {
            this.option = 0;
            this.closeWindow();
        } else if (c == this.cancelButton) {
            this.closeWindow();
        }
    }
}

