/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dialog;

import com.scudata.app.common.AppUtil;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.ConfigUtilIde;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.common.swing.JTextAreaEditor;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.ide.spl.dialog.DialogUnitConfig_jBCancel_actionAdapter;
import com.scudata.ide.spl.dialog.DialogUnitConfig_jBOK_actionAdapter;
import com.scudata.ide.spl.dialog.DialogUnitConfig_this_windowAdapter;
import com.scudata.parallel.UnitConfig;
import com.scudata.parallel.UnitContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;

public class DialogUnitConfig
extends JDialog {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeCommonMessage.get();
    String YES = this.mm.getMessage("dialogunitconfig.yes");
    String NO = this.mm.getMessage("dialogunitconfig.no");
    private final byte TAB_UNIT = 0;
    private final byte TAB_CLIENT = 1;
    private JTabbedPane tabMain = new JTabbedPane();
    private JPanel panelUnit = new JPanel();
    private JPanel panelClient = new JPanel();
    private JPanel jPanelButton = new JPanel();
    private JButton jBOK = new JButton();
    private JButton jBCancel = new JButton();
    private JLabel labelTempTimeOut = new JLabel(this.mm.getMessage("dialogunitconfig.temptimeout"));
    private JSpinner jSTempTimeOut = new JSpinner(new SpinnerNumberModel(12, 0, Integer.MAX_VALUE, 1));
    private JLabel labelProxyTimeOut = new JLabel(this.mm.getMessage("dialogunitconfig.proxytimeout"));
    private JSpinner jSProxyTimeOut = new JSpinner(new SpinnerNumberModel(12, 0, Integer.MAX_VALUE, 1));
    private JLabel labelInterval = new JLabel(this.mm.getMessage("dialogunitconfig.checkinterval"));
    private JSpinner jSInterval = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
    private JLabel labelBacklog = new JLabel(this.mm.getMessage("dialogunitconfig.backlog"));
    private JSpinner jSBacklog = new JSpinner(new SpinnerNumberModel(10, 1, 50, 1));
    private JLabel labelHost = new JLabel(this.mm.getMessage("dialogunitconfig.hostlist"));
    private JButton bAddHost = new JButton();
    private JButton bDeleteHost = new JButton();
    JCheckBox cbAutoStart = new JCheckBox(this.mm.getMessage("dialogodbcconfig.autostart"));
    private final int COL_INDEX = 0;
    private final int COL_HOST = 1;
    private final int COL_PORT = 2;
    private final int COL_MAXTASKNUM = 3;
    private final int COL_ISLOCAL = 4;
    private final String TITLE_INDEX = this.mm.getMessage("dialogunitconfig.index");
    private final String TITLE_HOST = this.mm.getMessage("dialogunitconfig.tabunit");
    private final String TITLE_PORT = this.mm.getMessage("dialogunitconfig.port");
    private final String TITLE_MAXTASKNUM = this.mm.getMessage("dialogunitconfig.maxtasknum");
    private final String TITLE_ISLOCAL = this.mm.getMessage("dialogunitconfig.islocal");
    protected JTableEx tableHosts = new JTableEx(new String[]{this.TITLE_INDEX, this.TITLE_HOST, this.TITLE_PORT, this.TITLE_MAXTASKNUM, this.TITLE_ISLOCAL});
    private final int COL_START = 1;
    private final int COL_END = 2;
    private final String TITLE_START = this.mm.getMessage("dialogunitconfig.start");
    private final String TITLE_END = this.mm.getMessage("dialogunitconfig.end");
    private JTableEx tableClients = new JTableEx(new String[]{this.TITLE_INDEX, this.TITLE_START, this.TITLE_END});
    JCheckBox cbCheck = new JCheckBox(this.mm.getMessage("dialogunitconfig.check"));
    JLabel labelClientList = new JLabel(this.mm.getMessage("dialogunitconfig.clientlist"));
    private JButton bAddClient = new JButton();
    private JButton bDeleteClient = new JButton();
    JFrame parent;
    int option = 2;
    protected String fixedIP;
    protected int fixedPort;
    protected boolean isClusterEditing = false;
    protected UnitConfig unitConfig = null;

    public DialogUnitConfig(JFrame parent, String title) {
        super(parent, title, true);
        this.constructor(parent);
    }

    void constructor(JFrame parent) {
        this.parent = parent;
        try {
            this.rqInit();
            this.init();
            this.setSize(700, 600);
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
            this.resetLangText();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String dialogSelectDirectory(String oldPath) {
        String path = GM.dialogSelectDirectory(GV.appFrame, oldPath);
        return path;
    }

    public static File dialogSelectFile(String exts) {
        return GM.dialogSelectFile(GV.appFrame, exts);
    }

    public UnitConfig getUnitConfig() {
        return this.unitConfig;
    }

    public int getOption() {
        return this.option;
    }

    private void init() {
        try {
            int rc;
            UnitConfig uc = this.loadUnit();
            this.jSTempTimeOut.setValue(new Integer(uc.getTempTimeOutHour()));
            this.jSProxyTimeOut.setValue(new Integer(uc.getProxyTimeOutHour()));
            this.jSInterval.setValue(new Integer(uc.getInterval()));
            this.jSBacklog.setValue(new Integer(uc.getBacklog()));
            this.cbAutoStart.setSelected(uc.isAutoStart());
            List<UnitConfig.Host> hosts = uc.getHosts();
            if (hosts != null) {
                int i = 0;
                int size = hosts.size();
                while (i < size) {
                    UnitConfig.Host host = hosts.get(i);
                    int row = this.tableHosts.addRow();
                    this.tableHosts.data.setValueAt(host.getIp(), row, 1);
                    this.tableHosts.data.setValueAt(host.getPort(), row, 2);
                    this.tableHosts.data.setValueAt(host.getMaxTaskNum(), row, 3);
                    boolean isLocal = AppUtil.isLocalIP(host.getIp());
                    this.tableHosts.data.setValueAt(isLocal ? this.YES : this.NO, row, 4);
                    ++i;
                }
            }
            if ((rc = this.tableHosts.getRowCount()) > 0) {
                this.tableHosts.rowfocusChanged(--rc, rc);
            }
            this.cbCheck.setSelected(uc.isCheckClients());
            List<String> starts = uc.getEnabledClientsStart();
            List<String> ends = uc.getEnabledClientsEnd();
            if (starts != null) {
                int i = 0;
                int size = starts.size();
                while (i < size) {
                    String start = starts.get(i);
                    String end = ends.get(i);
                    int row = this.tableClients.addRow();
                    this.tableClients.data.setValueAt(start, row, 1);
                    this.tableClients.data.setValueAt(end, row, 2);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private UnitConfig loadUnit() throws Exception {
        if (this.isClusterEditing) {
            return this.unitConfig;
        }
        UnitConfig uc = new UnitConfig();
        try (InputStream is = null;){
            is = this.getUnitInputStream(UnitContext.UNIT_XML);
            if (is == null) {
                UnitConfig unitConfig = uc;
                return unitConfig;
            }
            uc.load(is, false);
            is.close();
            UnitConfig unitConfig = uc;
            return unitConfig;
        }
    }

    private InputStream getUnitInputStream(String relativePath) throws Exception {
        return UnitContext.getUnitInputStream(relativePath);
    }

    private boolean isUnitValid() {
        return this.tableHosts.verifyColumnData(1, this.TITLE_HOST, false, this);
    }

    private boolean save() throws Throwable {
        UnitConfig uc = new UnitConfig();
        uc.setTempTimeOutHour((Integer)this.jSTempTimeOut.getValue());
        uc.setProxyTimeOutHour((Integer)this.jSProxyTimeOut.getValue());
        uc.setInterval((Integer)this.jSInterval.getValue());
        uc.setBacklog((Integer)this.jSBacklog.getValue());
        uc.setAutoStart(this.cbAutoStart.isSelected());
        this.tableHosts.acceptText();
        ArrayList<UnitConfig.Host> hosts = new ArrayList<UnitConfig.Host>();
        int i = 0;
        int count = this.tableHosts.getRowCount();
        while (i < count) {
            String ip = (String)this.tableHosts.data.getValueAt(i, 1);
            int port = ((Number)this.tableHosts.data.getValueAt(i, 2)).intValue();
            UnitConfig.Host h = new UnitConfig.Host(ip, port);
            int max = ((Number)this.tableHosts.data.getValueAt(i, 3)).intValue();
            h.setMaxTaskNum(max);
            hosts.add(h);
            ++i;
        }
        uc.setHosts(hosts);
        uc.setCheckClients(this.cbCheck.isSelected());
        ArrayList<String> starts = new ArrayList<String>();
        ArrayList<String> ends = new ArrayList<String>();
        this.tableClients.acceptText();
        int i2 = 0;
        int count2 = this.tableClients.getRowCount();
        while (i2 < count2) {
            String start = (String)this.tableClients.data.getValueAt(i2, 1);
            starts.add(start);
            String end = (String)this.tableClients.data.getValueAt(i2, 2);
            ends.add(end);
            ++i2;
        }
        uc.setEnabledClientsStart(starts);
        uc.setEnabledClientsEnd(ends);
        if (this.isClusterEditing) {
            this.unitConfig = uc;
            return true;
        }
        try {
            String filePath = GM.getAbsolutePath(ConfigUtilIde.UNIT_CONFIG_FILE);
            File f = new File(filePath);
            if (f.exists() && !f.canWrite()) {
                String msg = IdeCommonMessage.get().getMessage("public.readonly", f.getName());
                throw new RQException(msg);
            }
            FileOutputStream fos = new FileOutputStream(f);
            uc.save(fos);
            fos.close();
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
        return true;
    }

    void resetLangText() {
        this.jBOK.setText(this.mm.getMessage("button.ok"));
        this.jBCancel.setText(this.mm.getMessage("button.cancel"));
        this.tabMain.setTitleAt(0, this.mm.getMessage("dialogunitconfig.tabunit"));
        this.tabMain.setTitleAt(1, this.mm.getMessage("dialogunitconfig.tabclient"));
    }

    private void rqInit() throws Exception {
        this.jPanelButton.setLayout(new VFlowLayout());
        this.jBOK.setActionCommand("");
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new DialogUnitConfig_jBOK_actionAdapter(this));
        this.jBOK.setMnemonic('O');
        this.jBCancel.setActionCommand("");
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addActionListener(new DialogUnitConfig_jBCancel_actionAdapter(this));
        this.jBCancel.setMnemonic('C');
        this.jPanelButton.add((Component)this.jBOK, null);
        this.jPanelButton.add((Component)this.jBCancel, null);
        ImageIcon iiAdd = GM.getImageIcon(this, "/com/scudata/ide/common/resources/b_add.gif");
        ImageIcon iiDel = GM.getImageIcon(this, "/com/scudata/ide/common/resources/b_delete.gif");
        this.bAddHost.setIcon(iiAdd);
        this.bDeleteHost.setIcon(iiDel);
        this.panelUnit.setLayout(new GridBagLayout());
        this.panelUnit.add((Component)this.labelTempTimeOut, GM.getGBC(1, 1));
        this.panelUnit.add((Component)this.jSTempTimeOut, GM.getGBC(1, 2, true));
        this.panelUnit.add((Component)this.labelProxyTimeOut, GM.getGBC(1, 3));
        this.panelUnit.add((Component)this.jSProxyTimeOut, GM.getGBC(1, 4, true));
        this.panelUnit.add((Component)this.labelInterval, GM.getGBC(2, 1));
        this.panelUnit.add((Component)this.jSInterval, GM.getGBC(2, 2, true));
        this.panelUnit.add((Component)this.labelBacklog, GM.getGBC(2, 3));
        this.panelUnit.add((Component)this.jSBacklog, GM.getGBC(2, 4, true));
        GridBagConstraints gbc = GM.getGBC(3, 1, true);
        gbc.gridwidth = 4;
        this.panelUnit.add((Component)this.cbAutoStart, gbc);
        JPanel panelHostList = new JPanel(new GridBagLayout());
        panelHostList.add((Component)this.labelHost, GM.getGBC(1, 1, true));
        panelHostList.add((Component)this.bAddHost, GM.getGBC(1, 2));
        panelHostList.add((Component)this.bDeleteHost, GM.getGBC(1, 3));
        gbc = GM.getGBC(4, 1, true);
        gbc.gridwidth = 4;
        this.panelUnit.add((Component)panelHostList, gbc);
        gbc = GM.getGBC(5, 1, true, true);
        gbc.gridwidth = 4;
        this.panelUnit.add((Component)new JScrollPane(this.tableHosts), gbc);
        this.tabMain.add((Component)this.panelUnit, "Unit");
        this.tabMain.add((Component)this.panelClient, "Client");
        this.addWindowListener(new DialogUnitConfig_this_windowAdapter(this));
        this.getContentPane().add((Component)this.tabMain, "Center");
        this.getContentPane().add((Component)this.jPanelButton, "East");
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.tableHosts.setIndexCol(0);
        this.tableHosts.setRowHeight(20);
        this.tableHosts.setColumnWidth(1, 230);
        this.tableHosts.setColumnSpinner(2);
        JTextAreaEditor editor2 = (JTextAreaEditor)this.tableHosts.getColumnEditor(2);
        editor2.setArrange(1, 65535, 1);
        this.tableHosts.setColumnSpinner(3);
        JTextAreaEditor editor = (JTextAreaEditor)this.tableHosts.getColumnEditor(3);
        editor.setArrange(1, 2048, 1);
        this.tableHosts.setColumnEditable(4, false);
        this.bAddHost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String defaultIP;
                DialogUnitConfig.this.tableHosts.acceptText();
                int r = DialogUnitConfig.this.tableHosts.getRowCount();
                String ip = defaultIP = UnitContext.getDefaultHost();
                int port = 8281;
                if (DialogUnitConfig.this.isClusterEditing) {
                    ip = DialogUnitConfig.this.fixedIP;
                    port = DialogUnitConfig.this.increasePort(port);
                } else if (r > 0) {
                    ip = (String)DialogUnitConfig.this.tableHosts.data.getValueAt(r - 1, 1);
                    ip = DialogUnitConfig.increaseIP(ip);
                }
                UnitConfig.Host h = new UnitConfig.Host(ip, port);
                int row = DialogUnitConfig.this.tableHosts.addRow();
                DialogUnitConfig.this.tableHosts.setValueAt(ip, row, 1);
                DialogUnitConfig.this.tableHosts.setValueAt(port, row, 2);
                DialogUnitConfig.this.tableHosts.setValueAt(h.getMaxTaskNum(), row, 3);
                boolean isLocal = AppUtil.isLocalIP(ip);
                DialogUnitConfig.this.tableHosts.setValueAt(isLocal ? DialogUnitConfig.this.YES : DialogUnitConfig.this.NO, row, 4);
            }
        });
        this.bDeleteHost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DialogUnitConfig.this.tableHosts.acceptText();
                DialogUnitConfig.this.tableHosts.deleteSelectedRows();
            }
        });
        this.tableClients.setIndexCol(0);
        this.tableClients.setRowHeight(20);
        this.bAddClient.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/b_add.gif"));
        this.bDeleteClient.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/b_delete.gif"));
        this.panelClient.setLayout(new GridBagLayout());
        this.panelClient.add((Component)this.cbCheck, GM.getGBC(1, 1, true));
        JPanel tmp = new JPanel(new GridBagLayout());
        tmp.add((Component)this.labelClientList, GM.getGBC(1, 1, true));
        tmp.add((Component)this.bAddClient, GM.getGBC(1, 2));
        tmp.add((Component)this.bDeleteClient, GM.getGBC(1, 3));
        this.panelClient.add((Component)tmp, GM.getGBC(2, 1, true));
        this.panelClient.add((Component)new JScrollPane(this.tableClients), GM.getGBC(3, 1, true, true));
        this.bAddClient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DialogUnitConfig.this.tableClients.acceptText();
                int r = DialogUnitConfig.this.tableClients.getRowCount();
                String tmp = "192.168.0.100";
                if (r > 0 && StringUtils.isValidString(tmp = (String)((DialogUnitConfig)DialogUnitConfig.this).tableClients.data.getValueAt(r - 1, 1))) {
                    tmp = DialogUnitConfig.increaseIP(tmp);
                }
                DialogUnitConfig.this.tableClients.addRow(new Object[]{0, tmp});
            }
        });
        this.bDeleteClient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DialogUnitConfig.this.tableClients.acceptText();
                DialogUnitConfig.this.tableClients.deleteSelectedRows();
            }
        });
        Dimension d = new Dimension(22, 22);
        this.initButton(this.bAddHost, d);
        this.initButton(this.bDeleteHost, d);
        this.initButton(this.bAddClient, d);
        this.initButton(this.bDeleteClient, d);
    }

    private int increasePort(int port) {
        int rows = this.tableHosts.getRowCount();
        int p = port;
        boolean find = false;
        block0: do {
            int r = 0;
            while (r < rows) {
                int tmp = (Integer)this.tableHosts.data.getValueAt(r, 2);
                if (p == tmp) {
                    find = true;
                    ++p;
                    continue block0;
                }
                if (r == rows - 1) {
                    find = false;
                }
                ++r;
            }
        } while (find);
        return p;
    }

    private static String increaseIP(String host) {
        if (host.indexOf(".") < 0) {
            return host;
        }
        String[] ipStr = host.split("\\.");
        int[] ipBuf = new int[4];
        int n = 0;
        while (n < 4) {
            ipBuf[n] = Integer.parseInt(ipStr[n]) & 0xFF;
            ++n;
        }
        if (ipBuf[3] == 255) {
            ipBuf[3] = 1;
            if (ipBuf[2] == 255) {
                ipBuf[2] = 0;
                if (ipBuf[1] == 255) {
                    ipBuf[1] = 0;
                    ipBuf[0] = ipBuf[0] + 1;
                } else {
                    ipBuf[1] = ipBuf[1] + 1;
                }
            } else {
                ipBuf[2] = ipBuf[2] + 1;
            }
        } else {
            ipBuf[3] = ipBuf[3] + 1;
        }
        return String.valueOf(ipBuf[0]) + "." + ipBuf[1] + "." + ipBuf[2] + "." + ipBuf[3];
    }

    private void initButton(JButton b, Dimension d) {
        b.setMaximumSize(d);
        b.setMinimumSize(d);
        b.setPreferredSize(d);
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jBOK_actionPerformed(ActionEvent e) {
        try {
            if (!this.isUnitValid()) {
                this.tabMain.setSelectedIndex(0);
                return;
            }
            if (!this.save()) {
                return;
            }
            this.option = 0;
            GM.setWindowDimension(this);
            this.dispose();
        }
        catch (Throwable t) {
            GM.showException(this, t);
        }
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jBSearchTarget_actionPerformed(ActionEvent e) {
        if (GM.getOperationSytem() == 0) {
            try {
                Runtime.getRuntime().exec("cmd /C start explorer.exe " + GM.getAbsolutePath("log"));
            }
            catch (Exception x) {
                GM.showException(this, x);
            }
        }
    }

    public static void main(String[] args) {
        String ip = "192.168.255.255";
        ip = DialogUnitConfig.increaseIP(ip);
        System.out.println(ip);
    }
}

