/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dialog;

import com.scudata.common.MessageManager;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.spl.base.JTableView;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DialogViewValue
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton jBUndo = new JButton();
    private JButton jBRedo = new JButton();
    private JButton jBCopy = new JButton();
    private JButton jBClose = new JButton();
    private JTableView tableValue = new JTableView(){
        private static final long serialVersionUID = 1L;

        @Override
        public void refreshValueButton() {
            DialogViewValue.this.jBUndo.setEnabled(DialogViewValue.this.tableValue.canUndo());
            DialogViewValue.this.jBRedo.setEnabled(DialogViewValue.this.tableValue.canRedo());
            DialogViewValue.this.jBCopy.setEnabled(!DialogViewValue.this.tableValue.valueIsNull());
        }
    };
    private MessageManager splMM = IdeSplMessage.get();

    public DialogViewValue() {
        super(GV.appFrame, IdeSplMessage.get().getMessage("dialogviewvalue.title"), true);
        this.init();
        this.setSize(400, 300);
        GM.setDialogDefaultButton(this, new JButton(), this.jBClose);
        this.setResizable(true);
    }

    public void setValue(Object value) {
        this.tableValue.setValue(value);
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelNorth = new JPanel(new GridBagLayout());
        panelNorth.add((Component)new JLabel(), this.getGBC(1, 1, true));
        this.jBUndo.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/m_pmtundo.gif"));
        this.jBUndo.setToolTipText(this.splMM.getMessage("panelvaluebar.undo"));
        this.initButton(this.jBUndo);
        panelNorth.add((Component)this.jBUndo, this.getGBC(1, 2));
        this.jBRedo.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/m_pmtredo.gif"));
        this.jBRedo.setToolTipText(this.splMM.getMessage("panelvaluebar.redo"));
        this.initButton(this.jBRedo);
        panelNorth.add((Component)this.jBRedo, this.getGBC(1, 3));
        this.jBCopy.setIcon(GM.getMenuImageIcon("copy"));
        this.jBCopy.setToolTipText(this.splMM.getMessage("panelvaluebar.copy"));
        this.initButton(this.jBCopy);
        panelNorth.add((Component)this.jBCopy, this.getGBC(1, 4));
        this.jBClose.setIcon(GM.getMenuImageIcon("quit"));
        this.jBClose.setToolTipText(this.splMM.getMessage("panelvaluebar.quit"));
        this.initButton(this.jBClose);
        this.jBClose.setEnabled(true);
        panelNorth.add((Component)this.jBClose, this.getGBC(1, 5));
        this.getContentPane().add((Component)panelNorth, "North");
        this.getContentPane().add((Component)new JScrollPane(this.tableValue), "Center");
    }

    private void initButton(AbstractButton button) {
        Dimension bSize = new Dimension(25, 25);
        button.setMinimumSize(bSize);
        button.setMaximumSize(bSize);
        button.setPreferredSize(bSize);
        button.addActionListener(this);
        button.setEnabled(false);
    }

    private GridBagConstraints getGBC(int r, int c) {
        return this.getGBC(r, c, false);
    }

    private GridBagConstraints getGBC(int r, int c, boolean b) {
        GridBagConstraints gbc = GM.getGBC(r, c, b);
        gbc.insets = new Insets(3, 3, 3, 3);
        return gbc;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (this.jBUndo.equals(src)) {
            this.tableValue.undo();
        } else if (this.jBRedo.equals(src)) {
            this.tableValue.redo();
        } else if (this.jBCopy.equals(src)) {
            this.tableValue.copyValue();
        } else if (this.jBClose.equals(src)) {
            GM.setWindowDimension(this);
            this.dispose();
        }
    }
}

