/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.etl;

import com.scudata.ide.spl.etl.ElementLib;
import com.scudata.ide.spl.etl.ObjectElement;

public class ElementInfo {
    private String name;
    private String title;
    private Class elementClass;
    transient ObjectElement instance = null;

    public ElementInfo(String name) {
        this.name = name;
        ElementInfo ei = ElementLib.getElementInfo(name);
        this.title = ei.getTitle();
        this.elementClass = ei.getElementClass();
    }

    public ElementInfo(String name, String title, Class elementClass) {
        this.name = name;
        this.title = title;
        this.elementClass = elementClass;
    }

    public byte getParentType() {
        return this.getInstance().getParentType();
    }

    public String getFuncName() {
        return this.getInstance().getFuncName();
    }

    public ObjectElement getInstance() {
        if (this.instance == null) {
            this.instance = this.newInstance();
        }
        return this.instance;
    }

    public ObjectElement newInstance() {
        try {
            ObjectElement oe = (ObjectElement)this.elementClass.newInstance();
            oe.setElementName(this.name);
            return oe;
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public Class getElementClass() {
        return this.elementClass;
    }
}

