/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.etl;

import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.ide.spl.etl.FieldDefine;
import com.scudata.ide.spl.etl.FuncMessage;
import com.scudata.ide.spl.etl.IFieldDefineDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FieldDimDialog
extends JDialog
implements IFieldDefineDialog {
    private static final long serialVersionUID = 1L;
    private static MessageManager mm = FuncMessage.get();
    JPanel jPanel2 = new JPanel();
    VFlowLayout vFlowLayout1 = new VFlowLayout();
    JButton jBOK = new JButton();
    JButton jBCancel = new JButton();
    JScrollPane jScrollPane1 = new JScrollPane();
    private final byte COL_INDEX = 0;
    private final byte COL_FIELD = 1;
    private final byte COL_DIM = (byte)2;
    JTableEx exportFields = new JTableEx(mm.getMessage("FieldDimDialog.exportfields"));
    JPanel jPanel1 = new JPanel();
    JButton jBAdd = new JButton();
    JButton jBDel = new JButton();
    JButton jBShiftUp = new JButton();
    JButton jBShiftDown = new JButton();
    private int m_option = 2;

    public FieldDimDialog(Dialog owner) {
        super(owner);
        try {
            this.init();
            this.rqInit();
            this.setSize(450, 300);
            this.resetText();
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    private void resetText() {
        this.setTitle(mm.getMessage("FieldDimDialog.title"));
        MessageManager icm = IdeCommonMessage.get();
        this.jBOK.setText(icm.getMessage("button.ok"));
        this.jBCancel.setText(icm.getMessage("button.cancel"));
        this.jBAdd.setText(icm.getMessage("button.add"));
        this.jBDel.setText(icm.getMessage("button.delete"));
        this.jBShiftUp.setText(icm.getMessage("button.shiftup"));
        this.jBShiftDown.setText(icm.getMessage("button.shiftdown"));
    }

    @Override
    public int getOption() {
        return this.m_option;
    }

    @Override
    public void setFieldDefines(ArrayList<FieldDefine> fields) {
        if (fields == null) {
            return;
        }
        int i = 0;
        while (i < fields.size()) {
            int row = this.exportFields.addRow();
            FieldDefine fd = fields.get(i);
            this.exportFields.data.setValueAt(fd.getOne(), row, 1);
            this.exportFields.data.setValueAt(Boolean.valueOf(fd.getTwo()), row, 2);
            ++i;
        }
    }

    @Override
    public ArrayList<FieldDefine> getFieldDefines() {
        this.exportFields.acceptText();
        int rows = this.exportFields.getRowCount();
        if (rows == 0) {
            return null;
        }
        ArrayList<FieldDefine> fields = new ArrayList<FieldDefine>();
        int i = 0;
        while (i < rows) {
            String name = (String)this.exportFields.data.getValueAt(i, 1);
            if (StringUtils.isValidString(name)) {
                FieldDefine fd = new FieldDefine();
                fd.setOne(name);
                Object val = this.exportFields.data.getValueAt(i, 2);
                if (val != null) {
                    fd.setTwo(((Boolean)val).toString());
                }
                fields.add(fd);
            }
            ++i;
        }
        return fields;
    }

    private void rqInit() {
        this.exportFields.setIndexCol(0);
        this.exportFields.setRowHeight(20);
        this.exportFields.setColumnCheckBox(2);
    }

    private void init() throws Exception {
        this.setModal(true);
        this.jPanel2.setLayout(this.vFlowLayout1);
        this.jBOK.setMnemonic('O');
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldDimDialog.this.exportFields.acceptText();
                FieldDimDialog.this.m_option = 0;
                FieldDimDialog.this.dispose();
            }
        });
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldDimDialog.this.dispose();
            }
        });
        this.jBAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldDimDialog.this.exportFields.addRow();
            }
        });
        this.jBDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldDimDialog.this.exportFields.deleteSelectedRows();
            }
        });
        this.jBShiftUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldDimDialog.this.exportFields.shiftUp();
            }
        });
        this.jBShiftDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldDimDialog.this.exportFields.shiftDown();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FieldDimDialog.this.dispose();
            }
        });
        this.jScrollPane1.getViewport().add(this.exportFields);
        this.jBAdd.setMnemonic('A');
        this.jBAdd.setText("\u589e\u52a0(A)");
        this.jBDel.setMnemonic('D');
        this.jBDel.setText("\u5220\u9664(D)");
        this.jBShiftUp.setMnemonic('U');
        this.jBShiftUp.setText("\u4e0a\u79fb(U)");
        this.jBShiftDown.setMnemonic('N');
        this.jBShiftDown.setText("\u4e0b\u79fb(N)");
        this.jPanel2.add((Component)this.jBOK, null);
        this.jPanel2.add((Component)this.jBCancel, null);
        this.jPanel2.add((Component)this.jPanel1, null);
        this.jPanel2.add((Component)this.jBAdd, null);
        this.jPanel2.add((Component)this.jBDel, null);
        this.jPanel2.add((Component)this.jBShiftUp, null);
        this.jPanel2.add((Component)this.jBShiftDown, null);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPanel2, "East");
    }
}

