/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.etl;

import com.scudata.common.Escape;
import com.scudata.common.StringUtils;
import com.scudata.dm.Sequence;
import com.scudata.util.Variant;

public class FuncParam {
    protected String name;
    protected Object value;

    public FuncParam() {
    }

    public FuncParam(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setEditString(String editString) {
        String tmp = editString;
        boolean removeEscape = !tmp.startsWith("[");
        this.value = Variant.parse(tmp, removeEscape);
        if (this.value instanceof String && Variant.isEquals(tmp, this.value)) {
            this.value = "=" + this.value;
        }
    }

    private String stringValueToEdit(String val) {
        if (val.startsWith("=")) {
            return val.substring(1);
        }
        return Escape.addEscAndQuote(val);
    }

    private String seriesValueToEdit(Sequence seq) {
        StringBuffer sb = new StringBuffer("[");
        int size = seq.length();
        int i = 1;
        while (i <= size) {
            Object o;
            if (i > 1) {
                sb.append(",");
            }
            if ((o = seq.get(i)) instanceof Sequence) {
                sb.append(this.seriesValueToEdit((Sequence)o));
            } else if (o instanceof String) {
                sb.append(this.stringValueToEdit((String)o));
            } else {
                sb.append(Variant.toString(o));
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public String toEditString(Object defValue) {
        if (this.value == null) {
            return null;
        }
        if (StringUtils.isSpaceString(this.value.toString())) {
            return null;
        }
        if (Variant.isEquals(this.value, defValue)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        if (this.value instanceof String) {
            String tmp = (String)this.value;
            sb.append(this.stringValueToEdit(tmp));
        } else if (this.value instanceof Sequence) {
            sb.append(this.seriesValueToEdit((Sequence)this.value));
        } else {
            sb.append(Variant.toString(this.value));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.value != null) {
            sb.append(this.value);
        }
        return sb.toString();
    }
}

