/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.etl;

import com.scudata.chart.Para;
import com.scudata.common.Escape;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.dm.Sequence;
import com.scudata.ide.common.GC;
import com.scudata.ide.spl.etl.ElementInfo;
import com.scudata.ide.spl.etl.ElementLib;
import com.scudata.ide.spl.etl.FieldDefine;
import com.scudata.ide.spl.etl.FuncMessage;
import com.scudata.ide.spl.etl.FuncParam;
import com.scudata.ide.spl.etl.IFuncObject;
import com.scudata.ide.spl.etl.ParamInfo;
import com.scudata.ide.spl.etl.ParamInfoList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public abstract class ObjectElement
implements IFuncObject {
    public MessageManager mm = FuncMessage.get();
    public static String SNULL = "_NULL_";
    String elementName;
    String cellName = null;

    @Override
    public abstract byte getReturnType();

    public abstract String getFuncName();

    public abstract String getFuncBody();

    public abstract String optionString();

    public void checkEmpty() {
    }

    public abstract ParamInfoList getParamInfoList();

    public abstract boolean setFuncBody(String var1);

    public void setOptions(String options) {
        if (options == null) {
            return;
        }
        String group = FuncMessage.get().getMessage("options");
        ArrayList<ParamInfo> ofs = this.getParamInfoList().getParams(group);
        if (ofs == null) {
            return;
        }
        for (ParamInfo pi : ofs) {
            String fieldName = pi.getName();
            try {
                Field fieldOption = this.getClass().getField(fieldName);
                if (fieldName.equals("zero")) {
                    fieldName = "0";
                } else if (fieldName.equals("one")) {
                    fieldName = "1";
                }
                Boolean value = options.indexOf(fieldName) > -1;
                fieldOption.set(this, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String toExpressionString() {
        StringBuffer sb = new StringBuffer();
        if (this.getReturnType() == 0) {
            sb.append(">");
        } else {
            sb.append("=");
        }
        if (StringUtils.isValidString(this.cellName)) {
            sb.append(this.cellName);
            sb.append(".");
        }
        sb.append(this.getFuncName());
        sb.append(this.getOptions());
        sb.append("(");
        String body = this.getFuncBody();
        if (StringUtils.isValidString(body)) {
            sb.append(body);
        }
        sb.append(")");
        return sb.toString();
    }

    public void setElementName(String eleName) {
        this.elementName = eleName;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getFuncDesc() {
        return this.mm.getMessage(String.valueOf(this.elementName) + ".desc");
    }

    public String getHelpUrl() {
        String url = this.mm.getMessage(String.valueOf(this.elementName) + ".url");
        if (url.startsWith(this.elementName)) {
            String prefix = "http://doc.raqsoft.com.cn/esproc/func/";
            if (GC.LANGUAGE == 4) {
                prefix = "http://doc.raqsoft.com/esproc/func/";
            }
            return String.valueOf(prefix) + this.elementName.toLowerCase() + ".html";
        }
        return url;
    }

    public void setCellName(String cellName) {
        this.cellName = cellName;
    }

    public String getCellName() {
        return this.cellName;
    }

    public void setParamInfoList(ArrayList<ParamInfo> paramInfos) {
        Sequence params = new Sequence();
        for (ParamInfo pi : paramInfos) {
            params.add(pi);
        }
        this.setParams(this.getClass(), this, params);
    }

    private void setParams(Class elementClass, ObjectElement elementObject, Sequence funcParams) {
        int size = funcParams.length();
        int i = 1;
        while (i <= size) {
            FuncParam fp = (FuncParam)funcParams.get(i);
            Para p = new Para(fp.getValue());
            Field f = null;
            try {
                f = elementClass.getField(fp.getName());
                String className = f.getType().getName().toLowerCase();
                if (className.endsWith("boolean")) {
                    f.set(elementObject, new Boolean(p.booleanValue()));
                } else if (className.endsWith("byte")) {
                    f.set(elementObject, new Byte((byte)p.intValue()));
                } else if (className.endsWith("int") || className.endsWith("integer")) {
                    f.set(elementObject, new Integer(p.intValue()));
                } else if (className.endsWith("float")) {
                    f.set(elementObject, new Float(p.floatValue()));
                } else if (className.endsWith("double")) {
                    f.set(elementObject, new Double(p.doubleValue()));
                } else if (className.endsWith(".color")) {
                    f.set(elementObject, p.colorValue(0));
                } else if (className.endsWith("string")) {
                    f.set(elementObject, p.stringValue());
                } else if (className.endsWith("sequence")) {
                    f.set(elementObject, p.sequenceValue());
                } else if (className.endsWith("date")) {
                    f.set(elementObject, p.dateValue());
                } else if (className.endsWith("chartcolor")) {
                    f.set(elementObject, p.chartColorValue());
                } else {
                    f.set(elementObject, p.getValue());
                }
            }
            catch (NoSuchFieldException className) {
            }
            catch (RQException rqe) {
                throw rqe;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++i;
        }
    }

    public static String getStringListExp(ArrayList<String> args, String seperator) {
        if (args == null || args.isEmpty()) {
            return "";
        }
        StringBuffer options = new StringBuffer();
        int i = 0;
        while (i < args.size()) {
            if (i > 0) {
                options.append(seperator);
            }
            options.append(args.get(i));
            ++i;
        }
        return options.toString();
    }

    public static ArrayList<String> getStringList(String args, String seperator) {
        if (!ObjectElement.isValidString(args)) {
            return null;
        }
        ArrayList<String> sl = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(args, seperator);
        while (st.hasMoreTokens()) {
            sl.add(st.nextToken());
        }
        return sl;
    }

    public String getOptions() {
        String options = this.optionString();
        if (StringUtils.isValidString(options)) {
            return "@" + options.toString();
        }
        return "";
    }

    public static String getParamExp(String paramValue) {
        if (paramValue == null) {
            return "";
        }
        if (paramValue.startsWith("=")) {
            return paramValue.substring(1);
        }
        return Escape.addEscAndQuote(paramValue);
    }

    public static String getParam(String paramValue) {
        if (!ObjectElement.isValidString(paramValue)) {
            return "";
        }
        if (paramValue.startsWith("\"")) {
            return Escape.removeEscAndQuote(paramValue);
        }
        return "=" + paramValue;
    }

    public static String getExpressionExp(String paramValue) {
        if (!ObjectElement.isValidString(paramValue)) {
            return "";
        }
        if (paramValue.startsWith("=")) {
            return paramValue.substring(1);
        }
        return paramValue;
    }

    public static String getExpression(String paramValue) {
        if (!ObjectElement.isValidString(paramValue)) {
            return "";
        }
        String exp = paramValue;
        int idx = 0;
        int len = exp.length();
        int tmp = Sentence.scanIdentifier(exp, idx);
        if (tmp < len - 1) {
            return "=" + paramValue;
        }
        return paramValue;
    }

    public static String getNumberExp(String paramValue) {
        if (!ObjectElement.isValidString(paramValue)) {
            return "";
        }
        if (paramValue.startsWith("=")) {
            return paramValue.substring(1);
        }
        return paramValue;
    }

    public static String getNumber(String paramValue) {
        if (!ObjectElement.isValidString(paramValue)) {
            return "";
        }
        try {
            Double d = Double.valueOf(paramValue);
            return paramValue;
        }
        catch (Exception x) {
            return "=" + paramValue;
        }
    }

    public static String getFieldDefineExp(ArrayList<FieldDefine> fields) {
        if (fields == null || fields.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (fields != null) {
            for (FieldDefine fd : fields) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(fd.getOne());
                if (StringUtils.isValidString(fd.getTwo())) {
                    sb.append(":");
                    sb.append(fd.getTwo());
                }
                if (!StringUtils.isValidString(fd.getThree())) continue;
                sb.append(":");
                sb.append(fd.getThree());
            }
        }
        return sb.toString();
    }

    public static ArrayList<FieldDefine> getFieldDefine(String fields) {
        if (!ObjectElement.isValidString(fields)) {
            return null;
        }
        ArrayList<FieldDefine> fds = new ArrayList<FieldDefine>();
        StringTokenizer st = new StringTokenizer(fields, ",");
        while (st.hasMoreTokens()) {
            String section = st.nextToken();
            StringTokenizer token = new StringTokenizer(section, ":");
            FieldDefine fd = new FieldDefine();
            fd.setOne(token.nextToken());
            if (token.hasMoreTokens()) {
                fd.setTwo(token.nextToken());
            }
            if (token.hasMoreTokens()) {
                fd.setThree(token.nextToken());
            }
            fds.add(fd);
        }
        return fds;
    }

    public static String getFieldDefineExp2(ArrayList<FieldDefine> fields) {
        if (fields == null || fields.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (fields != null) {
            for (FieldDefine fd : fields) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(fd.getOne());
                sb.append(":");
                if (StringUtils.isValidString(fd.getTwo())) {
                    sb.append(fd.getTwo());
                    continue;
                }
                sb.append(fd.getOne());
            }
        }
        return sb.toString();
    }

    public static ArrayList<FieldDefine> getFieldDefine2(String fields) {
        if (!StringUtils.isValidString(fields)) {
            return null;
        }
        ArrayList<FieldDefine> fds = new ArrayList<FieldDefine>();
        StringTokenizer st = new StringTokenizer(fields, ",");
        while (st.hasMoreTokens()) {
            String tmp = st.nextToken();
            StringTokenizer tmpST = new StringTokenizer(tmp, ":");
            String one = tmpST.nextToken();
            String two = tmpST.nextToken();
            FieldDefine fd = new FieldDefine();
            fd.setOne(one);
            if (!one.equals(two)) {
                fd.setTwo(two);
            }
            fds.add(fd);
        }
        return fds;
    }

    public static boolean isExpression(String paramValue) {
        if (paramValue == null) {
            return false;
        }
        return paramValue.startsWith("=");
    }

    private static String verifyParam(String param) {
        if (param.startsWith(";")) {
            param = String.valueOf(SNULL) + param;
        }
        param = Sentence.replace(param, ";;", ";" + SNULL + ";", 0);
        param = Sentence.replace(param, ";;", ";" + SNULL + ";", 0);
        param = Sentence.replace(param, ";,", ";" + SNULL + ",", 0);
        param = Sentence.replace(param, ";:", ";" + SNULL + ":", 0);
        param = Sentence.replace(param, ",:", "," + SNULL + ":", 0);
        return param;
    }

    public static boolean isValidString(String str) {
        if (!StringUtils.isValidString(str)) {
            return false;
        }
        return !str.equals(SNULL);
    }

    public static ObjectElement parseString(String exp, HashMap<String, ObjectElement> oes) {
        int indexOption;
        if (!ObjectElement.isValidString(exp)) {
            return null;
        }
        if (!(exp = exp.trim()).startsWith("=") && !exp.startsWith(">")) {
            return null;
        }
        int index = exp.indexOf("(");
        if (index < 0) {
            return null;
        }
        int iTmp = Sentence.scanParenthesis(exp, index);
        if (iTmp < 0) {
            return null;
        }
        if (iTmp < exp.length() - 1) {
            return null;
        }
        String celName = null;
        String funName = null;
        String options = null;
        String funBody = null;
        String tmp = exp.substring(1, index);
        int dot1 = tmp.indexOf(".");
        if (dot1 > 0) {
            celName = tmp.substring(0, dot1);
            tmp = tmp.substring(dot1 + 1);
        }
        if ((indexOption = tmp.indexOf("@")) > 0) {
            funName = tmp.substring(0, indexOption);
            tmp = tmp.substring(indexOption + 1);
        } else {
            funName = tmp;
            tmp = null;
        }
        options = tmp;
        funBody = exp.substring(index + 1, exp.length() - 1);
        ArrayList<ElementInfo> funObjs = ElementLib.getElementInfos(funName);
        if (funObjs.isEmpty()) {
            return null;
        }
        ElementInfo ei = null;
        if (funObjs.size() == 1) {
            ei = funObjs.get(0);
        } else {
            ObjectElement tmpOE;
            ObjectElement parent = oes.get(celName);
            byte parentType = parent == null ? (byte)0 : parent.getReturnType();
            int c = 0;
            ArrayList<ElementInfo> tmpFunObjs = new ArrayList<ElementInfo>();
            for (ElementInfo tmpEI : funObjs) {
                tmpOE = tmpEI.newInstance();
                if (tmpOE.getParentType() != parentType) continue;
                ei = tmpEI;
                ++c;
                tmpFunObjs.add(ei);
                if (!StringUtils.isValidString(funBody)) break;
            }
            if (c > 1) {
                for (ElementInfo tmpEI : tmpFunObjs) {
                    String tmps;
                    tmpOE = tmpEI.newInstance();
                    if (!tmpOE.setFuncBody(tmps = ObjectElement.verifyParam(funBody))) continue;
                    ei = tmpEI;
                    break;
                }
            }
        }
        if (ei == null) {
            return null;
        }
        ObjectElement oe = ei.newInstance();
        oe.setCellName(celName);
        oe.setOptions(options);
        if (StringUtils.isValidString(funBody)) {
            funBody = ObjectElement.verifyParam(funBody);
            oe.setFuncBody(funBody);
        }
        return oe;
    }
}

