/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.etl;

import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.spl.etl.FieldDefine;
import com.scudata.ide.spl.etl.FuncMessage;
import com.scudata.ide.spl.etl.FuncParam;
import com.scudata.ide.spl.etl.ObjectElement;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class ParamInfo
extends FuncParam {
    private String title;
    private int inputType;
    private Object defValue;
    private static transient Class currentClass;
    private static transient Object currentObj;
    private static transient Object defaultObj;
    private MessageManager mm = FuncMessage.get();
    private boolean needCheckEmpty = false;

    public static void setCurrent(Class objClass, Object obj) {
        currentClass = objClass;
        currentObj = obj;
        try {
            defaultObj = objClass.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ParamInfo(String name, boolean needCheck) {
        this(name, 1, needCheck);
    }

    public ParamInfo(String name) {
        this(name, 1);
    }

    public ParamInfo(String name, int inputType) {
        this(name, inputType, false);
    }

    public ParamInfo(String name, int inputType, boolean needCheck) {
        this.name = name;
        this.needCheckEmpty = needCheck;
        try {
            Field f = currentClass.getDeclaredField(name);
            Object paraValue = f.get(currentObj);
            this.value = paraValue instanceof Color ? new Integer(((Color)paraValue).getRGB()) : paraValue;
            String className = currentClass.getName();
            int last = className.lastIndexOf(46);
            String prefix = className.substring(last + 1);
            this.title = this.mm.getMessage(String.valueOf(prefix) + "." + name);
            this.inputType = inputType;
            this.defValue = f.get(defaultObj);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public Object getDefValue() {
        return this.defValue;
    }

    public void setFuncParam(FuncParam fp) {
        Object tmp;
        this.value = tmp = fp.getValue();
    }

    public String getTitle() {
        return this.title;
    }

    public int getInputType() {
        return this.inputType;
    }

    public void check() {
        if (this.needCheckEmpty) {
            String sValue = null;
            if (this.value instanceof ArrayList) {
                ArrayList al = (ArrayList)this.value;
                if (al.size() > 0) {
                    Object element = al.get(0);
                    if (element instanceof FieldDefine) {
                        ArrayList tmp = (ArrayList)this.value;
                        sValue = ObjectElement.getFieldDefineExp2(tmp);
                    } else if (element instanceof String) {
                        ArrayList tmp = (ArrayList)this.value;
                        sValue = ObjectElement.getStringListExp(tmp, ",");
                    }
                }
            } else if (this.value instanceof String) {
                sValue = (String)this.value;
            }
            if (!StringUtils.isValidString(sValue)) {
                throw new RuntimeException(this.mm.getMessage("EmptyWarning", this.title));
            }
        }
    }
}

