/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.http;

import com.scudata.common.Logger;
import com.scudata.ide.spl.ExcelServer;
import com.scudata.ide.spl.http.HttpHandlerExcel;
import com.scudata.resources.ParallelMessage;
import com.scudata.server.http.LinksPool;
import com.sun.net.httpserver.HttpServer;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class HttpServerExcel {
    private HttpServer httpServer;
    private String host = "127.0.0.1";
    private int maxLinks = 50;
    public static HttpServerExcel instance = null;

    public boolean start() throws Throwable {
        if (this.httpServer != null) {
            return false;
        }
        Logger.info(ParallelMessage.get().getMessage("SplxServerInIDE.starting"));
        InetAddress ia = InetAddress.getByName(this.host);
        int port = ExcelServer.getConfigPort("httpPort");
        try {
            InetSocketAddress inetSock = new InetSocketAddress(ia, port);
            this.httpServer = HttpServer.create(inetSock, this.maxLinks);
            LinksPool.setMaxLinks(this.maxLinks);
        }
        catch (BindException ex) {
            throw new Exception(ParallelMessage.get().getMessage("SplxServerInIDE.portbind", port), ex);
        }
        HttpHandlerExcel dhh = new HttpHandlerExcel();
        this.httpServer.createContext("/", dhh);
        this.httpServer.setExecutor(null);
        this.httpServer.start();
        Logger.info(ParallelMessage.get().getMessage("SplxServerInIDE.started", "http://" + this.host + ":" + port));
        return true;
    }

    public boolean stop() {
        if (this.httpServer == null) {
            return false;
        }
        this.httpServer.stop(1);
        this.httpServer = null;
        Logger.info(ParallelMessage.get().getMessage("SplxServerInIDE.stop"));
        return true;
    }

    public static HttpServerExcel getInstance() throws Exception {
        if (instance == null) {
            instance = new HttpServerExcel();
        }
        return instance;
    }

    public static void startHttpServer() {
        try {
            HttpServerExcel thServer = HttpServerExcel.getInstance();
            thServer.start();
        }
        catch (Throwable e) {
            Logger.error(e);
        }
    }

    public static void stopHttpServer() {
        try {
            if (instance != null) {
                instance.stop();
            }
        }
        catch (Throwable e) {
            Logger.error(e);
        }
    }
}

