/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.update;

import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.ServiceUtil;
import com.scudata.ide.common.dialog.DialogCheckUpdate;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.GMSplSE;
import com.scudata.ide.spl.ICheckHandler;
import com.scudata.ide.spl.control.SplEditorSE;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class UpdateManager {
    public static boolean checkUpdate(boolean isStarting, String productId, String productName) throws Exception {
        return UpdateManager.checkUpdate(GV.appFrame, isStarting, productId, productName);
    }

    public static boolean checkUpdate(Component parent, boolean isStarting, String productId, String productName) throws Exception {
        return UpdateManager.checkUpdate(parent, isStarting, productId, productName, null);
    }

    public static boolean checkUpdate(Component parent, boolean isStarting, String productId, String productName, ICheckHandler handler) throws Exception {
        String serverVersion;
        File serverFile = UpdateManager.getUpdateFile();
        if (serverFile == null) {
            GM.showException(parent, IdeCommonMessage.get().getMessage("updatemanager.noupdatefile"), true, GMSpl.getLogoImage(true), null);
            return false;
        }
        HashMap<String, String> map = UpdateManager.readProperties(new FileInputStream(serverFile));
        String localVersion = map.get("version");
        try {
            serverVersion = ServiceUtil.getVersion(productId);
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            if (e != null && !(e instanceof RQException) && (e instanceof UnknownHostException || ServiceUtil.containsURL(errorMessage))) {
                errorMessage = IdeCommonMessage.get().getMessage("updatemanager.networkerror");
            }
            GM.showException(parent, errorMessage, true, GMSpl.getLogoImage(true), IdeCommonMessage.get().getMessage("updatemanager.premessage"));
            return false;
        }
        if (serverVersion != null && localVersion != null && serverVersion.compareTo(localVersion) > 0) {
            String downloadUrl = GMSplSE.getDownloadUrl();
            return UpdateManager.dialogUpdate(parent, isStarting, downloadUrl, productName, handler);
        }
        if (!isStarting) {
            JOptionPane.showMessageDialog(parent, IdeCommonMessage.get().getMessage("update.islatest"));
        }
        return true;
    }

    public static boolean checkUpdateNoUI(String productId) throws Exception {
        String serverVersion;
        String localVersion;
        block5: {
            File serverFile = UpdateManager.getUpdateFile();
            if (serverFile == null) {
                return false;
            }
            HashMap<String, String> map = UpdateManager.readProperties(new FileInputStream(serverFile));
            localVersion = map.get("version");
            serverVersion = null;
            try {
                serverVersion = ServiceUtil.getVersion(productId);
            }
            catch (Exception e) {
                if (e == null) break block5;
                String errorMessage = e.getMessage();
                if (e instanceof UnknownHostException || ServiceUtil.containsURL(errorMessage)) {
                    errorMessage = IdeCommonMessage.get().getMessage("updatemanager.networkerror");
                }
                errorMessage = String.valueOf(IdeCommonMessage.get().getMessage("updatemanager.premessage")) + errorMessage;
                throw new RQException(errorMessage);
            }
        }
        if (serverVersion == null) {
            throw new RQException(String.valueOf(IdeCommonMessage.get().getMessage("updatemanager.premessage")) + IdeCommonMessage.get().getMessage("updatemanager.serverversionnull"));
        }
        return localVersion == null || serverVersion.compareTo(localVersion) <= 0;
    }

    public static boolean canUpdate() {
        File serverFile = UpdateManager.getUpdateFile();
        return serverFile != null;
    }

    private static File getUpdateFile() {
        String installPath = System.getProperty("start.home");
        if (!StringUtils.isValidString(installPath)) {
            return null;
        }
        File updateDir = new File(installPath, "update");
        if (!updateDir.exists()) {
            return null;
        }
        File serverFile = new File(updateDir, "server.txt");
        if (!serverFile.exists()) {
            return null;
        }
        return serverFile;
    }

    public static HashMap<String, String> readProperties(InputStream is) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = br.readLine()) != null) {
                int pos;
                if (line.trim().length() == 0 || (pos = line.indexOf("=")) < 0) continue;
                String key = line.substring(0, pos).trim();
                String value = line.substring(pos + 1).trim();
                map.put(key, value);
            }
        }
        finally {
            try {
                is.close();
                br.close();
            }
            catch (Exception exception) {}
        }
        return map;
    }

    private static boolean dialogUpdate(Component parent, boolean isStarting, String downloadUrl, String productName, ICheckHandler handler) {
        DialogCheckUpdate dcu;
        boolean forceUpdate = isStarting && SplEditorSE.forceUpdate();
        ImageIcon ii = GM.getLogoImage(true);
        boolean isDialog = false;
        if (parent instanceof Dialog) {
            isDialog = true;
            dcu = new DialogCheckUpdate((Dialog)parent, forceUpdate, productName, ii == null ? null : ii.getImage());
        } else {
            dcu = new DialogCheckUpdate((Frame)parent, forceUpdate, productName, ii == null ? null : ii.getImage());
        }
        if (parent == null && ii != null) {
            dcu.setIconImage(ii.getImage());
        }
        dcu.setCheckHandler(handler);
        if (!isDialog && GM.isMacOS()) {
            dcu.setAlwaysOnTop(true);
        }
        dcu.setVisible(true);
        int option = dcu.getOption();
        if (option == DialogCheckUpdate.SET_OPTION) {
            return true;
        }
        if (option == 0) {
            try {
                GM.browse(downloadUrl);
            }
            catch (Throwable t) {
                GM.showException(parent, t);
            }
        }
        return false;
    }

    public static String getDownloadUrl() throws Exception {
        File serverFile = UpdateManager.getUpdateFile();
        if (serverFile == null) {
            return null;
        }
        HashMap<String, String> map = UpdateManager.readProperties(new FileInputStream(serverFile));
        String downloadUrl = map.get("downloadUrl");
        return downloadUrl;
    }
}

