/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.vdb.commonvdb;

import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.IDialogDimensionListener;
import com.scudata.ide.common.dialog.DialogInputText;
import com.scudata.ide.vdb.VDB;
import com.scudata.ide.vdb.config.ConfigOptions;
import com.scudata.ide.vdb.control.FileChooserUICN;
import com.scudata.ide.vdb.control.ImageFileView;
import com.scudata.ide.vdb.resources.IdeMessage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ComponentUI;

public class GM {
    private static final String STRING_DIMENSION = ".dimension";
    private static final String CLASS_NAME_SEP = "$";
    private static IDialogDimensionListener ddListener = null;

    public static ImageIcon getImageIcon(String filePath) {
        return GM.getImageIcon(filePath, true);
    }

    public static ImageIcon getImageIcon(String filePath, boolean showException) {
        InputStream is = null;
        try {
            filePath = Sentence.replace(filePath, "\\", "/", 0);
            if (!filePath.startsWith("/")) {
                filePath = "/" + filePath;
            }
            if ((is = GM.class.getResourceAsStream(filePath)) == null) {
                is = GM.class.getResourceAsStream(filePath.toLowerCase());
            }
            if (is == null) {
                throw new Exception("Failed to get image file: " + filePath);
            }
            byte[] bt = GM.inputStream2Bytes(is);
            is.close();
            ImageIcon imageIcon = new ImageIcon(bt);
            return imageIcon;
        }
        catch (Exception e) {
            if (showException) {
                GM.showException(e);
            } else {
                GM.writeLog(e);
            }
            return null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static ImageIcon getMenuImageIcon(String menuText) {
        int dot = menuText.indexOf(".");
        String iconText = dot > 0 ? menuText.substring(dot + 1) : menuText;
        String iconPath = "/com/scudata/ide/vdb/img/m_" + iconText.toLowerCase() + ".gif";
        return GM.getImageIcon(iconPath);
    }

    public static byte[] inputStream2Bytes(InputStream is) throws Exception {
        int len;
        if (is == null) {
            return new byte[0];
        }
        byte[] bytes = new byte[10240];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((len = is.read(bytes)) != -1) {
            baos.write(bytes, 0, len);
        }
        return baos.toByteArray();
    }

    public static void showException(Object oMsg) {
        GM.showException(oMsg, true);
    }

    public static void showException(Object oMsg, boolean canCopyMsg) {
        Throwable e = null;
        String msg = oMsg instanceof Throwable ? (!StringUtils.isValidString((e = (Throwable)oMsg).getMessage()) ? e.toString() : e.getMessage()) : oMsg.toString();
        if (canCopyMsg) {
            DialogInputText dit = new DialogInputText(false);
            dit.setTitle(IdeMessage.get().getMessage("gm.exinfo"));
            dit.setText(msg);
            dit.setVisible(true);
            if (e != null) {
                e.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(VDB.getInstance(), msg, IdeMessage.get().getMessage("gm.exinfo"), 1);
        }
        GM.writeLog(e);
    }

    public static void writeLog(Throwable e) {
        if (ConfigOptions.bLogException.booleanValue() && StringUtils.isValidString(ConfigOptions.sLogFileName)) {
            File f = new File(ConfigOptions.sLogFileName);
            if (!f.exists()) {
                try {
                    f.createNewFile();
                }
                catch (Exception xf) {
                    return;
                }
            }
            try {
                FileOutputStream fos = new FileOutputStream(f, true);
                PrintWriter pw = new PrintWriter(fos);
                pw.println(new Date());
                e.printStackTrace(pw);
                fos.flush();
                pw.close();
            }
            catch (Exception logError) {
                return;
            }
        }
    }

    public static String getAbsolutePath(String path) {
        String home = System.getProperty("start.home");
        return GM.getAbsolutePath(path, home);
    }

    public static String getAbsolutePath(String path, String home) {
        File f = new File(path);
        if (f.exists()) {
            return path;
        }
        f = new File(home, path);
        return f.getAbsolutePath();
    }

    public static void initDialog(Window dlg, JButton okButton, JButton cancelButton) {
        GM.setDialogDefaultButton(dlg, okButton, cancelButton);
        GM.centerWindow(dlg);
    }

    public static void setDialogDefaultButton(Window dlg, JButton okButton, final JButton cancelButton) {
        JRootPane pane = null;
        if (dlg instanceof JDialog) {
            pane = ((JDialog)dlg).getRootPane();
            ((JDialog)dlg).setResizable(false);
        } else if (dlg instanceof JFrame) {
            pane = ((JFrame)dlg).getRootPane();
        }
        pane.setDefaultButton(okButton);
        okButton.requestFocus();
        AbstractAction cancelAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                cancelButton.doClick();
            }
        };
        String o = new String("esc");
        pane.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), o);
        pane.getActionMap().put(o, cancelAction);
        dlg.setSize(dlg.getWidth() + 10, dlg.getHeight() + 10);
    }

    public static void centerWindow(Component w) {
        if (!GM.loadWindowDimension(w)) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension winSize = w.getSize();
            if (winSize.height > screenSize.height) {
                winSize.height = screenSize.height;
            }
            if (winSize.width > screenSize.width) {
                winSize.width = screenSize.width;
            }
            w.setLocation((screenSize.width - winSize.width) / 2, (screenSize.height - winSize.height) / 2);
        }
    }

    public static IDialogDimensionListener getDDListener() {
        if (ddListener != null) {
            return ddListener;
        }
        ddListener = new IDialogDimensionListener(){

            @Override
            public void saveWindowDimension(Component dlg) {
                try {
                    String className;
                    Dimension d = dlg.getSize();
                    String width = String.valueOf(d.getWidth());
                    String height = String.valueOf(d.getHeight());
                    int index = width.indexOf(".");
                    if (index > 0) {
                        width = width.substring(0, index);
                    }
                    if ((index = height.indexOf(".")) > 0) {
                        height = height.substring(0, index);
                    }
                    if ((index = (className = dlg.getClass().getName()).indexOf(GM.CLASS_NAME_SEP)) > -1) {
                        className = className.substring(0, index);
                    }
                    ConfigOptions.dimensions.put(String.valueOf(className) + GM.STRING_DIMENSION, String.valueOf(width) + "," + height + "," + String.valueOf(dlg.getX()) + "," + String.valueOf(dlg.getY()));
                    ConfigOptions.save();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public boolean loadWindowDimension(Component dlg) {
                String className = dlg.getClass().getName();
                int index = className.indexOf(GM.CLASS_NAME_SEP);
                if (index > -1) {
                    className = className.substring(0, index);
                }
                try {
                    String key;
                    String dimension;
                    if (ConfigOptions.bWindowSize.booleanValue() && StringUtils.isValidString(dimension = ConfigOptions.dimensions.get(key = String.valueOf(className) + GM.STRING_DIMENSION))) {
                        String[] size = dimension.split(",");
                        dlg.setSize(Integer.parseInt(size[0]), Integer.parseInt(size[1]));
                        dlg.setLocation(Integer.parseInt(size[2]), Integer.parseInt(size[3]));
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return false;
            }
        };
        return ddListener;
    }

    public static boolean loadWindowDimension(Component jc) {
        return GM.getDDListener().loadWindowDimension(jc);
    }

    public static void saveWindowDimension(Component dlg) {
        GM.getDDListener().saveWindowDimension(dlg);
    }

    public static GridBagConstraints getGBC(int row, int col, boolean hFill, boolean vFill, int hGap) {
        return GM.getGBC(row, col, hFill, vFill, hGap, 3);
    }

    public static GridBagConstraints getGBC(int row, int col, boolean hFill, boolean vFill, int hGap, int vGap) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = col;
        gbc.gridy = row;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(vGap, hGap, vGap, hGap);
        gbc.fill = 2;
        if (hFill) {
            gbc.weightx = 1.0;
        }
        if (vFill) {
            gbc.fill = 1;
            gbc.weighty = 1.0;
        }
        return gbc;
    }

    public static GridBagConstraints getGBC(int row, int col, boolean hFill, boolean vFill) {
        return GM.getGBC(row, col, hFill, vFill, 8);
    }

    public static GridBagConstraints getGBC(int row, int col, boolean hFill) {
        return GM.getGBC(row, col, hFill, false);
    }

    public static GridBagConstraints getGBC(int row, int col) {
        return GM.getGBC(row, col, false);
    }

    public static int getAbsolutePos(Component c, boolean isGetX) {
        if (c == null) {
            return 0;
        }
        return isGetX ? c.getX() : c.getY() + GM.getAbsolutePos(c.getParent(), isGetX);
    }

    public static File dialogSelectFile(String fileExts) {
        return GM.dialogSelectFile(fileExts, ConfigOptions.sLastDirectory, "", "");
    }

    public static File dialogSelectFile(String fileExts, String currentDirectory, String title, String oldFileName) {
        return (File)GM.dialogSelectFiles(fileExts, currentDirectory, title, new File(oldFileName), false);
    }

    public static File[] dialogSelectFiles(String fileExts) {
        return GM.dialogSelectFiles(fileExts, ConfigOptions.sLastDirectory, "", null);
    }

    public static File[] dialogSelectFiles(String fileExts, String currentDirectory, String title, File[] oldFiles) {
        return (File[])GM.dialogSelectFiles(fileExts, currentDirectory, title, oldFiles, true);
    }

    private static Object dialogSelectFiles(String fileExts, String currentDirectory, String title, Object oldFiles, boolean multiSelect) {
        return GM.dialogSelectFiles(fileExts, currentDirectory, title, oldFiles, multiSelect, null, VDB.getInstance());
    }

    public static Object dialogSelectFiles(String fileExts, String currentDirectory, String buttonText, Object oldFiles, boolean multiSelect, String dialogTitle, Component parent) {
        int r;
        if (currentDirectory == null) {
            currentDirectory = ConfigOptions.sLastDirectory;
        }
        fileExts = fileExts.toLowerCase();
        JFileChooser chooser = new JFileChooser(currentDirectory){
            private static final long serialVersionUID = 1L;

            @Override
            protected void setUI(ComponentUI newUI) {
                super.setUI(new FileChooserUICN(this));
            }
        };
        chooser.setFileView(new ImageFileView());
        chooser.setMultiSelectionEnabled(multiSelect);
        String[] exts = fileExts.split(",");
        int i = exts.length - 1;
        while (i >= 0) {
            chooser.setFileFilter(GM.getFileFilter("." + exts[i], "*." + exts[i]));
            --i;
        }
        if (multiSelect) {
            if (oldFiles != null) {
                chooser.setSelectedFiles((File[])oldFiles);
            }
        } else {
            chooser.setSelectedFile((File)oldFiles);
        }
        if (StringUtils.isValidString(dialogTitle)) {
            chooser.setDialogTitle(dialogTitle);
        }
        if ((r = StringUtils.isValidString(buttonText) ? chooser.showDialog(parent, buttonText) : chooser.showOpenDialog(parent)) == 0) {
            ConfigOptions.sLastDirectory = chooser.getSelectedFile().getParent();
            if (multiSelect) {
                return chooser.getSelectedFiles();
            }
            String fileExt = chooser.getFileFilter().getDescription();
            int dot = fileExt.indexOf(".");
            fileExt = dot < 0 ? "" : fileExt.substring(dot);
            String path = chooser.getSelectedFile().getAbsolutePath();
            boolean fileHasExt = path.toLowerCase().endsWith(fileExt);
            if (!fileHasExt && fileExt.startsWith(".")) {
                File fWithExt = new File(String.valueOf(path) + fileExt);
                return fWithExt;
            }
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static FileFilter getFileFilter(final String extName, final String desc) {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                String s = f.getName().toLowerCase();
                return f.isDirectory() || s.endsWith(extName);
            }

            @Override
            public String getDescription() {
                return desc;
            }
        };
    }

    public static String dialogSelectDirectory(String currentDirectory) {
        JFileChooser chooser = new JFileChooser(currentDirectory);
        FileFilter dirFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "";
            }
        };
        chooser.setFileFilter(dirFilter);
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(VDB.getInstance()) == 0) {
            ConfigOptions.sLastDirectory = chooser.getSelectedFile().getAbsolutePath();
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public static boolean canSaveAsFile(String otherFile) {
        int r;
        if (!StringUtils.isValidString(otherFile)) {
            JOptionPane.showMessageDialog(VDB.getInstance(), IdeMessage.get().getMessage("file.inputfilename"));
            return false;
        }
        File saveFile = new File(otherFile);
        return !saveFile.exists() || (r = JOptionPane.showConfirmDialog(VDB.getInstance(), IdeMessage.get().getMessage("file.coverexistfile", otherFile), IdeMessage.get().getMessage("public.prompt"), 2)) != 2;
    }

    public static String getFileExts() {
        String fileExts = "vdb";
        return fileExts;
    }
}

