/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.vdb.config;

import com.scudata.ide.vdb.config.ConfigOptions;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ConfigOptionsWriter {
    private TransformerHandler handler = null;
    private int level = 0;
    private final String tab = "    ";
    private final String separator = System.getProperties().getProperty("os.name").toUpperCase().indexOf("WINDOWS") != -1 ? "\n" : "/n";

    public ConfigOptionsWriter() {
        try {
            SAXTransformerFactory fac = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            this.handler = fac.newTransformerHandler();
            Transformer transformer = this.handler.getTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "no");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startElement(String objectElement, AttributesImpl attrs) throws SAXException {
        if (attrs == null) {
            attrs = new AttributesImpl();
        }
        this.appendTab();
        if (objectElement != null) {
            this.handler.startElement("", "", objectElement, attrs);
        }
    }

    private void endElement(String objectElement) throws SAXException {
        this.appendTab();
        if (objectElement != null) {
            this.handler.endElement("", "", objectElement);
        }
    }

    private void endEmptyElement(String objectElement) throws SAXException {
        this.handler.endElement("", "", objectElement);
    }

    private void writeAttribute(String key, String value) throws SAXException {
        if (value == null) {
            value = "";
        }
        this.appendTab();
        this.handler.startElement("", "", key, new AttributesImpl());
        this.handler.characters(value.toCharArray(), 0, value.length());
        this.handler.endElement("", "", key);
    }

    private void appendTab() throws SAXException {
        StringBuffer sb = new StringBuffer(this.separator);
        int i = 0;
        while (i < this.level) {
            sb.append("    ");
            ++i;
        }
        String indent = sb.toString();
        this.handler.characters(indent.toCharArray(), 0, indent.length());
    }

    public void write(String filePath) throws Exception {
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            File f = new File(filePath);
            if (!f.exists()) {
                File p = f.getParentFile();
                p.mkdirs();
            }
            fos = new FileOutputStream(filePath);
            bos = new BufferedOutputStream(fos);
            this.write(bos);
            ((BufferedOutputStream)bos).flush();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }

    public void write(OutputStream out) throws Exception {
        StreamResult resultxml = new StreamResult(out);
        this.handler.setResult(resultxml);
        this.level = 0;
        this.handler.startDocument();
        this.handler.startElement("", "", "Config", this.getAttributesImpl(new String[]{"Version", "1"}));
        this.level = 1;
        this.startElement("Options", null);
        Map<String, Object> options = ConfigOptions.options;
        for (String key : options.keySet()) {
            this.level = 2;
            this.startElement("Option", this.getAttributesImpl(new String[]{"Name", key, "Value", this.object2String(options.get(key))}));
            this.endEmptyElement("Option");
        }
        this.level = 1;
        this.endElement("Options");
        this.startElement("Dimensions", null);
        Map<String, String> dimensions = ConfigOptions.dimensions;
        for (String key : dimensions.keySet()) {
            this.level = 2;
            this.startElement("Dimension", this.getAttributesImpl(new String[]{"Name", key, "Value", dimensions.get(key)}));
            this.endEmptyElement("Dimension");
        }
        this.level = 1;
        this.endElement("Dimensions");
        this.startElement("Connections", null);
        Map<String, String> connections = ConfigOptions.connections;
        for (String key : connections.keySet()) {
            this.level = 2;
            this.startElement("Connection", this.getAttributesImpl(new String[]{"Name", key, "Value", connections.get(key)}));
            this.endEmptyElement("Connection");
        }
        this.level = 1;
        this.endElement("Connections");
        this.level = 0;
        this.handler.endElement("", "", "Config");
        this.handler.endDocument();
    }

    private String object2String(Object val) {
        if (val == null) {
            return "";
        }
        return val.toString();
    }

    private AttributesImpl getAttributesImpl(String[] attrs) {
        AttributesImpl attrImpl = new AttributesImpl();
        int size = attrs.length;
        int i = 0;
        while (i < size) {
            if (attrs[i + 1] != null) {
                attrImpl.addAttribute("", "", attrs[i], String.class.getName(), String.valueOf(attrs[i + 1]));
            }
            i += 2;
        }
        return attrImpl;
    }
}

