/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.vdb.control;

import com.scudata.dm.Sequence;
import com.scudata.ide.common.GM;
import com.scudata.ide.vdb.control.ConnectionConfig;
import com.scudata.vdb.IVS;
import com.scudata.vdb.VDB;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

public class VDBTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    public static final byte TYPE_HOME = 0;
    public static final byte TYPE_CONNECTION = 1;
    public static final byte TYPE_VDB = 2;
    public static final byte TYPE_FOLDER = 3;
    public static final byte TYPE_SEQUENCE = 4;
    public static final byte TYPE_STRING = 5;
    public static final byte TYPE_IMAGE = 6;
    public static final byte TYPE_OTHER = 100;
    private boolean isLoaded = false;
    private byte type = (byte)100;
    private String title = null;
    private String filter = null;
    private ArrayList<VDBTreeNode> childBuffer = null;
    private boolean isMatched = false;
    private boolean isExpanded = false;

    public VDBTreeNode(IVS ivs) {
        this.setUserObject(ivs);
        Object data = this.getData();
        this.type = ivs instanceof VDB ? (byte)2 : (data == null ? (byte)3 : (data instanceof Sequence ? (byte)4 : (data instanceof String ? (byte)5 : (data instanceof byte[] ? (byte)6 : (byte)100))));
        this.title = this.getNodeTitle();
    }

    public VDB getVDB() {
        if (this.type <= 1) {
            return null;
        }
        VDBTreeNode pNode = this;
        while (pNode.getType() != 2) {
            pNode = (VDBTreeNode)pNode.getParent();
        }
        return (VDB)pNode.getUserObject();
    }

    public Object getData() {
        IVS ivs = (IVS)this.getUserObject();
        Object data = ivs.load(null);
        return data;
    }

    public boolean saveData(Object data) {
        IVS ivs = (IVS)this.getUserObject();
        ivs.save(data);
        return true;
    }

    private String getNodeTitle() {
        IVS ivs = (IVS)this.getUserObject();
        String name = (String)ivs.path("f");
        Object value = ivs.path(null);
        StringBuffer sb = new StringBuffer();
        if (value != null) {
            sb.append(value);
        }
        if (name != null) {
            sb.append(" [ ");
            sb.append(name);
            sb.append(" ]");
        } else if (sb.length() == 0) {
            sb.append("ROOT");
        } else {
            sb.append(" [ ]");
        }
        return sb.toString();
    }

    public VDBTreeNode(Object obj, byte type) {
        if (obj instanceof ConnectionConfig) {
            ConnectionConfig cc = (ConnectionConfig)obj;
            this.title = cc.getName();
        } else {
            this.title = obj.toString();
        }
        this.type = type;
        this.setUserObject(obj);
    }

    public void setFilter(String filter) {
        this.filter = filter.toLowerCase();
        this.filter();
    }

    private void filter() {
        if (this.childBuffer == null) {
            this.childBuffer = new ArrayList();
            int i = 0;
            while (i < this.getChildCount()) {
                this.childBuffer.add((VDBTreeNode)this.getChildAt(i));
                ++i;
            }
        }
        this.removeAllChildren();
        int c = 0;
        while (c < this.childBuffer.size()) {
            VDBTreeNode childNode = this.childBuffer.get(c);
            String lowerTitle = childNode.getTitle().toLowerCase();
            if (lowerTitle.indexOf(this.filter) >= 0) {
                this.add(childNode);
            }
            ++c;
        }
    }

    public String getFilter() {
        return this.filter;
    }

    public VDBTreeNode deepClone() {
        VDBTreeNode newNode = new VDBTreeNode((Object)this.title, this.type);
        newNode.setUserObject(this.getUserObject());
        newNode.setMatched(this.isMatched);
        return newNode;
    }

    public void setMatched(boolean isMatched) {
        this.isMatched = isMatched;
    }

    public boolean isMatched() {
        return this.isMatched;
    }

    public ImageIcon getDispIcon() {
        String imgPath = "/com/scudata/ide/vdb/img/";
        switch (this.type) {
            case 0: {
                imgPath = String.valueOf(imgPath) + "home.png";
                break;
            }
            case 1: {
                ConnectionConfig cc = (ConnectionConfig)this.getUserObject();
                if (cc.isConnected()) {
                    imgPath = String.valueOf(imgPath) + "connection_on.png";
                    break;
                }
                imgPath = String.valueOf(imgPath) + "connection_off.png";
                break;
            }
            case 2: {
                imgPath = String.valueOf(imgPath) + "vdb.png";
                break;
            }
            case 3: {
                imgPath = String.valueOf(imgPath) + "folder.png";
                break;
            }
            case 4: {
                imgPath = String.valueOf(imgPath) + "sequence.png";
                break;
            }
            case 5: {
                imgPath = String.valueOf(imgPath) + "string.png";
                break;
            }
            case 6: {
                imgPath = String.valueOf(imgPath) + "image.png";
                break;
            }
            case 100: {
                imgPath = String.valueOf(imgPath) + "other.png";
            }
        }
        ImageIcon img = GM.getImageIcon(imgPath);
        return img;
    }

    public void setLoaded(boolean isLoaded) {
        this.isLoaded = isLoaded;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public String getName() {
        return this.toString();
    }

    public String getFullPath() {
        String path = this.getName();
        VDBTreeNode pNode = (VDBTreeNode)this.getParent();
        while (pNode != null) {
            path = String.valueOf(pNode.getName()) + File.separator + path;
            pNode = (VDBTreeNode)pNode.getParent();
        }
        return path;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String toString() {
        return this.title;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }
}

