/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.vdb.dialog;

import com.scudata.common.StringUtils;
import com.scudata.ide.common.swing.JComboBoxEx;
import com.scudata.ide.vdb.commonvdb.GM;
import com.scudata.ide.vdb.commonvdb.LNFManager;
import com.scudata.ide.vdb.config.ConfigOptions;
import com.scudata.ide.vdb.dialog.RQDialog;
import com.scudata.ide.vdb.resources.IdeMessage;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DialogOptions
extends RQDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JCheckBox jCBAutoOpen = new JCheckBox("\u81ea\u52a8\u6253\u5f00(\u6700\u8fd1\u6587\u4ef6)");
    private JCheckBox jCBLogException = new JCheckBox("\u5c06\u5f02\u5e38\u5199\u5165\u65e5\u5fd7\u6587\u4ef6");
    private JCheckBox jCBWindowSize = new JCheckBox("\u8bb0\u5fc6\u7a97\u53e3\u4f4d\u7f6e\u5927\u5c0f");
    private JComboBoxEx jCBLNF = new JComboBoxEx();
    private JTextField textLogFileName = new JTextField();
    private JButton buttonLogFileName = new JButton();

    public DialogOptions() {
        super("\u9009\u9879", 450, 300);
        this.init();
        this.load();
    }

    @Override
    protected boolean okAction(ActionEvent e) {
        try {
            this.save();
            return true;
        }
        catch (Throwable t) {
            GM.showException(t);
            return false;
        }
    }

    private void save() throws Throwable {
        ConfigOptions.bAutoOpen = new Boolean(this.jCBAutoOpen.isSelected());
        ConfigOptions.bLogException = new Boolean(this.jCBLogException.isSelected());
        ConfigOptions.bWindowSize = new Boolean(this.jCBWindowSize.isSelected());
        ConfigOptions.iLookAndFeel = (Byte)this.jCBLNF.x_getSelectedItem();
        ConfigOptions.sLogFileName = this.textLogFileName.getText();
        ConfigOptions.save();
    }

    private void load() {
        this.jCBAutoOpen.setSelected(ConfigOptions.bAutoOpen);
        this.jCBLogException.setSelected(ConfigOptions.bLogException);
        this.jCBWindowSize.setSelected(ConfigOptions.bWindowSize);
        this.jCBLNF.x_setSelectedCodeItem(LNFManager.getValidLookAndFeel(ConfigOptions.iLookAndFeel));
        this.textLogFileName.setText(ConfigOptions.sLogFileName);
    }

    private void selectDir(JTextField textField) {
        String newPath;
        String lastDir = ConfigOptions.sLastDirectory;
        if (StringUtils.isValidString(textField.getText())) {
            lastDir = textField.getText();
        }
        if ((newPath = GM.dialogSelectDirectory(lastDir)) != null) {
            textField.setText(newPath);
        }
    }

    private void selectFile(JTextField textField) {
        File f;
        String filePath = textField.getText();
        String lastDir = null;
        String fileName = null;
        if (StringUtils.isValidString(filePath)) {
            f = new File(filePath);
            lastDir = f.getParent();
            fileName = f.getName();
        }
        if ((f = GM.dialogSelectFile("log", lastDir, null, fileName)) != null) {
            textField.setText(f.getAbsolutePath());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object c = e.getSource();
        if (this.buttonLogFileName == c) {
            this.selectFile(this.textLogFileName);
        }
    }

    private void init() {
        JPanel panelOpt = new JPanel(new GridLayout(3, 2, 5, 5));
        JPanel panelFile = new JPanel(new GridBagLayout());
        this.panelCenter.add((Component)panelOpt, "North");
        this.panelCenter.add((Component)panelFile, "Center");
        panelOpt.add(this.jCBAutoOpen);
        panelOpt.add(this.jCBLogException);
        panelOpt.add(this.jCBWindowSize);
        panelFile.add((Component)new JLabel(), GM.getGBC(0, 0));
        panelFile.add((Component)new JLabel("\u65e5\u5fd7\u6587\u4ef6"), GM.getGBC(3, 0));
        panelFile.add((Component)this.textLogFileName, GM.getGBC(3, 1, true));
        panelFile.add((Component)this.buttonLogFileName, GM.getGBC(3, 2));
        panelFile.add((Component)new JPanel(), GM.getGBC(4, 0, false, true));
        Vector<Object> codes = LNFManager.listLNFCode();
        Vector<String> disps = LNFManager.listLNFDisp();
        this.jCBLNF.x_setData(codes, disps);
        this.buttonLogFileName.setText(IdeMessage.get().getMessage("public.select"));
        this.buttonLogFileName.addActionListener(this);
    }
}

