/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.vdb.menu;

import com.scudata.common.StringUtils;
import com.scudata.ide.vdb.VDB;
import com.scudata.ide.vdb.commonvdb.GM;
import com.scudata.ide.vdb.resources.IdeMessage;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MenuFactory
extends JMenuBar
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected static Map<Short, JMenu> menus = new HashMap<Short, JMenu>();
    protected static Map<Short, JMenuItem> menuItems = new HashMap<Short, JMenuItem>();
    private static final int RECENT_FILE_COUNT = 5;
    public JMenuItem[] fileItem = new JMenuItem[5];

    public JMenuItem getJMenuItem(short menuId) {
        return menuItems.get(menuId);
    }

    public void setMenuEnabled(short menuId, boolean enabled) {
        JMenuItem mi = this.getJMenuItem(menuId);
        if (mi != null) {
            mi.setEnabled(enabled);
        }
    }

    public void setMenuEnabled(short[] menuIds, boolean enabled) {
        int i = 0;
        while (i < menuIds.length) {
            this.setMenuEnabled(menuIds[i], enabled);
            ++i;
        }
    }

    protected JMenu newMenu(short menuId, String menuText, char mneKey, boolean isMainMenu) {
        menuText = IdeMessage.get().getMessage("menu." + menuText);
        return this.getMenu(menuId, menuText, mneKey, isMainMenu);
    }

    private JMenu getMenu(short menuId, String menuText, char mneKey, boolean isMainMenu) {
        JMenu mItem = new JMenu(menuText);
        if (!isMainMenu) {
            mItem.setIcon(GM.getMenuImageIcon("blank"));
        }
        if (StringUtils.isValidString(String.valueOf(mneKey))) {
            mItem.setMnemonic(mneKey);
        }
        menus.put(menuId, mItem);
        return mItem;
    }

    protected JMenuItem newMenuItem(short cmdId, String menuId, char mneKey, Boolean accelerator) {
        return this.newMenuItem(cmdId, menuId, mneKey, accelerator, false);
    }

    protected JMenuItem newMenuItem(short cmdId, String menuId, char mneKey, Boolean accelerator, boolean hasIcon) {
        JMenuItem mItem = this.getMenuItem(cmdId, menuId, mneKey, accelerator, hasIcon);
        mItem.addActionListener(this);
        menuItems.put(cmdId, mItem);
        return mItem;
    }

    private JMenuItem getMenuItem(short cmdId, String menuId, char mneKey, Boolean accelerator, boolean hasIcon) {
        JMenuItem mItem = new JMenuItem(IdeMessage.get().getMessage("menu." + menuId), mneKey);
        mItem.setName(Short.toString(cmdId));
        if (hasIcon) {
            mItem.setIcon(GM.getMenuImageIcon(menuId));
        } else {
            mItem.setIcon(GM.getMenuImageIcon("blank"));
        }
        if (accelerator == null) {
            KeyStroke ks = KeyStroke.getKeyStroke((int)mneKey, 0);
            mItem.setAccelerator(ks);
        } else if (accelerator.booleanValue()) {
            int mask = 2;
            KeyStroke ks = KeyStroke.getKeyStroke((int)mneKey, mask);
            mItem.setAccelerator(ks);
        }
        return mItem;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String menuId = "";
        try {
            JMenuItem mi = (JMenuItem)e.getSource();
            menuId = mi.getName();
            short cmdId = Short.parseShort(menuId);
            VDB.getInstance().executeCmd(cmdId);
        }
        catch (Exception x) {
            GM.showException(x);
        }
    }
}

