/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.vdb.menu;

import com.scudata.ide.vdb.VDB;
import com.scudata.ide.vdb.commonvdb.GM;
import com.scudata.ide.vdb.resources.IdeMessage;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class ToolbarFactory
extends JToolBar {
    private static final long serialVersionUID = 1L;
    public static Map<Short, JButton> buttonHolder = new HashMap<Short, JButton>();
    private ActionListener actionNormal = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String menuId = "";
            try {
                menuId = e.getActionCommand();
                short cmdId = Short.parseShort(menuId);
                VDB.getInstance().executeCmd(cmdId);
            }
            catch (Exception ex) {
                GM.showException(ex);
            }
        }
    };

    public ToolbarFactory() {
        this(IdeMessage.get().getMessage("public.toolbar"));
    }

    public ToolbarFactory(String name) {
        super(name);
        this.setFloatable(false);
        this.setToolTipText(IdeMessage.get().getMessage("public.toolbar"));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.isOpaque()) {
            return;
        }
        Color control = UIManager.getColor("control");
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D g2 = (Graphics2D)g;
        Paint storedPaint = g2.getPaint();
        g2.setPaint(new GradientPaint(width / 2, (int)((double)height * 1.5), control.darker(), width / 2, 0.0f, control));
        g2.fillRect(0, 0, width, height);
        g2.setPaint(storedPaint);
    }

    protected JButton getButton(short cmdId, String menuId) {
        ImageIcon img = GM.getMenuImageIcon(menuId);
        JButton b = new JButton(img);
        b.setOpaque(false);
        b.setMargin(new Insets(0, 0, 0, 0));
        String toolTip = IdeMessage.get().getMessage("menu." + menuId);
        int index = toolTip.indexOf("(");
        if (index > -1) {
            toolTip = toolTip.substring(0, index);
        }
        b.setToolTipText(toolTip);
        b.setActionCommand(Short.toString(cmdId));
        b.addActionListener(this.actionNormal);
        buttonHolder.put(cmdId, b);
        return b;
    }

    public void setButtonEnabled(short cmdId, boolean enabled) {
        this.setButtonsEnabled(new short[]{cmdId}, enabled);
    }

    public void setButtonsEnabled(short[] cmdId, boolean enabled) {
        int i = 0;
        while (i < cmdId.length) {
            ((AbstractButton)buttonHolder.get(cmdId[i])).setEnabled(enabled);
            ++i;
        }
    }

    public void setButtonVisible(short cmdId, boolean visible) {
        this.setButtonsVisible(new short[]{cmdId}, visible);
    }

    public void setButtonsVisible(short[] cmdId, boolean visible) {
        int i = 0;
        while (i < cmdId.length) {
            ((AbstractButton)buttonHolder.get(cmdId[i])).setVisible(visible);
            ++i;
        }
    }
}

