/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.vdb.panel;

import com.scudata.common.ImageUtils;
import com.scudata.common.Logger;
import com.scudata.ide.common.EditListener;
import com.scudata.ide.vdb.control.VDBTreeNode;
import com.scudata.ide.vdb.panel.PanelEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class PanelImage
extends PanelEditor {
    private static final long serialVersionUID = 1L;
    JLabel image = null;

    public PanelImage(EditListener listener) {
        super(listener);
        this.setLayout(new BorderLayout());
        this.image = new JLabel();
        this.add((Component)this.image, "Center");
        this.init();
    }

    void init() {
    }

    void setImageBytes(byte[] bytes) {
        this.beforeInit();
        ImageIcon icon = new ImageIcon(bytes);
        this.image.setIcon(icon);
        this.afterInit();
    }

    byte[] getImageBytes() {
        ImageIcon ii = (ImageIcon)this.image.getIcon();
        int w = ii.getIconWidth();
        int h = ii.getIconHeight();
        BufferedImage bi = new BufferedImage(w, h, 2);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.drawImage(ii.getImage(), 0, 0, null);
        byte[] bytes = null;
        try {
            bytes = ImageUtils.writePNG(bi);
        }
        catch (IOException e) {
            Logger.severe(e);
        }
        return bytes;
    }

    @Override
    public void setNode(VDBTreeNode node) {
        this.node = node;
        byte[] bytes = (byte[])node.getData();
        this.setImageBytes(bytes);
    }

    @Override
    public VDBTreeNode getNode() {
        byte[] bytes = this.getImageBytes();
        this.node.saveData(bytes);
        return this.node;
    }
}

