/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.parallel;

import com.scudata.dm.Context;
import com.scudata.dm.JobSpace;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.ResourceManager;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.op.Channel;
import com.scudata.dm.op.Operable;
import com.scudata.dm.op.Operation;
import com.scudata.dm.op.Push;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.FunctionLib;
import com.scudata.parallel.ChannelProxy;
import com.scudata.parallel.Cluster;
import com.scudata.parallel.ClusterCursor;
import com.scudata.parallel.CursorProxy;
import com.scudata.parallel.IIlllIlIIIIIlllI;
import com.scudata.parallel.RemoteCursor;
import com.scudata.parallel.RemoteCursorProxy;
import com.scudata.parallel.Response;
import com.scudata.parallel.UnitClient;
import com.scudata.parallel.UnitCommand;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterChannel
extends Channel {
    private Cluster _$3;
    private int[] _$2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterChannel(ClusterChannel channel, Context ctx) {
        super(ctx);
        this._$3 = channel.getCluster();
        int count = this._$3.getUnitCount();
        this._$2 = new int[count];
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(this._$3.getHost(i), this._$3.getPort(i));
            try {
                UnitCommand command = new UnitCommand(71);
                command.setAttribute("jobSpaceId", this._$3.getJobSpaceId());
                command.setAttribute("channelProxyId", new Integer(channel._$2[i]));
                Response response = client.send(command);
                Integer id = (Integer)response.checkResult();
                this._$2[i] = id;
                continue;
            }
            finally {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterChannel(ClusterCursor cursor, Context ctx) {
        super(ctx);
        this._$3 = cursor.getCluster();
        int count = this._$3.getUnitCount();
        int[] csIds = cursor.getCursorProxyIds();
        this._$2 = new int[count];
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(this._$3.getHost(i), this._$3.getPort(i));
            try {
                UnitCommand command = new UnitCommand(70);
                command.setAttribute("jobSpaceId", this._$3.getJobSpaceId());
                command.setAttribute("cursorProxyId", new Integer(csIds[i]));
                Response response = client.send(command);
                Integer id = (Integer)response.checkResult();
                this._$2[i] = id;
                continue;
            }
            finally {
                client.close();
            }
        }
    }

    public static Response executeCreateChannel_CH(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer chId = (Integer)attributes.get("channelProxyId");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            ChannelProxy cp = (ChannelProxy)rm.getProxy(chId);
            Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes);
            Channel channel = new Channel(ctx);
            Push push = new Push(null, channel);
            cp.getChannel().addOperation(push, ctx);
            ChannelProxy proxy = new ChannelProxy(channel);
            rm.addProxy(proxy);
            return new Response(new Integer(proxy.getProxyId()));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    public static Response executeCreateChannel_CS(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer csId = (Integer)attributes.get("cursorProxyId");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            CursorProxy cp = (CursorProxy)rm.getProxy(csId);
            Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes);
            Channel channel = new Channel(ctx);
            Push push = new Push(null, channel);
            ICursor cursor = cp.getCursor();
            if (cursor != null) {
                cursor.addOperation(push, ctx);
            }
            ChannelProxy proxy = new ChannelProxy(channel);
            rm.addProxy(proxy);
            return new Response(new Integer(proxy.getProxyId()));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    public Cluster getCluster() {
        return this._$3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Operable addOperation(Operation op, Context ctx) {
        super.addOperation(op, ctx);
        Cluster cluster = this.getCluster();
        int count = cluster.getUnitCount();
        Function function = op.getFunction();
        String functionName = function.getFunctionName();
        String option = function.getOption();
        String param = function.getParamString();
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            try {
                UnitCommand command = new UnitCommand(72);
                command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
                command.setAttribute("channelProxyId", new Integer(this._$2[i]));
                command.setAttribute("functionName", functionName);
                command.setAttribute("option", option);
                command.setAttribute("param", param);
                IIlllIlIIIIIlllI.setParams(command, function, ctx);
                Response response = client.send(command);
                response.checkResult();
                continue;
            }
            finally {
                client.close();
            }
        }
        return this;
    }

    public static Response executeAddOperation(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer channelProxyId = (Integer)attributes.get("channelProxyId");
        String functionName = (String)attributes.get("functionName");
        String option = (String)attributes.get("option");
        String param = (String)attributes.get("param");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes, functionName, option);
            ResourceManager rm = js.getResourceManager();
            ChannelProxy channel = (ChannelProxy)rm.getProxy(channelProxyId);
            FunctionLib.executeMemberFunction(channel.getChannel(), functionName, param, option, ctx);
            return new Response();
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel fetch() {
        super.fetch();
        Cluster cluster = this.getCluster();
        int count = cluster.getUnitCount();
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            try {
                UnitCommand command = new UnitCommand(76);
                command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
                command.setAttribute("channelProxyId", new Integer(this._$2[i]));
                Response response = client.send(command);
                response.checkResult();
                continue;
            }
            finally {
                client.close();
            }
        }
        return this;
    }

    public static Response executeFetch(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer channelProxyId = (Integer)attributes.get("channelProxyId");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            ChannelProxy channel = (ChannelProxy)rm.getProxy(channelProxyId);
            channel.getChannel().fetch();
            return new Response();
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel groups(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt) {
        int i;
        super.groups(exps, names, calcExps, calcNames, opt);
        int dcount = exps == null ? 0 : exps.length;
        int mcount = calcExps == null ? 0 : calcExps.length;
        String[] dexps = null;
        String[] mexps = null;
        Expression[] totalExps = new Expression[dcount + mcount];
        if (dcount > 0) {
            dexps = new String[dcount];
            for (i = 0; i < dcount; ++i) {
                dexps[i] = exps[i].toString();
                totalExps[i] = exps[i];
            }
        }
        if (mcount > 0) {
            mexps = new String[mcount];
            for (i = 0; i < mcount; ++i) {
                mexps[i] = calcExps[i].toString();
                totalExps[i + dcount] = calcExps[i];
            }
        }
        Cluster cluster = this.getCluster();
        int count = cluster.getUnitCount();
        for (int i2 = 0; i2 < count; ++i2) {
            UnitClient client = new UnitClient(cluster.getHost(i2), cluster.getPort(i2));
            try {
                UnitCommand command = new UnitCommand(73);
                command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
                command.setAttribute("channelProxyId", new Integer(this._$2[i2]));
                command.setAttribute("dexps", dexps);
                command.setAttribute("names", names);
                command.setAttribute("mexps", mexps);
                command.setAttribute("calcNames", calcNames);
                command.setAttribute("option", opt);
                IIlllIlIIIIIlllI.setParams(command, totalExps, this.ctx);
                Response response = client.send(command);
                response.checkResult();
                continue;
            }
            finally {
                client.close();
            }
        }
        return this;
    }

    public static Response executeGroups(HashMap<String, Object> attributes) {
        int i;
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer channelProxyId = (Integer)attributes.get("channelProxyId");
        String[] dexps = (String[])attributes.get("dexps");
        String[] names = (String[])attributes.get("names");
        String[] mexps = (String[])attributes.get("mexps");
        String[] calcNames = (String[])attributes.get("calcNames");
        String opt = (String)attributes.get("option");
        Expression[] exps = null;
        Expression[] calcExps = null;
        JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
        Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes);
        if (dexps != null) {
            int dcount = dexps.length;
            exps = new Expression[dcount];
            for (i = 0; i < dcount; ++i) {
                exps[i] = new Expression(ctx, dexps[i]);
            }
        }
        if (mexps != null) {
            int mcount = mexps.length;
            calcExps = new Expression[mcount];
            for (i = 0; i < mcount; ++i) {
                calcExps[i] = new Expression(ctx, mexps[i]);
            }
        }
        try {
            ResourceManager rm = js.getResourceManager();
            ChannelProxy channel = (ChannelProxy)rm.getProxy(channelProxyId);
            channel.getChannel().groups(exps, names, calcExps, calcNames, opt);
            return new Response();
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel groupx(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, int capacity) {
        int i;
        super.groupx(exps, names, calcExps, calcNames, opt, capacity);
        int dcount = exps == null ? 0 : exps.length;
        int mcount = calcExps == null ? 0 : calcExps.length;
        String[] dexps = null;
        String[] mexps = null;
        Expression[] totalExps = new Expression[dcount + mcount];
        if (dcount > 0) {
            dexps = new String[dcount];
            for (i = 0; i < dcount; ++i) {
                dexps[i] = exps[i].toString();
                totalExps[i] = exps[i];
            }
        }
        if (mcount > 0) {
            mexps = new String[mcount];
            for (i = 0; i < mcount; ++i) {
                mexps[i] = calcExps[i].toString();
                totalExps[i + dcount] = calcExps[i];
            }
        }
        Cluster cluster = this.getCluster();
        int count = cluster.getUnitCount();
        for (int i2 = 0; i2 < count; ++i2) {
            UnitClient client = new UnitClient(cluster.getHost(i2), cluster.getPort(i2));
            try {
                UnitCommand command = new UnitCommand(74);
                command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
                command.setAttribute("channelProxyId", new Integer(this._$2[i2]));
                command.setAttribute("dexps", dexps);
                command.setAttribute("names", names);
                command.setAttribute("mexps", mexps);
                command.setAttribute("calcNames", calcNames);
                command.setAttribute("option", opt);
                command.setAttribute("capacity", new Integer(capacity));
                IIlllIlIIIIIlllI.setParams(command, totalExps, this.ctx);
                Response response = client.send(command);
                response.checkResult();
                continue;
            }
            finally {
                client.close();
            }
        }
        return this;
    }

    public static Response executeGroupx(HashMap<String, Object> attributes) {
        int i;
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer channelProxyId = (Integer)attributes.get("channelProxyId");
        String[] dexps = (String[])attributes.get("dexps");
        String[] names = (String[])attributes.get("names");
        String[] mexps = (String[])attributes.get("mexps");
        String[] calcNames = (String[])attributes.get("calcNames");
        String opt = (String)attributes.get("option");
        Integer capacity = (Integer)attributes.get("capacity");
        Expression[] exps = null;
        Expression[] calcExps = null;
        JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
        Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes);
        if (dexps != null) {
            int dcount = dexps.length;
            exps = new Expression[dcount];
            for (i = 0; i < dcount; ++i) {
                exps[i] = new Expression(ctx, dexps[i]);
            }
        }
        if (mexps != null) {
            int mcount = mexps.length;
            calcExps = new Expression[mcount];
            for (i = 0; i < mcount; ++i) {
                calcExps[i] = new Expression(ctx, mexps[i]);
            }
        }
        try {
            ResourceManager rm = js.getResourceManager();
            ChannelProxy channel = (ChannelProxy)rm.getProxy(channelProxyId);
            channel.getChannel().groupx(exps, names, calcExps, calcNames, opt, capacity);
            return new Response();
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel sortx(Expression[] exps, int capacity, String opt) {
        super.sortx(exps, capacity, opt);
        int fcount = exps.length;
        String[] fields = new String[fcount];
        for (int i = 0; i < fcount; ++i) {
            fields[i] = exps[i].toString();
        }
        Cluster cluster = this.getCluster();
        int count = cluster.getUnitCount();
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            try {
                UnitCommand command = new UnitCommand(75);
                command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
                command.setAttribute("channelProxyId", new Integer(this._$2[i]));
                command.setAttribute("fields", fields);
                command.setAttribute("capacity", new Integer(capacity));
                command.setAttribute("opt", opt);
                IIlllIlIIIIIlllI.setParams(command, exps, this.ctx);
                Response response = client.send(command);
                response.checkResult();
                continue;
            }
            finally {
                client.close();
            }
        }
        return this;
    }

    public static Response executeSortx(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer channelProxyId = (Integer)attributes.get("channelProxyId");
        String[] fields = (String[])attributes.get("fields");
        Integer capacity = (Integer)attributes.get("capacity");
        String opt = (String)attributes.get("opt");
        JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
        Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes);
        int fcount = fields.length;
        Expression[] exps = new Expression[fcount];
        for (int i = 0; i < fcount; ++i) {
            exps[i] = new Expression(ctx, fields[i]);
        }
        try {
            ResourceManager rm = js.getResourceManager();
            ChannelProxy channel = (ChannelProxy)rm.getProxy(channelProxyId);
            channel.getChannel().sortx(exps, capacity, opt);
            return new Response();
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object result() {
        if (this.result == null) {
            return null;
        }
        Cluster cluster = this.getCluster();
        int count = cluster.getUnitCount();
        Object[] results = new Object[count];
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            try {
                UnitCommand command = new UnitCommand(77);
                command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
                command.setAttribute("channelProxyId", new Integer(this._$2[i]));
                Response response = client.send(command);
                results[i] = response.checkResult();
                if (!(results[i] instanceof Integer)) continue;
                int id = (Integer)results[i];
                results[i] = new RemoteCursor(cluster.getHost(i), cluster.getPort(i), id);
                continue;
            }
            finally {
                client.close();
            }
        }
        return this.result.combineResult(results);
    }

    public static Response executeResult(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer channelProxyId = (Integer)attributes.get("channelProxyId");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            ChannelProxy channel = (ChannelProxy)rm.getProxy(channelProxyId);
            Object result = channel.getChannel().result();
            if (result instanceof ICursor) {
                RemoteCursorProxy rcp = new RemoteCursorProxy((ICursor)result);
                return new Response(new Integer(rcp._$2()));
            }
            return new Response(result);
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }
}

