/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.parallel;

import com.scudata.common.IntArrayList;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.JobSpace;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.ResourceManager;
import com.scudata.dm.Sequence;
import com.scudata.dw.IPhyTable;
import com.scudata.expression.Expression;
import com.scudata.parallel.Cluster;
import com.scudata.parallel.ClusterCursor;
import com.scudata.parallel.ClusterPhyTable;
import com.scudata.parallel.IClusterObject;
import com.scudata.parallel.IIlllIlIIIIIlllI;
import com.scudata.parallel.PhyTableProxy;
import com.scudata.parallel.Response;
import com.scudata.parallel.UnitClient;
import com.scudata.parallel.UnitCommand;
import com.scudata.parallel.llIllIIIIlIIlIII;
import com.scudata.resources.EngineMessage;
import com.scudata.resources.ParallelMessage;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterFile
implements IClusterObject {
    private Cluster _$5;
    private String _$4;
    private String _$3;
    private llIllIIIIlIIlIII[] _$2;
    private boolean _$1 = true;

    private ClusterFile() {
    }

    public ClusterFile(String host, int port, String fileName, int part, Context ctx) {
        this._$5 = new Cluster(new String[]{host}, new int[]{port}, ctx);
        this._$2 = new llIllIIIIlIIlIII[1];
        this._$2[0] = new llIllIIIIlIIlIII(this, host, port, part);
        this._$4 = fileName;
        if (part > 0) {
            this._$1 = true;
        }
    }

    public ClusterFile(ClusterFile clusterFile, String fileName, int[] parts, String opt) {
        this._$4 = fileName;
        this._$3 = opt;
        if (parts == null || parts.length == 0) {
            this._$1 = clusterFile._$1;
            this._$5 = clusterFile._$5;
            int count = clusterFile._$2.length;
            this._$2 = new llIllIIIIlIIlIII[count];
            for (int i = 0; i < count; ++i) {
                this._$2[i] = clusterFile._$2[i].dup(this);
            }
        } else {
            this._$1 = true;
            int count = parts.length;
            String[] hosts = new String[count];
            int[] ports = new int[count];
            this._$2 = new llIllIIIIlIIlIII[count];
            for (int i = 0; i < count; ++i) {
                llIllIIIIlIIlIII pf2;
                block6: {
                    for (llIllIIIIlIIlIII pf2 : clusterFile._$2) {
                        if (pf2.getPartition() != parts[i]) {
                            continue;
                        }
                        break block6;
                    }
                    MessageManager mm = ParallelMessage.get();
                    throw new RQException(mm.getMessage("PartitionUtil.lackfile2", fileName, parts[i]));
                }
                this._$2[i] = pf2.dup(this);
                hosts[i] = pf2.getHost();
                ports[i] = pf2.getPort();
            }
            Context ctx = clusterFile._$5.getContext();
            this._$5 = new Cluster(hosts, ports, ctx);
        }
    }

    public ClusterFile(Cluster cluster, String fileName, int[] parts, String opt) {
        int size;
        this._$4 = fileName;
        this._$3 = opt;
        this._$1 = true;
        String[] hosts = cluster.getHosts();
        int[] ports = cluster.getPorts();
        int hcount = hosts.length;
        int pcount = parts.length;
        this._$2 = new llIllIIIIlIIlIII[pcount];
        if (opt != null && opt.indexOf(119) != -1) {
            if (hcount != pcount) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("file" + mm.getMessage("function.paramCountNotMatch"));
            }
            for (int i = 0; i < hcount; ++i) {
                this._$2[i] = new llIllIIIIlIIlIII(this, hosts[i], ports[i], parts[i]);
            }
            this._$5 = cluster;
            return;
        }
        ArrayList<IntArrayList> hostList = new ArrayList<IntArrayList>();
        for (int i = 0; i < hcount; ++i) {
            try {
                int[] partList;
                for (int p : partList = IIlllIlIIIIIlllI.listFileParts(hosts[i], ports[i], fileName, parts)) {
                    for (size = hostList.size(); size <= p; ++size) {
                        hostList.add(new IntArrayList());
                    }
                    ((IntArrayList)hostList.get(p)).addInt(i);
                }
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int[] weights = new int[hcount];
        String[] useHosts = new String[pcount];
        int[] usePorts = new int[pcount];
        for (int i = 0; i < pcount; ++i) {
            int p = parts[i];
            if (hostList.size() <= p) {
                MessageManager mm = ParallelMessage.get();
                throw new RQException(mm.getMessage("PartitionUtil.lackfile2", fileName, p));
            }
            IntArrayList list = (IntArrayList)hostList.get(p);
            size = list.size();
            if (size == 0) {
                MessageManager mm = ParallelMessage.get();
                throw new RQException(mm.getMessage("PartitionUtil.lackfile2", fileName, p));
            }
            int h = list.getInt(0);
            for (int j = 1; j < list.size(); ++j) {
                int cur = list.getInt(j);
                if (weights[cur] >= weights[h]) continue;
                h = cur;
            }
            int n = h;
            weights[n] = weights[n] + 1;
            this._$2[i] = new llIllIIIIlIIlIII(this, hosts[h], ports[h], p);
            useHosts[i] = hosts[h];
            usePorts[i] = ports[h];
        }
        this._$5 = new Cluster(useHosts, usePorts, cluster.getContext());
    }

    public ClusterFile(Cluster cluster, String fileName, Sequence partSeq, String opt) {
        int size;
        this._$4 = fileName;
        this._$3 = opt;
        this._$1 = true;
        int pcount = partSeq.length();
        int[][] partArrays = new int[pcount][];
        int[] firstParts = new int[pcount];
        for (int i = 1; i <= pcount; ++i) {
            Object obj = partSeq.getMem(i);
            if (obj instanceof Number) {
                int p = ((Number)obj).intValue();
                partArrays[i - 1] = new int[]{p};
            } else if (obj instanceof Sequence) {
                Sequence seq = (Sequence)obj;
                if (seq.length() == 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("file" + mm.getMessage("function.invalidParam"));
                }
                partArrays[i - 1] = seq.toIntArray();
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException("file" + mm.getMessage("function.invalidParam"));
            }
            firstParts[i - 1] = partArrays[i - 1][0];
        }
        String[] hosts = cluster.getHosts();
        int[] ports = cluster.getPorts();
        int hcount = hosts.length;
        this._$2 = new llIllIIIIlIIlIII[pcount];
        if (opt != null && opt.indexOf(119) != -1) {
            if (hcount != pcount) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("file" + mm.getMessage("function.paramCountNotMatch"));
            }
            for (int i = 0; i < hcount; ++i) {
                if (partArrays[i].length != 1) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("file" + mm.getMessage("function.invalidParam"));
                }
                this._$2[i] = new llIllIIIIlIIlIII(this, hosts[i], ports[i], partArrays[i]);
            }
            this._$5 = cluster;
            return;
        }
        ArrayList<IntArrayList> hostList = new ArrayList<IntArrayList>();
        for (int i = 0; i < hcount; ++i) {
            try {
                int[] partList;
                for (int p : partList = IIlllIlIIIIIlllI.listFileParts(hosts[i], ports[i], fileName, firstParts)) {
                    for (size = hostList.size(); size <= p; ++size) {
                        hostList.add(new IntArrayList());
                    }
                    ((IntArrayList)hostList.get(p)).addInt(i);
                }
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int[] weights = new int[hcount];
        String[] useHosts = new String[pcount];
        int[] usePorts = new int[pcount];
        for (int i = 0; i < pcount; ++i) {
            int p = firstParts[i];
            if (hostList.size() <= p) {
                MessageManager mm = ParallelMessage.get();
                throw new RQException(mm.getMessage("PartitionUtil.lackfile2", fileName, p));
            }
            IntArrayList list = (IntArrayList)hostList.get(p);
            size = list.size();
            if (size == 0) {
                MessageManager mm = ParallelMessage.get();
                throw new RQException(mm.getMessage("PartitionUtil.lackfile2", fileName, p));
            }
            int h = list.getInt(0);
            for (int j = 1; j < list.size(); ++j) {
                int cur = list.getInt(j);
                if (weights[cur] >= weights[h]) continue;
                h = cur;
            }
            int n = h;
            weights[n] = weights[n] + 1;
            this._$2[i] = new llIllIIIIlIIlIII(this, hosts[h], ports[h], partArrays[i]);
            useHosts[i] = hosts[h];
            usePorts[i] = ports[h];
        }
        this._$5 = new Cluster(useHosts, usePorts, cluster.getContext());
    }

    public ClusterFile(Cluster cluster, String fileName, String opt) {
        this._$5 = cluster;
        this._$4 = fileName;
        this._$3 = opt;
        this._$1 = true;
        String[] hosts = cluster.getHosts();
        int[] ports = cluster.getPorts();
        int hcount = hosts.length;
        this._$2 = new llIllIIIIlIIlIII[hcount];
        for (int i = 0; i < hcount; ++i) {
            this._$2[i] = new llIllIIIIlIIlIII(this, hosts[i], ports[i], i + 1);
        }
    }

    public ClusterFile newFile(String pathName) {
        ClusterFile clusterFile = new ClusterFile();
        clusterFile._$5 = this._$5;
        clusterFile._$4 = pathName;
        clusterFile._$1 = this._$1;
        clusterFile._$3 = this._$3;
        llIllIIIIlIIlIII[] pfs = this._$2;
        int count = pfs.length;
        clusterFile._$2 = new llIllIIIIlIIlIII[count];
        for (int i = 0; i < count; ++i) {
            clusterFile._$2[i] = pfs[i].dup(clusterFile);
        }
        return clusterFile;
    }

    public boolean isDistributedFile() {
        return this._$1;
    }

    public int getUnitCount() {
        return this._$5.getUnitCount();
    }

    public llIllIIIIlIIlIII[] getPartitionFiles() {
        return this._$2;
    }

    public String getHost(int unit) {
        return this._$5.getHost(unit);
    }

    public int getPort(int unit) {
        return this._$5.getPort(unit);
    }

    public String getFileName() {
        return this._$4;
    }

    public String getOption() {
        return this._$3;
    }

    public Context getContext() {
        return this._$5.getContext();
    }

    public String getJobSpaceId() {
        return this._$5.getJobSpaceId();
    }

    @Override
    public Cluster getCluster() {
        return this._$5;
    }

    public ClusterCursor createBinaryCursor(String[] fields, String opt) {
        int count = this._$2.length;
        int[] proxyIds = new int[count];
        boolean isDistributed = this._$1;
        if (!isDistributed && opt != null && opt.indexOf(122) != -1) {
            isDistributed = true;
            for (int i = 0; i < count; ++i) {
                proxyIds[i] = this._$2[i].createBinaryCursor(fields, opt, i + 1, count, i);
            }
        } else {
            for (int i = 0; i < count; ++i) {
                proxyIds[i] = this._$2[i].createBinaryCursor(fields, opt, 0, 0, i);
            }
        }
        return new ClusterCursor(this, proxyIds, isDistributed);
    }

    public ClusterPhyTable createGroupTable(String[] colNames, Expression distribute, String opt, Context ctx) {
        int count = this._$2.length;
        int[] proxyIds = new int[count];
        String dis = distribute == null ? null : distribute.toString();
        for (int i = 0; i < count; ++i) {
            proxyIds[i] = this._$2[i].createGroupTable(colNames, dis, opt);
        }
        ClusterPhyTable table = new ClusterPhyTable(this, proxyIds, ctx);
        table._$1(distribute);
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterPhyTable openGroupTable(Context ctx) {
        int count = this._$2.length;
        int[] proxyIds = new int[count];
        for (int i = 0; i < count; ++i) {
            proxyIds[i] = this._$2[i].openGroupTable();
        }
        UnitClient client = new UnitClient(this._$5.getHost(0), this._$5.getPort(0));
        Expression distribute = null;
        try {
            UnitCommand command = new UnitCommand(3);
            command.setAttribute("jobSpaceId", this._$5.getJobSpaceId());
            command.setAttribute("tmdProxyId", new Integer(proxyIds[0]));
            Response response = client.send(command);
            String str = (String)response.checkResult();
            if (str != null) {
                distribute = new Expression(ctx, str);
            }
        }
        finally {
            client.close();
        }
        ClusterPhyTable table = new ClusterPhyTable(this, proxyIds, ctx);
        table._$1(distribute);
        return table;
    }

    public static Response executeGetDistribute(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer tmdProxyId = (Integer)attributes.get("tmdProxyId");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            PhyTableProxy tmd = (PhyTableProxy)rm.getProxy(tmdProxyId);
            IPhyTable table = tmd.getTableMetaData();
            String distribute = table.getDistribute();
            return new Response(distribute);
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    public Sequence resetGroupTable(String file, String option, String distribute, Integer blockSize) {
        if (!this.isDistributedFile()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.needDistributed"));
        }
        Sequence result = new Sequence();
        int count = this._$2.length;
        for (int i = 0; i < count; ++i) {
            result.add(this._$2[i].resetGroupTable(file, option, distribute, blockSize));
        }
        return result;
    }
}

