/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.parallel;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.IResource;
import com.scudata.dm.JobSpace;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.ResourceManager;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.BFileCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dw.Cuboid;
import com.scudata.dw.IPhyTable;
import com.scudata.dw.ITableIndex;
import com.scudata.dw.JoinCursor;
import com.scudata.dw.MemoryTable;
import com.scudata.dw.PhyTable;
import com.scudata.dw.PhyTableIndex;
import com.scudata.dw.TableFulltextIndex;
import com.scudata.dw.TableHashIndex;
import com.scudata.dw.TableKeyValueIndex;
import com.scudata.expression.Expression;
import com.scudata.expression.mfn.file.Structure;
import com.scudata.parallel.Cluster;
import com.scudata.parallel.ClusterCursor;
import com.scudata.parallel.ClusterFile;
import com.scudata.parallel.ClusterMemoryTable;
import com.scudata.parallel.CursorProxy;
import com.scudata.parallel.IClusterObject;
import com.scudata.parallel.IIIIIlIlIlIlIIIl;
import com.scudata.parallel.IIlllIlIIIIIlllI;
import com.scudata.parallel.IlIIIlIlIlllIlll;
import com.scudata.parallel.PhyTableProxy;
import com.scudata.parallel.Response;
import com.scudata.parallel.TableProxy;
import com.scudata.parallel.TaskManager;
import com.scudata.parallel.UnitClient;
import com.scudata.parallel.UnitCommand;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.ThreadPool;
import com.scudata.util.Variant;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterPhyTable
implements IClusterObject,
IResource {
    public static final int TYPE_TABLE = 0;
    public static final int TYPE_NEW = 1;
    public static final int TYPE_NEWS = 2;
    public static final int TYPE_DERIVE = 3;
    private ClusterFile _$6;
    private int[] _$5;
    private String[] _$4;
    private String[] _$3;
    private Expression _$2;
    private Context _$1;

    public ClusterPhyTable(ClusterFile clusterFile, int[] tmdProxyIds, Context ctx) {
        this._$6 = clusterFile;
        this._$5 = tmdProxyIds;
        this._$1 = ctx;
    }

    @Override
    public Cluster getCluster() {
        return this._$6.getCluster();
    }

    public ClusterFile getClusterFile() {
        return this._$6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterCursor cursor(ClusterCursor mcs, Expression[] exps, String[] fields, Expression filter, String[] fkNames, Expression[] codeExps, String[] opts, String opt, Context ctx) {
        Cluster cluster = this.getCluster();
        int count = cluster.getUnitCount();
        int[] mcsIds = mcs.getCursorProxyIds();
        if (mcsIds.length != count || !(mcs.getSource() instanceof ClusterPhyTable)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
        }
        String[] expStrs = null;
        if (exps != null) {
            int len = exps.length;
            expStrs = new String[len];
            for (int i = 0; i < len; ++i) {
                if (exps[i] == null) continue;
                expStrs[i] = exps[i].toString();
            }
        }
        int[] cursorProxyIds = new int[count];
        String[] codeExpStrs = null;
        if (codeExps != null) {
            int fkCount = codeExps.length;
            codeExpStrs = new String[fkCount];
            for (int i = 0; i < fkCount; ++i) {
                codeExpStrs[i] = codeExps[i].toString();
            }
        }
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            try {
                UnitCommand command = new UnitCommand(22);
                command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
                command.setAttribute("tmdProxyId", new Integer(this._$5[i]));
                command.setAttribute("cursorProxyId", new Integer(mcsIds[i]));
                command.setAttribute("expStrs", expStrs);
                command.setAttribute("fields", fields);
                command.setAttribute("filter", filter == null ? null : filter.toString());
                command.setAttribute("fkNames", fkNames);
                command.setAttribute("codeExps", codeExpStrs);
                command.setAttribute("opts", opts);
                command.setAttribute("unit", new Integer(i));
                command.setAttribute("opt", opt);
                if (filter != null) {
                    if (codeExps != null) {
                        int fkCount = codeExps.length;
                        Expression[] totalExps = new Expression[fkCount + 1];
                        System.arraycopy(codeExps, 0, totalExps, 0, fkCount);
                        totalExps[fkCount] = filter;
                        IIlllIlIIIIIlllI.setParams(command, totalExps, ctx);
                    } else {
                        IIlllIlIIIIIlllI.setParams(command, filter, ctx);
                    }
                } else if (codeExps != null) {
                    IIlllIlIIIIIlllI.setParams(command, codeExps, ctx);
                }
                Response response = client.send(command);
                Integer id = (Integer)response.checkResult();
                cursorProxyIds[i] = id;
                continue;
            }
            finally {
                client.close();
            }
        }
        ClusterCursor result = new ClusterCursor(this, cursorProxyIds, mcs.isDistributed());
        result.setDistribute(this._$2);
        result.setSortedColNames(this.getAllSortedColNames());
        return result;
    }

    public static Response executeCreateSyncCursor(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer tmdProxyId = (Integer)attributes.get("tmdProxyId");
        Integer mcsId = (Integer)attributes.get("cursorProxyId");
        String[] expStrs = (String[])attributes.get("expStrs");
        String[] fields = (String[])attributes.get("fields");
        String filter = (String)attributes.get("filter");
        String[] fkNames = (String[])attributes.get("fkNames");
        String[] codeExps = (String[])attributes.get("codeExps");
        String[] opts = (String[])attributes.get("opts");
        Integer unit = (Integer)attributes.get("unit");
        String opt = (String)attributes.get("opt");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            PhyTableProxy tmdp = (PhyTableProxy)rm.getProxy(tmdProxyId);
            IPhyTable tableMetaData = tmdp.getTableMetaData();
            CursorProxy cp = (CursorProxy)rm.getProxy(mcsId);
            ICursor mcs = cp.getCursor();
            Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes, "cursor", null);
            Expression exp = filter == null ? null : new Expression(ctx, filter);
            Expression[] exps = null;
            if (expStrs != null) {
                int len = expStrs.length;
                exps = new Expression[len];
                for (int i = 0; i < len; ++i) {
                    exps[i] = new Expression(ctx, expStrs[i]);
                }
            }
            Sequence[] codes = null;
            if (codeExps != null) {
                int fkcount = codeExps.length;
                codes = new Sequence[fkcount];
                for (int i = 0; i < fkcount; ++i) {
                    Expression codeExp = new Expression(ctx, codeExps[i]);
                    Object val = codeExp.calculate(ctx);
                    if (!(val instanceof Sequence)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
                    }
                    codes[i] = (Sequence)val;
                }
            }
            ICursor cursor = mcs instanceof MultipathCursors ? tableMetaData.cursor(exps, fields, exp, fkNames, codes, opts, (MultipathCursors)mcs, opt, ctx) : tableMetaData.cursor(exps, fields, exp, fkNames, codes, opts, opt, ctx);
            CursorProxy proxy = new CursorProxy(cursor, unit);
            rm.addProxy(proxy);
            return new Response(new Integer(proxy.getProxyId()));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterCursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Expression[] codeExps, String[] opts, int segCount, String opt, Context ctx) {
        int i;
        ClusterFile clusterFile = this.getClusterFile();
        int count = clusterFile.getUnitCount();
        int[] cursorProxyIds = new int[count];
        boolean isDistributedFile = clusterFile.isDistributedFile();
        boolean isSeg = !isDistributedFile;
        String[] expStrs = null;
        if (exps != null) {
            int len = exps.length;
            expStrs = new String[len];
            for (i = 0; i < len; ++i) {
                if (exps[i] == null) continue;
                expStrs[i] = exps[i].toString();
            }
        }
        String[] codeExpStrs = null;
        if (codeExps != null) {
            int fkCount = codeExps.length;
            codeExpStrs = new String[fkCount];
            for (int i2 = 0; i2 < fkCount; ++i2) {
                codeExpStrs[i2] = codeExps[i2].toString();
            }
        }
        for (i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(clusterFile.getHost(i), clusterFile.getPort(i));
            try {
                UnitCommand command = new UnitCommand(21);
                command.setAttribute("jobSpaceId", clusterFile.getJobSpaceId());
                command.setAttribute("tmdProxyId", new Integer(this._$5[i]));
                command.setAttribute("expStrs", expStrs);
                command.setAttribute("fields", fields);
                command.setAttribute("filter", filter == null ? null : filter.toString());
                command.setAttribute("fkNames", fkNames);
                command.setAttribute("codeExps", codeExpStrs);
                command.setAttribute("opts", opts);
                command.setAttribute("option", opt);
                command.setAttribute("unit", new Integer(i));
                command.setAttribute("unitCount", new Integer(count));
                command.setAttribute("isSeg", isSeg);
                command.setAttribute("segCount", new Integer(segCount));
                if (filter != null) {
                    if (codeExps != null) {
                        int fkCount = codeExps.length;
                        Expression[] totalExps = new Expression[fkCount + 1];
                        System.arraycopy(codeExps, 0, totalExps, 0, fkCount);
                        totalExps[fkCount] = filter;
                        IIlllIlIIIIIlllI.setParams(command, totalExps, ctx);
                    } else {
                        IIlllIlIIIIIlllI.setParams(command, filter, ctx);
                    }
                } else if (codeExps != null) {
                    IIlllIlIIIIIlllI.setParams(command, codeExps, ctx);
                }
                Response response = client.send(command);
                Integer id = (Integer)response.checkResult();
                cursorProxyIds[i] = id;
                continue;
            }
            finally {
                client.close();
            }
        }
        ClusterCursor result = new ClusterCursor(this, cursorProxyIds, isDistributedFile || isSeg);
        result.setDistribute(this._$2);
        result.setSortedColNames(this.getAllSortedColNames());
        return result;
    }

    public static Response executeCreateCursor(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer tmdProxyId = (Integer)attributes.get("tmdProxyId");
        String[] expStrs = (String[])attributes.get("expStrs");
        String[] fields = (String[])attributes.get("fields");
        String filter = (String)attributes.get("filter");
        String[] fkNames = (String[])attributes.get("fkNames");
        String[] codeExps = (String[])attributes.get("codeExps");
        String[] opts = (String[])attributes.get("opts");
        String opt = (String)attributes.get("option");
        Integer unit = (Integer)attributes.get("unit");
        int unitCount = (Integer)attributes.get("unitCount");
        boolean isSeg = (Boolean)attributes.get("isSeg");
        int segCount = (Integer)attributes.get("segCount");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            PhyTableProxy tmd = (PhyTableProxy)rm.getProxy(tmdProxyId);
            IPhyTable tableMetaData = tmd.getTableMetaData();
            Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes, "cursor", null);
            Expression exp = filter == null ? null : new Expression(ctx, filter);
            Expression[] exps = null;
            if (expStrs != null) {
                int len = expStrs.length;
                exps = new Expression[len];
                for (int i = 0; i < len; ++i) {
                    exps[i] = new Expression(ctx, expStrs[i]);
                }
            }
            Sequence[] codes = null;
            if (codeExps != null) {
                int fkcount = codeExps.length;
                codes = new Sequence[fkcount];
                for (int i = 0; i < fkcount; ++i) {
                    Expression codeExp = new Expression(ctx, codeExps[i]);
                    Object val = codeExp.calculate(ctx);
                    if (!(val instanceof Sequence)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
                    }
                    codes[i] = (Sequence)val;
                }
            }
            if (opt != null && opt.indexOf(109) != -1) {
                if (segCount < 2) {
                    segCount = Env.getCursorParallelNum();
                }
            } else {
                segCount = 1;
            }
            ICursor cursor = isSeg ? tableMetaData.cursor(exps, fields, exp, fkNames, codes, opts, unit + 1, unitCount, segCount, opt, ctx) : (segCount > 1 ? tableMetaData.cursor(exps, fields, exp, fkNames, codes, opts, segCount, opt, ctx) : tableMetaData.cursor(exps, fields, exp, fkNames, codes, opts, opt, ctx));
            CursorProxy proxy = new CursorProxy(cursor, unit);
            rm.addProxy(proxy);
            return new Response(new Integer(proxy.getProxyId()));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    public ClusterMemoryTable memory(String[] fields, Expression filter, String option, Context ctx) {
        int i;
        ClusterFile clusterFile = this.getClusterFile();
        int count = clusterFile.getUnitCount();
        IIIIIlIlIlIlIIIl[] tables = new IIIIIlIlIlIlIIIl[count];
        IlIIIlIlIlllIlll[] jobs = new IlIIIlIlIlllIlll[count];
        ThreadPool pool = TaskManager.getPool();
        for (i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(clusterFile.getHost(i), clusterFile.getPort(i));
            UnitCommand command = new UnitCommand(10);
            command.setAttribute("jobSpaceId", clusterFile.getJobSpaceId());
            command.setAttribute("tmdProxyId", new Integer(this._$5[i]));
            command.setAttribute("fields", fields);
            command.setAttribute("option", option);
            command.setAttribute("filter", filter == null ? null : filter.toString());
            command.setAttribute("unit", new Integer(i));
            IIlllIlIIIIIlllI.setParams(command, filter, ctx);
            jobs[i] = new IlIIIlIlIlllIlll(client, command);
            pool.submit(jobs[i]);
        }
        for (i = 0; i < count; ++i) {
            jobs[i].join();
            tables[i] = (IIIIIlIlIlIlIIIl)jobs[i].getResult();
        }
        ClusterMemoryTable result = new ClusterMemoryTable(this.getCluster(), tables, clusterFile.isDistributedFile());
        result.setDistribute(this._$2);
        result.setSortedColNames(this.getAllSortedColNames());
        return result;
    }

    public static Response executeMemory(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer tmdProxyId = (Integer)attributes.get("tmdProxyId");
        String[] fields = (String[])attributes.get("fields");
        String filter = (String)attributes.get("filter");
        Integer unit = (Integer)attributes.get("unit");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            PhyTableProxy tmdProxy = (PhyTableProxy)rm.getProxy(tmdProxyId);
            IPhyTable tmd = tmdProxy.getTableMetaData();
            Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes);
            Expression exp = filter == null ? null : new Expression(ctx, filter);
            ICursor cursor = tmd.cursor(fields, exp, ctx);
            Sequence seq = cursor.fetch();
            Table table = seq instanceof Table ? (Table)seq : seq.derive("o");
            MemoryTable memoryTable = new MemoryTable(table);
            if (tmd instanceof PhyTable) {
                String distribute = tmd.getDistribute();
                Integer partition = ((PhyTable)tmd).getGroupTable().getPartition();
                if (partition != null) {
                    memoryTable.setDistribute(distribute);
                    memoryTable.setPart(partition);
                }
            }
            TableProxy proxy = new TableProxy(memoryTable, unit);
            rm.addProxy(proxy);
            IIIIIlIlIlIlIIIl rmt = ClusterMemoryTable.newRemoteMemoryTable(proxy.getProxyId(), memoryTable);
            return new Response(rmt);
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterCursor icursor(String[] fields, Expression filter, String iname, String opt, Context ctx) {
        ClusterFile clusterFile = this.getClusterFile();
        int count = clusterFile.getUnitCount();
        int[] cursorProxyIds = new int[count];
        boolean isDistributedFile = clusterFile.isDistributedFile();
        if (!isDistributedFile) {
            count = 1;
        }
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(clusterFile.getHost(i), clusterFile.getPort(i));
            try {
                UnitCommand command = new UnitCommand(23);
                command.setAttribute("jobSpaceId", clusterFile.getJobSpaceId());
                command.setAttribute("tmdProxyId", new Integer(this._$5[i]));
                command.setAttribute("fields", fields);
                command.setAttribute("filter", filter == null ? null : filter.toString());
                command.setAttribute("iname", iname);
                command.setAttribute("opt", opt);
                IIlllIlIIIIIlllI.setParams(command, filter, ctx);
                Response response = client.send(command);
                Integer id = (Integer)response.checkResult();
                cursorProxyIds[i] = id;
                continue;
            }
            finally {
                client.close();
            }
        }
        ClusterCursor result = new ClusterCursor(this, cursorProxyIds, isDistributedFile);
        result.setDistribute(this._$2);
        result.setSortedColNames(this.getAllSortedColNames());
        return result;
    }

    public static Response executeICursor(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer tmdProxyId = (Integer)attributes.get("tmdProxyId");
        String[] fields = (String[])attributes.get("fields");
        String filter = (String)attributes.get("filter");
        String iname = (String)attributes.get("iname");
        String opt = (String)attributes.get("opt");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            PhyTableProxy tmd = (PhyTableProxy)rm.getProxy(tmdProxyId);
            Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes);
            Expression exp = filter == null ? null : new Expression(ctx, filter);
            ICursor cursor = tmd.icursor(fields, exp, iname, opt, ctx);
            CursorProxy proxy = new CursorProxy(cursor, 0);
            rm.addProxy(proxy);
            return new Response(new Integer(proxy.getProxyId()));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterPhyTable getTableMetaData(String tableName) {
        ClusterFile clusterFile = this._$6;
        int count = this._$5.length;
        int[] tableProxyIds = new int[count];
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(clusterFile.getHost(i), clusterFile.getPort(i));
            try {
                UnitCommand command = new UnitCommand(2);
                command.setAttribute("jobSpaceId", clusterFile.getJobSpaceId());
                command.setAttribute("tmdProxyId", new Integer(this._$5[i]));
                command.setAttribute("tableName", tableName);
                Response response = client.send(command);
                Integer id = (Integer)response.checkResult();
                tableProxyIds[i] = id;
                continue;
            }
            finally {
                client.close();
            }
        }
        ClusterPhyTable table = new ClusterPhyTable(clusterFile, tableProxyIds, this._$1);
        table._$1(this._$2);
        return table;
    }

    public static Response executeGetTableMetaData(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer tmdProxyId = (Integer)attributes.get("tmdProxyId");
        String tableName = (String)attributes.get("tableName");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            PhyTableProxy table = (PhyTableProxy)rm.getProxy(tmdProxyId);
            PhyTableProxy proxy = new PhyTableProxy(table.attach(tableName));
            rm.addProxy(proxy);
            return new Response(new Integer(proxy.getProxyId()));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    private void _$2() {
        if (!this._$6.isDistributedFile()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.needDistributed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence[] _$1(Sequence seq, Expression distribute, Context ctx, int unitCount) {
        int size = seq.length();
        Sequence[] groups = new Sequence[unitCount];
        for (int i = 0; i < unitCount; ++i) {
            groups[i] = new Sequence(size / unitCount + 10);
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(seq);
        stack.push(current);
        try {
            for (int i = 1; i <= size; ++i) {
                current.setCurrent(i);
                Object val = distribute.calculate(ctx);
                if (!(val instanceof Number)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("append" + mm.getMessage("function.paramTypeError"));
                }
                int n = ((Number)val).intValue();
                if (n < 1 || n > unitCount) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(n + mm.getMessage("engine.indexOutofBound"));
                }
                Object mem = seq.getMem(i);
                groups[n - 1].add(mem);
            }
        }
        finally {
            stack.pop();
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$1(ICursor cursor, Expression distribute, Context ctx) {
        this._$2 = distribute;
        this._$1 = ctx;
        this._$2();
        Cluster cluster = this.getCluster();
        int unitCount = cluster.getUnitCount();
        UnitClient[] clients = new UnitClient[unitCount];
        int fetchCount = ICursor.FETCHCOUNT * unitCount;
        try {
            Sequence data;
            int[] seqs = new int[unitCount];
            for (int i = 0; i < unitCount; ++i) {
                clients[i] = new UnitClient(cluster.getHost(i), cluster.getPort(i));
                seqs[i] = 0;
            }
            while ((data = cursor.fetch(fetchCount)) != null && data.length() != 0) {
                Sequence[] groups = this._$1(data, distribute, ctx, unitCount);
                for (int i = 0; i < unitCount; ++i) {
                    if (groups[i].length() == 0) continue;
                    UnitCommand command = new UnitCommand(81);
                    command.setAttribute("jobSpaceId", this._$6.getJobSpaceId());
                    command.setAttribute("tmdProxyId", new Integer(this._$5[i]));
                    command.setAttribute("data", groups[i]);
                    command.setAttribute("seq", seqs[i]);
                    Response response = clients[i].send(command);
                    response.checkResult();
                    int n = i;
                    seqs[n] = seqs[n] + 1;
                }
            }
            for (int i = 0; i < unitCount; ++i) {
                UnitCommand command = new UnitCommand(81);
                command.setAttribute("jobSpaceId", this._$6.getJobSpaceId());
                command.setAttribute("tmdProxyId", new Integer(this._$5[i]));
                command.setAttribute("data", null);
                command.setAttribute("seq", seqs[i]);
                Response response = clients[i].send(command);
                response.checkResult();
            }
        }
        finally {
            for (int i = 0; i < unitCount; ++i) {
                if (clients[i] == null) continue;
                clients[i].close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(ICursor cursor) {
        if (this._$2 != null) {
            this._$1(cursor, this._$2, this._$1);
            Cuboid.update(this, this._$1);
            return;
        }
        this._$2();
        Cluster cluster = this.getCluster();
        int unitCount = cluster.getUnitCount();
        if (cursor instanceof ClusterCursor) {
            ClusterCursor cs = (ClusterCursor)cursor;
            if (!cluster.isEquals(cs.getCluster())) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("dw.mcsNotMatch"));
            }
            int[] csProxyIds = cs.getCursorProxyIds();
            for (int i = 0; i < unitCount; ++i) {
                UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
                try {
                    UnitCommand command = new UnitCommand(80);
                    command.setAttribute("jobSpaceId", this._$6.getJobSpaceId());
                    command.setAttribute("tmdProxyId", new Integer(this._$5[i]));
                    command.setAttribute("csProxyId", new Integer(csProxyIds[i]));
                    Response response = client.send(command);
                    response.checkResult();
                    continue;
                }
                finally {
                    client.close();
                }
            }
        } else {
            Object[][] firstKeyValues = new Object[unitCount][];
            String[] keys = null;
            for (int i = 0; i < unitCount; ++i) {
                UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
                try {
                    UnitCommand command = new UnitCommand(82);
                    command.setAttribute("jobSpaceId", this._$6.getJobSpaceId());
                    command.setAttribute("tmdProxyId", new Integer(this._$5[i]));
                    Response response = client.send(command);
                    BaseRecord record = (BaseRecord)response.checkResult();
                    firstKeyValues[i] = record.getFieldValues();
                    if (keys != null) continue;
                    keys = record.dataStruct().getFieldNames();
                    continue;
                }
                finally {
                    client.close();
                }
            }
            Sequence data = cursor.peek(1);
            if (data == null) {
                return;
            }
            block11: for (int i = 0; i < unitCount; ++i) {
                UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
                int seq = 0;
                try {
                    while (true) {
                        data = i == unitCount - 1 ? cursor.fetch(ICursor.FETCHCOUNT) : ClusterPhyTable._$1(cursor, keys, firstKeyValues[i + 1]);
                        UnitCommand command = new UnitCommand(81);
                        command.setAttribute("jobSpaceId", this._$6.getJobSpaceId());
                        command.setAttribute("tmdProxyId", new Integer(this._$5[i]));
                        command.setAttribute("data", data);
                        command.setAttribute("seq", seq);
                        Response response = client.send(command);
                        response.checkResult();
                        if (data == null) continue block11;
                        if (data.length() == 0) {
                            continue block11;
                        }
                        ++seq;
                    }
                }
                finally {
                    client.close();
                }
            }
        }
        Cuboid.update(this, this._$1);
    }

    public static Response executeAppendByCSID(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer tmdProxyId = (Integer)attributes.get("tmdProxyId");
        Integer csProxyId = (Integer)attributes.get("csProxyId");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            PhyTableProxy tmd = (PhyTableProxy)rm.getProxy(tmdProxyId);
            CursorProxy csProxy = (CursorProxy)rm.getProxy(csProxyId);
            tmd.getTableMetaData().append(csProxy.getCursor());
            return new Response();
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    public static Response executeGetFirstKeyValue(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer tmdProxyId = (Integer)attributes.get("tmdProxyId");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            PhyTableProxy tmd = (PhyTableProxy)rm.getProxy(tmdProxyId);
            IPhyTable table = tmd.getTableMetaData();
            ICursor cursor = table.cursor(table.getAllSortedColNames());
            Sequence seq = cursor.peek(1);
            if (seq == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("dw.needClusterCursor"));
            }
            cursor.close();
            BaseRecord record = (BaseRecord)seq.get(1);
            return new Response(record);
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    public static Response executeAppendByData(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer tmdProxyId = (Integer)attributes.get("tmdProxyId");
        Sequence data = (Sequence)attributes.get("data");
        int seq = (Integer)attributes.get("seq");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            PhyTableProxy tmd = (PhyTableProxy)rm.getProxy(tmdProxyId);
            Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes);
            if (seq == 0) {
                tmd.createTempFile();
            }
            FileObject fo = tmd.getTempFile();
            if (data == null || data.length() == 0) {
                BFileCursor bfc = new BFileCursor(fo, null, "x", ctx);
                tmd.getTableMetaData().append(bfc);
            } else {
                fo.exportSeries(data, "ab", null);
            }
            return new Response();
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    private static Sequence _$1(ICursor cursor, String[] names, Object[] vals) {
        Sequence seq = cursor.peek(ICursor.FETCHCOUNT);
        if (seq == null || seq.length() == 0) {
            return null;
        }
        int fcount = names.length;
        int[] findex = new int[fcount];
        DataStruct ds = ((BaseRecord)seq.getMem(1)).dataStruct();
        for (int f = 0; f < fcount; ++f) {
            findex[f] = ds.getFieldIndex(names[f]);
            if (findex[f] != -1) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(names[f] + mm.getMessage("ds.fieldNotExist"));
        }
        Object[] curVals = new Object[fcount];
        int len = seq.length();
        for (int i = 1; i <= len; ++i) {
            BaseRecord r = (BaseRecord)seq.getMem(i);
            for (int f = 0; f < fcount; ++f) {
                curVals[f] = r.getNormalFieldValue(findex[f]);
            }
            if (Variant.compareArrays(curVals, vals) < 0) continue;
            if (i == 1) {
                return null;
            }
            return cursor.fetch(i - 1);
        }
        cursor.skip(ICursor.FETCHCOUNT);
        return seq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence update(Sequence data, String opt) {
        if (data == null || data.length() == 0) {
            return null;
        }
        this._$2();
        Sequence result = new Sequence();
        Cluster cluster = this.getCluster();
        int unitCount = cluster.getUnitCount();
        if (this._$2 != null) {
            Sequence[] groups = this._$1(data, this._$2, this._$1, unitCount);
            for (int i = 0; i < unitCount; ++i) {
                UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
                try {
                    if (groups[i] == null || groups[i].length() == 0) continue;
                    UnitCommand command = new UnitCommand(83);
                    command.setAttribute("jobSpaceId", this._$6.getJobSpaceId());
                    command.setAttribute("tmdProxyId", new Integer(this._$5[i]));
                    command.setAttribute("data", groups[i]);
                    command.setAttribute("opt", opt);
                    Response response = client.send(command);
                    Sequence seq = (Sequence)response.checkResult();
                    if (seq == null || seq.length() == 0) continue;
                    result.addAll(seq);
                    continue;
                }
                finally {
                    client.close();
                }
            }
        } else {
            Object[][] firstKeyValues = new Object[unitCount][];
            String[] keys = null;
            for (int i = 0; i < unitCount; ++i) {
                UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
                try {
                    UnitCommand command = new UnitCommand(82);
                    command.setAttribute("jobSpaceId", this._$6.getJobSpaceId());
                    command.setAttribute("tmdProxyId", new Integer(this._$5[i]));
                    Response response = client.send(command);
                    BaseRecord record = (BaseRecord)response.checkResult();
                    firstKeyValues[i] = record.getFieldValues();
                    if (keys != null) continue;
                    keys = record.dataStruct().getFieldNames();
                    continue;
                }
                finally {
                    client.close();
                }
            }
            data.sortFields(keys);
            MemoryCursor cursor = new MemoryCursor(data);
            for (int i = 0; i < unitCount; ++i) {
                UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
                try {
                    data = i == unitCount - 1 ? cursor.fetch(ICursor.FETCHCOUNT) : ClusterPhyTable._$1(cursor, keys, firstKeyValues[i + 1]);
                    if (data == null) continue;
                    UnitCommand command = new UnitCommand(83);
                    command.setAttribute("jobSpaceId", this._$6.getJobSpaceId());
                    command.setAttribute("tmdProxyId", new Integer(this._$5[i]));
                    command.setAttribute("data", data);
                    command.setAttribute("opt", opt);
                    Response response = client.send(command);
                    Sequence seq = (Sequence)response.checkResult();
                    if (seq == null || seq.length() == 0) continue;
                    result.addAll(seq);
                    continue;
                }
                finally {
                    client.close();
                }
            }
        }
        return result;
    }

    public static Response executeUpdate(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer tmdProxyId = (Integer)attributes.get("tmdProxyId");
        Sequence data = (Sequence)attributes.get("data");
        String opt = (String)attributes.get("opt");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            PhyTableProxy tmd = (PhyTableProxy)rm.getProxy(tmdProxyId);
            Sequence result = tmd.getTableMetaData().update(data, opt);
            return new Response(result);
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence delete(Sequence data, String opt) {
        this._$2();
        Cluster cluster = this.getCluster();
        int unitCount = cluster.getUnitCount();
        Sequence result = new Sequence();
        if (data == null || data.length() == 0) {
            return null;
        }
        for (int i = 0; i < unitCount; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            try {
                UnitCommand command = new UnitCommand(84);
                command.setAttribute("jobSpaceId", this._$6.getJobSpaceId());
                command.setAttribute("tmdProxyId", new Integer(this._$5[i]));
                command.setAttribute("data", data);
                command.setAttribute("opt", opt);
                Response response = client.send(command);
                Sequence seq = (Sequence)response.checkResult();
                if (seq == null || seq.length() == 0) continue;
                result.addAll(seq);
                continue;
            }
            finally {
                client.close();
            }
        }
        return result;
    }

    public static Response executeDelete(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer tmdProxyId = (Integer)attributes.get("tmdProxyId");
        Sequence data = (Sequence)attributes.get("data");
        String opt = (String)attributes.get("opt");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            PhyTableProxy tmd = (PhyTableProxy)rm.getProxy(tmdProxyId);
            Sequence result = tmd.getTableMetaData().delete(data, opt);
            return new Response(result);
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence deleteIndex(String indexName) {
        Sequence result = new Sequence();
        this._$2();
        Cluster cluster = this.getCluster();
        int unitCount = cluster.getUnitCount();
        for (int i = 0; i < unitCount; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            try {
                UnitCommand command = new UnitCommand(85);
                command.setAttribute("jobSpaceId", this._$6.getJobSpaceId());
                command.setAttribute("tmdProxyId", new Integer(this._$5[i]));
                command.setAttribute("indexName", indexName);
                Response response = client.send(command);
                Object val = response.checkResult();
                result.add(val);
                continue;
            }
            finally {
                client.close();
            }
        }
        return result;
    }

    public static Response executeDeleteIndex(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer tmdProxyId = (Integer)attributes.get("tmdProxyId");
        String indexName = (String)attributes.get("indexName");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            PhyTableProxy tmd = (PhyTableProxy)rm.getProxy(tmdProxyId);
            boolean result = tmd.getTableMetaData().deleteIndex(indexName);
            return new Response(new Boolean(result));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIndex(String I, String[] fields, Object obj, String opt, Expression w) {
        this._$2();
        Cluster cluster = this.getCluster();
        int unitCount = cluster.getUnitCount();
        for (int i = 0; i < unitCount; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            try {
                UnitCommand command = new UnitCommand(86);
                command.setAttribute("jobSpaceId", this._$6.getJobSpaceId());
                command.setAttribute("tmdProxyId", new Integer(this._$5[i]));
                command.setAttribute("I", I);
                command.setAttribute("fields", fields);
                command.setAttribute("obj", obj);
                command.setAttribute("opt", opt);
                if (w != null) {
                    command.setAttribute("w", w.toString());
                }
                Response response = client.send(command);
                response.checkResult();
                continue;
            }
            finally {
                client.close();
            }
        }
    }

    public static Response executeCreateIndex(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer tmdProxyId = (Integer)attributes.get("tmdProxyId");
        String I = (String)attributes.get("I");
        String[] fields = (String[])attributes.get("fields");
        Object obj = attributes.get("obj");
        String opt = (String)attributes.get("opt");
        String exp = (String)attributes.get("w");
        try {
            Expression w;
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            PhyTableProxy tmd = (PhyTableProxy)rm.getProxy(tmdProxyId);
            PhyTable table = (PhyTable)tmd.getTableMetaData();
            Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes);
            Expression expression = w = exp == null ? null : new Expression(ctx, exp);
            if (obj == null) {
                if (opt != null) {
                    if (opt.indexOf(119) != -1) {
                        TableFulltextIndex index = new TableFulltextIndex(table, I);
                        index.create(fields, opt, ctx, w);
                    } else {
                        FileObject indexFile = null;
                        String dir = table.getGroupTable().getFile().getAbsolutePath() + "_";
                        if (I != null && (indexFile = new FileObject(dir + table.getTableName() + "_" + I)).isExists()) {
                            ITableIndex index = table.getTableMetaDataIndex(indexFile, I, true);
                            if (opt.indexOf(50) != -1) {
                                index.loadAllBlockInfo();
                            } else if (opt.indexOf(51) != -1) {
                                index.loadAllKeys();
                            } else if (opt.indexOf(48) != -1) {
                                index.unloadAllBlockInfo();
                            }
                        }
                    }
                } else {
                    PhyTableIndex index = new PhyTableIndex(table, I);
                    index.create(fields, opt, ctx, w);
                }
            } else if (obj instanceof String[]) {
                TableKeyValueIndex index = new TableKeyValueIndex(table, I);
                index.create(fields, (String[])obj, opt, ctx, w);
            } else if (obj instanceof Integer) {
                TableHashIndex index = new TableHashIndex(table, I, (int)((Integer)obj));
                index.create(fields, opt, ctx, w);
            }
            return new Response();
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllSortedColNames() {
        if (this._$3 != null) {
            return this._$3;
        }
        Cluster cluster = this.getCluster();
        UnitClient client = new UnitClient(cluster.getHost(0), cluster.getPort(0));
        try {
            UnitCommand command = new UnitCommand(88);
            command.setAttribute("jobSpaceId", this._$6.getJobSpaceId());
            command.setAttribute("tmdProxyId", new Integer(this._$5[0]));
            Response response = client.send(command);
            this._$3 = (String[])response.checkResult();
            String[] stringArray = this._$3;
            return stringArray;
        }
        finally {
            client.close();
        }
    }

    public static Response executeGetPkey(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer tmdProxyId = (Integer)attributes.get("tmdProxyId");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            PhyTableProxy tmd = (PhyTableProxy)rm.getProxy(tmdProxyId);
            IPhyTable table = tmd.getTableMetaData();
            String[] pkeys = table.getAllSortedColNames();
            return new Response(pkeys);
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllColNames() {
        if (this._$4 != null) {
            return this._$4;
        }
        Cluster cluster = this.getCluster();
        UnitClient client = new UnitClient(cluster.getHost(0), cluster.getPort(0));
        try {
            UnitCommand command = new UnitCommand(91);
            command.setAttribute("jobSpaceId", this._$6.getJobSpaceId());
            command.setAttribute("tmdProxyId", new Integer(this._$5[0]));
            Response response = client.send(command);
            this._$4 = (String[])response.checkResult();
            String[] stringArray = this._$4;
            return stringArray;
        }
        finally {
            client.close();
        }
    }

    public static Response executeGetAllColNames(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer tmdProxyId = (Integer)attributes.get("tmdProxyId");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            PhyTableProxy tmd = (PhyTableProxy)rm.getProxy(tmdProxyId);
            IPhyTable table = tmd.getTableMetaData();
            String[] names = table.getAllColNames();
            return new Response(names);
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    Expression _$1() {
        return this._$2;
    }

    void _$1(Expression distribute) {
        this._$2 = distribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterCursor news(Expression[] exps, String[] fields, Object cursor2, String[] csNames, int type, String option, Expression filter, String[] fkNames, Sequence[] codes, String[] opts) {
        Cluster cluster = this.getCluster();
        int unitCount = cluster.getUnitCount();
        Boolean isSeq = false;
        ClusterCursor cs = null;
        ClusterMemoryTable cmt = null;
        if (cursor2 instanceof ClusterCursor) {
            cs = (ClusterCursor)cursor2;
            if (!cluster.isEquals(cs.getCluster())) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("dw.mcsNotMatch"));
            }
        } else if (cursor2 instanceof ClusterMemoryTable) {
            cmt = (ClusterMemoryTable)cursor2;
            isSeq = true;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.mcsNotMatch"));
        }
        int len = exps.length;
        String[] expStrs = new String[len];
        for (int i = 0; i < len; ++i) {
            expStrs[i] = exps[i].toString();
        }
        String filterStr = filter == null ? null : filter.toString();
        int[] newCursorProxyIds = new int[unitCount];
        int[] cs2ProxyIds = isSeq != false ? cmt.getProxyIds() : cs.getCursorProxyIds();
        for (int i = 0; i < unitCount; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            try {
                UnitCommand command = new UnitCommand(89);
                command.setAttribute("jobSpaceId", this._$6.getJobSpaceId());
                command.setAttribute("tmdProxyId", new Integer(this._$5[i]));
                command.setAttribute("expStrs", expStrs);
                command.setAttribute("fields", fields);
                command.setAttribute("type", new Integer(type));
                command.setAttribute("option", option);
                command.setAttribute("filterStr", filterStr);
                command.setAttribute("fkNames", fkNames);
                command.setAttribute("codes", codes);
                command.setAttribute("opts", opts);
                command.setAttribute("unit", new Integer(i));
                command.setAttribute("isSeq", isSeq);
                command.setAttribute("cs2ProxyId", new Integer(cs2ProxyIds[i]));
                command.setAttribute("csNames", csNames);
                Response response = client.send(command);
                Integer id = (Integer)response.checkResult();
                newCursorProxyIds[i] = id;
                continue;
            }
            finally {
                client.close();
            }
        }
        return new ClusterCursor(cluster, newCursorProxyIds, true);
    }

    public static Response executeNews(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer tmdProxyId = (Integer)attributes.get("tmdProxyId");
        String[] expStrs = (String[])attributes.get("expStrs");
        String[] fields = (String[])attributes.get("fields");
        Integer type = (Integer)attributes.get("type");
        String option = (String)attributes.get("option");
        String filterStr = (String)attributes.get("filterStr");
        String[] fkNames = (String[])attributes.get("fkNames");
        Sequence[] codes = (Sequence[])attributes.get("codes");
        String[] opts = (String[])attributes.get("opts");
        Integer unit = (Integer)attributes.get("unit");
        Boolean isSeq = (Boolean)attributes.get("isSeq");
        Integer cs2ProxyId = (Integer)attributes.get("cs2ProxyId");
        String[] csNames = (String[])attributes.get("csNames");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes);
            int count = expStrs.length;
            Expression[] exps = new Expression[count];
            for (int f = 0; f < count; ++f) {
                exps[f] = new Expression(ctx, expStrs[f]);
            }
            Expression filter = filterStr == null ? null : new Expression(ctx, filterStr);
            ResourceManager rm = js.getResourceManager();
            PhyTableProxy tmd = (PhyTableProxy)rm.getProxy(tmdProxyId);
            ICursor cursor = null;
            if (isSeq.booleanValue()) {
                TableProxy tableProxy = (TableProxy)rm.getProxy(cs2ProxyId);
                cursor = new MemoryCursor(tableProxy.getTable());
            } else {
                CursorProxy cs2Proxy = (CursorProxy)rm.getProxy(cs2ProxyId);
                cursor = cs2Proxy.getCursor();
            }
            if (cursor instanceof MultipathCursors) {
                MultipathCursors mcursor = (MultipathCursors)cursor;
                ICursor[] cursors = mcursor.getCursors();
                int pathCount = cursors.length;
                for (int i = 0; i < pathCount; ++i) {
                    Expression w = null;
                    if (filter != null) {
                        w = filter.newExpression(ctx);
                    }
                    JoinCursor cs = new JoinCursor(tmd.getTableMetaData(), exps, fields, cursors[i], csNames, (int)(type | 0x10), option, w, fkNames, codes, opts, ctx);
                    cursors[i] = cs;
                }
                cursor = new MultipathCursors(cursors, ctx);
            } else {
                cursor = new JoinCursor(tmd.getTableMetaData(), exps, fields, cursor, csNames, type, option, filter, fkNames, codes, opts, ctx);
            }
            CursorProxy proxy = new CursorProxy(cursor, unit);
            rm.addProxy(proxy);
            return new Response(new Integer(proxy.getProxyId()));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Cluster cluster = this._$6.getCluster();
        int count = cluster.getUnitCount();
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            try {
                UnitCommand command = new UnitCommand(4);
                command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
                command.setAttribute("tmdProxyId", this._$5[i]);
                client.send(command);
                continue;
            }
            finally {
                client.close();
            }
        }
    }

    public static Response executeCloseGroupTable(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer tmdProxyId = (Integer)attributes.get("tmdProxyId");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            PhyTableProxy tmd = (PhyTableProxy)rm.getProxy(tmdProxyId);
            tmd.close();
            return new Response();
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence cgroups(String[] expNames, String[] names, String[] newExpNames, String[] newNames, Expression w, boolean hasM, int n, String option, Context ctx) {
        ClusterFile clusterFile = this.getClusterFile();
        int count = clusterFile.getUnitCount();
        Sequence result = null;
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(clusterFile.getHost(i), clusterFile.getPort(i));
            try {
                UnitCommand command = new UnitCommand(90);
                command.setAttribute("jobSpaceId", clusterFile.getJobSpaceId());
                command.setAttribute("tmdProxyId", new Integer(this._$5[i]));
                command.setAttribute("expNames", expNames);
                command.setAttribute("names", names);
                command.setAttribute("newExpNames", newExpNames);
                command.setAttribute("newNames", newNames);
                command.setAttribute("w", w == null ? null : w.toString());
                command.setAttribute("hasM", new Boolean(hasM));
                command.setAttribute("n", new Integer(n));
                command.setAttribute("option", option);
                IIlllIlIIIIIlllI.setParams(command, w, ctx);
                Response response = client.send(command);
                if (result == null) {
                    result = (Sequence)response.checkResult();
                    continue;
                }
                result.addAll((Sequence)response.checkResult());
                continue;
            }
            finally {
                client.close();
            }
        }
        return result;
    }

    public static Response executeCgroups(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer tmdProxyId = (Integer)attributes.get("tmdProxyId");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            PhyTableProxy tmd = (PhyTableProxy)rm.getProxy(tmdProxyId);
            PhyTable srcTable = (PhyTable)tmd.getTableMetaData();
            Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes);
            String[] expNames = (String[])attributes.get("expNames");
            String[] names = (String[])attributes.get("names");
            String[] newExpNames = (String[])attributes.get("newExpNames");
            String[] newNames = (String[])attributes.get("newNames");
            String w = (String)attributes.get("w");
            Expression exp = w == null ? null : new Expression(ctx, w);
            Boolean hasM = (Boolean)attributes.get("hasM");
            Integer n = (Integer)attributes.get("n");
            String option = (String)attributes.get("option");
            Sequence result = Cuboid.cgroups(expNames, names, newExpNames, newNames, srcTable, exp, (boolean)hasM, (int)n, option, ctx);
            return new Response(result);
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseRecord getStructure() {
        ClusterFile clusterFile = this.getClusterFile();
        BaseRecord result = null;
        UnitClient client = new UnitClient(clusterFile.getHost(0), clusterFile.getPort(0));
        try {
            UnitCommand command = new UnitCommand(92);
            command.setAttribute("jobSpaceId", clusterFile.getJobSpaceId());
            command.setAttribute("tmdProxyId", new Integer(this._$5[0]));
            Response response = client.send(command);
            result = (BaseRecord)response.checkResult();
        }
        finally {
            client.close();
        }
        return result;
    }

    public static Response executeGetStructure(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer tmdProxyId = (Integer)attributes.get("tmdProxyId");
        String opt = (String)attributes.get("opt");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            PhyTableProxy tmd = (PhyTableProxy)rm.getProxy(tmdProxyId);
            IPhyTable table = tmd.getTableMetaData();
            return new Response(Structure.getTableStruct((PhyTable)table, opt));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }
}

