/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.parallel;

import com.scudata.common.Logger;
import com.scudata.dm.FileObject;
import com.scudata.dm.RandomOutputStream;
import com.scudata.parallel.RemoteFileProxyManager;
import java.io.IOException;
import java.io.InputStream;

public class RemoteFileProxy {
    String _$9;
    InputStream _$8;
    RandomOutputStream _$7;
    int _$6 = -1;
    Integer _$5 = null;
    boolean _$4 = false;
    private long _$3 = -1L;
    private long _$2 = -1L;
    byte[] _$1 = null;

    public RemoteFileProxy(String fileName, Integer partition, int id, Boolean isAppend) {
        this._$9 = fileName;
        this._$5 = partition;
        this._$6 = id;
        if (isAppend != null) {
            this._$4 = isAppend;
        }
        this._$3();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("RemoteFileProxy " + this._$9 + " id:" + this._$6);
        return sb.toString();
    }

    int _$4() {
        return this._$6;
    }

    void _$3() {
        this._$3 = System.currentTimeMillis();
    }

    public void setReadPosition(long rp) {
        this._$2 = rp;
    }

    public byte[] read(int bufSize) throws Exception {
        byte[] buf2;
        int n;
        int count;
        if (this._$1 == null) {
            this._$1 = new byte[bufSize];
        }
        InputStream is = this._$2();
        int len = bufSize;
        for (n = 0; n < len && (count = is.read(this._$1, n, len - n)) >= 0; n += count) {
        }
        len = n;
        if (len <= 0) {
            buf2 = new byte[]{};
        } else if (len != bufSize) {
            buf2 = new byte[len];
            System.arraycopy(this._$1, 0, buf2, 0, len);
        } else {
            buf2 = this._$1;
        }
        this._$3();
        return buf2;
    }

    public void write(byte[] bytes) throws Exception {
        RandomOutputStream os = this._$1();
        os.write(bytes);
        this._$3();
    }

    public void setPosition(long posi) throws IOException {
        RandomOutputStream os = this._$1();
        os.position(posi);
    }

    public long position() throws IOException {
        RandomOutputStream os = this._$1();
        return os.position();
    }

    private InputStream _$2() throws Exception {
        if (this._$8 == null) {
            if (this._$2 != -1L && this._$7 != null) {
                this._$8 = this._$7.getInputStream(this._$2);
            } else {
                FileObject fo = new FileObject(this._$9);
                fo.setPartition(this._$5);
                if (!fo.isExists()) {
                    String msg = this._$9;
                    msg = msg + " is not exist.";
                    Logger.debug(msg);
                    throw new Exception(msg);
                }
                this._$8 = fo.getInputStream();
            }
        }
        return this._$8;
    }

    private RandomOutputStream _$1() {
        if (this._$7 == null) {
            FileObject fo = new FileObject(this._$9);
            fo.setPartition(this._$5);
            this._$7 = fo.getRandomOutputStream(this._$4);
        }
        return this._$7;
    }

    public boolean tryLock() throws Exception {
        return this._$1().tryLock();
    }

    public boolean lock() throws Exception {
        return this._$1().lock();
    }

    public void close() {
        this.destroy();
        RemoteFileProxyManager.delProxy(this._$6);
    }

    public void destroy() {
        if (this._$8 != null) {
            try {
                this._$8.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (this._$7 != null) {
            try {
                this._$7.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean checkTimeOut(int timeOut) {
        if ((System.currentTimeMillis() - this._$3) / 1000L > (long)timeOut) {
            Logger.info(this + " is timeout.");
            this.destroy();
            return true;
        }
        return false;
    }
}

