/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.parallel;

import com.scudata.common.Logger;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.parallel.RemoteFileProxy;
import com.scudata.parallel.Request;
import com.scudata.parallel.Response;
import com.scudata.parallel.SocketData;
import com.scudata.server.unit.UnitServer;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteFileProxyManager {
    static ArrayList<RemoteFileProxy> _$1 = new ArrayList();

    public static ArrayList<RemoteFileProxy> getFileProxys() {
        return _$1;
    }

    public static Response execute(Request req, SocketData sd) {
        Response res = new Response();
        try {
            switch (req.getAction()) {
                case 30003: {
                    String fileName = (String)req.getAttr("File name");
                    Integer partition = (Integer)req.getAttr("Partition");
                    int id = UnitServer.nextId();
                    String opt = (String)req.getAttr("Opt");
                    if (opt != null && (opt = opt.toLowerCase()).indexOf(116) >= 0) {
                        fileName = new File(Env.getTempPath(), fileName).getPath();
                    }
                    Boolean isAppend = (Boolean)req.getAttr("Is append");
                    RemoteFileProxy rfp = new RemoteFileProxy(fileName, partition, id, isAppend);
                    RemoteFileProxyManager.addProxy(rfp);
                    res.setResult(new Integer(id));
                    break;
                }
                case 30010: {
                    int id = (Integer)req.getAttr("From handle");
                    long rpos = (Long)req.getAttr("From position");
                    RemoteFileProxy rfp = RemoteFileProxyManager.getProxy(id);
                    rfp.setReadPosition(rpos);
                    res.setResult(new Integer(id));
                    break;
                }
                case 30001: {
                    String fileName = (String)req.getAttr("File name");
                    String op = (String)req.getAttr("Opt");
                    if (op != null && (op = op.toLowerCase()).indexOf(116) >= 0) {
                        fileName = new File(Env.getTempPath(), fileName).getPath();
                    }
                    FileObject fo = new FileObject(fileName);
                    HashMap<String, Comparable<Boolean>> properties = new HashMap<String, Comparable<Boolean>>();
                    properties.put("exists", new Boolean(fo.isExists()));
                    properties.put("lastModified", new Long(fo.getFile().lastModified()));
                    properties.put("size", new Long(fo.size()));
                    res.setResult(properties);
                    break;
                }
                case 30002: {
                    String fileName = (String)req.getAttr("File name");
                    FileObject fo = new FileObject(fileName);
                    boolean b = fo.delete();
                    Logger.debug("Delete file " + fileName + ": " + b);
                    res.setResult(new Boolean(b));
                    break;
                }
                case 30004: {
                    int id = ((Number)req.getAttr("handle")).intValue();
                    RemoteFileProxy rfp = RemoteFileProxyManager.getProxy(id);
                    int bufSize = ((Number)req.getAttr("Buffer size")).intValue();
                    try {
                        byte[] result = rfp.read(bufSize);
                        res.setResult(result);
                    }
                    catch (Exception x) {
                        res.setException(x);
                    }
                    break;
                }
                case 30006: {
                    int id = ((Number)req.getAttr("handle")).intValue();
                    RemoteFileProxy rfp = RemoteFileProxyManager.getProxy(id);
                    byte[] bytes = (byte[])req.getAttr("bytes");
                    try {
                        rfp.write(bytes);
                    }
                    catch (Exception x) {
                        res.setException(x);
                    }
                    break;
                }
                case 30005: {
                    int id = ((Number)req.getAttr("handle")).intValue();
                    RemoteFileProxy rfp = RemoteFileProxyManager.getProxy(id);
                    rfp.close();
                    break;
                }
                case 30007: {
                    int id = ((Number)req.getAttr("handle")).intValue();
                    RemoteFileProxy rfp = RemoteFileProxyManager.getProxy(id);
                    Long result = rfp.position();
                    res.setResult(result);
                    break;
                }
                case 30008: {
                    int id = ((Number)req.getAttr("handle")).intValue();
                    RemoteFileProxy rfp = RemoteFileProxyManager.getProxy(id);
                    long pos = ((Number)req.getAttr("position")).longValue();
                    rfp.setPosition(pos);
                    break;
                }
                case 30009: {
                    int id = ((Number)req.getAttr("handle")).intValue();
                    RemoteFileProxy rfp = RemoteFileProxyManager.getProxy(id);
                    boolean isLock = rfp.tryLock();
                    res.setResult(new Boolean(isLock));
                    break;
                }
                case 30011: {
                    int id = ((Number)req.getAttr("handle")).intValue();
                    RemoteFileProxy rfp = RemoteFileProxyManager.getProxy(id);
                    boolean lock = rfp.lock();
                    res.setResult(new Boolean(lock));
                    break;
                }
                case 30100: {
                    String fileName = (String)req.getAttr("fileName");
                    Integer partition = (Integer)req.getAttr("partition");
                    FileObject fo = new FileObject(fileName);
                    fo.setPartition(partition);
                    InputStream is = fo.getInputStream();
                    byte[] fileBuf = RemoteFileProxyManager.read(is, Env.FILE_BUFSIZE);
                    sd.write(fileBuf);
                    while (fileBuf != null) {
                        fileBuf = RemoteFileProxyManager.read(is, Env.FILE_BUFSIZE);
                        sd.write(fileBuf);
                    }
                    is.close();
                    res.setResult(Boolean.TRUE);
                }
            }
        }
        catch (Exception x) {
            Logger.debug(x);
            res.setException(x);
        }
        return res;
    }

    public static byte[] read(InputStream is, int size) throws Exception {
        byte[] buf2;
        byte[] buf = new byte[size];
        int len = is.read(buf);
        if (len <= 0) {
            buf2 = null;
        } else if (len != size) {
            buf2 = new byte[len];
            System.arraycopy(buf, 0, buf2, 0, len);
        } else {
            buf2 = buf;
        }
        return buf2;
    }

    public static synchronized void addProxy(RemoteFileProxy rfp) {
        _$1.add(rfp);
    }

    public static synchronized void delProxy(int proxyID) {
        for (int i = 0; i < _$1.size(); ++i) {
            RemoteFileProxy rfp = _$1.get(i);
            if (rfp._$4() != proxyID) continue;
            _$1.remove(i);
            break;
        }
    }

    public static synchronized RemoteFileProxy getProxy(int proxyId) throws Exception {
        for (int i = 0; i < _$1.size(); ++i) {
            RemoteFileProxy rfp = _$1.get(i);
            if (rfp._$4() != proxyId) continue;
            return rfp;
        }
        throw new Exception("Remote file id:" + proxyId + " is timeout.");
    }

    public static synchronized void checkTimeOut(int proxyTimeOut) {
        for (int i = _$1.size() - 1; i >= 0; --i) {
            RemoteFileProxy rft = _$1.get(i);
            if (!rft.checkTimeOut(proxyTimeOut)) continue;
            _$1.remove(rft);
        }
    }
}

