/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.parallel;

import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.CellLocation;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.CanceledException;
import com.scudata.dm.Context;
import com.scudata.dm.DfxManager;
import com.scudata.dm.FileObject;
import com.scudata.dm.IResource;
import com.scudata.dm.JobSpace;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.ParallelCaller;
import com.scudata.dm.ParallelProcess;
import com.scudata.dm.RetryException;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.parallel.HostManager;
import com.scudata.parallel.ITask;
import com.scudata.parallel.RemoteCursor;
import com.scudata.parallel.RemoteCursorProxy;
import com.scudata.parallel.RemoteCursorProxyManager;
import com.scudata.parallel.Response;
import com.scudata.parallel.TaskManager;
import com.scudata.parallel.UnitContext;
import com.scudata.resources.ParallelMessage;
import com.scudata.server.odbc.OdbcServer;
import com.scudata.server.unit.JdbcTask;
import com.scudata.server.unit.UnitServer;
import com.scudata.thread.Job;
import com.scudata.util.CellSetUtil;
import com.scudata.util.DatabaseUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class Task
extends Job
implements IResource,
ITask {
    Object _$23;
    boolean _$22 = false;
    ArrayList _$21;
    String _$20;
    boolean _$19 = false;
    Object _$18;
    CellLocation _$17;
    CellLocation _$16;
    int _$15 = 0;
    int _$14 = -1;
    long _$13 = -1L;
    long _$12 = -1L;
    RemoteCursorProxyManager _$11 = null;
    transient Object _$10 = null;
    transient boolean _$9 = false;
    transient Response _$8 = null;
    private long _$7 = -1L;
    private static List _$6 = null;
    private String _$5 = null;
    transient Context _$4;
    MessageManager _$3 = ParallelMessage.get();
    long _$2 = 0L;
    boolean _$1 = false;

    public Task(Object dfxName, List argList, int taskId, String spaceId) {
        this._$23 = dfxName;
        this._$21 = (ArrayList)argList;
        this._$14 = taskId;
        this._$20 = spaceId;
        JobSpaceManager.getSpace(spaceId).getResourceManager().add(this);
    }

    public Task(Object dfxName, List argList, int taskId, String spaceId, boolean isProcessCaller, Object reduce, CellLocation accumulateLocation, CellLocation currentLocation) {
        this(dfxName, argList, taskId, spaceId);
        this._$19 = isProcessCaller;
        this._$18 = reduce;
        this._$17 = accumulateLocation;
        this._$16 = currentLocation;
    }

    public void setProcessTaskId(int id) {
        this._$15 = id;
    }

    public static void setConnectedDsNames(List dsNames) {
        _$6 = dsNames;
    }

    public void access() {
        this._$7 = System.currentTimeMillis();
    }

    public void resetAccess() {
        this._$7 = -1L;
    }

    public void destroy() {
        if (this._$11 != null) {
            this._$11.destroy();
            this._$11 = null;
        }
        DatabaseUtil.closeAutoDBs(this._$4);
        this._$1 = true;
    }

    private void _$3() {
        this._$13 = System.currentTimeMillis();
    }

    public RemoteCursorProxyManager getCursorManager() {
        if (this._$11 == null) {
            this._$11 = new RemoteCursorProxyManager(this);
        }
        return this._$11;
    }

    public boolean isRunning() {
        return this._$10 != null;
    }

    public static ICursor toCursor(Object result) {
        Object[] values;
        String[] fields;
        if (result instanceof Sequence) {
            Sequence t = (Sequence)result;
            if (t.length() > 0) {
                MemoryCursor mc = new MemoryCursor(t);
                return mc;
            }
            result = "";
        }
        if (result instanceof ICursor) {
            return (ICursor)result;
        }
        if (result instanceof BaseRecord) {
            BaseRecord rec = (BaseRecord)result;
            fields = rec.getFieldNames();
            values = rec.getFieldValues();
        } else {
            fields = new String[]{"_1"};
            values = new Object[]{result};
        }
        Table table = new Table(fields);
        table.newLast(values);
        MemoryCursor mc = new MemoryCursor(table);
        return mc;
    }

    public ICursor[] executeOdbc() throws Exception {
        Object obj = this._$1(true);
        if (obj instanceof Response) {
            Response res = (Response)obj;
            if (res.getError() != null) {
                throw res.getError();
            }
            if (res.getException() != null) {
                throw res.getException();
            }
            return null;
        }
        Sequence results = (Sequence)obj;
        int size = results.length();
        ICursor[] cursors = new ICursor[size];
        for (int i = 1; i <= size; ++i) {
            cursors[i - 1] = Task.toCursor(results.get(i));
        }
        return cursors;
    }

    public Response execute() {
        Object obj = this._$1(false);
        if (obj instanceof Response) {
            return (Response)obj;
        }
        Response res = new Response();
        res.setResult(obj);
        return res;
    }

    private Exception _$2() {
        if (this._$5 != null) {
            MessageManager mm = ParallelMessage.get();
            String status = mm.getMessage("Task.cancel", this, this._$5);
            if (this._$5.equalsIgnoreCase(CanceledException.TYPE_MONITOR)) {
                return new Exception(status);
            }
        }
        return new CanceledException(this._$5);
    }

    public static Context prepareEnv() throws Exception {
        Context context = new Context();
        if (_$6 == null) {
            UnitServer us = UnitServer.instance;
            OdbcServer os = OdbcServer.instance;
            if (us != null) {
                if (us.getRaqsoftConfig() != null) {
                    _$6 = us.getRaqsoftConfig().getAutoConnectList();
                }
            } else if (os != null && os.getRaqsoftConfig() != null) {
                _$6 = os.getRaqsoftConfig().getAutoConnectList();
            }
        }
        DatabaseUtil.connectAutoDBs(context, _$6);
        return context;
    }

    private Sequence _$1() throws Exception {
        this._$4 = Task.prepareEnv();
        PgmCellSet pcs = this._$1(this._$4);
        this._$10 = pcs;
        JobSpace js = JobSpaceManager.getSpace(this._$20);
        this._$4.setJobSpace(js);
        this._$4.addResource(this);
        pcs.setContext(this._$4);
        Object[] argsVal = null;
        if (this._$21 != null) {
            argsVal = this._$21.toArray();
        }
        if (ParallelCaller.isScript(this._$23)) {
            if (argsVal != null && argsVal.length > 0) {
                for (int i = 0; i < argsVal.length; ++i) {
                    this._$4.setParamValue("arg" + (i + 1), argsVal[i]);
                }
            }
        } else {
            CellSetUtil.putArgValue(pcs, argsVal);
        }
        pcs.calculateResult();
        if (pcs.getInterrupt()) {
            throw this._$2();
        }
        Sequence results = new Sequence();
        UnitServer server = UnitServer.instance;
        boolean isLocalExecute = server == null;
        UnitContext uc = null;
        if (!isLocalExecute) {
            uc = server.getUnitContext();
        }
        while (pcs.hasNextResult()) {
            Object tmp = JdbcTask.checkResult(pcs.nextResult());
            if (!isLocalExecute && tmp instanceof ICursor) {
                int proxyId = UnitServer.nextId();
                RemoteCursorProxyManager rcpm = this.getCursorManager();
                RemoteCursorProxy rcp = new RemoteCursorProxy(rcpm, (ICursor)tmp, proxyId);
                rcpm.addProxy(rcp);
                RemoteCursor rc = new RemoteCursor(uc.getLocalHost(), uc.getLocalPort(), this._$14, proxyId);
                this._$4.addResource(rc);
                results.add(rc);
                continue;
            }
            results.add(tmp);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _$1(boolean isODBC) {
        Sequence seq;
        block26: {
            this._$3();
            try {
                if (this._$9) {
                    throw this._$2();
                }
                this._$2 = System.currentTimeMillis();
                Object result = null;
                if (this._$19) {
                    ParallelProcess pp = new ParallelProcess(this._$23);
                    this._$10 = pp;
                    ArrayList multiArgs = this._$21;
                    for (int i = 0; i < multiArgs.size(); ++i) {
                        pp.addCall((List)multiArgs.get(i));
                    }
                    pp.setJobSpaceId(this._$20);
                    pp.setReduce(this._$18, this._$17, this._$16);
                    pp.setProcessTaskId(this._$14);
                    result = pp.execute();
                } else {
                    seq = this._$1();
                    result = isODBC ? seq : (seq.length() == 1 ? seq.get(1) : seq);
                }
                seq = result;
                Object var9_10 = null;
                if (this._$10 == null) break block26;
            }
            catch (Throwable x) {
                Response response;
                block27: {
                    try {
                        if (!this._$19) {
                            Logger.debug(this, x);
                        }
                        Response res = new Response();
                        if (x instanceof Error) {
                            res.setError((Error)x);
                        } else if (x instanceof Exception) {
                            HostManager hm = HostManager.instance();
                            String msg = "[" + hm + "] ";
                            String causemsg = x.getMessage();
                            if (causemsg != null) {
                                msg = causemsg.startsWith("[") ? causemsg : msg + causemsg;
                            }
                            Exception ex = x instanceof RetryException ? new RetryException(msg, x) : new Exception(msg, x);
                            res.setException(ex);
                        }
                        response = res;
                        Object var9_11 = null;
                        if (this._$10 == null) break block27;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        if (this._$10 != null) {
                            if (this._$10 instanceof PgmCellSet) {
                                this._$12 = System.currentTimeMillis();
                                ((PgmCellSet)this._$10).reset();
                                if (this._$22) {
                                    DfxManager.getInstance().putDfx((PgmCellSet)this._$10);
                                }
                            } else {
                                ParallelProcess pp = (ParallelProcess)this._$10;
                                pp.close();
                            }
                            this._$10 = null;
                        }
                        if (this._$11 == null) {
                            TaskManager.delTask(this._$14);
                        }
                        this.access();
                        throw throwable;
                    }
                    if (this._$10 instanceof PgmCellSet) {
                        this._$12 = System.currentTimeMillis();
                        ((PgmCellSet)this._$10).reset();
                        if (this._$22) {
                            DfxManager.getInstance().putDfx((PgmCellSet)this._$10);
                        }
                    } else {
                        ParallelProcess pp = (ParallelProcess)this._$10;
                        pp.close();
                    }
                    this._$10 = null;
                }
                if (this._$11 == null) {
                    TaskManager.delTask(this._$14);
                }
                this.access();
                return response;
            }
            if (this._$10 instanceof PgmCellSet) {
                this._$12 = System.currentTimeMillis();
                ((PgmCellSet)this._$10).reset();
                if (this._$22) {
                    DfxManager.getInstance().putDfx((PgmCellSet)this._$10);
                }
            } else {
                ParallelProcess pp = (ParallelProcess)this._$10;
                pp.close();
            }
            this._$10 = null;
        }
        if (this._$11 == null) {
            TaskManager.delTask(this._$14);
        }
        this.access();
        return seq;
    }

    public Response cancel() {
        return this.cancel(null);
    }

    public Response cancel(String reason) {
        this._$5 = reason;
        Response res = new Response();
        if (this._$10 == null) {
            if (this._$13 == -1L) {
                res.setResult(Boolean.TRUE);
                this._$9 = true;
            } else {
                res.setException(new Exception("Task is finished."));
            }
        } else {
            if (this._$10 instanceof PgmCellSet) {
                ((PgmCellSet)this._$10).interrupt();
            } else {
                ((ParallelProcess)this._$10).cancel(reason);
            }
            res.setResult(Boolean.TRUE);
            Logger.debug(this + " is canceled.");
        }
        return res;
    }

    public String getDfxName() {
        return ParallelCaller.dfxDelegate(this._$23);
    }

    public List getArgList() {
        return this._$21;
    }

    public int getTaskID() {
        return this._$14;
    }

    public long getCallTime() {
        return this._$13;
    }

    public void setCallTime(long callTime) {
        this._$13 = callTime;
    }

    public long getFinishTime() {
        return this._$12;
    }

    public void setFinishTime(long finishTime) {
        this._$12 = finishTime;
    }

    PgmCellSet _$1(Context ctx) {
        PgmCellSet pcs;
        DfxManager dfxManager = DfxManager.getInstance();
        if (ParallelCaller.isScript(this._$23)) {
            String dfx = (String)this._$23;
            pcs = CellSetUtil.toPgmCellSet(dfx);
        } else if (this._$23 instanceof String) {
            String dfx = (String)this._$23;
            FileObject fo = new FileObject(dfx, "s");
            this._$22 = true;
            pcs = dfxManager.removeDfx(fo, ctx);
        } else {
            pcs = (PgmCellSet)this._$23;
        }
        return pcs;
    }

    public boolean checkTimeOut(int timeOut) {
        if (this._$7 < 0L) {
            return false;
        }
        long unvisit = (System.currentTimeMillis() - this._$7) / 1000L;
        if (unvisit > (long)timeOut) {
            Logger.info(this + " is timeout.");
            this.destroy();
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this._$15 == 0) {
            sb.append(" [" + ParallelCaller.dfxDelegate(this._$23) + "] ");
            sb.append(ParallelCaller.args2String(this._$21));
            sb.append(this._$3.getMessage("Task.taskid", this._$14));
        } else {
            sb.append(this._$3.getMessage("Task.taskAndMainId", this._$14, this._$15));
        }
        System.out.println(sb);
        return sb.toString();
    }

    public void run() {
        long l1 = System.currentTimeMillis();
        if (!this._$19 || this._$21.size() >= 2) {
            Logger.debug(this._$3.getMessage("Task.taskBegin", this));
        }
        this._$8 = this.execute();
        long l2 = System.currentTimeMillis();
        DecimalFormat df = new DecimalFormat("###,###");
        long lastTime = l2 - l1;
        if (!this._$19 || this._$21.size() >= 2) {
            Logger.debug(this._$3.getMessage("Task.taskEnd", this, df.format(lastTime)));
        }
    }

    public boolean isProcessCaller() {
        return this._$19;
    }

    public void setProcessCaller(boolean b) {
        this._$19 = b;
    }

    public void setReduce(Object reduce, CellLocation accuLoc, CellLocation currentLoc) {
        this._$18 = reduce;
        this._$17 = accuLoc;
        this._$16 = currentLoc;
    }

    public Response getResponse() {
        return this._$8;
    }

    public void close() {
        if (!this._$1) {
            this.destroy();
            TaskManager.delTask(this._$14);
        }
    }
}

