/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.parallel;

import com.scudata.app.common.AppUtil;
import com.scudata.app.config.ConfigUtil;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.GMBase;
import com.scudata.common.Logger;
import com.scudata.common.ScudataLogger;
import com.scudata.common.SplServerConfig;
import com.scudata.common.StringUtils;
import com.scudata.dm.Env;
import com.scudata.parallel.HostManager;
import com.scudata.parallel.UnitClient;
import com.scudata.parallel.UnitConfig;
import com.scudata.resources.ParallelMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitContext {
    public static String UNIT_XML = "unitServer.xml";
    HostManager _$11 = HostManager.instance();
    int _$10 = 0;
    private int _$9 = 5;
    private int _$8 = 0;
    private int _$7 = 10;
    private RaqsoftConfig _$6 = null;
    private boolean _$5 = false;
    private boolean _$4 = false;
    private List<String> _$3 = null;
    private List<String> _$2 = null;
    private String _$1;

    public RaqsoftConfig getRaqsoftConfig() {
        return this._$6;
    }

    public void setRaqsoftConfig(RaqsoftConfig rc) {
        this._$6 = rc;
    }

    public String getLogFile() {
        return this._$1;
    }

    public boolean isCheckClients() {
        return this._$5;
    }

    public boolean isAutoStart() {
        return this._$4;
    }

    private static boolean _$1(String ip, String start, String end) {
        if (!StringUtils.isValidString(end)) {
            return ip.equals(start);
        }
        return ip.compareTo(start) >= 0 && ip.compareTo(end) <= 0;
    }

    public boolean checkClientIP(String client) {
        return UnitContext.checkClientIP(client, this._$3, this._$2);
    }

    public static boolean checkClientIP(String client, List<String> enabledClientsStart, List<String> enabledClientsEnd) {
        if (enabledClientsStart == null || enabledClientsStart.isEmpty()) {
            return false;
        }
        for (int i = 0; i < enabledClientsStart.size(); ++i) {
            String end;
            String start = enabledClientsStart.get(i);
            if (!UnitContext._$1(client, start, end = enabledClientsEnd.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean _$1(String host, int port) {
        try {
            InetAddress add = InetAddress.getByName(host);
            ServerSocket ss = new ServerSocket(port, 10, add);
            ss.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static InputStream getUnitInputStream(String relativePath) throws Exception {
        relativePath = "config/" + relativePath;
        FileInputStream inputStream = null;
        if (inputStream == null) {
            String serverPath = GMBase.getAbsolutePath(relativePath);
            File serverFile = new File(serverPath);
            if (!serverFile.exists()) {
                throw new Exception(ParallelMessage.get().getMessage("UnitContext.noconfig", serverPath));
            }
            inputStream = new FileInputStream(serverPath);
        }
        return inputStream;
    }

    private static UnitConfig _$1() throws Exception {
        InputStream inputStream = UnitContext.getUnitInputStream(UNIT_XML);
        UnitConfig uc = new UnitConfig();
        uc.load(inputStream);
        inputStream.close();
        return uc;
    }

    public static ArrayList<UnitInfo> listNodes() throws Exception {
        ArrayList<UnitInfo> uis = new ArrayList<UnitInfo>();
        UnitConfig uc = UnitContext._$1();
        List<UnitConfig.Host> hosts = uc.getHosts();
        for (int i = 0; i < hosts.size(); ++i) {
            UnitConfig.Host uchost = hosts.get(i);
            UnitInfo ui = new UnitInfo();
            ui._$2 = uchost.getIp();
            ui._$1 = uchost.getPort();
            uis.add(ui);
        }
        return uis;
    }

    public UnitContext(String specifyHost, int specifyPort) throws Exception {
        int t;
        String file;
        UnitConfig uc = UnitContext._$1();
        String host = null;
        int port = 8281;
        UnitConfig.Host ucHost = null;
        List<UnitConfig.Host> hosts = uc.getHosts();
        if (hosts.isEmpty()) {
            throw new Exception(ParallelMessage.get().getMessage("UnitContext.emptyunit"));
        }
        for (int i = 0; i < hosts.size(); ++i) {
            int p;
            ucHost = hosts.get(i);
            String tmpHost = ucHost.getIp();
            if (tmpHost.equalsIgnoreCase("localhost")) {
                tmpHost = UnitContext.getDefaultHost();
            }
            if (specifyHost != null) {
                if (specifyHost.equalsIgnoreCase("localhost")) {
                    specifyHost = UnitContext.getDefaultHost();
                }
                if (!tmpHost.equals(specifyHost)) continue;
                if (specifyPort == 0) {
                    p = ucHost.getPort();
                } else {
                    if (specifyPort != ucHost.getPort()) continue;
                    p = specifyPort;
                }
            } else {
                p = ucHost.getPort();
            }
            if (tmpHost.equalsIgnoreCase("localhost")) {
                String defIP = UnitContext.getDefaultHost();
                Logger.info("Using IP:" + defIP + " instead of:" + tmpHost + ".");
                tmpHost = defIP;
            }
            if (!this._$1(tmpHost, p)) continue;
            host = tmpHost;
            port = p;
            break;
        }
        if (host == null) {
            if (specifyHost != null) {
                throw new Exception(ParallelMessage.get().getMessage("UnitContext.failhost", specifyHost + ":" + specifyPort));
            }
            throw new Exception(ParallelMessage.get().getMessage("UnitContext.nohost"));
        }
        String home = System.getProperty("start.home");
        File f = new File(home, file = "nodes/" + UnitClient.getHostPath(host) + "_" + port + "/log/log.txt");
        File fp = f.getParentFile();
        if (!fp.exists()) {
            fp.mkdirs();
        }
        this._$1 = f.getAbsolutePath();
        ScudataLogger.FileHandler lfh = ScudataLogger.newFileHandler(this._$1);
        ScudataLogger.addFileHandler(lfh);
        String path = "nodes/" + UnitClient.getHostPath(host) + "_" + port + "/temp";
        f = new File(home, path);
        if (!f.exists()) {
            f.mkdirs();
        }
        path = f.getAbsolutePath();
        Env.setTempPath(path);
        this._$5 = uc.isCheckClients();
        this._$4 = uc.isAutoStart();
        this._$3 = uc.getEnabledClientsStart();
        this._$2 = uc.getEnabledClientsEnd();
        this._$11.setHost(host);
        this._$11.setPort(port);
        this._$11.setMaxTaskNum(ucHost.getMaxTaskNum());
        this._$11.setPreferredTaskNum(ucHost.getPreferredTaskNum());
        this._$10 = uc.getTempTimeOut();
        if (this._$10 > 0) {
            Logger.debug(ParallelMessage.get().getMessage("UnitContext.temptimeout", this._$10));
        }
        if ((t = uc.getInterval()) > 0) {
            this._$9 = t;
        }
        if ((t = uc.getBacklog()) > 0) {
            this._$7 = t;
        }
        this._$8 = uc.getProxyTimeOut();
    }

    public UnitContext(SplServerConfig ssc) throws Exception {
        if (StringUtils.isValidString(ssc.logPath)) {
            this._$1 = ssc.logPath;
            File f = new File(this._$1);
            File fp = f.getParentFile();
            if (!fp.exists()) {
                fp.mkdirs();
            }
            this._$1 = f.getAbsolutePath();
            ScudataLogger.FileHandler lfh = ScudataLogger.newFileHandler(this._$1);
            ScudataLogger.addFileHandler(lfh);
        }
        if (StringUtils.isValidString(ssc.tempTimeOut)) {
            this._$10 = Integer.parseInt(ssc.tempTimeOut);
            if (this._$10 > 0) {
                Logger.debug(ParallelMessage.get().getMessage("UnitContext.temptimeout", this._$10));
            }
        }
        if (StringUtils.isValidString(ssc.proxyTimeOut)) {
            this._$8 = Integer.parseInt(ssc.proxyTimeOut);
        }
        if (StringUtils.isValidString(ssc.interval)) {
            this._$9 = Integer.parseInt(ssc.interval);
        }
        if (StringUtils.isValidString(ssc.backlog)) {
            this._$7 = Integer.parseInt(ssc.backlog);
        }
        if (StringUtils.isValidString(ssc.splConfig)) {
            FileInputStream is = new FileInputStream(ssc.splConfig);
            this._$6 = ConfigUtil.load(is, true);
            ((InputStream)is).close();
        }
    }

    public static String getDefaultHost() {
        String[] allHosts = AppUtil.getLocalIps();
        String tmpHost = "127.0.0.1";
        if (allHosts.length > 0) {
            for (int i = 0; i < allHosts.length && ((tmpHost = allHosts[i]).indexOf(58) > 0 || tmpHost.equals("127.0.0.1")); ++i) {
            }
        }
        return tmpHost;
    }

    public int getTimeOut() {
        return this._$10;
    }

    public int getTimeOutHour() {
        return this._$10;
    }

    public int getInterval() {
        return this._$9;
    }

    public int getBacklog() {
        return this._$7;
    }

    public int getProxyTimeOut() {
        return this._$8;
    }

    public int getProxyTimeOutHour() {
        return this._$8;
    }

    public String getLocalHost() {
        return this._$11.getHost();
    }

    public int getLocalPort() {
        return this._$11.getPort();
    }

    public String toString() {
        return this._$11.toString();
    }

    public static class UnitInfo {
        private String _$2 = null;
        private int _$1 = 8281;

        public String getHost() {
            return this._$2;
        }

        public void setHost(String host) {
            this._$2 = host;
        }

        public int getPort() {
            return this._$1;
        }

        public void setPort(int port) {
            this._$1 = port;
        }
    }
}

