/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.parallel;

import com.scudata.common.MessageManager;
import com.scudata.dm.ZoneManager;
import com.scudata.parallel.ITask;
import com.scudata.parallel.PartitionManager;
import com.scudata.parallel.RemoteCursorProxyManager;
import com.scudata.parallel.RemoteFileProxyManager;
import com.scudata.parallel.Request;
import com.scudata.parallel.Response;
import com.scudata.parallel.SocketData;
import com.scudata.parallel.TaskManager;
import com.scudata.parallel.UnitCommand;
import com.scudata.resources.ParallelMessage;
import com.scudata.server.unit.JdbcManager;
import com.scudata.server.unit.UnitServer;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitWorker
extends Thread {
    UnitServer _$5;
    SocketData _$4;
    boolean _$3 = false;
    String _$2 = null;
    private volatile boolean _$1 = false;

    public UnitWorker(ThreadGroup tg, String name) {
        super(tg, name);
    }

    public void setErrorCheck(String clientIP) {
        this._$3 = true;
        this._$2 = clientIP;
    }

    public void setSocket(SocketData sd, UnitServer currentServer) {
        this._$4 = sd;
        this._$5 = currentServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object obj;
            Response response = null;
            while (!this._$1 && (obj = this._$4.read()) != null) {
                if (!(obj instanceof Request)) {
                    break;
                }
                Request req = (Request)obj;
                switch (req.getActionType()) {
                    case 10000: {
                        this.setName("UnitWorker[execute splx]:" + req);
                        if (req.getAction() == 10001) {
                            this._$1("splx", req);
                        }
                        if (this._$3) {
                            response = new Response();
                            MessageManager mm = ParallelMessage.get();
                            Exception error = new Exception(mm.getMessage("UnitWorker.errorcheck", this._$2));
                            response.setException(error);
                            break;
                        }
                        response = TaskManager.execute(req);
                        break;
                    }
                    case 20000: {
                        this.setName("UnitWorker[serve cursor]:" + req);
                        int taskId = ((Number)req.getAttr("Task id")).intValue();
                        try {
                            RemoteCursorProxyManager rcpm;
                            if (taskId == -1) {
                                rcpm = RemoteCursorProxyManager.getInstance();
                            } else {
                                ITask t = TaskManager.getTask(taskId);
                                rcpm = t.getCursorManager();
                            }
                            response = rcpm.execute(req);
                        }
                        catch (Exception x) {
                            response = new Response();
                            response.setException(x);
                        }
                        break;
                    }
                    case 30000: {
                        this.setName("UnitWorker[serve file]:" + req);
                        response = RemoteFileProxyManager.execute(req, this._$4);
                        break;
                    }
                    case 40000: {
                        this.setName("UnitWorker[serve partition]:" + req);
                        response = PartitionManager.execute(req, this._$4);
                        break;
                    }
                    case 50000: {
                        this.setName("UnitWorker[ZONE]:" + req);
                        response = ZoneManager.execute(req);
                        break;
                    }
                    case 60000: {
                        this.setName("UnitWorker[UnitCommand]:" + req);
                        UnitCommand uc = (UnitCommand)req.getAttr("Command Object");
                        response = uc.execute();
                        break;
                    }
                    case 70000: {
                        this.setName("UnitWorker[JDBC]:" + req);
                        response = JdbcManager.execute(req);
                        break;
                    }
                    default: {
                        this.setName("UnitWorker[execute cmd]:" + req);
                        response = this._$5.execute(req);
                    }
                }
                this._$4.write(response);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        finally {
            try {
                this._$4.serverClose();
            }
            catch (Exception exception) {}
        }
    }

    public void shutdown() {
        this._$1 = true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("UnitWorker:");
        sb.append(this._$4.getSocket().getRemoteSocketAddress());
        sb.append("-" + this._$4.getSocket().hashCode());
        return sb.toString();
    }

    private void _$1(String typeName, Request req) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fileName", req.getAttr("Dfx name"));
        map.put("params", req.getAttr("Arg list"));
        this.collectData(typeName, map);
    }

    public void collectData(String typeName, Map<String, Object> map) {
    }
}

