/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.parallel;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.FileGroup;
import com.scudata.dm.FileObject;
import com.scudata.dm.JobSpace;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.cursor.BFileCursor;
import com.scudata.dw.ColComTable;
import com.scudata.dw.ComTable;
import com.scudata.dw.IPhyTable;
import com.scudata.dw.PhyTable;
import com.scudata.dw.RowComTable;
import com.scudata.parallel.ClusterFile;
import com.scudata.parallel.CursorProxy;
import com.scudata.parallel.IIlllIlIIIIIlllI;
import com.scudata.parallel.PhyTableProxy;
import com.scudata.parallel.Response;
import com.scudata.parallel.UnitClient;
import com.scudata.parallel.UnitCommand;
import com.scudata.resources.EngineMessage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class llIllIIIIlIIlIII {
    private ClusterFile _$4;
    private String _$3;
    private int _$2;
    private int[] _$1;

    public llIllIIIIlIIlIII(ClusterFile clusterFile, String host, int port, int partition) {
        this._$4 = clusterFile;
        this._$3 = host;
        this._$2 = port;
        if (partition != -1) {
            this._$1 = new int[]{partition};
        }
    }

    public llIllIIIIlIIlIII(ClusterFile clusterFile, String host, int port, int[] parts) {
        this._$4 = clusterFile;
        this._$3 = host;
        this._$2 = port;
        this._$1 = parts;
    }

    public llIllIIIIlIIlIII dup(ClusterFile clusterFile) {
        return new llIllIIIIlIIlIII(clusterFile, this._$3, this._$2, this._$1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createGroupTable(String[] colNames, String distribute, String opt) {
        UnitClient client = new UnitClient(this._$3, this._$2);
        String fileName = this._$4.getFileName();
        try {
            UnitCommand command = new UnitCommand(1);
            command.setAttribute("fileName", fileName);
            command.setAttribute("parts", this._$1);
            command.setAttribute("jobSpaceId", this._$4.getJobSpaceId());
            command.setAttribute("colNames", colNames);
            command.setAttribute("distribute", distribute);
            command.setAttribute("opt", opt);
            Response response = client.send(command);
            Integer id = (Integer)response.checkResult();
            int n = id;
            return n;
        }
        finally {
            client.close();
        }
    }

    public static Response executeCreateGroupTable(HashMap<String, Object> attributes) {
        String fileName = (String)attributes.get("fileName");
        int[] parts = (int[])attributes.get("parts");
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        String[] colNames = (String[])attributes.get("colNames");
        String distribute = (String)attributes.get("distribute");
        String opt = (String)attributes.get("opt");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            Context ctx = IIlllIlIIIIIlllI.createContext(js);
            FileObject fo = new FileObject(fileName);
            if (parts != null && parts.length == 1) {
                fo.setPartition(parts[0]);
            }
            File file = fo.getLocalFile().file();
            if ((opt == null || opt.indexOf(121) == -1) && file.exists()) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("file.fileAlreadyExist", fo.getFileName()));
            }
            if (opt != null && opt.indexOf(121) != -1 && file.exists()) {
                try {
                    ComTable table = ComTable.open(file, ctx);
                    table.delete();
                }
                catch (IOException e) {
                    throw new RQException(e.getMessage(), e);
                }
            }
            ComTable gt = opt != null && opt.indexOf(114) != -1 ? new RowComTable(file, colNames, distribute, opt, ctx) : new ColComTable(file, colNames, distribute, opt, ctx);
            if (parts != null && parts.length == 1) {
                gt.setPartition(parts[0]);
            }
            PhyTable table = gt.getBaseTable();
            PhyTableProxy proxy = new PhyTableProxy(table);
            js.getResourceManager().addProxy(proxy);
            return new Response(new Integer(proxy.getProxyId()));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int openGroupTable() {
        UnitClient client = new UnitClient(this._$3, this._$2);
        try {
            UnitCommand command = new UnitCommand(5);
            command.setAttribute("fileName", this._$4.getFileName());
            command.setAttribute("parts", this._$1);
            command.setAttribute("jobSpaceId", this._$4.getJobSpaceId());
            Response response = client.send(command);
            Integer id = (Integer)response.checkResult();
            int n = id;
            return n;
        }
        finally {
            client.close();
        }
    }

    public static Response executeOpenGroupTable(HashMap<String, Object> attributes) {
        String fileName = (String)attributes.get("fileName");
        int[] parts = (int[])attributes.get("parts");
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        try {
            IPhyTable table;
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            Context ctx = IIlllIlIIIIIlllI.createContext(js);
            if (parts == null || parts.length <= 1) {
                FileObject fo = new FileObject(fileName);
                if (parts != null && parts.length == 1) {
                    fo.setPartition(parts[0]);
                }
                File file = fo.getLocalFile().file();
                PhyTable tmd = ComTable.openBaseTable(file, ctx);
                table = tmd;
                if (parts != null && parts.length == 1) {
                    tmd.getGroupTable().setPartition(parts[0]);
                }
            } else {
                FileGroup fileGroup = new FileGroup(fileName, parts);
                table = fileGroup.open(null, ctx);
            }
            PhyTableProxy proxy = new PhyTableProxy(table);
            js.getResourceManager().addProxy(proxy);
            return new Response(new Integer(proxy.getProxyId()));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createBinaryCursor(String[] fields, String opt, int segSeq, int segCount, int unit) {
        UnitClient client = new UnitClient(this._$3, this._$2);
        String fileName = this._$4.getFileName();
        try {
            UnitCommand command = new UnitCommand(20);
            command.setAttribute("fileName", fileName);
            command.setAttribute("segSeq", new Integer(segSeq));
            command.setAttribute("segCount", new Integer(segCount));
            command.setAttribute("unit", new Integer(unit));
            command.setAttribute("jobSpaceId", this._$4.getJobSpaceId());
            command.setAttribute("fields", fields);
            command.setAttribute("opt", opt);
            Response response = client.send(command);
            Integer id = (Integer)response.checkResult();
            int n = id;
            return n;
        }
        finally {
            client.close();
        }
    }

    public static Response executeCreateBinaryCursor(HashMap<String, Object> attributes) {
        String fileName = (String)attributes.get("fileName");
        Integer segSeq = (Integer)attributes.get("segSeq");
        Integer segCount = (Integer)attributes.get("segCount");
        Integer unit = (Integer)attributes.get("unit");
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        String[] fields = (String[])attributes.get("fields");
        String opt = (String)attributes.get("opt");
        FileObject fo = new FileObject(fileName);
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes);
            BFileCursor cursor = segCount > 1 ? new BFileCursor(fo, fields, segSeq, segCount, opt, ctx) : new BFileCursor(fo, fields, opt, ctx);
            CursorProxy proxy = new CursorProxy(cursor, unit);
            js.getResourceManager().addProxy(proxy);
            return new Response(new Integer(proxy.getProxyId()));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetGroupTable(String file, String option, String distribute, Integer blockSize) {
        UnitClient client = new UnitClient(this._$3, this._$2);
        try {
            UnitCommand command = new UnitCommand(87);
            command.setAttribute("fileName", this._$4.getFileName());
            command.setAttribute("parts", this._$1);
            command.setAttribute("file", file);
            command.setAttribute("option", option);
            command.setAttribute("jobSpaceId", this._$4.getJobSpaceId());
            command.setAttribute("distribute", distribute);
            command.setAttribute("blockSize", blockSize);
            Response response = client.send(command);
            Boolean result = (Boolean)response.checkResult();
            boolean bl = result;
            return bl;
        }
        finally {
            client.close();
        }
    }

    public static Response executeResetGroupTable(HashMap<String, Object> attributes) {
        String fileName = (String)attributes.get("fileName");
        int[] parts = (int[])attributes.get("parts");
        String file = (String)attributes.get("file");
        String option = (String)attributes.get("option");
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        String distribute = (String)attributes.get("distribute");
        Integer blockSize = (Integer)attributes.get("blockSize");
        try {
            boolean result;
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            Context ctx = IIlllIlIIIIIlllI.createContext(js);
            if (parts == null || parts.length <= 1) {
                FileObject fo = new FileObject(fileName);
                if (parts != null && parts.length == 1) {
                    fo.setPartition(parts[0]);
                }
                ComTable table = ComTable.open(fo.getLocalFile().file(), ctx);
                if (file == null) {
                    result = table.reset(null, option, ctx, distribute);
                } else {
                    FileObject newFile = new FileObject(file);
                    if (parts != null && parts.length == 1) {
                        newFile.setPartition(parts[0]);
                    }
                    result = table.reset(newFile.getLocalFile().file(), option, ctx, distribute);
                }
            } else {
                FileGroup fileGroup = new FileGroup(fileName, parts);
                if (file == null) {
                    result = fileGroup.resetGroupTable(option, blockSize, null, ctx);
                } else {
                    FileGroup newFileGroup = new FileGroup(file, parts);
                    result = fileGroup.resetGroupTable(newFileGroup, option, distribute, blockSize, null, ctx);
                }
            }
            return new Response(result);
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    public String getHost() {
        return this._$3;
    }

    public int getPort() {
        return this._$2;
    }

    public int getPartition() {
        if (this._$1 != null && this._$1.length > 0) {
            return this._$1[0];
        }
        return -1;
    }

    public int[] getParts() {
        return this._$1;
    }
}

