/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.server.http;

import com.scudata.app.config.ConfigConsts;
import com.scudata.app.config.ConfigWriter;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.ScudataLogger;
import com.scudata.common.StringUtils;
import com.scudata.dm.Env;
import com.scudata.parallel.UnitClient;
import com.scudata.parallel.UnitContext;
import com.scudata.parallel.XmlUtil;
import com.scudata.resources.ParallelMessage;
import com.scudata.server.unit.UnitServer;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import sun.net.util.IPAddressUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpContext
extends ConfigWriter {
    public static final String HTTP_CONFIG_FILE = "HttpServer.xml";
    public static String dfxHome;
    private String _$6;
    private int _$5;
    private int _$4;
    private boolean _$3;
    private ArrayList<String> _$2;
    static MessageManager _$1;

    public HttpContext(boolean showException) {
        block3: {
            this._$6 = UnitContext.getDefaultHost();
            this._$5 = 8508;
            this._$4 = 50;
            this._$3 = false;
            this._$2 = new ArrayList();
            try {
                InputStream inputStream = UnitContext.getUnitInputStream(HTTP_CONFIG_FILE);
                if (inputStream != null) {
                    this.load(inputStream);
                }
            }
            catch (Exception x) {
                if (!showException) break block3;
                x.printStackTrace();
            }
        }
    }

    public String getDefaultUrl() {
        String tmp = this._$6;
        if (IPAddressUtil.isIPv6LiteralAddress(this._$6)) {
            int percentIndex = this._$6.indexOf(37);
            if (percentIndex > 0) {
                tmp = tmp.substring(0, percentIndex);
            }
            tmp = "[" + tmp + "]";
        }
        return "http://" + tmp + ":" + this._$5;
    }

    public void load(InputStream is) throws Exception {
        String mp;
        String file;
        String home;
        File f;
        File fp;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document xmlDocument = docBuilder.parse(is);
        NodeList nl = xmlDocument.getChildNodes();
        Node root = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equalsIgnoreCase("Server")) continue;
            root = n;
        }
        if (root == null) {
            throw new Exception(_$1.getMessage("UnitConfig.errorxml"));
        }
        String buf = XmlUtil.getAttribute(root, "host");
        if (StringUtils.isValidString(buf)) {
            this._$6 = buf;
        }
        if (StringUtils.isValidString(buf = XmlUtil.getAttribute(root, "port"))) {
            this._$5 = Integer.parseInt(buf);
        }
        if (StringUtils.isValidString(buf = XmlUtil.getAttribute(root, "autostart"))) {
            this._$3 = Boolean.parseBoolean(buf);
        }
        if (!(fp = (f = new File(home = UnitServer.getHome(), file = "http/" + UnitClient.getHostPath(this._$6) + "_" + this._$5 + "/log/log.txt")).getParentFile()).exists()) {
            fp.mkdirs();
        }
        String logFile = f.getAbsolutePath();
        ScudataLogger.FileHandler lfh = ScudataLogger.newFileHandler(logFile);
        ScudataLogger.addFileHandler(lfh);
        buf = XmlUtil.getAttribute(root, "parallelNum");
        if (StringUtils.isValidString(buf)) {
            // empty if block
        }
        if (StringUtils.isValidString(buf = XmlUtil.getAttribute(root, "maxlinks"))) {
            this._$4 = Integer.parseInt(buf);
        }
        if (!StringUtils.isValidString(mp = Env.getMainPath())) {
            Logger.info("Main path is empty.");
        } else {
            File main = new File(mp);
            if (main.exists()) {
                String mainPath = main.getAbsolutePath();
                this._$1(main, mainPath);
            }
        }
    }

    private void _$1(File main, String mainPath) {
        File[] fs = main.listFiles();
        if (fs == null) {
            return;
        }
        for (int i = 0; i < fs.length; ++i) {
            if (!fs[i].isDirectory()) continue;
            String path = fs[i].getAbsolutePath();
            path = path.substring(mainPath.length());
            path = StringUtils.replace(path, "\\", "/");
            this._$2.add(path);
            this._$1(fs[i], mainPath);
        }
    }

    public void save(OutputStream out) throws SAXException {
        StreamResult resultxml = new StreamResult(out);
        this.handler.setResult(resultxml);
        this.level = 0;
        this.handler.startDocument();
        String paths = "";
        for (int i = 0; i < this._$2.size(); ++i) {
            if (paths.length() > 0) {
                paths = paths + ",";
            }
            paths = paths + this._$2.get(i);
        }
        this.handler.startElement("", "", "Server", this.getAttributesImpl(new String[]{ConfigConsts.VERSION, "1", "host", this._$6, "port", this._$5 + "", "autostart", this._$3 + "", "maxlinks", this._$4 + "", "sapPath", paths}));
        this.handler.endElement("", "", "Server");
        this.handler.endDocument();
    }

    public String getHost() {
        return this._$6;
    }

    public int getPort() {
        return this._$5;
    }

    public boolean isAutoStart() {
        return this._$3;
    }

    public void setHost(String host) {
        this._$6 = host;
    }

    public void setPort(int port) {
        this._$5 = port;
    }

    public void setAutoStart(boolean as) {
        this._$3 = as;
    }

    public int getMaxLinks() {
        return this._$4;
    }

    public void setMaxLinks(int m) {
        this._$4 = m;
    }

    public ArrayList<String> getSapPath() {
        return this._$2;
    }

    public void setSapPath(ArrayList<String> paths) {
        this._$2 = paths;
    }

    public String toString() {
        return this._$6 + ":" + this._$5;
    }

    static {
        _$1 = ParallelMessage.get();
    }
}

