/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.server.http;

import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.Env;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.mfn.sequence.Export;
import com.scudata.resources.ParallelMessage;
import com.scudata.server.IServer;
import com.scudata.server.http.HttpContext;
import com.scudata.server.http.LinksPool;
import com.scudata.server.http.llIlIIIlIIllIIIl;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplxHttpHandler
implements HttpHandler {
    private IServer _$2 = null;
    static MessageManager _$1 = ParallelMessage.get();

    public void setIServer(IServer is) {
        this._$2 = is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        try {
            URI uri;
            String path;
            if (HttpContext.dfxHome == null) {
                String mainPath = Env.getMainPath();
                if (mainPath == null || mainPath.trim().length() == 0) {
                    throw new Exception(_$1.getMessage("DfxHttpHandler.emptyMain"));
                }
                mainPath = StringUtils.replace(mainPath, "\\", "/");
                HttpContext.dfxHome = mainPath.trim();
            }
            if ((path = (uri = httpExchange.getRequestURI()).getPath()).equals("/shutdown")) {
                this._$2.shutDown();
                return;
            }
            if (path.equals("/favicon.ico")) {
                return;
            }
            if (!LinksPool.canCreateLink()) {
                throw new Exception("\u5728\u7ebf\u8fde\u63a5\u6570\u8d85\u8fc7\u4e86\u6700\u5927\u503c" + LinksPool.getMaxLinks() + "\uff0c\u8bf7\u7a0d\u5019\u518d\u8bbf\u95ee");
            }
            new Thread(new llIlIIIlIIllIIIl(this, httpExchange)).start();
            LinksPool.addLink();
        }
        catch (Throwable t) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    t.printStackTrace(new PrintStream(baos));
                }
                finally {
                    baos.close();
                }
                String result = "error:" + baos.toString();
                result = StringUtils.replace(result, "\n", "<br>");
                Logger.severe(t);
                byte[] bytes = result.getBytes("UTF-8");
                httpExchange.getResponseHeaders().add("Content-Type", "text/html;charset=UTF-8");
                httpExchange.sendResponseHeaders(500, bytes.length);
                OutputStream os = httpExchange.getResponseBody();
                os.write(bytes);
                os.close();
            }
            catch (Throwable th) {
                Logger.severe(th);
            }
            finally {
                try {
                    httpExchange.close();
                }
                catch (Throwable th) {}
            }
        }
    }

    private Object _$1(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String || obj instanceof byte[]) {
            return obj;
        }
        String result = "";
        if (obj instanceof Table) {
            Table t = (Table)obj;
            result = Export.export(t, null, null, null, "t", new Context());
        } else {
            result = obj instanceof Sequence ? ((Sequence)obj).toExportString() : (obj instanceof BaseRecord ? ((BaseRecord)obj).toString("tq") : obj.toString());
        }
        return result;
    }

    private void _$1(String typeName, HttpExchange http) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        String uri = http.getRequestURI().toString();
        if (!uri.equals("/") && uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        m.put("url", uri);
        m.put("method", http.getRequestMethod());
        m.put("protocol", http.getProtocol());
        m.put("address", http.getLocalAddress().toString());
        this.collectData(typeName, m);
    }

    public void collectData(String typeName, Map<String, Object> map) {
    }

    static /* synthetic */ void _$1(SplxHttpHandler x0, String x1, HttpExchange x2) {
        x0._$1(x1, x2);
    }

    static /* synthetic */ Object _$1(SplxHttpHandler x0, Object x1) {
        return x0._$1(x1);
    }
}

