/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.server.odbc;

import com.scudata.dm.BaseRecord;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.Date;

public class DataTypes {
    public static final byte TYPE_NULL = 0;
    public static final byte TYPE_BOOL = 1;
    public static final byte TYPE_INT = 2;
    public static final byte TYPE_LONG = 3;
    public static final byte TYPE_FLOAT = 4;
    public static final byte TYPE_DECIMAL = 5;
    public static final byte TYPE_STRING = 6;
    public static final byte TYPE_DATE = 7;
    public static final byte TYPE_TIME = 8;
    public static final byte TYPE_DATETIME = 9;
    public static final byte TYPE_BINARY = 10;
    public static final byte TYPE_UNSUPPORT = 126;

    public static void writeByte(OutputStream out, byte size) throws Exception {
        if (out == null) {
            return;
        }
        out.write(size);
    }

    public static byte readByte(InputStream in) throws IOException {
        int ch1 = in.read();
        if (ch1 < 0) {
            throw new EOFException();
        }
        return (byte)ch1;
    }

    public static void writeInt(OutputStream out, int size) throws Exception {
        if (out == null) {
            return;
        }
        out.write(size >>> 24);
        out.write(size >>> 16);
        out.write(size >>> 8);
        out.write(size);
    }

    public static int readInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    public static void writeBool(OutputStream out, boolean b) throws Exception {
        if (out == null) {
            return;
        }
        if (b) {
            out.write(1);
        } else {
            out.write(0);
        }
    }

    public static boolean readBool(InputStream in) throws IOException {
        int ch1 = in.read();
        return ch1 == 1;
    }

    public static String readString(InputStream is) throws IOException {
        int len = DataTypes.readInt(is) * 2;
        byte[] buf = new byte[len];
        for (int i = 0; i < len; ++i) {
            buf[i] = (byte)is.read();
        }
        String str = new String(buf, "utf-16be");
        return str;
    }

    public static void writeString(OutputStream out, String str) throws Exception {
        if (out == null) {
            return;
        }
        if (str == null) {
            DataTypes.writeInt(out, 0);
            return;
        }
        int len = str.length();
        DataTypes.writeInt(out, len);
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            out.write(ch >> 8);
            out.write(ch);
        }
    }

    public static void writeLong(OutputStream out, long size) throws Exception {
        if (out == null) {
            return;
        }
        out.write((int)(size >>> 56));
        out.write((int)(size >>> 48));
        out.write((int)(size >>> 40));
        out.write((int)(size >>> 32));
        out.write((int)(size >>> 24));
        out.write((int)(size >>> 16));
        out.write((int)(size >>> 8));
        out.write((int)size);
    }

    public static long readLong(InputStream in) throws IOException {
        long ch8;
        long ch7;
        long ch6;
        long ch5;
        long ch4;
        long ch3;
        long ch2;
        long ch1 = in.read();
        if ((ch1 | (ch2 = (long)in.read()) | (ch3 = (long)in.read()) | (ch4 = (long)in.read()) | (ch5 = (long)in.read()) | (ch6 = (long)in.read()) | (ch7 = (long)in.read()) | (ch8 = (long)in.read())) < 0L) {
            throw new EOFException();
        }
        return (ch1 << 56) + (ch2 << 48) + (ch3 << 40) + (ch4 << 32) + (ch5 << 24) + (ch6 << 16) + (ch7 << 8) + ch8;
    }

    public static void writeFloat(OutputStream out, double d) throws Exception {
        if (out == null) {
            return;
        }
        long l = Double.doubleToLongBits(d);
        DataTypes.writeLong(out, l);
    }

    public static Double readFloat(InputStream in) throws IOException {
        long bits = DataTypes.readLong(in);
        return Double.longBitsToDouble(bits);
    }

    public static void writeDecimal(OutputStream out, BigDecimal dec) throws Exception {
        if (out == null) {
            return;
        }
        String str = dec.toString();
        DataTypes.writeString(out, str);
    }

    public static BigDecimal readDecimal(InputStream in) throws IOException {
        String str = DataTypes.readString(in);
        return new BigDecimal(str);
    }

    public static void writeDate(OutputStream out, java.sql.Date d) throws Exception {
        if (out == null) {
            return;
        }
        long l = d.getTime();
        DataTypes.writeLong(out, l);
    }

    public static java.sql.Date readDate(InputStream in) throws IOException {
        long bits = DataTypes.readLong(in);
        return new java.sql.Date(bits);
    }

    public static void writeTime(OutputStream out, Time t) throws Exception {
        if (out == null) {
            return;
        }
        Long l = t.getTime();
        DataTypes.writeLong(out, l);
    }

    public static Time readTime(InputStream in) throws IOException {
        Long L = DataTypes.readLong(in);
        return new Time(L);
    }

    public static void writeDateTime(OutputStream out, Date date) throws Exception {
        if (out == null) {
            return;
        }
        long l = date.getTime();
        DataTypes.writeLong(out, l);
    }

    public static Date readDateTime(InputStream in) throws IOException {
        long l = DataTypes.readLong(in);
        return new Date(l);
    }

    public static void writeBinary(OutputStream out, byte[] bytes) throws Exception {
        if (out == null) {
            return;
        }
        int len = bytes.length;
        DataTypes.writeInt(out, len);
        out.write(bytes);
    }

    public static byte[] readBinary(InputStream in) throws IOException {
        int len = DataTypes.readInt(in);
        byte[] bytes = new byte[len];
        in.read(bytes);
        return bytes;
    }

    private static byte _$1(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Boolean) {
            return 1;
        }
        if (obj instanceof Integer) {
            return 2;
        }
        if (obj instanceof Long) {
            return 3;
        }
        if (obj instanceof Double) {
            return 4;
        }
        if (obj instanceof BigDecimal) {
            return 5;
        }
        if (obj instanceof String) {
            return 6;
        }
        if (obj instanceof java.sql.Date) {
            return 7;
        }
        if (obj instanceof Time) {
            return 8;
        }
        if (obj instanceof Date) {
            return 9;
        }
        if (obj instanceof byte[]) {
            return 10;
        }
        return 126;
    }

    private static void writeObject(OutputStream out, Object obj) throws Exception {
        byte dataType = DataTypes._$1(obj);
        DataTypes.writeByte(out, dataType);
        switch (dataType) {
            case 0: {
                break;
            }
            case 1: {
                DataTypes.writeBool(out, (Boolean)obj);
                break;
            }
            case 2: {
                DataTypes.writeInt(out, (Integer)obj);
                break;
            }
            case 3: {
                DataTypes.writeLong(out, (Long)obj);
                break;
            }
            case 4: {
                DataTypes.writeFloat(out, (Double)obj);
                break;
            }
            case 5: {
                DataTypes.writeDecimal(out, (BigDecimal)obj);
                break;
            }
            case 6: {
                DataTypes.writeString(out, (String)obj);
                break;
            }
            case 7: {
                DataTypes.writeDate(out, (java.sql.Date)obj);
                break;
            }
            case 8: {
                DataTypes.writeTime(out, (Time)obj);
                break;
            }
            case 9: {
                DataTypes.writeDateTime(out, (Date)obj);
                break;
            }
            case 10: {
                DataTypes.writeBinary(out, (byte[])obj);
                break;
            }
            default: {
                throw new Exception("Unsupported data:" + obj.getClass().getName());
            }
        }
    }

    private static Object readObject(InputStream in) throws Exception {
        byte dataType = DataTypes.readByte(in);
        switch (dataType) {
            case 0: {
                return null;
            }
            case 1: {
                return DataTypes.readBool(in);
            }
            case 2: {
                return DataTypes.readInt(in);
            }
            case 3: {
                return DataTypes.readLong(in);
            }
            case 4: {
                return DataTypes.readFloat(in);
            }
            case 5: {
                return DataTypes.readDecimal(in);
            }
            case 6: {
                return DataTypes.readString(in);
            }
            case 7: {
                return DataTypes.readDate(in);
            }
            case 8: {
                return DataTypes.readTime(in);
            }
            case 9: {
                return DataTypes.readDateTime(in);
            }
            case 10: {
                return DataTypes.readBinary(in);
            }
        }
        return null;
    }

    public static void writeRowData(OutputStream out, Object[] row) throws Exception {
        int cols = 0;
        if (row != null) {
            cols = row.length;
        }
        DataTypes.writeInt(out, cols);
        for (int c = 0; c < cols; ++c) {
            Object val = row[c];
            DataTypes.writeObject(out, val);
        }
    }

    public static Object[] readRowData(InputStream is) throws Exception {
        int cols = DataTypes.readInt(is);
        if (cols == 0) {
            return null;
        }
        Object[] data = new Object[cols];
        for (int c = 0; c < cols; ++c) {
            data[c] = DataTypes.readObject(is);
        }
        return data;
    }

    public static void writeTable(OutputStream out, Object[][] table) throws Exception {
        OutputStream baos = out;
        if (table == null) {
            DataTypes.writeInt(baos, 0);
        } else {
            int rows = table.length;
            DataTypes.writeInt(baos, rows);
            for (int r = 0; r < rows; ++r) {
                Object[] row = table[r];
                DataTypes.writeRowData(baos, row);
            }
        }
    }

    public static void checkTable(Sequence table) throws Exception {
        DataTypes.writeTable(null, table);
    }

    public static void writeTable(OutputStream out, Sequence table) throws Exception {
        if (table == null) {
            DataTypes.writeInt(out, 0);
        } else {
            int rows = table.length();
            DataTypes.writeInt(out, rows);
            for (int r = 1; r <= table.length(); ++r) {
                Object[] rowData;
                Object rowObj = table.get(r);
                if (rowObj instanceof BaseRecord) {
                    BaseRecord rec = (BaseRecord)rowObj;
                    rowData = rec.getFieldValues();
                } else {
                    rowData = new Object[]{rowObj};
                }
                DataTypes.writeRowData(out, rowData);
                if (out == null) break;
            }
        }
    }

    public static Object[][] readTable(InputStream is) throws Exception {
        int rows = DataTypes.readInt(is);
        if (rows == 0) {
            return null;
        }
        Object[] data = new Object[rows];
        int cols = 0;
        for (int r = 0; r < data.length; ++r) {
            Object[] row;
            data[r] = row = DataTypes.readRowData(is);
            if (r != 0) continue;
            cols = row.length;
        }
        Object[][] table = new Object[rows][cols];
        for (int r = 0; r < rows; ++r) {
            Object[] row = (Object[])data[r];
            for (int c = 0; c < cols; ++c) {
                table[r][c] = row[c];
            }
        }
        return table;
    }

    public static void writeDatastructAndData(OutputStream os, Table table) throws Exception {
        String[] columns = table.dataStruct().getFieldNames();
        int size = columns.length;
        DataTypes.writeInt(os, size);
        for (int i = 0; i < size; ++i) {
            DataTypes.writeString(os, columns[i]);
        }
        DataTypes.writeTable(os, table);
    }
}

