/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.server.odbc;

import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.dm.Env;
import com.scudata.parallel.TempFileMonitor;
import com.scudata.parallel.UnitContext;
import com.scudata.resources.ParallelMessage;
import com.scudata.server.ConnectionProxyManager;
import com.scudata.server.IServer;
import com.scudata.server.StartUnitListener;
import com.scudata.server.odbc.OdbcContext;
import com.scudata.server.odbc.OdbcMonitor;
import com.scudata.server.odbc.llIIIIIlIlIIIIlI;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class OdbcServer
implements IServer {
    public static OdbcServer instance = null;
    StartUnitListener _$9 = null;
    private OdbcContext _$8 = null;
    private OdbcMonitor _$7 = null;
    TempFileMonitor _$6 = null;
    volatile boolean _$5 = true;
    static int _$4 = 0;
    static Object _$3 = new Object();
    ThreadGroup _$2 = new ThreadGroup("OdbcWorker");
    private RaqsoftConfig _$1 = null;

    public void setRaqsoftConfig(RaqsoftConfig rc) {
        this._$1 = rc;
    }

    public RaqsoftConfig getRaqsoftConfig() {
        return this._$1;
    }

    private OdbcServer() throws Exception {
    }

    public static OdbcServer getInstance() throws Exception {
        if (instance == null) {
            instance = new OdbcServer();
        }
        return instance;
    }

    public void terminate() {
        this.shutDown();
    }

    public void shutDown() {
        this._$5 = true;
    }

    public synchronized boolean isRunning() {
        return this.isAlive();
    }

    private synchronized void _$1(boolean b, int port) {
        this._$5 = b;
        if (!this._$5 && this._$9 != null) {
            this._$9.serverStarted(port);
        }
    }

    public boolean isAlive() {
        return !this._$5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nextId() {
        Object object = _$3;
        synchronized (object) {
            int c = ++_$4;
            if (c == Integer.MAX_VALUE) {
                _$4 = 1;
                c = 1;
            }
            return c;
        }
    }

    public OdbcContext getContext() {
        return this._$8;
    }

    public static String getHome() {
        String home = System.getProperty("start.home");
        return home;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ServerSocket ss = null;
        Logger.info(ParallelMessage.get().getMessage("OdbcServer.run1"));
        Logger.info(ParallelMessage.get().getMessage("UnitServer.run2", OdbcServer.getHome()));
        try {
            InputStream is = UnitContext.getUnitInputStream("OdbcServer.xml");
            is.close();
            this._$8 = new OdbcContext();
        }
        catch (Exception x) {
            if (this._$9 != null) {
                this._$9.serverStartFail();
            }
            x.printStackTrace();
            return;
        }
        String host = this._$8.getHost();
        int port = this._$8.getPort();
        try {
            InetAddress add = InetAddress.getByName(host);
            ss = new ServerSocket(port, 10, add);
            int TimeOut = 3000;
            ss.setSoTimeout(TimeOut);
        }
        catch (Exception x) {
            if (this._$9 != null) {
                this._$9.serverStartFail();
            }
            if (x instanceof BindException) {
                System.out.println(ParallelMessage.get().getMessage("DfxServerInIDE.portbind", host + ":" + port));
            } else {
                x.printStackTrace();
            }
            return;
        }
        if (StringUtils.isValidString(Env.getTempPath())) {
            int timeOut = this._$8.getTimeOut();
            int interval = this._$8.getConPeriod();
            this._$6 = new TempFileMonitor(timeOut, interval);
            this._$6.start();
        }
        this._$7 = new OdbcMonitor();
        this._$7.start();
        Logger.info(ParallelMessage.get().getMessage("OdbcServer.run3", host + ":" + port));
        this._$1(false, port);
        int c = 0;
        try {
            while (!this._$5) {
                try {
                    Socket s = ss.accept();
                    llIIIIIlIlIIIIlI ow = new llIIIIIlIlIIIIlI(this._$2, "OdbcWorker-" + c++);
                    ow.setSocket(s);
                    ow.start();
                }
                catch (InterruptedIOException e) {}
            }
            Thread[] threads = new Thread[this._$2.activeCount()];
            this._$2.enumerate(threads);
            for (int i = 0; i < threads.length; ++i) {
                Thread t = threads[i];
                if (!t.isAlive()) continue;
                ((llIIIIIlIlIIIIlI)t).shutDown();
            }
            if (this._$6 != null) {
                this._$6.stopThread();
            }
            this._$7.stopThread();
            ConnectionProxyManager.getInstance().destroy();
            Logger.info(ParallelMessage.get().getMessage("OdbcServer.stop"));
        }
        catch (Exception x) {
            x.printStackTrace();
            Logger.info(ParallelMessage.get().getMessage("OdbcServer.error", x.getMessage()));
        }
        finally {
            try {
                if (ss != null) {
                    ss.close();
                }
            }
            catch (Exception x) {}
            instance = null;
        }
    }

    public void setStartUnitListener(StartUnitListener listen) {
        this._$9 = listen;
    }

    public String getHost() {
        return this._$8.toString();
    }

    public boolean isAutoStart() {
        if (this._$8 == null) {
            this._$8 = new OdbcContext();
        }
        return this._$8.isAutoStart();
    }
}

