/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.server.odbc;

import com.scudata.app.common.AppUtil;
import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.Escape;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.common.UUID;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.expression.fn.Eval;
import com.scudata.parallel.Response;
import com.scudata.parallel.Task;
import com.scudata.server.IProxy;
import com.scudata.server.odbc.ConnectionProxy;
import com.scudata.server.odbc.OdbcServer;
import com.scudata.server.odbc.ResultSetProxy;
import com.scudata.util.DatabaseUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementProxy
extends IProxy {
    String _$9 = null;
    ArrayList _$8 = null;
    String _$7 = null;
    List _$6 = null;
    Task _$5 = null;
    transient Context _$4;

    public StatementProxy(ConnectionProxy cp, int id, String cmd, ArrayList<Object> params) throws Exception {
        super(cp, id);
        this._$9 = cmd;
        if (!StringUtils.isValidString(cmd)) {
            throw new Exception("Prepare statement cmd is empty!");
        }
        Logger.debug("StatementProxy cmd:\r\n" + cmd);
        this._$8 = params;
        if (this._$2()) {
            this._$1();
            String spaceId = UUID.randomUUID().toString();
            this._$5 = new Task(this._$7, this._$6, id, spaceId);
        }
        this.access();
    }

    public ConnectionProxy getConnectionProxy() {
        return (ConnectionProxy)this.getParent();
    }

    public String getCmd() {
        return this._$9;
    }

    private boolean _$2() {
        this._$9 = this._$9.trim();
        if (this._$9.startsWith("{") && this._$9.endsWith("}")) {
            this._$9 = this._$9.substring(1, this._$9.length() - 1);
        }
        String lower = this._$9.toLowerCase();
        return lower.startsWith("call ");
    }

    private void _$1() {
        if (!this._$2()) {
            return;
        }
        String tmp = this._$9;
        int left = tmp.indexOf(40);
        if (left == -1) {
            throw new RuntimeException(this._$9 + " must contain '()'");
        }
        if (!tmp.endsWith(")")) {
            throw new RuntimeException(this._$9 + " must end with ')'");
        }
        String name = tmp.substring(5, left).trim();
        this._$7 = AppUtil.searchSplFilePath(name);
        String strparams = tmp.substring(left + 1, tmp.length() - 1);
        this._$6 = this._$1(strparams);
    }

    private static String _$2(String args) {
        ArgumentTokenizer at1 = new ArgumentTokenizer(args);
        StringBuffer buf = new StringBuffer();
        while (at1.hasMoreTokens()) {
            String arg = at1.nextToken();
            String tmp = Escape.removeEscAndQuote(arg);
            arg = tmp.equals(arg) ? tmp : Escape.addEscAndQuote(tmp);
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(arg);
        }
        return buf.toString();
    }

    private List _$1(String strParams) {
        if (this._$8 == null) {
            throw new RuntimeException("You didn't bind any parameter for Call dfx()!");
        }
        String exp = "[" + StatementProxy._$2(strParams) + "]";
        Context ctx = new Context();
        Sequence arg = new Sequence();
        for (Object o : this._$8) {
            arg.add(o);
        }
        Sequence o = (Sequence)Eval.calc(exp, arg, null, ctx);
        ArrayList<Object> cmpArgs = new ArrayList<Object>();
        int len = o.length();
        for (int i = 1; i <= len; ++i) {
            cmpArgs.add(o.get(i));
        }
        return cmpArgs;
    }

    public List<String> getParams() {
        return this._$8;
    }

    public ResultSetProxy getResultSetProxy(int id) throws Exception {
        ResultSetProxy rsp = (ResultSetProxy)this.getProxy(id);
        if (rsp == null) {
            throw new Exception("ResultSet " + id + " is not exist or out of time!");
        }
        return rsp;
    }

    public int[] execute() throws Exception {
        int[] resultIds;
        if (this._$5 != null) {
            ICursor[] cursors = this._$5.executeOdbc();
            int size = cursors.length;
            resultIds = new int[size];
            for (int i = 0; i < size; ++i) {
                int resultId;
                ICursor cursor = cursors[i];
                resultIds[i] = resultId = OdbcServer.nextId();
                ResultSetProxy rsp = new ResultSetProxy(this, resultId, cursor);
                this.addProxy(rsp);
            }
        } else {
            Object obj;
            Context context = Task.prepareEnv();
            if (this._$8 != null && this._$8.size() > 0) {
                ArrayList<Object> args = new ArrayList<Object>();
                for (Object arg : this._$8) {
                    args.add(arg);
                }
                obj = AppUtil.executeSql(this._$9, args, context);
            } else {
                obj = AppUtil.executeCmd(this._$9, context);
            }
            ICursor cursor = obj instanceof ICursor ? (ICursor)obj : Task.toCursor(obj);
            int resultId = OdbcServer.nextId();
            resultIds = new int[]{resultId};
            ResultSetProxy rsp = new ResultSetProxy(this, resultId, cursor);
            this.addProxy(rsp);
        }
        return resultIds;
    }

    public boolean cancel() throws Exception {
        Response res = this._$5.cancel();
        if (res.getException() != null) {
            throw res.getException();
        }
        return true;
    }

    public long getStartTime() {
        return this._$5.getCallTime();
    }

    public long getEndTime() {
        return this._$5.getFinishTime();
    }

    public void setMaxRows(int max) {
    }

    public boolean hasNextResultSet() {
        return false;
    }

    public ICursor nextResultSet() {
        return null;
    }

    @Override
    public void close() {
        if (this._$5 != null) {
            this._$5.close();
        }
        if (this._$4 != null) {
            DatabaseUtil.closeAutoDBs(this._$4);
        }
    }

    @Override
    public String toString() {
        return "Statement " + this.getId();
    }
}

