/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.server.odbc;

import com.esproc.jdbc.JDBCUtil;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.dm.ParamList;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.server.ConnectionProxyManager;
import com.scudata.server.odbc.ConnectionProxy;
import com.scudata.server.odbc.DataTypes;
import com.scudata.server.odbc.OdbcContext;
import com.scudata.server.odbc.OdbcServer;
import com.scudata.server.odbc.ResultSetProxy;
import com.scudata.server.odbc.StatementProxy;
import com.scudata.util.CellSetUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class llIIIIIlIlIIIIlI
extends Thread {
    static final int _$5 = 65536;
    private Socket _$4;
    private volatile boolean _$3 = false;
    OutputStream _$2;
    InputStream _$1;

    public llIIIIIlIlIIIIlI(ThreadGroup tg, String name) {
        super(tg, name);
    }

    public void setSocket(Socket socket) throws Exception {
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(true);
        socket.setReceiveBufferSize(65536);
        socket.setSendBufferSize(65536);
        socket.setSoLinger(true, 1);
        socket.setReuseAddress(true);
        socket.setSoTimeout(3000);
        this._$4 = socket;
        this._$1();
    }

    private void _$1() throws IOException {
        OutputStream os = this._$4.getOutputStream();
        this._$2 = new BufferedOutputStream(os);
        this._$2.flush();
        InputStream is = this._$4.getInputStream();
        this._$1 = new BufferedInputStream(is);
    }

    private void _$1(OutputStream os, int code, String returnMsg) throws Exception {
        DataTypes.writeInt(os, code);
        if (returnMsg == null) {
            return;
        }
        if (code < 0) {
            DataTypes.writeString(os, returnMsg);
        }
    }

    private ConnectionProxy _$1(ConnectionProxyManager cpm, int connId) throws Exception {
        return (ConnectionProxy)cpm.getConnectionProxy(connId);
    }

    private boolean _$1(int reqType, InputStream is, OutputStream os) {
        try {
            OdbcServer server = OdbcServer.getInstance();
            OdbcContext context = server.getContext();
            ConnectionProxyManager cpm = ConnectionProxyManager.getInstance();
            switch (reqType) {
                case 1000: {
                    String user = DataTypes.readString(is);
                    String password = DataTypes.readString(is);
                    if (!context.isUserExist(user)) {
                        this._$1(os, -1, "Login error: invalid user " + user);
                        break;
                    }
                    try {
                        boolean success = context.checkUser(user, password);
                        if (success) {
                            int connId = OdbcServer.nextId();
                            ConnectionProxy connProxy = new ConnectionProxy(cpm, connId, user);
                            cpm.addProxy(connProxy);
                            this._$1(os, connId, "Login OK, current odbc user: " + user);
                            System.setProperty("_userName", user);
                        }
                    }
                    catch (Exception x) {
                        this._$1(os, -1, x.getMessage());
                    }
                    break;
                }
                case 1001: {
                    int connId = DataTypes.readInt(is);
                    String dfx = DataTypes.readString(is);
                    Object[] args = DataTypes.readRowData(is);
                    ArrayList<Object> argList = new ArrayList<Object>();
                    if (args != null) {
                        for (int i = 0; i < args.length; ++i) {
                            argList.add(args[i]);
                        }
                    }
                    ConnectionProxy connProxy = this._$1(cpm, connId);
                    int stateId = OdbcServer.nextId();
                    StatementProxy sp = new StatementProxy(connProxy, stateId, dfx, argList);
                    connProxy.addProxy(sp);
                    this._$1(os, stateId, null);
                    break;
                }
                case 1002: {
                    int connId = DataTypes.readInt(is);
                    int stateId = DataTypes.readInt(is);
                    ConnectionProxy connProxy = this._$1(cpm, connId);
                    StatementProxy sp = connProxy.getStatementProxy(stateId);
                    int[] resultIds = sp.execute();
                    DataTypes.writeInt(os, resultIds.length);
                    for (int i = 0; i < resultIds.length; ++i) {
                        DataTypes.writeInt(os, resultIds[i]);
                    }
                    this._$1("odbc", sp);
                    break;
                }
                case 1003: {
                    int connId = DataTypes.readInt(is);
                    int stateId = DataTypes.readInt(is);
                    ConnectionProxy connProxy = this._$1(cpm, connId);
                    StatementProxy sp = connProxy.getStatementProxy(stateId);
                    sp.cancel();
                    DataTypes.writeInt(os, 0);
                    break;
                }
                case 1010: {
                    int connId = DataTypes.readInt(is);
                    int stateId = DataTypes.readInt(is);
                    int resultId = DataTypes.readInt(is);
                    ConnectionProxy connProxy = this._$1(cpm, connId);
                    StatementProxy sp = connProxy.getStatementProxy(stateId);
                    ResultSetProxy rsp = sp.getResultSetProxy(resultId);
                    String[] columns = rsp.getColumns();
                    if (columns == null) {
                        DataTypes.writeInt(os, 0);
                        return true;
                    }
                    int size = columns.length;
                    DataTypes.writeInt(os, size);
                    for (int i = 0; i < size; ++i) {
                        DataTypes.writeString(os, columns[i]);
                    }
                    break;
                }
                case 1011: {
                    int connId = DataTypes.readInt(is);
                    int stateId = DataTypes.readInt(is);
                    int resultId = DataTypes.readInt(is);
                    int n = DataTypes.readInt(is);
                    ConnectionProxy connProxy = this._$1(cpm, connId);
                    StatementProxy sp = connProxy.getStatementProxy(stateId);
                    ResultSetProxy rsp = sp.getResultSetProxy(resultId);
                    Sequence data = rsp.fetch(n);
                    DataTypes.checkTable(data);
                    DataTypes.writeInt(os, 0);
                    DataTypes.writeTable(os, data);
                    break;
                }
                case 1012: {
                    String properties = DataTypes.readString(is);
                    DataTypes.writeInt(os, 0);
                    break;
                }
                case 1018: {
                    int connId = DataTypes.readInt(is);
                    int stateId = DataTypes.readInt(is);
                    ConnectionProxy connProxy = this._$1(cpm, connId);
                    StatementProxy sp = connProxy.getStatementProxy(stateId);
                    sp.destroy();
                    this._$1(os, 0, "Statement:" + stateId + " is closed.");
                    break;
                }
                case 1020: {
                    int connId = DataTypes.readInt(is);
                    int stateId = DataTypes.readInt(is);
                    int resultId = DataTypes.readInt(is);
                    ConnectionProxy connProxy = this._$1(cpm, connId);
                    StatementProxy sp = connProxy.getStatementProxy(stateId);
                    ResultSetProxy rsp = sp.getResultSetProxy(resultId);
                    rsp.destroy();
                    this._$1(os, 0, "ResultSet:" + resultId + " is closed.");
                    break;
                }
                case 1050: {
                    int connId = DataTypes.readInt(is);
                    String filter = DataTypes.readString(is);
                    Map<String, String> m = JDBCUtil.getSplList(filter);
                    String spCols = "PROCEDURE_CAT,PROCEDURE_SCHEM,PROCEDURE_NAME,NUM_INPUT_PARAMS,NUM_OUTPUT_PARAMS,NUM_RESULT_SETS,REMARKS,PROCEDURE_TYPE";
                    StringTokenizer st = new StringTokenizer(spCols, ",");
                    ArrayList<String> cols = new ArrayList<String>();
                    while (st.hasMoreTokens()) {
                        String name = st.nextToken();
                        cols.add(name);
                    }
                    Table storeInfos = new Table(StringUtils.toStringArray(cols));
                    for (String path : m.keySet()) {
                        String dfxName = m.get(path);
                        int paramCount = this._$1(path);
                        storeInfos.newLast(new Object[]{"", "", dfxName, paramCount, -1, -1, "", 2});
                    }
                    DataTypes.writeInt(os, 0);
                    DataTypes.writeTable(os, storeInfos);
                    break;
                }
                case 1060: {
                    int connId = DataTypes.readInt(is);
                    String tableName = DataTypes.readString(is);
                    ConnectionProxy connProxy = this._$1(cpm, connId);
                    Table table = JDBCUtil.getTables(tableName);
                    DataTypes.writeDatastructAndData(os, table);
                    break;
                }
                case 1061: {
                    int connId = DataTypes.readInt(is);
                    String tableName = DataTypes.readString(is);
                    String columnName = DataTypes.readString(is);
                    ConnectionProxy connProxy = this._$1(cpm, connId);
                    Table table = JDBCUtil.getColumns(tableName, columnName, new Context());
                    DataTypes.writeDatastructAndData(os, table);
                    break;
                }
                case 1111: {
                    int connId = DataTypes.readInt(is);
                    ConnectionProxy connProxy = this._$1(cpm, connId);
                    this._$1(os, 0, null);
                    os.flush();
                    connProxy.destroy();
                    return false;
                }
                case 2222: {
                    return false;
                }
            }
        }
        catch (Throwable x) {
            String msg = x.getMessage();
            while (msg == null && x.getCause() != null) {
                x = x.getCause();
                msg = x.getMessage();
            }
            try {
                this._$1(os, -1, msg);
            }
            catch (Exception e) {
                // empty catch block
            }
            x.printStackTrace();
            Logger.debug("Service exception:" + msg);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _$1(String dfx) throws Exception {
        int c = -1;
        FileInputStream in = null;
        try {
            in = new FileInputStream(dfx);
            PgmCellSet cs = CellSetUtil.readPgmCellSet(in);
            ParamList pl = cs.getParamList();
            if (pl != null) {
                c = pl.count();
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return c;
    }

    public void shutDown() {
        this._$3 = true;
    }

    @Override
    public void run() {
        try {
            InputStream is = this._$1;
            OutputStream os = this._$2;
            while (!this._$3) {
                int reqType = 0;
                try {
                    reqType = DataTypes.readInt(is);
                }
                catch (SocketTimeoutException e) {
                    continue;
                }
                if (reqType == -1) {
                    OdbcServer.getInstance().shutDown();
                    return;
                }
                if (reqType != -2 && reqType > 0 && this._$1(reqType, is, os)) {
                    os.flush();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this._$1.close();
            this._$2.close();
            this._$4.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void _$1(String typeName, StatementProxy sp) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cmd", sp.getCmd());
        map.put("id", sp.getId());
        map.put("size", sp.size());
        map.put("params", sp.getParams().toString());
        String user = System.getProperty("_userName");
        if (user != null) {
            map.put("userName", user);
            System.clearProperty("_userName");
        }
        this.collectData(typeName, map);
    }

    public void collectData(String typeName, Map<String, Object> map) {
    }
}

